<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Model for the tb_document_types table.
 */
class Document_type extends CI_Model {
    const TABLE = "tb_document_types";

    const ID_COL = "id";
    const DOCUMENT_ID_COL = "document_id";
    const TYPE_NAME_COL = "type_name";
    const BRANCH_CODE_COL = "branch_code";
    const COMPANY_CODE_COL = "company_code";
    const USER_ID_COL = "user_id";
    const STATUS_COL = "status";
    const CREATEDON_COL = "createdon";

    private  $id;
    private  $document_id;
    private  $type_name;
    private  $company_code;
    private  $branch_code;
    private  $country_code;
    private  $user_id;
    private  $status;
    private  $createdon;

    /**
     * Given a WHERE array of conditions, return the number of rows that match
     * the conditions.
     *
     * @param array $where
     * @param boolean $active_only default TRUE
     * @return int number of rows for where statement (0 or 1 based on limit)
     */
    public function exists(array $where, bool $active_only = TRUE)
    {
        if( $active_only ) { $where[self::STATUS_COL] = 1; }
        $this->db->where($where);
        $this->db->limit(1);
        return $this->db->count_all_results(self::TABLE);
    }

    /**
     * SELECT data from DB.
     *
     * @param array $columns use class constants for keys in the key value pairs
     * @param array $where use class constants for keys in the key value pairs
     * @param boolean $active_only default TRUE
     * @return CI_DB_result
     */
    public function select(array $columns, array $where, bool $active_only = TRUE)
    {
        if( $active_only ) { $where[self::STATUS_COL] = 1; }
        $this->db->select($columns);
        $this->db->where($where);
        $this->db->from(self::TABLE);
        return $this->db->get();
    }
}