<?php defined('BASEPATH') or exit('No direct script access allowed');
class FinancialReportModel extends CI_Model
{
 
  function getsearchdata($whr, $whr_id)
  {
    $this->db->select('r.*');
    $this->db->from('tb_reveneus r');
    $this->db->join("tb_orders o", "o.id=r.order_id", "INNER");
    $this->db->where("o.status !=", '0');
    $this->db->where($whr);
    if (!empty($whr_id)) {
      $this->db->where_in('r.user_id', $whr_id);
    }
    $res1 = $this->db->order_by('r.id', 'DESC');
    $res = $res1->get();
    $result = $res->result_array();
    return $result;
  }
  function getorderdata($whr)
  {

    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $this->db->select("o.order_id,convertToClientTZ(o.pickup_datetime,'" . $curtz . "') as pickup_datetime,convertToClientTZ(o.delivery_datetime,'" . $curtz . "') as delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.goods_value,o.vendor_id,o.shipment_id,o.pickup_city,o.delivery_city,o.status,o.trip_sts,o.trip_id, o.shipmentid,o.createdon,Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.volumetric_weight Else 0 End) as volumetric_weight,o.shift_id,cm.name as customer_name,cm.code as customer_cid");
    $this->db->from("tb_orders o");
    $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
    $this->db->join("tb_customers cm", "o.customer_id=cm.id", "LEFT");
    $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
    $this->db->where("o.status !=", '0');
    $this->db->where($whr);
    $res = $this->db->get();
    $result = $res->row_array();
    return $result;
  }

  public  function getreferenceorderdetails($id, $reference_id)
  {
    $getreforderdetails = $this->db->query("SELECT ref_value FROM tb_order_references WHERE status='1' AND reference_id='$reference_id' AND order_id='" . $id . "' LIMIT 1");
    return $getreforderdetails;
  }

    public function getpickupshipdateils($orderId, $statusId)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];

        return $this->db->query(
            "SELECT convertToClientTZ(o.pickup_datetime,'" . $curtz . "') AS createdon,convertToClientTZ(o.delivery_datetime,'" . $curtz . "') AS estimate_d_date FROM `tb_stop_status` tps,`tb_orders` o WHERE tps.status_id = ? AND o.shift_id=tps.shipment_id AND o.order_id = ? ORDER BY tps.id DESC",
            [$statusId, $orderId]
        );
    }

  public function getlaststoptransdetails($order_id)
  {
    $getlaststatusdetails = $this->db->query("select sm.id,sm.status_name,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te,`tb_status_master` sm where ts.id=tps.shipment_id AND te.shift_id=ts.id AND sm.id=tps.status_id AND te.order_id='" . $order_id . "' order by tps.id desc LIMIT 1");
    return $getlaststatusdetails;
  }
  public function getdeliveryconsigdetails($ordernum, $status_id, $stop_type)
  {
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $getdeliverydetails = $this->db->query(" select convertToClientTZ(tps.createdon,'" . $curtz . "') as createdon,te.order_id from `tb_stop_status` tps,`tb_shifts` ts,`tb_employee` te where tps.status_id = '" . $status_id . "' AND tps.stop_type='" . $stop_type . "' AND ts.id=tps.shipment_id AND te.shift_id=ts.id AND te.order_id='" . $ordernum . "' order by tps.id desc");
    return $getdeliverydetails;
  }

  public function getorderswithnobill($user_id, $whr)
  {
    $result = $all = $rev_ids = $no_revs = array();
    $getorder_ids = $this->db->select("id")->get_where("tb_orders", array('user_id' => $user_id, 'status!=' => '0'));
    if ($getorder_ids->num_rows() > 0) {
      foreach ($getorder_ids->result() as $res) {
        $all[] = $res->id;
      }
    }
    if (!empty($all)) {
      $getrevenues = $this->db->query("SELECT order_id FROM tb_reveneus WHERE order_id IN (" . implode(',', $all) . " ) AND status='1' GROUP BY order_id");
      if ($getrevenues->num_rows() > 0) {
        foreach ($getrevenues->result() as $rev) {
          $rev_ids[] = $rev->order_id;
        }
      }
    }
    $whr1 = "";
    if (!empty($rev_ids)) {
      $whr1 = "o.id NOT IN (" . implode(',', $rev_ids) . ") AND ";
    }
    $getdata = $this->db->query("SELECT o.id,c.name,c.code FROM tb_orders o,tb_customers c where " . $whr1 . " o.user_id = '" . $user_id . "' AND o.status != '0' AND o.customer_id =c.id " . $whr . " ORDER BY id DESC");
    if ($getdata->num_rows() > 0) {
      foreach ($getdata->result() as $res) {
        $result[] = array('order_id' => $res->id, 'recipient_code' => $res->code, 'recipient_name' => $res->name);
      }
    }
    return $result;
  }

    public function getOrderCount(string $orderTableWhere, array $postData): array
    {
        $postData['revenueType'] = $postData['revenueType'] ?? '';
        if ('111' === $postData['revenueType']) {
            $this->db->select('count(o.id) as count');
            $this->db->from("tb_orders o ");
            $this->db->join("tb_reveneus r", "o.id=r.order_id and r.status='1'", "left");
            $this->db->join("tb_customers  c", "c.id=o.customer_id and c.status='1'", "left");
            $this->db->where($orderTableWhere);
            $res = $this->db->get();
            return ($res->num_rows() > 0) ? $res->row_array() : [];
        }
        $this->db->select("count(r.id) as count");
        $this->db->from("tb_reveneus r");
        $this->db->join("tb_orders o", "o.id=r.order_id", "INNER");
        $orderTableWhere .= " and r.status='1'";
        $this->db->where($orderTableWhere);
        $res = $this->db->get();
        return ($res->num_rows() > 0) ? $res->row_array() : [];
    }
}
