<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Geocitymodel extends CI_Model
{
    function getsearchdata(array $whr, array $where): array
    {
        $this->db->select('tt.*');
        $this->db->from('tb_geo_cities as tt');
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->order_by('tt.id', 'DESC');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    function viewdata(int $id): array
    {
        $this->db->select('tt.*');
        $this->db->from('tb_geo_cities as tt');
        $this->db->where('tt.id', $id);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
    function editdata(int $id): array
    {
        $this->db->select('tt.*');
        $this->db->from('tb_geo_cities as tt');
        $this->db->where('tt.id', $id);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
    function selectprovince(string $cpCode): array
    {
        $this->db->select('id, province_iso_code');
        $this->db->from('tb_geo_provinces');
        $this->db->where('country_code', $cpCode);
        $this->db->where('status', 1);
        $this->db->group_by('province_iso_code');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];

    }
    function selectBranchCodes(string $brCode): array
    {
        $this->db->select('id, branch_code');
        $this->db->from('tb_branch_master');
        $this->db->where('company_code', $brCode);
        $this->db->where('status', 1);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function generateRandomId(): mixed
    {
        $lastGenId = '';
        $this->db->from('tb_geo_cities');
        $this->db->select('id');
        $this->db->limit(1, 0);
        $this->db->order_by('id', 'desc');
        $result = $this->db->get()->row_array();
        if (isset($result) && sizeof($result) > 0) {
            $lastId = $result['id'] + 1;
            if (strlen($lastId) < 4) {
                $lastGenId = str_pad($lastId, 4, '0', STR_PAD_LEFT);
            } else {
                $lastGenId = $lastId;
            }
        } else {
            $lastId = 1;
            $lastGenId = str_pad($lastId, 4, '0', STR_PAD_LEFT);
        }
        return $lastGenId;
    }

}
