<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KPIReportmodel extends CI_Model
{
    public function getBranchWiseSalogAirOrders(string $fromDate, string $toDate): array
    {
        $condition = "(r.reference_id='SD' AND r.ref_value !='3')";
        $this->db->select("o.id, o.company_code, o.branch_code, MONTH(o.createdon) AS months");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "o.id=r.order_id");
        $this->db->where("o.created_source", '5');
        $this->db->where("DATE(o.createdon) >=", $fromDate);
        $this->db->where("DATE(o.createdon) <=", $toDate);
        $this->db->where_in("o.branch_code", ['IDJKT', 'IDSUB', 'INHYD', 'INPNQ', 'NZAKL', 'PHMNL', 'THBKK', 'TWTPE', 'VNHAN', 'VNSGN', 'MYKUL', 'SGTGA', 'PHCEBU', 'PKKHI']);
        $this->db->where($condition);
        $this->db->where("o.status !=", '0');
        $finalResult = $this->db->get();
        if ($finalResult->num_rows() > 0) {
            foreach ($finalResult->result_array() as $allOrders) {
                $salogOrders[$allOrders['months']][$allOrders['branch_code']]['orders'][] = $allOrders['id'];
            }
        }
        return $salogOrders ?? [];
    }

    public function getSalogOrders(array $orders, string $ordertype): array
    {
        if (!empty($orders)) {
            $this->db->select("order_id");
            $this->db->from("tb_order_references");
            $this->db->where_in("order_id", $orders);
            $this->db->where("ref_value", $ordertype);
            $this->db->where("status !=", '0');
            $finalResult = $this->db->get();
            foreach ($finalResult->result_array() as $data) {
                $finalOutput[] = $data['order_id'];
            }
        }
        return $finalOutput ?? [];
    }

    public function getStatusOrders(array $newArray, string $statusType): int
    {
        if (!empty($newArray)) {
            $this->db->select("count(id) as orderCount");
            $this->db->from("tb_stop_status");
            $this->db->where_in("order_id", $newArray);
            $this->db->where("status_code", $statusType);
            $finalResult = $this->db->get();
            return $finalResult->num_rows() > 0 ? $finalResult->row()->orderCount : 0;
        } else {
            return 0;
        }
    }

    public function getAllBrancCodes(): array
    {
        $this->db->select("condition");
        $this->db->from("access_conditions");
        $this->db->where('title', 'KPI_BRANCH_CODES');
        $finalResult = $this->db->get();
        if ($finalResult->num_rows() > 0) {
            $branchCodes = explode(',', $finalResult->row()->condition);
            return $branchCodes;
        } else {
            return [];
        }
    }
}

