<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Knopstripsmodel extends CI_Model
{
    public function getAllKnopsBasedOrderIds(array $userData): array
    {
        $this->userData = $userData;
        $queryString = "SELECT o.id,o.order_id,o.shift_id,o.trip_id,o.shipmentid FROM tb_orders o, tb_order_details d WHERE o.id = d.order_row_id AND o.status > ? AND  o.shift_id > ? AND o.trip_sts = ? ";
        $queryParams = [0, 0, 0,];
        if ($this->userData['childId'] > 0) {
            $usersWithoutDepartment = $this->userData['usersWithoutDepartment'];
            if (!empty($usersWithoutDepartment)) {
                $i = 1;
                $arrayCount = count($usersWithoutDepartment);
                foreach ($usersWithoutDepartment as $eachLine) {
                    if ($i > 1) {
                        $queryString .= " OR (o.company_code = ? AND o.branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    } else {
                        $queryString .= " AND ( (o.company_code = ? AND o.branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    }
                    if ($arrayCount === $i) {
                        $queryString .= " ) AND ";
                    }
                    $i++;
                }
            } else {
                $j = 1;
                $usersWithDepartmentCodes = $this->userData['usersWithDepartmentCodes'];
                if (!empty($usersWithDepartmentCodes)) {
                    $arrayCount = count($usersWithDepartmentCodes);
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        if ($j > 1) {
                            $queryString .= " OR (o.company_code = ? AND o.branch_code = ? AND d.department_code = ? ) ";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                            $queryParams[] = $eachLine['departmentCode'];
                        } else {
                            $queryString .= " AND ( (o.company_code = ? AND o.branch_code = ? AND d.department_code = ? ) ";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                            $queryParams[] = $eachLine['departmentCode'];
                        }
                        if ($arrayCount === $j) {
                            $queryString .= " ) AND ";
                        }
                        $j++;
                    }
                }
            }
        } else {
            $queryString .= "AND o.company_code = ? AND o.branch_code = ? AND ";
            $queryParams[] = $this->userData['company_code'];
            $queryParams[] = $this->userData['branch_code'];
            if ($this->userData['department_code'] != "") {
                $queryString .= " d.department_code = ? AND ";
                $queryParams[] = $this->userData['department_code'];
            }
        }
        $queryString .= " d.status > ? ORDER BY o.id DESC";
        $queryParams[] = 0;
        $getOrderIds = $this->db->query($queryString, $queryParams);
        $getOrdersData = $getOrderIds->num_rows() > 0 ? $getOrderIds->result_array() : [];
        foreach ($getOrdersData as $eachRow) {
            $orderIds[] = $eachRow['id'];
            $tripId = $eachRow['trip_id'];
            $shiftId = $eachRow['shift_id'];
            $allshiftIds[] = $shiftId;
            $ordersData[$eachRow['id']] = ['rowId' => $eachRow['id'], 'bookingId' => $eachRow['order_id'], 'shiftId' => $shiftId, 'tripId' => $tripId, 'shipmentId' => $eachRow['shipmentid']];
        }
        return ['orderIds' => $orderIds ?? [], 'allshiftIds' => $allshiftIds ?? [], 'ordersData' => $ordersData ?? []];
    }

    public function getVehicleAndDriversForTrips(array $shiftIds, string $whereCondition): array
    {
        if (empty($shiftIds)) {
            return ['shiftIds' => [], 'tripDetails' => []];
        }
        $query = $this->db->query("SELECT s.id,v.vehicle_id,a.driver_id,d.contact_num,d.track_type,d.track_vendor,d.sim_carrier FROM tb_shifts s,tb_shft_veh v,tb_orders o,tb_vendors c,tbl_assigned_drivers a,tb_truck_drivers d WHERE " . $whereCondition . " AND s.id = v.shft_id AND o.shift_id=s.id AND v.carrier_id = c.id AND v.vehicle_id = a.vehicle_id AND a.driver_id = d.id AND s.id IN ? AND v.status = ? AND a.status = ? AND d.status = ? GROUP BY s.id", [$shiftIds, 1, 1, 'Active']);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachRow) {
            $shiftId = $eachRow['id'];
            $finalShiftIds[] = $shiftId;
            $response[$shiftId] = ['shiftId' => $shiftId, 'vehicleId' => $eachRow['vehicle_id'], 'driverId' => $eachRow['driver_id'], 'contactNumber' => $eachRow['contact_num'], 'trackType' => $eachRow['track_type'], 'trackVendor' => $eachRow['track_vendor'], 'simCarrier' => $eachRow['sim_carrier']];
        }
        return ['shiftIds' => $finalShiftIds ?? [], 'tripDetails' => $response ?? []];
    }

    public function getTripsBasedOnOrderId(array $orderIds, array $shiftIds, int $start, int $limit): array
    {
        if (empty($orderIds) || empty($shiftIds)) {
            return [];
        }
        $query = $this->db->query(
            "SELECT o.id as orderRowId,o.shift_id as shiftRowId FROM tb_orders o,tb_shifts s WHERE o.id IN ? AND o.shift_id IN ? AND o.status > ? AND s.status > ? AND o.shift_id = s.id  GROUP BY o.id ORDER BY o.shift_id DESC limit ?,?",
            [$orderIds, $shiftIds, 0, 0, $limit, $start]
        );
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachRow) {
            $result[] = ['shiftRowId' => $eachRow['shiftRowId'], 'orderRowId' => $eachRow['orderRowId']];
        }
        return $result ?? [];
    }

    public function getAllKNOpsBasedCrossBorderShiftIds(array $userData, array $postData = []): array
    {
        $shiftIds = $shiftLegIds = $searchShiftIds = [];
        $searchValue = trim($postData['table_search'] ?? "");
        if ($searchValue !== "") {
            $searchShiftIds = $this->getSearchConditionsForKNOpsInVisibilityPage($userData, $postData, [], '1');
            if (empty($searchShiftIds)) {
                return [];
            }
        }
        $queryString = "SELECT o.shift_id FROM tb_orders o, tb_order_details d WHERE o.id = d.order_row_id AND o.status > ? AND o.shift_id > ?";
        $queryParams = [0, 0];
        if (!empty($searchShiftIds)) {
            $queryString .= " AND o.shift_id IN ?";
            $queryParams[] = $searchShiftIds;
        }
        $queryString .= " AND o.trip_sts = ? ";
        $queryParams[] = 0;
        if ($userData['childId'] > 0) {
            $usersWithoutDepartment = $userData['usersWithoutDepartment'];
            if (!empty($usersWithoutDepartment)) {
                $i = 1;
                $arrayCount = count($usersWithoutDepartment);
                foreach ($usersWithoutDepartment as $eachLine) {
                    if ($i > 1) {
                        $queryString .= " OR (o.company_code = ? AND o.branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    } else {
                        $queryString .= " AND ( (o.company_code = ? AND o.branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    }
                    if ($arrayCount === $i) {
                        $queryString .= " ) ";
                    }
                    $i++;
                }
            } else {
                $j = 1;
                $usersWithDepartmentCodes = $userData['usersWithDepartmentCodes'];
                if (!empty($usersWithDepartmentCodes)) {
                    $arrayCount = count($usersWithDepartmentCodes);
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        if ($j > 1) {
                            $queryString .= " OR (o.company_code = ? AND o.branch_code = ? AND d.department_code = ? ) ";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                            $queryParams[] = $eachLine['departmentCode'];
                        } else {
                            $queryString .= " AND ( (o.company_code = ? AND o.branch_code = ? AND d.department_code = ? ) ";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                            $queryParams[] = $eachLine['departmentCode'];
                        }
                        if ($arrayCount === $j) {
                            $queryString .= " ) ";
                        }
                        $j++;
                    }
                }
            }
        } else {
            $queryString .= " AND o.company_code = ? AND o.branch_code = ? ";
            $queryParams[] = $userData['company_code'];
            $queryParams[] = $userData['branch_code'];
            if ($userData['department_code'] != "") {
                $queryString .= "AND d.department_code = ? ";
                $queryParams[] = $userData['department_code'];
            }
        }
        $queryString .= " AND d.status > ? ORDER BY o.id DESC";
        $queryParams[] = 0;
        $getOrderIds = $this->db->query($queryString, $queryParams);
        $getOrdersData = $getOrderIds->num_rows() > 0 ? $getOrderIds->result_array() : [];
        foreach ($getOrdersData as $eachRow) {
            $shiftIds[] = $eachRow['shift_id'];
        }
        if (empty($shiftIds)) {
            return [];
        }
        $getCrossBorderShiftLegIds = $this->db->query("SELECT id from tb_shifts WHERE origin_id IS NOT NULL AND destination_id IS NOT NULL AND status =? AND id IN ? AND shift_leg_id = ?", ['1', $shiftIds, '0']);
        if ($getCrossBorderShiftLegIds->num_rows() > 0) {
            foreach ($getCrossBorderShiftLegIds->result_array() as $eachShift) {
                $shiftLegIds[] = $eachShift['id'];
            }
        }
        if (!empty($shiftLegIds)) {
            $getCountryShiftIds = $this->db->query("SELECT id from tb_shifts WHERE shift_leg_id IN ? AND status = ?  GROUP BY shipmentid", [$shiftLegIds, '1']);
            if ($getCountryShiftIds->num_rows() > 0) {
                foreach ($getCountryShiftIds->result_array() as $eachLine) {
                    $response[] = $eachLine['id'];
                }
            }
        }
        return $response ?? [];
    }


    public function getSearchConditionsForKNOpsInVisibilityPage(array $userData, array $post, array $shiftIds, int $crossBorderFlag = 0): array
    {
        $searchValue = trim($post['table_search'] ?? "");
        if (($searchValue === "") && ($crossBorderFlag != "1")) {
            $normalTripsCondition[] = " s.id IN (" . implode(",", $shiftIds) . ") AND s.status = 1";
            return $normalTripsCondition ?? [];
        }
        $searchShiftIds = [];
        $queryString = "SELECT id FROM tb_users WHERE ";
        if ($userData['childId'] > 0) {
            $usersWithoutDepartment = $userData['usersWithoutDepartment'];
            if (!empty($usersWithoutDepartment)) {
                $i = 1;
                $arrayCount = count($usersWithoutDepartment);
                foreach ($usersWithoutDepartment as $eachLine) {
                    if ($i > 1) {
                        $queryString .= " OR (company_code = ? AND branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    } else {
                        $queryString .= " ( (company_code = ? AND branch_code = ? ) ";
                        $queryParams[] = $eachLine['companyCode'];
                        $queryParams[] = $eachLine['branchCode'];
                    }
                    if ($arrayCount === $i) {
                        $queryString .= " ) ";
                    }
                    $i++;
                }
            } else {
                $j = 1;
                $usersWithDepartmentCodes = $userData['usersWithDepartmentCodes'];
                if (!empty($usersWithDepartmentCodes)) {
                    $arrayCount = count($usersWithDepartmentCodes);
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        if ($j > 1) {
                            $queryString .= " OR (company_code = ? AND branch_code = ? )";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                        } else {
                            $queryString .= " ( (company_code = ? AND branch_code = ?  ) ";
                            $queryParams[] = $eachLine['companyCode'];
                            $queryParams[] = $eachLine['branchCode'];
                        }
                        if ($arrayCount === $j) {
                            $queryString .= " ) ";
                        }
                        $j++;
                    }
                }
            }
        } else {
            $queryString .= " company_code = ? AND branch_code = ? ";
            $queryParams[] = $userData['company_code'];
            $queryParams[] = $userData['branch_code'];
        }
        $queryString .= " AND status = ?";
        $queryParams[] = 'Active';
        $checkUserId = $this->db->query($queryString, $queryParams);
        $getUserId = $checkUserId->num_rows() > 0 ? $checkUserId->result_array() : [];
        $userIds = $searchShiftIds = [];
        foreach ($getUserId as $eachLine) {
            $userIds[] = $eachLine['id'];
        }
        if (!empty($userIds)) {
            $getStopdetails = $this->db->query("SELECT shift_id FROM tb_employee WHERE (order_id LIKE ? OR assoc_id LIKE ?) AND status = ? AND user_id IN ? LIMIT 10", ['%' . $searchValue . '%', '%' . $searchValue . '%', '1', $userIds]);
            $stopDetails = $getStopdetails->num_rows() > 0 ? $getStopdetails->result_array() : [];
            foreach ($stopDetails as $res) {
                $searchShiftIds[] = $res['shift_id'];
            }
            $getStopDetailsRefQuery = $this->db->query("SELECT o.shift_id FROM tb_orders o LEFT JOIN tb_order_references r ON o.id=r.order_id WHERE r.ref_value LIKE ? AND r.reference_id =? AND o.shift_id != ? AND o.user_id IN ? AND o.status > ? AND r.status = ?", [$searchValue, 'DQ', '0', $userIds, '0', '1']);
            $getStopDetailsRef = $getStopDetailsRefQuery->num_rows() > 0 ? $getStopDetailsRefQuery->result_array() : [];
            foreach ($getStopDetailsRef as $eachRow) {
                $searchShiftIds[] = $eachRow['shift_id'];
            }
        }

        if ($crossBorderFlag > 0) {
            return $searchShiftIds;
        } else {
            if (!empty($searchShiftIds)) {
                $normalTripsCondition[] = " ( s.id IN (" . implode(
                        ",",
                        $searchShiftIds
                    ) . ") OR s.shipmentid LIKE '%" . $searchValue . "%'
                    OR v.name LIKE '%" . $searchValue . "%'
                    OR sv.register_number LIKE '%" . $searchValue . "%')";
            } else {
                $normalTripsCondition[] = " (s.shipmentid LIKE '%" . $searchValue . "%'
                OR v.name LIKE '%" . $searchValue . "%'
                OR sv.register_number LIKE '%" . $searchValue . "%' ) ";
            }
            return $normalTripsCondition ?? [];
        }
    }

    public function getPendingOrdersData(string $whereCondition, string $timeZone): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.order_id,o.order_status,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,o.pickup_city,o.pickup_country,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.delivery_city,o.delivery_country FROM tb_orders o LEFT JOIN tb_order_details d ON o.id=d.order_row_id WHERE o.trip_id=? AND (`o`.`trip_id` =? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =?) AND o.status!=? AND o.trip_sts=?  AND d.status > ? $whereCondition  GROUP BY o.order_id ORDER BY o.pickup_datetime DESC",
            [$timeZone, $timeZone, 0, 0, 0, 0, 0, 0]
        );
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getActiveOrdersData(string $whereCondition, string $timeZone): array
    {
        $query = $this->db->query(
            "SELECT o.id,o.order_id,o.order_status,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,o.pickup_city,o.pickup_country,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.delivery_city,o.delivery_country FROM tb_orders o LEFT JOIN tb_order_details d ON o.id=d.order_row_id WHERE (o.trip_id!=? OR (o.trip_id=? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>?)) AND o.status!=? AND o.trip_sts=? AND d.status > ? $whereCondition  GROUP BY o.order_id ORDER BY o.pickup_datetime DESC",
            [$timeZone, $timeZone, 0, 0, 0, 0, 0, 0]
        );
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCompletedOrdersData(string $whereCondition, string $timeZone): array
    {
        $query = $this->db->query("SELECT o.id,o.order_id,convertToClientTZ(o.pickup_datetime,?) as pickup_datetime,convertToClientTZ(o.delivery_datetime,?) as delivery_datetime,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.shift_id,o.trip_id FROM tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE o.trip_sts=? " . $whereCondition . " ORDER BY o.updatedon DESC",
            [$timeZone, $timeZone, 1]
        );
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getReferencesDataInfoForAllOrders(string $whereCondition, string $statusType): array
    {
        if ($statusType == 'pending') {
            $query = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE  r.order_id=o.id " . $whereCondition . " AND o.trip_id=? AND o.trip_sts=? AND d.status = ? AND r.status=? GROUP BY r.id ORDER BY r.id DESC", [0, 0, 1, 1]);
        } elseif ($statusType == 'active') {
            $query = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE r.order_id=o.id AND o.trip_id!=? AND o.trip_sts=? " . $whereCondition . " AND d.status =? AND r.status=? GROUP BY r.id ORDER BY r.id DESC", [0, 0, 1, 1]);
        } else {
            $query = $this->db->query("SELECT r.id,r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE r.order_id=o.id " . $whereCondition . " AND o.trip_sts=? AND r.status=? GROUP BY r.id ORDER BY r.id DESC", [1, 1]);
        }
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getAllBookingDetails(string $whereCondition, string $statusType): array
    {
        if ($statusType == 'active') {
            $query = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE o.status!=0 " . $whereCondition . " AND ((o.trip_id=? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>?) OR (o.trip_id!=? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=?))  AND o.trip_sts=? GROUP BY o.order_id", [0, 0, 0, 0, 0]);
        } elseif ($statusType == 'pending') {
            $query = $this->db->query("SELECT o.order_id FROM tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id WHERE o.status!=? " . $whereCondition . " AND  (o.trip_id=? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=?) AND o.trip_sts=? GROUP BY o.order_id", [0, 0, 0, 0]);
        } else {
            $query = $this->db->query("SELECT o.id,o.order_id FROM tb_orders o LEFT JOIN tb_order_details d ON d.order_row_id = o.id  WHERE o.status!=? AND o.trip_sts=? " . $whereCondition . " GROUP BY o.order_id ORDER BY o.updatedon DESC", [0, 1]);
        }
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
}

?>
