<?php
class Kpimodel extends CI_Model
{


    public function getReports($post, $limit, $offset)
    {
        $this->db->select('k.id,k.order_row_id,k.order_id,k.delivery_note,k.shift_id,k.transport_mode,k.vendor_id,k.customer_id,k.carrier_name,k.customer_name,k.booking,k.shipment,k.tender,k.pickup,k.delivery,k.score,k.total_days,k.kpi,k.user_id,k.company_code,k.status,k.createdon,k.pickup_datetime,k.delivery_datetime,k.epod_date,k.gate_in_pickup_datetime,k.gate_out_pickup_datetime,k.gate_in_delivery_datetime,k.gate_out_delivery_datetime,k.kpi_departure_to_arrvial,k.pickup_status,k.pickup_comments,k.delivery_status,k.delivery_comments,k.carrier_assigned_date,o.pickup_country,o.delivery_country,o.pickup_city,o.delivery_city,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2'
        );
        $this->db->from('kpi_report k');
        $this->db->join('tb_orders o', 'o.id = k.order_row_id', 'left');
        $this->db->where("k.status = 1");

        if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $this->db->where('k.vendor_id', $uid);
        }else {
            if (isset($post['user_id']) && $post['user_id'] > 0) {
                $this->db->where('k.user_id', $post['user_id']);
            } else {
                $this->db->where('k.user_id', $this->session->userdata('user_id'));
            }
        }
        $fromDate = $post['fromdate_search'];
        $toDate =   $post['todate_search'];
        if ( !empty($fromDate) && !empty($toDate) ) {
            $this->db->where('date(k.`booking`) >=', $fromDate);
            $this->db->where('date(k.`booking`) <=', $toDate);
        }
        elseif (!empty($fromDate)) {
            $this->db->where('date(k.`booking`) =', $fromDate);
        }
        elseif (!empty($toDate) ) {
            $this->db->where('date(k.`booking`) =', $toDate);
        }

        $shipmentFromDate = $post['shipment_fromdate_search'];
        $shipmentToDate =   $post['shipment_todate_search'];
        if ( !empty($shipmentFromDate) &&  !empty($shipmentToDate) ) {
            $this->db->where('date(k.`tender`) >=', $shipmentFromDate);
            $this->db->where('date(k.`tender`) <=', $shipmentToDate);
        }
        elseif (!empty($shipmentFromDate)) {
            $this->db->where('date(k.`tender`) =', $fromDate);
        }
        elseif (!empty($shipmentToDate) ) {
            $this->db->where('date(k.`tender`) =', $shipmentToDate);
        }
        if($this->input->post('hidden_cid')){
            $this->db->where('k.customer_id', $post['hidden_cid']);
        }
        if (isset($post['carrier_search']) && trim($post['carrier_search']) != "") {
            $this->db->where('k.vendor_id', $post['carrier_search']);
        }

        $companyCode = $this->session->userdata('company_code');
        if (isset($companyCode) && $companyCode != "") {
            $this->db->where('k.company_code', $companyCode);
        }

        if ($limit > 0) {
            $this->db->limit($limit,$offset);
        }
		$this->db->group_by('k.order_row_id');
        $this->db->order_by('k.id', 'DESC');
        $query =$this->db->get();
        return $query;
    }
}
