<?php

class Livetrackmodel extends CI_Model
{
    public function fetchVehiclesShifts(string $userid, string $curtz): array
    {
        $query = $this->db->query(
            "-- livetrackservice getVehiclesShifts
            SELECT
                s.id, s.shipmentid,
                convertToClientTZ(s.startdate, ?) AS stime,
			    convertToClientTZ(s.enddate, ?) AS etime,
                convertToClientTZ(s.startdate, ?) AS startdate,
			    s.trip_type, s.splace, s.eplace,
                v.id AS shft_veh_id,
                v.route_id, v.vehicle_id, v.register_number,
			    IFNULL(t.status, 0) AS status,
                IFNULL(t.id, 0) AS tripid,
                IFNULL(t.driver_id, 0) AS driver_id
			FROM tb_shifts AS s, tb_shft_veh AS v
			    LEFT OUTER JOIN tb_trips AS t ON t.shift_id = v.shft_id AND t.vehicle_id = v.vehicle_id AND t.status = 1
			WHERE s.user_id = ? AND s.user_id = v.user_id AND s.status = 1
			AND s.status = v.status AND s.id = v.shft_id AND v.vehicle_id != 0
			GROUP BY shft_veh_id ORDER BY tripid DESC",
            [$curtz, $curtz, $curtz, $userid]
        );

        return $query ? $query->result() : [];
    }

    public function fetchLocationNameForMultipleLocations(array $locations): array
    {
        $found = [];

        if (empty($locations)) {
            return [[], []];
        }

        // for matching location as KEY there is used concat(lat,':',lng)
        // for example: '1.4005582:103.89562'
        $query = $this->db->query("-- livetrackservice
        SELECT concat(lat, ':', lng) as location_key, name1
        FROM tb_location_data
        WHERE concat(lat, ':', lng) in ?", [ $locations ]);

        if (!$query) {
            return [ $found, $missing = $locations ];
        }

        foreach ($query->result() as $row) {
            $found [$row->location_key] = $row->name1;
        }

        return [ $found, $missing = array_diff($locations, array_keys($found)) ];
    }

    public function fetchSpeedUpdates(array $vehicleIds): array
    {
        if (empty($vehicleIds)) {
            return [];
        }

        $query = $this->db->query(
            "SELECT
            id, speed, latitude, longitude
        FROM tb_trucks_data
        WHERE id IN ?",
            [$vehicleIds]
        );

        return $query ? $query->result() : [];
    }

    public function fetchUserActiveVehicles(string $userid): array
    {
        $query = $this->db->query(
            "SELECT
               v.vehicle_id, v.register_number, v.shft_id
        FROM tb_shft_veh as v
        WHERE v.user_id= ?
          AND v.status = 1
          AND v.shft_id in (
            SELECT id
            FROM tb_shifts as s
            WHERE s.user_id = ?
              and s.status = 1
        )",
            [$userid, $userid]
        );

        return $query ? $query->result() : [];
    }

    public function fetchVehiclesOfActiveTrips(array $vehicles):array
    {
        if (empty($vehicles)) {
            return [];
        }

        $query = $this->db->query(
            "SELECT
                id as tripid, vehicle_id, status,
                driver_id, stime, start_imei, start_reading
            FROM tb_trips
            WHERE status=1
                AND vehicle_id IN ?
            ORDER BY shift_id desc",
            [$vehicles]
        );

        return $query ? $query->result_array() : [];
    }

}
