<?php

defined('BASEPATH') or exit('No direct script access allowed');

class MassStatusModel extends CI_Model
{
    public function getStopStatusDetails(string $currentTimeZone, int $shiftId, int $tripId): array
    {
        $this->db->select("sm.id as sid, sm.status_name,sm.status_code, ts.id, ts.order_id, ts.stop_id, ts.stop_detail_id,ts.stop_type, ts.status_id, convertToClientTZ(ts.createdon, '{$currentTimeZone}') as createdon");
        $this->db->from("tb_status_master AS sm");
        $this->db->join("tb_stop_status AS ts", "sm.id = ts.status_id AND ts.shipment_id = '{$shiftId}' AND ts.trip_id = '{$tripId}' AND ts.status=1", "LEFT");
        $this->db->where_in('sm.status_code', ['SV0120', 'SV0130', 'SV0140', 'SV0230', 'SV0310', 'SV0410', 'SV0510', 'SV0610', 'SV0131']);
        $getResult = $this->db->get();
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getOrderReferenceByOrderIds(array $orderRowIds): array
    {
        if (empty($orderRowIds)) {
            return [];
        }
        $this->db->select("order_id,reference_id,ref_value");
        $this->db->from("tb_order_references");
        $this->db->where_in("order_id", $orderRowIds);
        $this->db->where_in("reference_id", ['DQ', 'AAM', 'AWB', 'XSR', 'SD', 'INN', 'CTR']);
        $this->db->where("ref_value !=", '');
        $this->db->where("status", 1);
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachRow) {
                $data[$eachRow['order_id']][] = $eachRow;
            }
        }
        return $data ?? [];
    }

    public function getTripData(array $shiftIds, array $bookingIds): array
    {
        if (empty($shiftIds) || empty($bookingIds)) {
            return [];
        }
        $this->db->select("s.id,e.id as stopdetailsid,e.order_id,t.id as trip_id,t.shift_id,t.vehicle_id,t.driver_id,t.start_imei");
        $this->db->from("tb_shiporder_stops s");
        $this->db->join("tb_employee e", "s.id=e.stop_id");
        $this->db->join("tb_trips t", "s.shipment_id=t.shift_id", "LEFT");
        $this->db->where_in("s.shipment_id", $shiftIds);
        $this->db->where_in("e.order_id", $bookingIds);
        $this->db->where("s.status", 1);
        $this->db->where("e.status", 1);
        $this->db->group_by("e.order_id");
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachRow) {
                $data[$eachRow['order_id']] = $eachRow;
            }
        }
        return $data ?? [];
    }

    public function getStopDetailIds(array $shiftIds, array $bookingIds): array
    {
        if (empty($shiftIds) || empty($bookingIds)) {
            return [];
        }
        $this->db->select("s.id,e.id as stopdetailsid,e.order_id");
        $this->db->from("tb_shiporder_stops s");
        $this->db->join("tb_employee e", "s.id=e.stop_id");
        $this->db->where_in("s.shipment_id", $shiftIds);
        $this->db->where_in("e.shift_id", $shiftIds);
        $this->db->where_in("e.order_id", $bookingIds);
        $this->db->where("s.status", 1);
        $this->db->where("e.status", 1);
        $this->db->group_by("e.order_id");
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachRow) {
                $data[$eachRow['order_id']] = $eachRow;
            }
        }
        return $data ?? [];
    }

    public function getShipOrderDetails(array $shiftIds, array $bookingIds): array
    {
        if (empty($shiftIds) || empty($bookingIds)) {
            return [];
        }
        $sql = " SELECT
                  s.id,
                  s.stoptype,
                  s.ordernumber,
                  s.status,
                  e.id as stopdetailsid,
                  e.order_id
                FROM
                  tb_shiporder_stops s,
                  tb_employee e
                WHERE
                  s.shipment_id = e.shift_id
                  AND s.shipment_id IN ?
                  AND s.status = 1
                  AND s.id = e.stop_id
                  AND e.status = 1
                  AND e.order_id IN ?
                UNION
                SELECT
                  s.id,
                  s.stoptype,
                  s.ordernumber,
                  s.status,
                  e.id as stopdetailsid,
                  e.order_id
                FROM
                  tb_shiporder_stops s,
                  tb_employee e
                WHERE
                  s.shipment_id = e.shift_id
                  AND s.shipment_id IN ?
                  AND s.status = 1
                  AND s.id = e.drop_stopid
                  AND e.status = 1
                  AND e.order_id IN ?
                ORDER BY
                  ordernumber ASC
                ";
        $query = $this->db->query($sql, [$shiftIds, $bookingIds, $shiftIds, $bookingIds]);
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $eachRow) {
                $data[$eachRow['order_id']][] = $eachRow;
            }
        }
        return $data ?? [];
    }

    public function getShipmentCount(string $searchWhere, string $carrierWhere): int
    {
        $sql = "SELECT
                      COUNT(DISTINCT o.id) as count
                    FROM
                      tb_orders o,
                      tb_shft_veh v,
                      tb_vendors c,
                      tbl_assigned_drivers a,
                      tb_truck_drivers d,
                      tb_employee tbe
                    WHERE
                      o.shift_id = v.shft_id
                      AND o.order_id = tbe.order_id
                      AND v.carrier_id = c.id
                      AND v.vehicle_id = a.vehicle_id
                      AND a.driver_id = d.id
                      AND v.status = 1
                      AND a.status = 1
                      AND d.status = 'Active' $searchWhere $carrierWhere
                      AND o.status != 0
                      AND o.trip_sts = 0";
        $query = $this->db->query($sql);
        return $query->num_rows() > 0 ? (int)$query->row()->count : 0;
    }

    public function getShipOrderStopsByPickOrDropId(array $shiftIds, array $bookingIds): array
    {
        $sql = "SELECT
                  s.id,
                  e.id as stopdetailsid,
                  e.order_id
                FROM
                  tb_shiporder_stops s,
                  tb_employee e
                WHERE
                  s.shipment_id IN ?
                  AND s.status = 1
                  AND (
                    s.id = e.stop_id
                    OR s.id = e.drop_stopid
                  )
                  AND e.status = 1
                  AND e.shift_id IN ?
                  AND e.order_id IN ?
                ";
        $query = $this->db->query($sql, [$shiftIds, $shiftIds, $bookingIds]);
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $eachRow) {
                $data[$eachRow['order_id']] = $eachRow;
            }
        }
        return $data ?? [];
    }

    public function getOrderRefValues(array $references): array
    {
        $this->db->select("order_id");
        $this->db->from("tb_order_references");
        $this->db->where("status", 1);
        $this->db->where_in("reference_id", ['DQ', 'XSR', 'AWB', 'MAWB']);
        $this->db->where_in("ref_value", $references);
        $this->db->where("status", 1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
        return $result ?? [];
    }

    public function getLatestDriverDataByVehicle(array $vehicleIds): array
    {
        $query = $this->db->query("SELECT vehicle_id,driver_id,updated_on FROM tbl_assigned_drivers WHERE vehicle_id IN ? AND status = ?", [$vehicleIds, 1]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        if (empty($queryResult)) {
            return [];
        }
        $vehiclesData = $dummyArray = [];
        foreach ($queryResult as $eachLine) {
            $vehiclesData[] = ['vehicleId' => $eachLine['vehicle_id'], 'driverId' => $eachLine['driver_id'], 'updatedDate' => $eachLine['updated_on']];
        }
        if (empty($vehiclesData)) {
            return [];
        }
        $keys = array_column($vehiclesData, 'updatedDate');
        array_multisort($keys, SORT_DESC, $vehiclesData);
        foreach ($vehiclesData as $eachId) {
            if (!in_array($eachId['vehicleId'], $dummyArray)) {
                $driverData[$eachId['vehicleId']] = $eachId['driverId'] ?? 0;
                $dummyArray[] = $eachId['vehicleId'];
            }
        }
        return $driverData ?? [];
    }
    
    public function getStopStatusDetailsNoTrip($curtz, $shift_id, $order_id) {
        $sql = "SELECT 
                    os.id,
                    os.order_id,
                    os.status_id as sid,
                    convertToClientTZ(os.createdon, ?) as createdon,
                    os.stop_id,
                    os.stop_detail_id,
                    os.stop_type,
                    sm.status_name
                FROM tb_stop_status os
                LEFT JOIN tb_status_master sm ON os.status_id = sm.id
                WHERE os.shipment_id = ? 
                  AND os.order_id   = ?
                  AND os.status     = 1
                ORDER BY os.createdon DESC";
        
        $query = $this->db->query($sql, [$curtz, $shift_id, $order_id]);
        return $query ? $query->result_array() : [];
    }
}
