<?php

class Misautoreportmodel extends CI_Model
{
    public function getOrdersDataByCustomerCodes(array $customerIds): array
    {
        $sql = "SELECT o.id,o.order_id,o.user_id,o.customer_id,c.code,c.email_id FROM tb_orders o LEFT JOIN tb_customers c ON c.id=o.customer_id WHERE o.createdon BETWEEN NOW() - INTERVAL 30 DAY AND NOW() AND o.status !=0 AND c.id IN ? order by o.id DESC";
        $query = $this->db->query($sql,[$customerIds]);
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $row) {
                $customerOrderIds[$row['customer_id']][] = ['id'=>$row['id'],'order_id'=>$row['order_id']];
                $customerCodes[$row['customer_id']] = $row['code'];
                $allOrderIds[] = $row['id'];
                $customerEmailIds[$row['customer_id']] = $row['email_id'];
                $userIds[$row['id']] = $row['user_id'];
            }
        }
        return ['customer_order_ids' => $customerOrderIds ?? [], 'all_order_ids' => $allOrderIds ?? [], 'customer_email_ids' => $customerEmailIds ?? [], 'userIds' => $userIds ?? [], 'customerCodes' => $customerCodes ?? []];
    }
    public function getOrdersDataWithIds(array $orderIds = []): array
    {
        if (empty($orderIds)) {
            return [];
        }
        $sql = "SELECT
              `o`.`id`,
              `o`.`order_id`,
              `o`.`pickup_datetime`,
              `o`.`pickup_endtime`,
              `o`.`delivery_datetime`,
              `o`.`drop_endtime`,
              `o`.`pickup_company`,
              `o`.`delivery_company`,
              `o`.`pickup_country`,
              `o`.`delivery_country`,
              `o`.`pickup_city`,
              `o`.`delivery_city`,
              `o`.`pickup_pincode`,
              `o`.`delivery_pincode`,
              `o`.`pickup_address1`,
              `o`.`delivery_address1`,
              `o`.`pickup_address2`,
              `o`.`delivery_address2`,
              `o`.`transport_mode`,
              `o`.`company_code`,
              `o`.`branch_code`,
              `o`.`trip_sts`,
              `o`.`shift_id`,
              `o`.`trip_id`,
              `o`.`shipmentid`,
              `o`.`createdon`,
              CONCAT(s.service_id, '-', s.name) as service,
              (SELECT r.ref_value FROM tb_order_references r
                        WHERE r.order_id = o.id AND r.reference_id = ? ) AS consignment_no,
              `c`.`cntry_timezone`
            FROM
              `tb_orders` `o`
              LEFT JOIN `tb_order_details` `od` ON `o`.`id` = `od`.`order_row_id`
              LEFT JOIN `tb_service_master` `s` ON `od`.`service` = `s`.`id`
              LEFT JOIN `tb_users` `u` ON `o`.`user_id` = `u`.`id`
              LEFT JOIN `tbl_country_master` `c` ON `u`.`country_code` = `c`.`country_code`
            WHERE
              `o`.`id` IN ? AND o.status != ? ";
        $query = $this->db->query($sql, ['DQ', $orderIds, 0]);
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $row) {
                $data[$row['id']] = $row;
            }
        }
        return $data ?? [];
    }

    public function getOrdersLastKnownStatus(array $shiftIds): array
    {
        $this->db->select("ts.order_id, Case When ts.status_code='0500' Then 'Pickup' When ts.status_code='2300' Then 'Drop' Else sm.status_name End as status_name");
        $this->db->from("tb_stop_status ts");
        $this->db->join("tb_status_master sm", "sm.id=ts.status_id", "LEFT");
        $this->db->join("tb_orders o", "ts.order_id=o.id", "LEFT");
        $this->db->where_in("ts.shipment_id", $shiftIds);
        $this->db->where("ts.status", 1);
        $this->db->where("sm.customer_view", 1);
        $this->db->group_by("ts.order_id");
        $this->db->order_by("ts.order_id,ts.id DESC");
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $milestoneStatuses) {
                $data[$milestoneStatuses['order_id']] = $milestoneStatuses['status_name'];
            }
        }
        return $data ?? [];
    }

    public function getCargoDetails(array $orderIds = []): array
    {
        if (empty($orderIds)) {
            return [];
        }
        $this->db->select('SUM(cd.weight) as weight,cd.weight_unit,SUM(cd.quantity) as quantity,ocd.order_id');
        $this->db->from("tb_cargo_details cd");
        $this->db->join('tb_order_cargodetails ocd', 'cd.id= ocd.cargo_id', 'LEFT');
        if (!empty($orderIds)) {
            $this->db->where_in('ocd.order_id', $orderIds);
        }
        $this->db->where('ocd.status', 1);
        $this->db->group_by('ocd.order_id');
        $getResult = $this->db->get();
        if (!empty($orderIds)) {
            foreach ($getResult->result_array() as $eachRow) {
                $results[$eachRow['order_id']] = $eachRow;
            }
        }
        return $results ?? [];
    }

    public function getTripCreationDates(array $shiftIds, array $userTimeZones): array
    {
        $this->db->select("s.id,s.user_id,s.created_on");
        $this->db->from("tb_shifts s");
        $this->db->where_in("s.id", $shiftIds);
        $getResult = $this->db->get();
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachTrip) {
                $userId = $eachTrip['user_id'];
                $timeZone = $userTimeZones[$userId] ?? 'Asia/Kolkata';
                $data[$eachTrip['id']] = getdatetimebytimezone($timeZone, $eachTrip['created_on'], DFLT_TZ)['datetime'];
            }
        }
        return $data ?? [];
    }

    public function getUserTimeZones(array $userIds): array
    {
        $query = $this->db->query("SELECT u.id, c.cntry_timezone FROM tb_users u, tbl_country_master c WHERE u.country_code = c.country_code AND u.id IN ? AND u.status = ? AND c.status = ?", [$userIds, 'Active', '1']);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachLine) {
            $response[$eachLine['id']] = $eachLine['cntry_timezone'];
        }
        return $response ?? [];
    }

    public function getOrderGateOutDetails(array $orderIds, array $userTimeZones, array $userIds): array
    {
        $query = $this->db->query("SELECT order_id,latitude,longitude,createdon FROM tb_stop_status WHERE order_id IN ? AND status_code = ? AND status = ?", [$orderIds, '3000', '1']);
        $result = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($result as $eachLine) {
            $orderId = $eachLine['order_id'];
            $userId = $userIds[$orderId] ?? 0;
            if ($userId > 0) {
                $timeZone = $userTimeZones[$userId];
            }
            $dateTime = getdatetimebytimezone($timeZone ?? 'Asia/Kolkata', $eachLine['createdon'], DFLT_TZ)['datetime'];
            $response[$eachLine['order_id']] = ['location' => getLocationName($eachLine['latitude'], $eachLine['longitude']), 'time' => $dateTime];
        }
        return $response ?? [];
    }

    public function getCustomersForMisReports(): array
    {
        $this->db->select("c.id,c.code,c.email_id as customer_email,bm.email_id as branch_email");
        $this->db->from("tb_party_reference r");
        $this->db->join("tbl_party_master m", "r.partner_id = m.id", "LEFT");
        $this->db->join("tbl_party_types t", "t.id = m.party_type_id", "INNER");
        $this->db->join("tb_customers c", "c.code = m.code", "INNER");
        $this->db->join("tb_branch_master bm", "bm.branch_code = m.branch_code", "LEFT");
        $this->db->where("c.company_code = m.company_code AND t.name = 'Customer' AND r.name  = 'Daily MIS' AND m.status = 1 AND r.status = 1");
        $this->db->where_in("r.value", ['Y','Yes','YES','yes']);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

}
