<?php
class MultiOrderToCarrierAssignModel extends CI_Model
{
	public function getShipmentRatesCount(int $shipmentId): int
	{
		return $this->db->query("SELECT id FROM tb_shipment_rates WHERE shift_id = ? AND status = ? ", [$shipmentId, 1])->num_rows();
	}

	public function getShiftCount(int $shipmentId): int
	{
		return $this->db->query("SELECT id FROM tb_trips WHERE shift_id = ? ", [$shipmentId])->num_rows();
	}

	public function getShiftEmployees(int $shipmentId): array
	{
		$getResult = $this->db->query("SELECT id, pickup_datetime, drop_datetime FROM tb_employee WHERE shift_id = ? ", [$shipmentId]);
		return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
	}

	public function checkActiveTrip(int $vehicleId, int $shiftId):string
	{
		$getResult = $this->db->query("SELECT o.shipmentid FROM tb_trips t 
			INNER JOIN tb_orders o ON (o.trip_id = t.id)
			WHERE t.vehicle_id != ? AND t.shift_id = ? AND t.status = ?", [$vehicleId, $shiftId, 1]);
		return $getResult->num_rows() > 0 ? $getResult->row()->shipmentid : "";
	}

	public function getMultiLegOrdersCount(array $shiftIds): int
    {
        $getResult = $this->db->query("SELECT id FROM tb_shifts WHERE shift_leg_id IN ? ", [$shiftIds]);
        return $getResult->num_rows() ?? 0;
    }

    public function getCarriersByCompanyCode(array $companyCodes): array
    {
        $getResult = $this->db->query("
                        SELECT v.id, v.name,v.code
                        FROM tb_vendors AS v
                        JOIN tbl_party_master AS pm ON (pm.code=v.code AND v.code IS NOT NULL AND pm.company_code=v.company_code)
                        WHERE pm.status = ? AND v.status = ? AND v.company_code = ?
                        GROUP BY v.id
                        ORDER BY v.name ASC",
                        [1, 1, $companyCodes]
                    );
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }

    public function getCarriersByAdminUser(int $userId): array
    {
        $getResult = $this->db->query(
                    "SELECT v.id, v.name, v.code
                     FROM tb_vendors AS v
                     JOIN tbl_party_master AS pm ON (pm.code = v.code AND v.code IS NOT NULL AND pm.user_id = v.user_id)
                     WHERE pm.status = ? AND v.status = ? AND v.user_id = ?
                     GROUP BY v.id
                     ORDER BY v.name ASC",
                    [1, 1, $userId]);
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }
}