<?php
class Notifymodel extends CI_Model {

    function notifyList($where){
        $this->db->select('nm.*,c.code customer_code,s.name service_name,o.type_name order_type')->from('tb_notify_management nm');
        $this->db->join('tb_customers c','c.id=nm.customer_id','LEFT');
        $this->db->join('tb_service_master s','s.id=nm.service','LEFT');
        $this->db->join('tb_order_types o','o.id=nm.order_type','LEFT');
        $this->db->where('nm.status',1);
        $this->db->group_by('nm.notification_id');
        if($where){
            $this->db->where($where);
        }
        $this->db->order_by('id','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function notifyContactsList($where){
        $this->db->select('nm.*,c.code customer_code,s.name service_name,o.type_name order_type')->from('tb_notify_management nm');
        $this->db->join('tb_customers c','c.id=nm.customer_id','LEFT');
        $this->db->join('tb_service_master s','s.id=nm.service','LEFT');
        $this->db->join('tb_order_types o','o.id=nm.order_type','LEFT');
        $this->db->where('nm.status',1);
        if($where){
            $this->db->where($where);
        }
        $this->db->order_by('id','ASC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function getCustomerNotifydata($where){
       // $this->db->select('nm.*')->from('tb_notify_management nm');
        $this->db->select('c.id customerid,pm.id pmid,pm.customer_code,pm.party_type_id,pm.code pmcode,pt.name as partytype,nm.*')->from('tbl_party_master pm');
        $this->db->join('tb_customers c','pm.customer_code = c.code','LEFT');
        $this->db->join('tbl_party_types pt','pt.id = pm.party_type_id','LEFT');
        $this->db->join('tb_notify_management nm','nm.customer_id = c.id and nm.party_type=pt.name','LEFT');
        $this->db->where($where);
        /* if(!isset($where['pm.customer_code'])){
            $this->db->where('pm.customer_code IS NOT NULL',null,false);
        } */
        $this->db->where('c.code IS NOT NULL',null,false);
        $this->db->where('pt.name IS NOT NULL',null,false);
        $this->db->group_by('pm.customer_code,pt.name');
        //$this->db->order_by('id','DESC');
        $res = $this->db->get();
       // print_r($this->db->last_query()); exit;
        $result = $res->result_array();
        return $result;
    }

    public function getlatestnotifyid(){
        $this->db->select('notification_id')->from('tb_notify_management');
        $this->db->order_by('id','DESC');
        $query  = $this->db->get()->row_array();
        if($query && count($query) > 0){
        return $query['notification_id'];
        } else {
            return 'NOTIFY000';
        }
    }

    public function getnotificationids($like){
        $this->db->select('notification_id')->from('tb_notify_management');
        $this->db->like('notification_id',$like);
        $this->db->group_by('notification_id');
        $query = $this->db->get();
        return $query->result_array();
    }

    function saveContact($data){
       // $where = array('party_type'=>$data['party_type'],'customer_id'=>$data['customer_id']);
        $where = array('party_type'=>$data['party_type'],'company_code'=>$data['company_code'],'branch_code'=>$data['branch_code']);
        $check = $this->db->get_where('tb_notify_management',$where)->result();
        if(count($check)>0){
            $this->db->where($where);
            $this->db->update('tb_notify_management',$data);
        } else {
            $this->db->insert('tb_notify_management',$data);
            $id = $this->db->insert_id();
            $notification_id = 'NOTIFY00'.$id;
            $this->db->where(array("id"=>$id));
            $this->db->update('tb_notify_management',array('notification_id'=>$notification_id));
        }
        return true;
    }

    function getCustomers($search){
        $this->db->select('id,code')->from('tb_customers');
        $this->db->where('user_id',$this->session->userdata('user_id'));
        $this->db->like('code',$search);
        $this->db->order_by('id','DESC');

        $result = $this->db->get();
        return $result->result_array();
    }

    function getNotifyData($where){
        $this->db->select('pt.id partytype_id,pt.name partytype,nm.*')->from('tbl_party_types pt');
        $this->db->join('tb_notify_management nm','nm.party_type_id = pt.id','LEFT');
        $this->db->where($where);
        $this->db->where('nm.status',1);
        $this->db->group_by('pt.name');
        $result = $this->db->get();
        //print_r($this->db->last_query()); exit;
        if(count($result->result_array())>0){
            $finalarray = array();
            $where['party_type'] = 'Admin';
            unset($where['pt.status']);
            $admintype = $this->db->get_where('tb_notify_management nm',$where)->row_array();
            if($admintype){
                $admintype['partytype_id'] = 0;
                $admintype['partytype'] = 'Admin';
                $finalarray = array($admintype);
            }
            $finalarray = array_merge($finalarray,$result->result_array());
            return $finalarray;
            //return $result->result_array();
        } else {
            $result = array(array('partytype_id'=>0,'partytype'=>'Admin'));;
            $this->db->select('pt.id partytype_id,pt.name partytype')->from('tbl_party_types pt');
            $this->db->where('user_id',$this->session->userdata('user_id'));
            $this->db->order_by('pt.name','ASC');
            $this->db->group_by('pt.name');
            $result = array_merge($result,$this->db->get()->result_array());
            $col = array(
                'id' =>0,
                'notification_id' => '',
                'party_id' => 0,
                'booking_create' => 0,
                'booking_delete' => 0,
                'booking_edit' => 0,
                'trip_create' => 0,
                'trip_delete' => 0,
                'trip_edit' => 0,
                'driver_accept' => 0,
                'pickup_note' => 0,
                'delivery_note' => 0,
                'pod_note' => 0,
                'push_note' => 0,
                'route_deviate' => 0,
                'speed' => 0,
                'temperature' => 0,
                'email_note' => 0,
                'sms_note' => 0,
                'whatsapp_note' => 0,
                );
            foreach($result as $r){
                $return [] = array_merge($r,$col);
            }
            return $return;
        }
    }

    function orderinvolvedparties($order_id){
        $this->db->select('m.id as party_master_id,m.name as username,m.email as emailid,m.mobile as mobile,p.name as party_type')->from('tb_order_parties t');
        $this->db->join('tbl_party_master m','t.party_id=m.id','LEFT');
        $this->db->join('tbl_party_types p','p.id=m.party_type_id','LEFT');
        $this->db->where('t.status',1);
        $this->db->where('t.order_id',$order_id);
       // $this->db->group_by('t.party_type');
        $this->db->order_by('m.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function getNotifyTrigger($where){
        $this->db->select('*')->from('tb_notify_management');
        $this->db->where($where);
        $query = $this->db->get();
        return $query->row_array();
    }

    function getCountries(){
        $this->db->select('id,country_name')->from('tbl_country_master');
        $this->db->where('status',1);
        $this->db->order_by('country_name','ASC');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getConsigneeDetailsByOrderId(int $orderRowId): array
    {
        $getCustomerCid = $this->db->query("select o.id,o.order_id,o.branch_code,c.name,c.code,c.email_id,o.company_code FROM tb_orders o,tb_customers c WHERE (o.id = ? OR o.order_id = ? ) AND o.customer_id = c.id", [$orderRowId, $orderRowId]);
        $customerCid = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->code : "";
        $bookingId = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->order_id : "";
        $companyCode = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->company_code : "";
        $customerMail = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->email_id : "";
        $customerName = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->name : "";
        $orderRowId = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->id : "";
        $branchCode = $getCustomerCid->num_rows() > 0 ? $getCustomerCid->row()->branch_code : "";
        $checkNZCustomerCid = checkAccessConditions('RELATED_2_NZCONSIGNEE_MAILS', $customerCid);
        $checkOtherCustomersQuery = $this->db->query("SELECT id FROM statusnotification_customers WHERE customer_cid = ? AND company_code = ? AND status = ?", [$customerCid, $companyCode, '1']);
        $checkOtherCustomerCid = $checkOtherCustomersQuery->num_rows() > 0 ? $checkOtherCustomersQuery->row_array() : [];
        if (!$checkNZCustomerCid && empty($checkOtherCustomerCid)) {
            return [];
        }
        $getDeliveryNote = $this->db->query("SELECT ref_value FROM tb_order_references WHERE order_id = ? AND reference_id = ? AND status = ? ", [$orderRowId, 'DQ', '1']);
        $deliveryNote = $getDeliveryNote->num_rows() > 0 ? $getDeliveryNote->row()->ref_value : "";
        $getConsignee = $this->db->query("SELECT o.party_id,t.name FROM tb_order_parties o,tbl_party_types t WHERE o.order_id =? AND o.status =? AND o.party_type=t.id AND t.name IN ?", [$orderRowId, '1', ['Consignee', 'Delivery']]);
        $getConsigneeData = $getConsignee->num_rows() > 0 ? $getConsignee->result_array() : [];
        $consigneeData = [];
        if (empty($getConsigneeData)) {
            return  ['mailId' => "", 'name' => "", 'bookingId' => $bookingId, 'deliveryNote' => $deliveryNote, 'companyCode' => $companyCode, 'customerCid' => $customerCid, 'customerMail' => $customerMail, 'customerName' => $customerName, 'branchCode' => $branchCode ?? ""];
        }
        foreach ($getConsigneeData as $eachLine) {
            $partyName = strtolower($eachLine['name']);
            $consigneeData[$partyName] = $eachLine['party_id'];
        }
        $consigneeRowId = $consigneeData['consignee'] ?? 0;
        $partyRowId = $consigneeData['delivery'] ?? $consigneeRowId;
        if ($partyRowId === 0) {
            return ['mailId' => "", 'name' => "", 'bookingId' => $bookingId, 'deliveryNote' => $deliveryNote, 'companyCode' => $companyCode, 'customerCid' => $customerCid, 'customerMail' => $customerMail, 'customerName' => $customerName, 'branchCode' => $branchCode ?? ""];
        }
        $getConsigneeMailId = $this->db->query("SELECT name,email,code FROM tbl_party_master WHERE id = ?", [$partyRowId]);
        $consigneeName = $getConsigneeMailId->num_rows() > 0 ? $getConsigneeMailId->row()->name : "";
        $consigneeMail = $getConsigneeMailId->num_rows() > 0 ? $getConsigneeMailId->row()->email : "";
        $consigneeCode = $getConsigneeMailId->num_rows() > 0 ? $getConsigneeMailId->row()->code : "";
        if ($checkNZCustomerCid) {
            $getNzMail = $this->db->query("SELECT email_id FROM nz_consignee_mailids WHERE consignee_code = ? AND status = ?", [$consigneeCode, 1]);
            $consigneeMail = $getNzMail->num_rows() > 0 ? $getNzMail->row()->email_id : "";
        }
        return ['mailId' => $consigneeMail, 'name' => $consigneeName, 'bookingId' => $bookingId, 'deliveryNote' => $deliveryNote, 'companyCode' => $companyCode, 'customerCid' => $customerCid, 'customerMail' => $customerMail, 'customerName' => $customerName, 'branchCode' => $branchCode ?? ""];
    }

    public function getDataForCarrierNotification(int $shiftId): array
    {
        $query = $this->db->query(
                            "SELECT
                  (
                    SELECT
                      GROUP_CONCAT(
                        DISTINCT r.ref_value SEPARATOR '/'
                      )
                    FROM
                      tb_order_references r
                      JOIN tb_orders rd ON rd.id = r.order_id
                    WHERE
                      rd.shift_id = ?
                      AND r.reference_id IN ('XSR')
                      AND r.status = 1
                      AND rd.status != 0
                  ) AS salog_tracking_nos,
                  GROUP_CONCAT(o.order_id SEPARATOR '/') as booking_ids,
                  (
                    SELECT
                      GROUP_CONCAT(concat(code, '?????', email))
                    FROM
                      tb_vendors v
                    WHERE
                      v.id = o.vendor_id
                      AND status = 1
                    GROUP BY o.vendor_id
                  ) AS carrier_mail,
                   o.branch_code
                FROM
                  `tb_orders` `o`
                WHERE
                  o.shift_id = ?
                  AND o.id != 0",
            [$shiftId,$shiftId]
        );
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getOrderDataForStatusNotification(string $bookingId): array
    {
        $query = $this->db->query(
            "SELECT
                  o.branch_code,
                  o.customer_id,
                  c.code,
                  c.name,
                  r.ref_value as salog_tracking_no,
                  r1.ref_value as salog_creator_email,
                  v.email AS carrier_mail
                FROM
                  `tb_orders` `o`
                  LEFT JOIN `tb_customers` `c` ON `o`.`customer_id` = `c`.`id`
                  LEFT JOIN `tb_vendors` `v` ON `o`.`vendor_id` = `v`.`id`
                  LEFT JOIN `tb_order_references` `r` ON `o`.`id` = `r`.`order_id`
                  AND `r`.`reference_id` = 'XSR'
                  AND `r`.`status` = 1
                  LEFT JOIN `tb_order_references` `r1` ON `o`.`id` = `r1`.`order_id`
                  AND `r1`.`reference_id` = 'SAC'
                  AND `r1`.`status` = 1
                WHERE
                  o.order_id = ?
                 ", [$bookingId]
        );
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
}



