<?php

use App\Models\OrderList\Search\SearchInterface;
use App\Models\Table;

class Order extends Table implements SearchInterface
{
    public const TABLE = "tb_orders";

    public const STOPPAGE_COL = "Stoppage";
    public const ASSIGNED_TO_COL = "assigned_to";
    public const BRANCH_CODE_COL = "branch_code";
    public const CARGO_APPROVAL_COL = "cargo_approval";
    public const CATEGORY_ID_COL = "category_id";
    public const COMPANY_CODE_COL = "company_code";
    public const CONSIGNEE_ID_COL = "consignee_id";
    public const CREATED_SOURCE_COL = "created_source";
    public const CREATEDON_COL = "createdon";
    public const CREDIT_APPROVAL_COL = "credit_approval";
    public const CURRENCY_COL = "currency";
    public const CUSTOMER_AREA_COL = "customer_area";
    public const CUSTOMER_CODE_COL = "customer_code";
    public const CUSTOMER_COMMENTS_COL = "customer_comments";
    public const CUSTOMER_EMAIL_COL = "customer_email";
    public const CUSTOMER_ID_COL = "customer_id";
    public const CUSTOMER_NAME_COL = "customer_name";
    public const CUSTOMER_PHONE_COL = "customer_phone";
    public const DEDICATED_VEHICLE_COL = "dedicated_vehicle";
    public const DELIVERY_ADDRESS1_COL = "delivery_address1";
    public const DELIVERY_ADDRESS2_COL = "delivery_address2";
    public const DELIVERY_CITY_COL = "delivery_city";
    public const DELIVERY_COMPANY_COL = "delivery_company";
    public const DELIVERY_COUNTRY_COL = "delivery_country";
    public const DELIVERY_DATETIME_COL = "delivery_datetime";
    public const DELIVERY_PINCODE_COL = "delivery_pincode";
    public const DESTINATION_BRANCH_COL = "destination_branch";
    public const DLAT_COL = "dlat";
    public const DLNG_COL = "dlng";
    public const DROP_CUSTID_COL = "drop_custid";
    public const DROP_ENDTIME_COL = "drop_endtime";
    public const DROP_PARTYID_COL = "drop_partyid";
    public const GOODS_VALUE_COL = "goods_value";
    public const HOLD_TYPE_COL = "hold_type";
    public const ID_COL = "id";
    public const IS_CREATED_COL = "is_created";
    public const LOGICALRECEIVER_COL = "logicalreceiver";
    public const LOGICALSENDER_COL = "logicalsender";
    public const MODEOFTRANSPORT_COL = "modeoftransport";
    public const ORDER_ID_COL = "order_id";
    public const EXTERNAL_ORDER_ID_COL = "external_order_id";
    public const ORDER_STATUS_COL = "order_status";
    public const PARENT_ID_COL = "parent_id";
    public const PHYSICALRECEIVER_COL = "physicalreceiver";
    public const PHYSICALSENDER_COL = "physicalsender";
    public const PICKUP_ADDRESS1_COL = "pickup_address1";
    public const PICKUP_ADDRESS2_COL = "pickup_address2";
    public const PICKUP_CITY_COL = "pickup_city";
    public const PICKUP_COMPANY_COL = "pickup_company";
    public const PICKUP_COUNTRY_COL = "pickup_country";
    public const PICKUP_CUSTID_COL = "pickup_custid";
    public const PICKUP_DATETIME_COL = "pickup_datetime";
    public const PICKUP_ENDTIME_COL = "pickup_endtime";
    public const PICKUP_PARTYID_COL = "pickup_partyid";
    public const PICKUP_PINCODE_COL = "pickup_pincode";
    public const PLAT_COL = "plat";
    public const PLNG_COL = "plng";
    public const PRODUCT_COL = "product";
    public const QUANTITY_COL = "quantity";
    public const RESOLUTION_ID_COL = "resolution_id";
    public const SHIFT_ID_COL = "shift_id";
    public const SHIPMENT_ID_COL = "shipment_id";
    public const SHIPMENTID_COL = "shipmentid";
    public const SHIPPER_ID_COL = "shipper_id";
    public const STATUS_COL = "status";
    public const SUB_UID_COL = "sub_uid";
    public const TRANSPORT_MODE_COL = "transport_mode";
    public const TRIP_ID_COL = "trip_id";
    public const TRIP_STS_COL = "trip_sts";
    public const UPDATEDON_COL = "updatedon";
    public const USER_ID_COL = "user_id";
    public const VEHICLE_TYPE_COL = "vehicle_type";
    public const VENDOR_AREA_COL = "vendor_area";
    public const VENDOR_CODE_COL = "vendor_code";
    public const VENDOR_COMMENTS_COL = "vendor_comments";
    public const VENDOR_EMAIL_COL = "vendor_email";
    public const VENDOR_ID_COL = "vendor_id";
    public const VENDOR_NAME_COL = "vendor_name";
    public const VENDOR_PHONE_COL = "vendor_phone";
    public const VOLUME_COL = "volume";
    public const WEIGHT_COL = "weight";
    public const SALOG_STATUSES = [
        'SALOG PENDING',
        'SALOG ACTIVE',
        'SALOG CLOSED',
        'SALOG TO BE BILLED',
        'SALOG CANCELLED'
    ];

    public function __construct()
    {
        parent::__construct();
    }

    protected function set_active_condition(array &$conditions): void
    {
        $conditions[static::TABLE . '.' . static::STATUS_COL] = [1, 2];
    }

    public function getamzorderdata($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts)
    {
        // to prevent slow query, it's best to gather order id's as prefetch query

        $this->db->select("o.id");
        $this->db->from("tb_orders o");
        $this->extractedConditionsToGetAmzOrderDataQuery($searchids, $whr, $userid, $countryuids, $searchsts, $subcusts, $custid);
        $query = $this->db->get();

        if (empty($orderIds = $query->result())) {
            return [];
        }

        // now prepare main query with subqueries using order id's from prefetch query

        $orderIds = array_map(function($row) { return $row->id; }, $orderIds);
        $orderIdsCondition = implode(',', $orderIds);

        $subQuery1 = "(select order_id, CONCAT(GROUP_CONCAT(json_object(reference_id, ref_value)  SEPARATOR ',')) as reference_value
            from tb_order_references ar where
            reference_id IN ('DQ','CTR','PO','AWB')
            AND order_id in ( ".$orderIdsCondition." )
            group by order_id
         ) as reference_inner ";

        $subQuery2 = "(select order_id, group_concat(json_object(
               \"type\", type,
               \"invoice_status\", invoice_status,
               \"recipient_name\", recipient_name,
               \"amount\", concat(currency,' ',amount)
            ) order by type desc) as invoice_details
         from tb_reveneus
            WHERE status = 1
            AND order_id in ( ".$orderIdsCondition." )
            group by order_id) as invoice_inner ";

        $this->db->select(
            "invoice_inner.invoice_details,reference_inner.reference_value,o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.company_code,o.branch_code,o.trip_sts,o.trip_id,o.shipmentid,o.createdon,o.updatedon,o.created_source,o.parent_id,o.weight as totwg,o.volume as totvol,o.quantity as totqty"
        );
        $this->db->from("tb_orders o");
        $this->db->join($subQuery1, 'o.id = reference_inner.order_id', 'LEFT');
        $this->db->join($subQuery2, 'o.id = invoice_inner.order_id', 'LEFT');
        $this->extractedConditionsToGetAmzOrderDataQuery($searchids, $whr, $userid, $countryuids, $searchsts, $subcusts, $custid);
        $this->db->order_by("o.createdon", 'DESC');

        $this->db->query("SET SESSION group_concat_max_len = 1000000");
        $getorder = $this->db->get();

        return $getorder->result_array();
    }


    private function extractedConditionsToGetAmzOrderDataQuery($searchids, $whr, $userid, $countryuids, $searchsts, $subcusts, $custid): void
    {
        $this->db->where("o.status !=", 0);

        if (!empty($searchids)) {
            $this->db->where_in("o.order_id", $searchids);
            unset($whr['o.order_id']);
        }

        if ($userid != '0') {
            if (!empty($countryuids)) {
                $this->db->where_in("o.user_id", $countryuids);
            } else {
                $this->db->where("o.user_id", $userid);
            }
        }

        if ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING') {
            $this->db->where("o.trip_id", 0);
            $this->db->where("o.trip_sts", 0);
        }

        if ($searchsts == 'ACTIVE' || $searchsts == 'SALOG ACTIVE') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 0);
        }

        if ($searchsts == 'CLOSED' || $searchsts == 'SALOG CLOSED') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 1);
        }

        if ($searchsts == 'SALOG PENDING' || $searchsts == 'SALOG ACTIVE' || $searchsts == 'SALOG CLOSED' || $searchsts == 'SALOG TO BE BILLED') {
            $this->db->where('o.created_source', '5');
        }

        if ($searchsts == 'SALOG TO BE BILLED') {
            $salogorders = $this->getsalogtobebilled($countryuids, $userid, $subcusts, $custid);

            if (!empty($salogorders)) {
                $this->db->where_in('o.order_id', $salogorders);
            } else {
                $this->db->where('o.id', 0);
            }
        }

        if (!empty($subcusts)) {
            $this->db->where_in("o.customer_id", $subcusts);
        } elseif (!empty($custid)) {
            $this->db->where_in('o.customer_id', $custid);
        }

        if (isset($whr['o.customer_id'])) {
            $this->db->where_in('o.customer_id', $whr['o.customer_id']);
            unset($whr['o.customer_id']);
        }

        $this->db->where($whr);
        $this->db->group_by("o.id");
    }

    public function getOrderByOrderId(string $order_id): object {
        $query = $this->db->query(
            "SELECT * FROM tb_orders WHERE order_id = ? ORDER BY id desc LIMIT 1",
            [$order_id]
        );

        return $query->row();
    }

    public function getOrderById(string $id): object {
        $query = $this->db->query(
            "SELECT * FROM tb_orders WHERE id = ?",
            [$id]
        );

        return $query->row();
    }

    /**
     * @param array $ids
     * @return string
     */
    public function getIdByOrderId(array $ids)
    {
        if (empty($ids)) {
            return false;
        }

        try {
            $query = "SELECT group_concat(id) as order_numbers FROM tb_orders WHERE order_id in ?";
            $result = $this->db->query($query, [$ids])->row();

            return isset($result->order_numbers) ? $result->order_numbers : false;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getsalogtobebilled($countryuids, $userid, $subcusts, $custid)
    {
        $order_ids = array();
        $company_code = $this->session->userdata('company_code');
        $permission = checkuserpermissions();
        $whr = " AND o.user_id ='" . $userid . "' ";
        if (in_array('orders', $permission)) {
            $whr = " AND o.company_code LIKE '" . $company_code . "' ";
        } else {
            if ($userid != '0') {
                if (!empty($countryuids)) {
                    $whr = " AND o.user_id IN ('" . implode('', $countryuids) . "') ";
                } else {
                    $whr = " AND o.user_id ='" . $userid . "' ";
                }
            }
        }
        if (!empty($subcusts)) {
            $whr = " AND o.customer_id IN ('" . implode('', $subcusts) . "') ";
        } else {
            if ($custid != "") {
                $whr = " AND o.customer_id ='" . $custid . "' ";
            }
        }
        $qry = $this->db->query(
            "SELECT o.order_id FROM tb_reveneus r,tb_orders o WHERE o.status !='0' " . $whr . " AND o.created_source ='5' AND o.id=r.order_id AND r.recipient_role LIKE 'Internal BU' AND r.status ='1' AND r.invoice_status < '3' "
        );
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $order_ids[] = $res->order_id;
            }
        }
        return $order_ids;
    }


    public function indexQuery($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts, $mapping = null): CI_DB_query_builder
    {
        if (
            empty(
            array_filter(
                [
                    $searchids,
                    $searchsts,
                    $custid,
                    $countryuids,
                    $whr,
                    $subcusts,
                    $mapping
                ],
                static function ($element) {
                    return !empty($element);
                }
            )
            )
        ) {
            $whr['date(o.createdon) >='] = (new DateTime())->format('Y-m-d');
            $whr['date(o.createdon) <='] = (new DateTime())->format('Y-m-d');
        }

        $orderIds = $mapping && !empty($mapping) ? $mapping : $searchids;

        $tbReveneusJoin = "
		    (SELECT order_id,
                    GROUP_CONCAT(json_object(
                       'type', type,
                       'invoice_status', invoice_status,
                       'recipient_name', recipient_name,
                       'amount', concat(currency,' ',amount),
                       'debtor_jfr', debtor_jfr
                    ) ORDER BY type DESC) as invoice_details
                FROM tb_reveneus
                WHERE status = 1
                GROUP BY order_id
            ) as invoice_inner ";

        $company_code = $this->session->userdata('company_code');

        //For VNKN estimated delivery date should be late delivery date, NEW TRIPS MODULE CODE
        $query = $this->db->select(
            "
                tu.name as username,o.pickup_partyid,
                (SELECT (CASE
                        WHEN o.vendor_id > 0 THEN v.name
                        WHEN o.vendor_id = 0 AND o.shift_id > 0 THEN (SELECT name FROM tb_vendors WHERE id = (SELECT vendor_id from tb_shifts where id = o.shift_id) LIMIT 1)
                    ELSE
                        ''
                    END)) AS vendor_name, (SELECT (CASE
                        WHEN o.vendor_id > 0 THEN v.code
                        WHEN o.vendor_id = 0 AND o.shift_id > 0 THEN (SELECT code FROM tb_vendors WHERE id = (SELECT vendor_id from tb_shifts where id = o.shift_id) LIMIT 1)
                    ELSE
                        ''
                    END)) AS vendor_code,
                invoice_inner.invoice_details as invoice_details,
                d.order_status as order_detail_status,
                o.id,
                o.order_id,
                o.pickup_datetime,
                o.delivery_datetime,
                o.drop_endtime,
                o.pickup_company as pickup,
                o.delivery_company as delivery,
                o.delivery_city,
                o.weight,
                o.gross_weight_uom,
                o.chargeable_weight,
                o.chargeable_weight_uom,
                o.transport_mode,
                o.vendor_id,
                 o.customer_name as external_customer,
                o.company_code,
                o.branch_code,
                o.shipment_id,
                o.status,
                o.order_status,
                o.Stoppage,
                o.trip_sts,
                o.shift_id,
                o.trip_id,
                o.shipmentid as shipmentid,
                o.createdon,
                o.updatedon,
                o.created_source,
                o.parent_id,
                d.delivery_note,
                d.department_code,
                GROUP_CONCAT(`cx`.weight_unit) as weight_unit,
                `cx`.secondweight_uom,
                `cx`.secondvolume_uom,
                Sum(Case When c.status = '1' Then c.second_weight Else 0 End) as second_weight,
                Sum(Case When c.status = '1' Then c.second_volume Else 0 End) as second_volume,
                TRUNCATE(Sum(Case When c.status = '1' Then (Case When `cx`.`weight_unit` IN ('G', 'Gms', 'gms', 'grm') Then c.weight/1000 Else
                (Case When `cx`.`weight_unit` IN ('Kg', 'kg') Then c.weight Else
                    (Case When `cx`.`weight_unit` IN ('Tons', 'tons') Then c.weight * 1000 Else
                    CASE WHEN o.company_code ='AUKN' THEN c.weight ELSE 0 END
                    End) End) End) Else 0 End), 3) as totwg,
                SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,
                SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,
                SUM(Case When c.status = '1' Then c.scanned_quantity Else 0 End) as tot_scanned_qty,
                d.num_of_pallets,d.order_type,d.cost_center_id,s.createdon as delivered_time,
                (SELECT CONCAT(GROUP_CONCAT(json_object(reference_id, ref_value)  SEPARATOR ','))
                    FROM tb_order_references
                    WHERE reference_id IN ('DQ','CTR','MN','LPC','XSR','POS','ORD','PO','AWB','PQ') AND status=1 AND order_id = o.id
                    GROUP BY order_id
                ) as reference_value,
                cu.name as customer_name, cu.code as customer_code,
                (CASE WHEN (SELECT count(*) FROM tb_pod_uploads where order_id = o.id and doc_type='3' and stop_type='D') > 0 THEN 'YES' ELSE 'NO' END) as pod
            "
        );
        
        

        $query->from("tb_orders o");
        $query->join("tb_order_details d", "o.id=d.order_row_id AND o.order_id = d.order_id", "LEFT");
        $query->join("tb_users tu", "tu.id=o.user_id", "LEFT");
        $query->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $query->join("tb_cargo_details cx", "c.cargo_id=cx.id", "LEFT");
        $query->join("tb_stop_status s", "o.id=s.order_id AND s.status_code='3000' AND s.status ='1'", "LEFT");
        $query->join("tb_vendors v", "v.id=o.vendor_id", "LEFT");
        $query->join("tb_customers cu", "cu.id = o.customer_id", 'left');        //Vivek B updated query
        $query->join($tbReveneusJoin, 'o.id = invoice_inner.order_id', 'LEFT');

        //Search option change for scanned and manifested orders
        if ($searchsts == 'SCANNED') {
            $query->join("tb_order_status os", "o.id=os.order_id AND os.status_code ='2491'", "LEFT");
        }


        if (!in_array($searchsts, ['CLOSED','SALOG CLOSED'])) {
            $query->where("o.status !=", 0);
        }


        if (!empty($orderIds)) {
            $query->where_in("o.order_id", $orderIds);
            unset($whr['o.order_id']);
        }

        $permission = checkuserpermissions();

        if (in_array('orders', $permission)) {
            $query->where("o.company_code", $company_code);
        } elseif ($userid != '0') {
            if (!empty($countryuids)) {
                $query->where_in("o.user_id", $countryuids);
            } else {
                $query->where("o.user_id", $userid);
            }
        }

        if (isset($company_code) && $company_code == 'AUKN' && ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING')) {
            $au_where = "(o.id NOT IN (select order_id from tb_order_status where  order_id=o.id and status_code ='2491'))";
            $query->where($au_where);

            /* NEW TRIPS MODULE CODE */
            $wherepen = "(o.trip_id=0 AND o.shift_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
            $query->where($wherepen);
            $query->where("o.trip_id", 0);
			$query->where("o.trip_sts", 0);
            $query->where("o.status !=", 3);
        } elseif ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING') {
            /* NEW TRIPS MODULE CODE */
            $wherepen = "(o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
            $query->where($wherepen);
            $query->where("o.trip_id", 0);
			$query->where("o.trip_sts", 0);
            $query->where("o.status !=", 3);
        }

        if (in_array($searchsts, self::SALOG_STATUSES)) {
            $query->where('o.created_source', '5');
        }

        if ($searchsts == 'ACTIVE' || $searchsts == 'SALOG ACTIVE') {
            $query->where("o.trip_id !=", 0);
            /* NEW TRIPS MODULE CODE */
            $whereact = "(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
            $query->where($whereact);
            $query->where("o.trip_sts", 0);
            $query->where("o.status !=", 3);
        } elseif ($searchsts == 'CLOSED' || $searchsts == 'SALOG CLOSED') {
            /* NEW TRIPS MODULE CODE */
            $whereact = "(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
            $query->where($whereact);
            $query->where("o.trip_sts", 1);
            $query->where("o.status !=", 3);
        } elseif ($searchsts == 'SALOG TO BE BILLED') {
            $salogorders = $this->getsalogtobebilled($countryuids, $userid, $subcusts, $custid);

            if (!empty($salogorders)) {
                $query->where_in('o.order_id', $salogorders);
            } else {
                $query->where('o.id', 0);
            }
            $query->where("o.status !=", 3);
        } elseif ($searchsts == 'SALOG CANCELLED' || $searchsts == 'CANCELLED') {
            $query->where("o.status", 3);
        }

        if (!empty($subcusts)) {
            $query->where_in("o.customer_id", $subcusts);
        } elseif (!empty($custid)) {
            $query->where_in('o.customer_id', $custid);
        }

        if (isset($whr['o.customer_id'])) {
            $query->where_in('o.customer_id', $whr['o.customer_id']);
            unset($whr['o.customer_id']);
        }

        if (isset($whr['o.delivery_company'])) {
            $query->like('o.delivery_company', $whr['o.delivery_company']);
            unset($whr['o.delivery_company']);
        }

        if (isset($whr['o.pickup_company'])) {
            $query->like('o.pickup_company', $whr['o.pickup_company']);
            unset($whr['o.pickup_company']);
        }

        $query->where($whr);
        $query->group_by("o.id");
        $query->order_by("o.id", 'DESC');

        return $query;
    }

    /**
     * @param int $userid
     * @param array $searchids
     * @param string $searchsts
     * @param string $custid
     * @param array $countryuids
     * @param array $whr
     * @param array $subcusts
     * @param null|array $mapping
     * @return array
     */
    public function getorderdata(
        $userid,
        $searchids,
        $searchsts,
        $custid,
        $countryuids,
        $whr,
        $subcusts,
        $mapping = null
    ) {
        $query = $this->indexQuery($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts, $mapping);
        $this->db->query("SET SESSION group_concat_max_len = 1000000");
        $getorder = $query->get();

        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }

        return $result;
    }

    public function getorderids_xborder($orderids, $searchTerm)
    {
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where("status !=", 0);
        if (!empty($orderids)) {
            $this->db->where_in("id", $orderids);
        } else {
            $this->db->where("id", 0);
        }
        $this->db->like("order_id", $searchTerm);
        $this->db->order_by("createdon", 'DESC');
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getorders_bypartymaster($type, $cid, $userid, $countryuids, $subcusts, $custid)
    {
        $result = array();
        $permission = checkuserpermissions();
        $whr = "AND t.name LIKE '" . $type . "' AND (m.code LIKE '" . $cid . "' OR m.name LIKE '" . $cid . "' )";
        if (in_array('orders', $permission)) {
            $company_code = $this->session->userdata('company_code');
            $whr .= "AND o.company_code LIKE '" . $company_code . "' ";
        } else {
            if ($userid != '0') {
                if (!empty($countryuids)) {
                    $whr .= "AND o.user_id IN (" . implode(',', $countryuids) . ") ";
                } else {
                    $whr .= "AND o.user_id ='" . $userid . "' ";
                }
            } else {
                if (!empty($subcusts)) {
                    $whr .= "AND o.customer_id IN (" . implode(',', $subcusts) . ") ";
                } else {
                    if ($custid != "") {
                        $whr .= "AND o.customer_id = '" . $custid . "' ";
                    }
                }
            }
        }
        $chkqry = $this->db->query(
            "SELECT o.order_id FROM tb_orders o,tbl_party_master m,tbl_party_types t,tb_order_parties p WHERE p.order_id =o.id AND t.id=p.party_type AND m.id=p.party_id AND p.status ='1' AND m.status='1' " . $whr
        );
        /*
         * $this->db->select("o.order_id");
         * $this->db->from("tb_orders o");
         * $this->db->join("tb_order_parties p","p.order_id=o.id AND p.status ='1'","LEFT");
         * $this->db->join("tbl_party_types t","t.id=p.party_type AND p.status ='1'","LEFT");
         * $this->db->join("tbl_party_master m","m.id=p.party_id AND m.status ='1'","LEFT");
         * $this->db->where("t.name",$type);
         * $this->db->where("m.code",$cid);
         * $permission = checkuserpermissions();
         * if(in_array('orders', $permission)){
         * $company_code = $this->session->userdata('company_code');
         * $this->db->where("o.company_code",$company_code);
         * }else{
         * if ( $userid != '0' ) {
         * if ( ! empty( $countryuids ) ) {
         * $this->db->where_in( "o.user_id", $countryuids );
         * } else {
         * $this->db->where( "o.user_id", $userid );
         * }
         * }
         * }
         * if ( ! empty( $subcusts ) ) {
         * $this->db->where_in( "o.customer_id", $subcusts );
         * } else {
         * if ( $custid != "" ) {
         * $this->db->where( 'o.customer_id', $custid );
         * }
         * }
         * $chkqry = $this->db->get();
         */
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $result[] = $res->order_id;
            }
        }
        return $result;
    }

    public function getxborderorderdata($searchids, $searchsts, $whr)
    {
        $this->db->select(
            "o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,o.createdon,d.delivery_note,d.department_code, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $this->db->where("o.status !=", 0);
        if (!empty($searchids)) {
            $this->db->where_in("o.order_id", $searchids);
        } else {
            $this->db->where_in("o.id", 0);
        }
        if ($searchsts == 'PENDING') {
            $this->db->where("(o.trip_id=0 AND o.shift_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)");
        }
        if ($searchsts == 'ACTIVE') {
            $this->db->where("(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))");
            $this->db->where("o.trip_sts", 0);
        }
        if ($searchsts == 'CLOSED') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 1);
        }
        $this->db->where($whr);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        $result = $getorder->num_rows() > 0 ? $getorder->result_array() : [];
        if (!empty($result)) {
            $reqData = ['id', 'order_id'];
            $this->db->query('SET SESSION  group_concat_max_len=10240');
            $this->load->model('DataArrayFormatter_model');
            $this->load->model('DataQueryFormatter_model');
            $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $result);
            if (isset($formattedData['commaSeparated']['order_id'])) {
                $tripCountData = $this->DataQueryFormatter_model->getTripCountFromEmployee($formattedData['commaSeparated']['order_id']);
            }
        }
        return ['orders' => $result, 'trips' => $tripCountData ?? []];
    }

    public function getcustomercodebyids($select, $table, $ids)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where_in('id', $ids);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }

        return $result;
    }

    public function getordertoedit($id)
    {
        $this->db->select(
            "o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.plat,o.plng,o.dlat,o.dlng,o.shipment_id,o.delivery_datetime,o.drop_endtime,
            o.pickup_company as pickup,o.delivery_company as delivery,o.pickup_address1,o.delivery_address1,
            o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,
            o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.currency,
            o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,o.pickup_partyid,
            o.drop_custid,o.drop_partyid,o.trip_sts,o.shift_id,o.trip_id,o.status,o.order_status,o.createdon,
            o.updatedon,o.shipmentid,o.consignee_id,o.shipper_id as o_shipper_id,o.created_source,d.order_type,d.shipper_id,d.service,
            d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,
            d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code,
            d.docs_received_datetime,d.docs_sent_datetime,d.consignment_note,d.order_remarks,d.cost_center_id,
            o.external_order_id,o.logicalreceiver,o.physicalreceiver,o.physicalsender,o.logicalsender,o.volume,o.weight, o.user_id"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->where("o.id", $id);
        $this->db->limit(1);
        $chkorder = $this->db->get();

        return $chkorder;
    }

    public function getOrderForAuthorization($id)
    {
        $this->db->select(
            "o.user_id,o.company_code,o.branch_code,o.customer_id,o.vendor_id"
        );
        $this->db->from("tb_orders o");
        $this->db->where("o.id", $id);
        $this->db->limit(1);

        return $this->db->get();
    }

    public function getpickupdetails($id)
    {
        $getpickupdetails = $this->db->query(
            "SELECT id,name,address,pincode,code,country FROM tb_customers WHERE status='1' AND id='" . $id . "' LIMIT 1"
        );

        return $getpickupdetails;
    }

    public function getpartydetailsbycid($id)
    {
        $getdetails = $this->db->query(
            "SELECT id,name,email,street,location_id as city,state,mobile,pincode,country,customeridentifier,fax,partyindetifier FROM tbl_party_master WHERE status='1' AND customeridentifier='" . $id . "' ORDER BY id DESC LIMIT 1"
        );

        return $getdetails;
    }

    public function getpartydetailsbyid($id)
    {
        $getdetails = $this->db->query(
            "SELECT id,name,email,street,location_id as city,state,mobile,pincode,country,customeridentifier,fax,partyindetifier FROM tbl_party_master WHERE status='1' AND id='" . $id . "' ORDER BY id DESC LIMIT 1"
        );

        return $getdetails;
    }

    public function getreferencebyorder($id)
    {
        $getreference = $this->db->query(
            "SELECT o.ref_value,r.id,r.name FROM tb_order_references o,tb_reference_master r WHERE o.order_id='" . $id . "' AND o.reference_id=r.name AND o.status='1' AND r.status='1' ORDER BY o.id DESC"
        );

        return $getreference->result_array();
    }

    public function getcreditdata($table, $order_id)
    {
        $result = array();
        $this->db->select("*");
        $this->db->from($table);
        $this->db->where("order_id", $order_id);
        $this->db->where("status", 1);
        $result = $this->db->get();

        return $result;
    }

    public function getmasters($table, $select)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where("status", 1);
        $result = $this->db->get();

        return $result;
    }

    public function getchargesforrevenuemodel($revenue_id)
    {
        $getcharges = $this->db->select("*")->get_where("tb_charges", array('revenue_id' => $revenue_id, 'status' => 1)
        );
        $this->db->select("c.*,c1.charge_code as chargecode");
        $this->db->from("tb_charges c");
        $this->db->join("tb_charge_codes c1", "c.charge_code=c1.id", "LEFT");
        $this->db->where("c.revenue_id", $revenue_id);
        $this->db->where("c.status", 1);
        $getcharges = $this->db->get();

        return $getcharges;
    }

    public function getchargecodes($code)
    {
        $this->db->select("id,name");
        $this->db->from("tb_charge_codes");
        $this->db->where('status', 1);
        $this->db->like('name', $code);
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getorderids($user_id, $custid, $searchTerm)
    {
        $company_code = $this->session->userdata('company_code');
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where("status !=", 0);

        $this->db->like("order_id", $searchTerm);
        if (!empty($custid)) {
            $this->db->where_in("customer_id", $custid);
        } else {
            $permission = checkuserpermissions();
            if (in_array("orders", $permission)) {
                $company_code = $this->session->userdata('company_code');
                $this->db->where("company_code", $company_code);
            } else {
                $this->db->where("user_id", $user_id);
            }
        }
        if ($this->session->userdata("user_role_id") == 3) {
            $this->db->where("vendor_id", $this->session->userdata("id"));
        }
        $this->db->order_by("createdon", 'DESC');
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getcountryuserorderids($user_id, $countryids, $searchTerm)
    {
        $company_code = $this->session->userdata('company_code');
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where("status !=", 0);
        $this->db->like("order_id", $searchTerm);
        if (!empty($countryids)) {
            $this->db->where_in("user_id", $countryids);
        }
        $this->db->order_by("createdon", 'DESC');
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getcustomerbasedservices($cust_code, $service_id)
    {
        $this->db->select('rs.id,rs.service_id,rs.service_name,rs.product');
        $this->db->from("tb_rate_services rs");
        $this->db->join("tb_rate_offerings ro", "rs.id=ro.rate_service_id", "LEFT");
        $this->db->join("tb_customer_profile cp", "cp.id=ro.cust_profile_id", "LEFT");
        $this->db->join("tb_customer_profile_list cl", "cp.id=cl.cp_id", "LEFT");
        $this->db->where("cl.profile_id", $cust_code);
        $this->db->where("rs.service_type", $service_id);
        $this->db->where('rs.status', 1);
        $this->db->where('cp.status', 1);
        $this->db->where('cl.status', 1);
        $this->db->where('ro.status', 1);
        $this->db->group_by('rs.id');
        $this->db->order_by("rs.id", "DESC");
        $chkqry = $this->db->get();
        return $chkqry;
    }

    public function getlanes_byservice($source, $service_id)
    {
        if (!empty($source)) {
            $whereCondition = $this->generateWhereConditionForGeo($source);
            if (!empty($whereCondition)) {
                $whereString = "( ".implode('OR', $whereCondition)." ) ";
                $this->db->select("l.id,l.lane_id,l.lane_name");
                $this->db->from("tb_lanes_master l");
                $this->db->join("tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT");
                $this->db->where($whereString);
                $this->db->where("rl.rate_id", $service_id);
                $this->db->where("rl.status", 1);
                $this->db->where("l.status", 1);
                $this->db->group_by('l.id');
                $this->db->order_by("l.id", "DESC");
                $query = $this->db->get();
                $response = $query->num_rows() > 0 ? $query->result_array() : [];
            }
        }
        return $response ?? [];
    }

    public function getlanes_byservicerange($service_id)
    {
        $this->db->select("l.id,l.lane_id,l.lane_name");
        $this->db->from("tb_lanes_master l");
        $this->db->join("tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT");
        $this->db->where("rl.rate_id", $service_id);
        $this->db->where("l.source_geo", 1);
        $this->db->where("l.destination_geo", 1);
        $this->db->where("rl.status", 1);
        $this->db->where("l.status", 1);
        $this->db->group_by('l.id');
        $this->db->order_by("l.id", "DESC");
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getifrangeexits($service_id)
    {
        $this->db->select("l.id,l.lane_id,l.lane_name");
        $this->db->from("tb_lanes_master l");
        $this->db->join("tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT");
        $this->db->where("rl.rate_id", $service_id);
        $this->db->where("l.source_geo", 1);
        $this->db->where("l.destination_geo", 1);
        $this->db->group_by('l.id');
        $this->db->order_by("l.id", "DESC");
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getVendorbasedservices($vendor_code, $service_id)
    {
        $this->db->select('rs.id,rs.service_id,rs.service_name');
        $this->db->from("tb_rate_services rs");
        $this->db->join("tb_rate_offerings ro", "rs.id=ro.rate_service_id", "LEFT");
        $this->db->join("tb_vendor_profile vp", "vp.id=ro.vendor_profile_id", "LEFT");
        $this->db->join("tb_vendor_profile_list vpl", "vp.id=vpl.vp_id", "LEFT");
        $this->db->where("vpl.profile_id", $vendor_code);
        $this->db->where("rs.service_type", $service_id);
        $this->db->where('rs.status', 1);
        $this->db->where('vp.status', 1);
        $this->db->where('vpl.status', 1);
        $this->db->where('ro.status', 1);
        $this->db->group_by('rs.id');
        $this->db->order_by("rs.id", "DESC");
        $chkqry = $this->db->get();

        return $chkqry;
    }

    /* Get customer profile by using customer code */
    public function getcustomerprofileforpreference($cust_code, $user_id)
    {
        $this->db->select('cp.id');
        $this->db->from("tb_customer_profile cp");
        $this->db->join("tb_customer_profile_list cpl", "cpl.cp_id=cp.id", "LEFT");
        $this->db->where("cpl.profile_id", $cust_code);
        $this->db->where("cp.user_id", $user_id);
        $this->db->where("cp.status", 1);
        $chkqry = $this->db->get();

        return $chkqry;
    }

    public function getvendorprofileforpreference($code, $user_id)
    {
        $this->db->select('vp.id');
        $this->db->from("tb_vendor_profile vp");
        $this->db->join("tb_vendor_profile_list vpl", "vpl.vp_id=vp.id", "LEFT");
        $this->db->where("vpl.profile_id", $code);
        $this->db->where("vp.user_id", $user_id);
        $this->db->where("vp.status", 1);
        $this->db->where("vpl.status", 1);
        $this->db->group_by("vp.id");
        $chkqry = $this->db->get();
        return $chkqry;
    }

    public function getvendorpreferencebyorderdetails($vend_profile_id, $user_id, $pickup, $delivery, $vendorProfiles = [],$rateRecord = "")
    {
        $whr = "";
        $result = [];
        if (!empty($pickup) && !empty($delivery)) {
            $whr = " (rps.country LIKE '" . $pickup['country'] . "' OR rps.state LIKE '" . $pickup['state'] . "' OR rps.city LIKE '" . $pickup['city'] . "' OR rps.pincode LIKE '" . $pickup['pincode'] . "') AND rps.user_id='" . $user_id . "' AND rps.status='1' AND (rds.country LIKE '" . $delivery['country'] . "' OR rds.state LIKE '" . $delivery['state'] . "' OR rds.city LIKE '" . $delivery['city'] . "' OR rds.pincode LIKE '" . $delivery['pincode'] . "' ) AND rds.user_id ='" . $user_id . "' AND rds.status='1' AND rp.status='1'";
        }
        $rateRecordRowId = 0;
        if ($whr != "") {
            if($rateRecord != ""){
                $getRateId = $this->db->query("SELECT id from tb_rate_records where rate_id = ? ",[$rateRecord]);
                $rateRecordRowId = $getRateId->num_rows() >0 ? $getRateId->row()->id :0;
            }
            $this->db->select('rp.id,rp.rate_prefer_id,rp.rate_service_id,rp.rate_offering_id,rp.rate_record_id,rp.auto_bill');
            $this->db->from("tb_rate_preferences rp");
            $this->db->join("tb_rateprefer_source rps", "rps.rate_prefer_id=rp.id", "LEFT");
            $this->db->join("tb_rateprefer_destination rds", "rds.rate_prefer_id=rp.id", "LEFT");
            if ($rateRecordRowId > 0) {
                $this->db->where("rp.rate_record_id", $rateRecordRowId);
            }
            if (!empty($vendorProfiles)) {
                $this->db->where_in("rp.vend_profile_id", $vendorProfiles);
            } else {
                $this->db->where("rp.vend_profile_id", $vend_profile_id);
            }
            $this->db->where("rp.tariff_type", '1');
            $this->db->group_by("rp.id");
            $this->db->where($whr);
            $chkqry = $this->db->get();
            if ($chkqry->num_rows() > 0) {
                $result = $chkqry->result_array();
            }
            return $result;
        }
    }

    /* Get rate Preference list by order details */
    public function getpreferencebyorderdetails($cust_profile_id, $user_id, $arr)
    {
        $result = array();
        $whr = "";
        if ($cust_profile_id != "" && $cust_profile_id != '0') {
            if (!empty($arr)) {
                $whr = " (rps.country LIKE '" . $arr['pickup'] . "' OR rps.state LIKE '" . $arr['pickup_state'] . "' OR rps.city LIKE '" . $arr['pickup_city'] . "' OR rps.pincode LIKE '" . $arr['pickup_pincode'] . "') AND rps.user_id='" . $user_id . "' AND rps.status='1' AND (rds.country LIKE '" . $arr['drop'] . "' OR rds.state LIKE '" . $arr['drop_state'] . "' OR rds.city LIKE '" . $arr['drop_city'] . "' OR rds.pincode LIKE '" . $arr['drop_pincode'] . "' ) AND rds.user_id ='" . $user_id . "' AND rds.status='1' AND rp.status='1'";
            }
            if ($whr != "") {
                $this->db->select('rp.id,rp.rate_service_id,rp.rate_offering_id,rp.rate_record_id,rp.auto_bill');
                $this->db->from("tb_rate_preferences rp");
                $this->db->join("tb_rateprefer_source rps", "rps.rate_prefer_id=rp.id", "LEFT");
                $this->db->join("tb_rateprefer_destination rds", "rds.rate_prefer_id=rp.id", "LEFT");
                $this->db->where("rp.cust_profile_id", $cust_profile_id);
                $this->db->where("rp.tariff_type", '0');
                $this->db->where("rp.user_id", $user_id);
                $this->db->where("rp.status", 1);
                $this->db->group_by("rp.id");
                $chkqry = $this->db->get();
                if ($chkqry->num_rows() > 0) {
                    $result = $chkqry->result_array();
                }
                return $result;
            }
        }
    }

    public function getvatdetails($data)
    {
        /* get vat Details With customer/vendor */
        $result = array();
        $this->db->select(
            "v.name,v.cat_id,v.cat_val,lv.charge_id,lv.vat,c.charge_code,l.source_geo,l.source_country,l.destination_geo,l.destination_country"
        );
        $this->db->from("tbl_vat_master v");
        $this->db->join('tbl_lanes l', 'l.vatid = v.id', 'left');
        $this->db->join('tbl_lane_vat lv', 'lv.lane_id = l.id', 'left');
        $this->db->join('tb_charge_codes c', 'c.id = lv.charge_id', 'left');
        if ($data['type'] == 0) {
            $this->db->join('tbl_party_master p', 'p.customeridentifier = v.customeridentifier', 'left');
        } else {
            $this->db->join('tbl_party_master p', 'p.customeridentifier = v.vendoridentifier', 'left');
        }
        $this->db->where("p.code", $data['custcode']);
        $this->db->where("c.id", $data['chargecodeid']);
        $this->db->where("v.company_code", $data['company_code']);
        $this->db->where("v.status", 1);
        $this->db->where("l.status", 1);
        $this->db->where("lv.status", 1);
        $this->db->where("p.user_id", $data['user_id']);
        $this->db->where("p.status", 1);
        $getvatdetails = $this->db->get();
        if ($getvatdetails->num_rows() > 0) {
            $result = $getvatdetails->result_array();
        }

        return $result;
    }

    public function getvatgeneric($data)
    {
        /* get vat Details Without customer/vendor(Generic) */
        $result = array();
        $this->db->select(
            "v.name,v.cat_id,v.cat_val,lv.charge_id,lv.vat,c.charge_code,l.source_geo,l.source_country,l.destination_geo,l.destination_country"
        );
        $this->db->from("tbl_vat_master v");
        $this->db->join('tbl_lanes l', 'l.vatid = v.id', 'left');
        $this->db->join('tbl_lane_vat lv', 'lv.lane_id = l.id', 'left');
        $this->db->join('tb_charge_codes c', 'c.id = lv.charge_id', 'left');
        $this->db->where("c.id", $data['chargecodeid']);
        $this->db->where("v.company_code", $data['company_code']);
        $this->db->where("v.status", 1);
        $this->db->where("l.status", 1);
        $this->db->where("lv.status", 1);
        $getvatdetails = $this->db->get();
        if ($getvatdetails->num_rows() > 0) {
            $result = $getvatdetails->result_array();
        }

        return $result;
    }

    private function generateWhereConditionForGeo(array $source): array
    {
        $whereCondition = [];
        $pickup_city = str_replace("'", "_", $source['pickup_city'] ?? "");
        $delivery_city = str_replace("'", "_", $source['delivery_city'] ?? "");
        $pickupDetails = [$source['pickup_country'], $source['pickup_state'], $source['pickup_division_name'], $pickup_city, $source['pickup_zcode'], $source['pickup_sub_district']];
        $deliveryDetails = [$source['delivery_country'], $source['delivery_state'], $source['delivery_division_name'], $delivery_city, $source['delivery_zcode'], $source['delivery_sub_district']];
        $geoHeirarchy = [2, 3, 4, 5, 6, 7];
        foreach ($pickupDetails as $pickupKey => $pickupvalue) {
            foreach ($deliveryDetails as $deliveryKey => $deliveryValue) {
                if (!in_array('', [$pickupvalue, $deliveryValue], true)) {
                    $whereCondition[] = " ( l.source_geo = '" . $geoHeirarchy[$pickupKey] . "' AND l.source = '" . $pickupvalue . "' AND l.destination_geo = '" . $geoHeirarchy[$deliveryKey] . "' AND l.destination = '" . $deliveryValue . "' ) ";
                }
            }
        }
        return $whereCondition;
    }
   
    public function getserviceid_bylanes($source)
    {
        if (!empty($source)) {
            $whereCondition = $this->generateWhereConditionForGeo($source);
            $company_code = $this->session->userdata('company_code');
            if (!empty($whereCondition)) {
                $whereString = "( ".implode('OR', $whereCondition)." ) ";
                $this->db->select("l.id,l.lane_id,l.lane_name");
                $this->db->select("rl.rate_id");
                $this->db->from("tb_rateservice_lanes rl");
                $this->db->join("tb_lanes_master l", "l.id=rl.lane_id", "LEFT");
                $this->db->where($whereString);
                if ($company_code == "RUKN") {
                    $this->db->where("l.company_code", $company_code);
                } else {
                    $this->db->where("rl.user_id", $source['user_id']);
                    $this->db->where("l.user_id", $source['user_id']);
                }
                $this->db->where("rl.status", 1);
                $this->db->where("l.status", 1);
                $this->db->group_by('rl.rate_id');
                $this->db->order_by("l.id", "DESC");
                $query = $this->db->get();
                $result = $query->num_rows() > 0 ? $query->result_array() : [];
            }
        }
        return $result ?? [];
    }

    /* Australia ASN order data  */
    public function getauasnorderdata($whr)
    {
        $result = array();
        $this->db->select(
            "id,order_id, pickup_company as Shipper Name, delivery_company as Consignee Name, pickup_country as Shipper Country, delivery_country as Consignee Country, pickup_city as Shipper City, delivery_city as Consignee City, pickup_pincode as  Shipper Zipcode, delivery_pincode as  Consignee Zipcode, pickup_address1 as Shipper Address, delivery_address1 as  Consignee Address , pickup_address2 as Shipper State, delivery_address2 as Consignee State"
        );
        $this->db->from("tb_orders");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }

        return $result;
    }

    /* Australia ASN order cargo  data  */
    public function getasncargodetails($whr)
    {
        $result = array();
        $this->db->select("length,width,height,weight,volume,quantity");
        $this->db->from("tb_order_cargodetails");
        $this->db->where($whr);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }

        return $result;
    }

    /* get reference numbers */
    public function getrefnums()
    {
        $result = array();
        $this->db->select('name');
        $this->db->distinct('name');
        $this->db->from('tb_reference_master');
        $this->db->where('status', 1);
        $this->db->order_by('name', 'ASC');
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }
       
        return $result;
    }

    /* get reference numbers */
    public function getrefvals($whr, $where, $userid = null, $countryuids = null)
    {
        $result = array();
        $this->db->select('o.order_id');
        $this->db->from('tb_order_references r');
        $this->db->join("tb_orders o", "o.id=r.order_id", "LEFT");
        
        if (!empty($countryuids)) {
            $this->db->where_in("o.user_id", $countryuids);
           
        } else {
            if ($userid != "") {
                $permission = checkuserpermissions();
                if (in_array("orders", $permission)) {
                    $company_code = $this->session->userdata('company_code');
                    $this->db->where("o.company_code", $company_code);
                } else {
                    $this->db->where("o.user_id", $userid);
                }
            }
        }
        $this->db->where($whr);
        $this->db->like($where);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }

        return $result;
    }

    public function getorderbookingids($whr, $where)
    {
        $result = array();
        $this->db->select('o.order_id');
        $this->db->from('tb_order_references r');
        $this->db->join("tb_orders o", "o.id=r.order_id", "LEFT");
        $this->db->where($whr);
        $this->db->like($where);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = $res->result_array();
        }

        return $result;
    }

    public function getorderdatamini($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts)
    {
        $result = array();

        $this->db->select(
            "o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.vendor_id,o.customer_id,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,r.reference_id,r.ref_value,o.createdon,o.parent_id,d.delivery_note,d.department_code, d.num_of_pallets"
        );
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_order_references r", "o.id=r.order_id", "LEFT");
        $this->db->where("o.status !=", 0);
        if (!empty($searchids)) {
            $this->db->where_in("o.order_id", $searchids);
        }
        if ($userid != '0') {
            if (!empty($countryuids)) {
                $this->db->where_in("o.user_id", $countryuids);
            } else {
                $this->db->where("o.user_id", $userid);
            }
        }
        if ($searchsts == 'PENDING') {
            $this->db->where("o.trip_id", 0);
        }
        if ($searchsts == 'ACTIVE') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 0);
        }
        if ($searchsts == 'CLOSED') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 1);
        }
        if (!empty($subcusts)) {
            $this->db->where_in("o.customer_id", $subcusts);
        } else {
            if ($custid != "") {
                $this->db->where('o.customer_id', $custid);
            }
        }
        if (isset($whr['like_c'])) {
            $like_c = $whr['like_c'];
            unset($whr['like_c']);
            $this->db->where($like_c);
        }

        if (isset($whr['DOC_DESC'])) {
            $DOC_DESC = $whr['DOC_DESC'];
            unset($whr['DOC_DESC']);
            $this->db->where($DOC_DESC, null, false);
        }
        if (isset($whr['customer_id_c'])) {
            $customer_id_c = $whr['customer_id_c'];
            unset($whr['customer_id_c']);
            $this->db->where($customer_id_c);
        }

        $this->db->where($whr);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get('tb_orders o');
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }

//    echo $this->db->last_query();exit;
        return $result;
    }

    public function getrecentorderid(string $whr)
    {
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where($whr);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        return $this->db->get();
    }

    public function checkbooking_existsornot($booking_id)
    {
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where('order_id', $booking_id);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $chk = $this->db->get();
        return $chk;
    }
   
    public function getOrderdetailsByOrderId($ids, $where_field)
    {
        $result = [];

        if (isset($where_field) && $where_field != "") {
            $this->db->select("vendor_id");
            $this->db->from("tb_orders");
            if ($where_field == "id") {
                $this->db->where('id', $ids);
            } else {
                if ($where_field == "order_id") {
                    $this->db->where_in('order_id', $ids);
                }
            }

            $this->db->where('status!=', '0');
            $qrychk = $this->db->get();

            if ($qrychk->num_rows() > 0) {
                $vendor_id = $qrychk->row()->vendor_id;
                if ($vendor_id > 0) {
                    $this->db->select(
                        "order_id,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,customer_id,c.name,c.code,c.street,c.location,c.pincode,c.country,v.id as vendor_id,v.name as vendor_name,v.location as vendor_city,v.address as vendor_address,v.pincode as vendor_pincode,v.country as vendor_country"
                    );
                    $this->db->from('tb_orders o');
                    $this->db->join('tb_customers c', 'c.id = o.customer_id', 'left');
                    $this->db->join('tb_vendors v', 'v.id = o.vendor_id', 'left');

                    if ($where_field == 'id') {
                        $this->db->where('o.id', $ids);
                    } else {
                        if ($where_field == "order_id") {
                            $this->db->where_in('o.order_id', $ids);
                        }
                    }
                    $dat = $this->db->get();
                    if ($dat->num_rows() > 0) {
                        if ($where_field == 'id') {
                            $result = $dat->row_array();
                        } else {
                            if ($where_field == "order_id") {
                                $result = $dat->result_array();
                            }
                        }
                    }
                } else {
                    $this->db->select(
                        "order_id,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,customer_id,c.name,c.code,c.street,c.location,c.pincode,c.country"
                    );
                    $this->db->from('tb_orders o');
                    $this->db->join('tb_customers c', 'c.id = o.customer_id', 'left');
                    if (isset($where_field) && $where_field == 'id') {
                        $this->db->where('o.id', $ids);
                    } else {
                        $this->db->where_in('o.order_id', $ids);
                    }
                    $dat = $this->db->get();
                    if ($dat->num_rows() > 0) {
                        if ($where_field == 'id') {
                            $result = $dat->row_array();
                        } else {
                            if ($where_field == "order_id") {
                                $result = $dat->result_array();
                            }
                        }
                    }
                }
            }
        }

        return $result;
    }

    /**
     *  This method get truck number and register number where trip tb_trips.status != 1 (where there is no active trip)
     * @param int  truckTypeId (truck_type), int carrierid (vendor_id)
     *    return query result
     */
    public function getvehicleinfo(int $truckTypeId, int $vendorId): object
    {
        $sql = "SELECT td.id,
		td.truck_number,
		td.register_number
		FROM   tb_trucks_data td
		WHERE  td.id NOT IN (SELECT tp.vehicle_id
							FROM   tb_trips tp
							WHERE  tp.vehicle_id = td.id
									AND tp.status = 1)
				AND td.truck_type = ?
				AND td.vendor_id = ?
		GROUP  BY td.id
		ORDER  BY td.truck_number";
        return $this->db->query($sql, [$truckTypeId, $vendorId]);
    }

    /**
     *  This method is used to get all the truck numbers which are under particular carrier
     * @param int  carrierId, int vehicleType
     *    return array (result of query)
     */
    public function getVehicleByCarrierInfo(int $carrierId, int $vehicleType): array
    {
        $whr = "status ='Active' AND vendor_id ='" . $carrierId . "'";
        if ($vehicleType > 0 && !(checkAccessConditions('DRIVER_LIST_WITH_CARRIER_COMPANY_CODE', $this->session->userdata('company_code')))) {
            $whr .= " AND truck_type ='" . $vehicleType . "'";
        }
        $this->db->select("id,register_number");
        $this->db->from("tb_trucks_data");
        $this->db->where($whr);
        $this->db->order_by("register_number", "ASC");
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    /**
     *  This method is used to get all the primary drivers from given vehicle
     * @param array  driverIds
     *    return array (result of query)
     */
    public function getDriverDetailsFromIds(array $driverIds): array
    {
        $this->db->select("id,name");
        $this->db->from("tb_truck_drivers");
        $this->db->where_in('id', $driverIds);
        $driverIdsequence = sprintf('FIELD(id, %s)', implode(', ', $driverIds));
        $this->db->where("status", 'Active');
        $this->db->order_by($driverIdsequence);
        $qry = $this->db->get();
        return $qry->num_rows() > 0 ? $qry->result_array() : [];
    }

	/**
	 * Get some commonly used columns from tb_orders.
	 *
	 * @param string $order_id matches the order_id column on tb_orders. It
	 *               is the public facing order identifier
     * @return CI_DB_result
	 */
	public function get_common_order_foreign_keys(string $order_id, bool $active_only = true)
	{
		return $this->base_query(['order_id' => $order_id], $active_only)
			->select([
                         'id',
                         'order_id',
                         'company_code',
                         'branch_code',
                         'shift_id',
                         'trip_id',
                     ])
            ->get();
    }

    /**
     * Given the public facing order_id (also called the booking id), retun a
     * queryset for the ID's that match that order_id.
     *
     * @param string $order_id is NOT the `id` column. It is the `order_id`
     *               column
     * @param bool $active_only
     * @return int id of the order
     */
    public function get_id_from_order_number(string $order_id, bool $active_only = true)
    {
        $query = $this->base_query(['order_id' => $order_id], $active_only)
            ->select('id')
            ->order_by('id', 'DESC')
            ->get();

        if (!$query->num_rows()) {
            throw new Exception("Order {$order_id} does not exist");
        }

		return $query->result()[0]->id;
	}

	/**
     *  This method is used to get all the order status codes from given order id
     * @param int  orderId
     *    return array (result of query)
     */
    public function getOrderStatusCodes(int $orderId): array
    {
        $where = "status=1 and order_id=".$orderId." and status_code!=''";
        $this->db->select("distinct(status_code)");
        $this->db->from("tb_stop_status");
        $this->db->where($where);
        $this->db->order_by('createdon');
        $qry = $this->db->get();
        return $qry->num_rows() > 0 ? $qry->result_array() : [];
    }
    public function checkIfExistsByBookingId(string $bookingId): bool
    {
        $orders = $this->db
            ->select('id')
            ->from('tb_orders')
            ->where([
                'order_id' => $bookingId,
                'trip_sts' => 0
            ])
            ->get()->result();

        return count($orders) === 1;
    }

    public function getTotalMeasurementData(string $orderId, string $lbhReport = ""): array
    {
        $CargoData = [];
        $totalQuantity = 0;
        $totalVolume = 0;
        $totalWeight = 0;
        $this->db->select('ocd.quantity,ocd.volume,ocd.weight,cd.weight_unit,cd.volume_unit, ocd.length, cd.length_unit, ocd.width, cd.width_unit, ocd.height, cd.height_unit');
        $this->db->from('tb_order_cargodetails AS ocd');
        $this->db->join('tb_cargo_details AS cd', 'cd.id = ocd.cargo_id', 'LEFT');
        $this->db->where([
            'ocd.order_id' => $orderId,
            'ocd.status' => 1
        ]);
        $getCargoData = $this->db->get();
        //log_message("error","Inn222:".$this->db->last_query());
        $CargoData = (!empty($getCargoData->num_rows())) ? $getCargoData->result_array() : [];
        //log_message("error","OrderId:".$orderId);
        if($lbhReport == 'No') {
            //log_message("error","CargoData11:".json_encode($CargoData));
            foreach ($CargoData as $data) {
                $totalQuantity += $data['quantity'];
                //$totalVolume += $data['volume'];
                //$totalWeight += $data['weight'];
                $weightUnit = ($data['weight_unit'] != null) ? $data['weight_unit'] : '';
                $volumeUnit = ($data['volume_unit'] != null) ? $data['volume_unit'] : '';
                if ((float)$data['weight'] > 0) {
                    $totalWeight += $this->weightConvertKgs($weightUnit, (float)($data['weight']));
                }
                if ((float)$data['volume'] > 0) {
                    $totalVolume += $this->volumeConvertCbft($volumeUnit, (float)($data['volume']));
                }
            }
            
             $CargoData = [[
                'quantity'  => $totalQuantity,
                'volume'    => $totalVolume,
                'weight'    => $totalWeight,
                'weight_unit'    => 'KG',
                'volume_unit'    => 'CBFT',
            ]];
            
            //return ['quantity' => $totalQuantity, 'volume' => $totalVolume, 'weight' => $totalWeight, 'volumeFT' => $totalVolumeFT,];
        }
        //log_message("error","CargoData2222:".json_encode($CargoData));
        return $CargoData;
    }
    
    public function weightConvertKgs(string $weightUnit, float $weight): float
    {
        switch (strtoupper($weightUnit)) {
            case 'G':
            case 'GMS':
            case 'GRM':
                return round(($weight / 1000),2);
            case 'TONS':
                return round(($weight * 1000),2);
            default:
                return round(($weight),2);
        }
    }
    
    public function volumeConvertCbft(string $volumeUnit, float $volume): float
    {
        switch (strtoupper($volumeUnit)) {
            case 'CBM':
                return round(($volume * 35.3147),2);
            case 'CBCM':
                return round(($volume * 0.0000353147),2);
            case 'CBIN':
                return round(($volume * 0.000578704),2);
            default:
                return round(($volume),2);
        }
    }
    
    public function dimensionsConvertft(string $dimensionUnit, float $dimension): float
    {
        switch (strtoupper($dimensionUnit)) {
            case 'M':
                return round(($dimension * 3.28084),2);
            case 'CM':
                return round(($dimension / 0.0328084),2);
            case 'INCHES':
                return round(($dimension / 12),2);
            default:
                return round(($dimension),2);
        }
    }

    public function getOrderParties(int $orderId, array $orderIds = []): array
    {
        $this->db->select("p.name,p.email,p.mobile,p.user_id,p.code,p.partyindetifier,p.location_id,p.country,p.state,p.street,p.pincode,o.order_id,t.name as party_type_name");
        $this->db->from("tbl_party_master p");
        $this->db->join("tb_order_parties o", "o.party_id=p.id", "INNER");
        $this->db->join("tbl_party_types t", "t.id=o.party_type", "INNER");
        if ($orderId > 0) {
            $this->db->where("o.order_id", $orderId);
        } else {
            $this->db->where_in("o.order_id", $orderIds);
        }
        $this->db->where("o.status", 1);
        $this->db->where_in("t.name", ['FREIGHT_PAYER', 'Customer', 'Shipper', 'Consignee','Carrier']);
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCountryCodesFromMaster(array $countries): array
    {
        $result = [];
        $this->db->select("country_name,country_code");
        $this->db->from("tbl_country_master");
        $this->db->where("(country_name IN ('" . implode("','", $countries) . "') OR country_code IN ('" . implode(",", $countries) . "') ) AND status ='1'");
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            foreach ($query->result_array() as $eachLine) {
                $result[$eachLine['country_name']] = $eachLine['country_code'];
                $result[$eachLine['country_code']] = $eachLine['country_code'];
            }
        }
        return $result;
    }

    public function filterCarrierList(string $search_key, string $company_code): array
    {
        $query = $this->db->query("SELECT `id`, `company_code`, `name` FROM `tb_vendors`
            WHERE `name` LIKE ? ESCAPE '!' AND `company_code` = ?
            ORDER BY `created_on` DESC",['%'.$search_key.'%', $company_code]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getNZCustomerOrders(array $subCustomers, int $customerId, array $orderIds, string $status, array $searchIds, array $whereCondition): object
    {
        $this->db->select(
            "o.id, o.order_id,o.pickup_datetime, o.delivery_datetime,
o.delivery_company as master_name,o.delivery_address1,o.delivery_address2,o.delivery_city,
o.drop_custid, o.status,o.order_status, o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,c.type_name as costCenter"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_cost_center c", "d.cost_center_id=c.id", "LEFT");
        if (!empty($subCustomers)) {
            $this->db->where_in("o.customer_id", $subCustomers);
        } else {
            $this->db->where("o.customer_id", $customerId);
        }
        if (!empty($orderIds)) {
            $this->db->where_in('o.id', $orderIds);
        }
        $this->db->where("o.status !=", 0);
        if (in_array($status, ['PENDING', 'SALOG PENDING'])) {
            $this->db->where("o.trip_id", 0);
        }
        if (in_array($status, ['ACTIVE', 'SALOG ACTIVE'])) {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 0);
        }
        if (in_array($status, ['CLOSED', 'SALOG CLOSED'])) {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 1);
        }
        if (in_array($status, self::SALOG_STATUSES)) {
            $this->db->where('o.created_source', '5');
        }
        if (!empty($searchIds)) {
            $this->db->where_in("o.order_id", $searchIds);
        }
        $this->db->where($whereCondition);
        $this->db->group_by("o.id");
        $this->db->order_by("o.id", "DESC");
        return $this->db->get();
    }

    public function getNZCustomerOrderRevenues(array $orderIds, string $sessionCurrency): array
    {
        $response = [];
        if (!empty($orderIds)) {
            $query = $this->db->query("SELECT order_id,sum(amount) as amount FROM tb_reveneus WHERE type = ? AND order_id IN ? AND status = ? GROUP BY order_id", ['0', $orderIds, '1']);
            $result = $query->num_rows() > 0 ? $query->result_array() : [];
            foreach ($result as $eachLine) {
                $response[$eachLine['order_id']] = $eachLine['amount'] . " " . $sessionCurrency;
            }
        }
        return $response;
    }

    public function getVehicleByAccessCondition(array $vendorIds, int $vehicleType): array
    {
        $condition = ['Active',$vendorIds];
        $whr = "";
        if ($vehicleType > 0) {
            $whr .= " AND truck_type = ?";
            $condition[] = $vehicleType;
        }
        $query =$this->db->query("SELECT id,register_number FROM tb_trucks_data WHERE status = ? AND vendor_id IN ? {$whr} ORDER BY register_number ASC",$condition);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCutomerDetailsWithOrder(array $orderIds): array
    {
        $query = $this->db->query("SELECT o.id,o.order_id,o.pickup_city,o.modeoftransport,o.is_created,o.shift_id,o.trip_id,o.shipmentid,c.sendto_knlogin FROM tb_orders o,tb_customers c WHERE c.id = o.customer_id AND o.id IN ? GROUP BY o.id", [$orderIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function deleteOrderById(int $id): string
    {
        return $this->db->query("UPDATE tb_orders set status = ? WHERE id = ?", [0, $id]);
    }

    public function checkMyknCustomerFromOrders(string $columns,array $orderIds): array
    {
        $query = $this->db->query(
            "SELECT " . $columns . "
    FROM tb_orders o
        INNER JOIN tb_customers c on o.customer_id = c.id
        LEFT JOIN tb_order_details d on o.id = d.order_row_id
        WHERE o.id IN ? AND o.status > ?",
            [$orderIds, 0]
        );
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsWithStopsStatus(array $orderIds): array
    {
        $orderstopStatus = $this->db->query(
            "(SELECT id,order_id,status_code,latitude,longitude,loc_name,createdon,driver_id
FROM tb_stop_status WHERE order_id IN ? AND STATUS = ? AND sentknlogin = ?) UNION ALL (SELECT id,order_id,status_code,latitude,longitude,'' AS loc_name, status_date AS createdon,'' AS driver_id FROM tb_order_status
WHERE order_id IN ? AND STATUS = ? AND sentknlogin = ?)",
            [$orderIds, 1, 0, $orderIds, 1, 0]
        );
        return $orderstopStatus->num_rows() > 0 ? $orderstopStatus->result_array() : [];
    }

    public function getSelectedConsigneeDetails(array $whereData): array
    {
        $this->db->select(
            "pm.id, pm.party_type_id, pm.name, pm.email, pm.street, pm.location_id as city,"
            . " pm.state, pm.mobile, pm.address, pm.pincode, pm.country, pm.code, pm.fax,"
            . " JSON_UNQUOTE(pm.additional_info->'$.delivery_instructions') AS delivery_instructions," .
            "JSON_UNQUOTE(pm.additional_info->'$.pickup_instructions') AS pickup_instructions,pt.name as partytype"
        );
        $this->db->from("tbl_party_master pm");
        $this->db->join("tbl_party_types pt", "pm.party_type_id = pt.id", "LEFT");
        $this->db->where($whereData);
        $this->db->limit(1);
        $result = $this->db->get();
        return $result->num_rows() > 0 ? $result->row_array() : [];
    }

    public function indexQueryKOP($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts, $mapping = null): CI_DB_query_builder
    {
        if (
            empty(
            array_filter(
                [
                    $searchids,
                    $searchsts,
                    $custid,
                    $countryuids,
                    $whr,
                    $subcusts,
                    $mapping
                ],
                static function ($element) {
                    return !empty($element);
                }
            )
            )
        ) {
            $whr['date(o.createdon) >='] = (new DateTime())->format('Y-m-d');
            $whr['date(o.createdon) <='] = (new DateTime())->format('Y-m-d');
        }

        $orderIds = $mapping && !empty($mapping) ? $mapping : $searchids;
        $company_code = $this->session->userdata('company_code');
        $query = $this->db->select(
            "
                tu.name as username,o.pickup_partyid,
                (SELECT (CASE
                        WHEN o.vendor_id > 0 THEN v.name
                        WHEN o.vendor_id = 0 AND o.shift_id > 0 THEN (SELECT name FROM tb_vendors WHERE id = (SELECT vendor_id from tb_shifts where id = o.shift_id) LIMIT 1)
                    ELSE
                        ''
                    END)) AS vendor_name,
                d.order_status as order_detail_status,
                o.id,
                o.order_id,
                o.pickup_datetime,
                o.delivery_datetime,
                o.drop_endtime,
                o.pickup_company as pickup,
                o.delivery_company as delivery,
                o.delivery_city,
                o.weight,
                o.gross_weight_uom,
                o.chargeable_weight,
                o.chargeable_weight_uom,
                o.transport_mode,
                o.vendor_id,
                o.company_code,
                o.branch_code,
                o.shipment_id,
                o.status,
                o.order_status,
                o.Stoppage,
                o.trip_sts,
                o.shift_id,
                o.trip_id,
                o.shipmentid as shipmentid,
                o.createdon,
                o.created_source,
                o.parent_id,
                d.delivery_note,
                d.department_code,
                GROUP_CONCAT(`cx`.weight_unit) as weight_unit,
                `cx`.secondweight_uom,
                `cx`.secondvolume_uom,
                Sum(Case When c.status = '1' Then c.second_weight Else 0 End) as second_weight,
                Sum(Case When c.status = '1' Then c.second_volume Else 0 End) as second_volume,
                TRUNCATE(Sum(Case When c.status = '1' Then (Case When `cx`.`weight_unit` IN ('G', 'Gms', 'gms', 'grm') Then c.weight/1000 Else
                (Case When `cx`.`weight_unit` IN ('Kg', 'kg') Then c.weight Else
                    (Case When `cx`.`weight_unit` IN ('Tons', 'tons') Then c.weight * 1000 Else
                    CASE WHEN o.company_code ='AUKN' THEN c.weight ELSE 0 END
                    End) End) End) Else 0 End), 3) as totwg,
                SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,
                SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,
                SUM(Case When c.status = '1' Then c.scanned_quantity Else 0 End) as tot_scanned_qty,
                d.num_of_pallets,d.order_type,d.cost_center_id,s.createdon as delivered_time,
                (SELECT CONCAT(GROUP_CONCAT(json_object(reference_id, ref_value)  SEPARATOR ','))
                    FROM tb_order_references
                    WHERE reference_id IN ('DQ','CTR','MN','LPC','XSR','POS','ORD','PO','AWB') AND status=1 AND order_id = o.id
                    GROUP BY order_id
                ) as reference_value,
                cu.name as customer_name,
                (CASE WHEN (SELECT count(*) FROM tb_pod_uploads where order_id = o.id) > 0 THEN 'YES' ELSE 'NO' END) as pod
            "
        );

        $query->from("tb_orders o");
        $query->join("tb_order_details d", "o.id=d.order_row_id AND o.order_id = d.order_id", "LEFT");
        $query->join("tb_users tu", "tu.id=o.user_id", "LEFT");
        $query->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $query->join("tb_cargo_details cx", "c.cargo_id=cx.id", "LEFT");
        $query->join("tb_stop_status s", "o.id=s.order_id AND s.status_code='3000' AND s.status ='1'", "LEFT");
        $query->join("tb_vendors v", "v.id=o.vendor_id", "LEFT");
        $query->join("tb_customers cu", "cu.id = o.customer_id", 'left');        //Vivek B updated query
        // $query->join($tbReveneusJoin, 'o.id = invoice_inner.order_id', 'LEFT');

        //Search option change for scanned and manifested orders
        if ($searchsts == 'SCANNED') {
            $query->join("tb_order_status os", "o.id=os.order_id AND os.status_code ='2491'", "LEFT");
        }


        if (!in_array($searchsts, ['CLOSED','SALOG CLOSED'])) {
            $query->where("o.status !=", 0);
        }


        if (!empty($orderIds)) {
            $query->where_in("o.order_id", $orderIds);
            unset($whr['o.order_id']);
        }
        if (isset($company_code) && $company_code == 'AUKN' && ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING')) {
            $au_where = "(o.id NOT IN (select order_id from tb_order_status where  order_id=o.id and status_code ='2491'))";
            $query->where($au_where);

            /* NEW TRIPS MODULE CODE */
            $wherepen = "(o.trip_id=0 AND o.shift_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
            $query->where($wherepen);
            $query->where("o.trip_id", 0);
            $query->where("o.trip_sts", 0);
        } elseif ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING') {
            /* NEW TRIPS MODULE CODE */
            $wherepen = "(o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
            $query->where($wherepen);
            $query->where("o.trip_id", 0);
            $query->where("o.trip_sts", 0);
        }

        if (in_array($searchsts, self::STATUSES)) {
            $query->where('o.created_source', '5');
        }

        if ($searchsts == 'ACTIVE' || $searchsts == 'SALOG ACTIVE') {
            $query->where("o.trip_id !=", 0);
            /* NEW TRIPS MODULE CODE */
            $whereact = "(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
            $query->where($whereact);
            $query->where("o.trip_sts", 0);
        } elseif ($searchsts == 'CLOSED' || $searchsts == 'SALOG CLOSED') {
            /* NEW TRIPS MODULE CODE */
            $whereact = "(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
            $query->where($whereact);
            $query->where("o.trip_sts", 1);
        } elseif ($searchsts == 'SALOG TO BE BILLED') {
            $salogorders = $this->getsalogtobebilled($countryuids, $userid, $subcusts, $custid);

            if (!empty($salogorders)) {
                $query->where_in('o.order_id', $salogorders);
            } else {
                $query->where('o.id', 0);
            }
        }
        if (isset($whr['o.customer_id'])) {
            $query->where_in('o.customer_id', $whr['o.customer_id']);
            unset($whr['o.customer_id']);
        }

        if (isset($whr['o.delivery_company'])) {
            $query->like('o.delivery_company', $whr['o.delivery_company']);
            unset($whr['o.delivery_company']);
        }

        if (isset($whr['o.pickup_company'])) {
            $query->like('o.pickup_company', $whr['o.pickup_company']);
            unset($whr['o.pickup_company']);
        }
        $userData = $this->session->userdata();
        $queryString = "";
        if ($userData['childId'] > 0) {
            $usersWithoutDepartment = $userData['usersWithoutDepartment'];
            if (!empty($usersWithoutDepartment)) {
                $i = 1;
                $arrayCount = count($usersWithoutDepartment);
                foreach ($usersWithoutDepartment as $eachLine) {
                    if ($i > 1) {
                        $queryString .= " OR (o.company_code = '".$eachLine['companyCode']."' AND o.branch_code = '".$eachLine['branchCode']."' ) ";
                    } else {
                        $queryString .= " ( (o.company_code = '".$eachLine['companyCode']."' AND o.branch_code = '".$eachLine['branchCode']."' ) ";
                    }
                    if ($arrayCount === $i) {
                        $queryString .= " ) ";
                    }
                    $i++;
                }
            } else {
                $j = 1;
                $usersWithDepartmentCodes = $userData['usersWithDepartmentCodes'];
                if (!empty($usersWithDepartmentCodes)) {
                    $arrayCount = count($usersWithDepartmentCodes);
                    foreach ($usersWithDepartmentCodes as $eachLine) {
                        if ($j > 1) {
                            $queryString .= " OR (o.company_code = '".$eachLine['companyCode']."' AND o.branch_code = '".$eachLine['branchCode']."' AND d.department_code = '".$eachLine['departmentCode']."' ) ";
                        } else {
                            $queryString .= " ( (o.company_code = '".$eachLine['companyCode']."' AND o.branch_code = '".$eachLine['branchCode']."' AND d.department_code = '".$eachLine['departmentCode']."' ) ";
                        }
                        if ($arrayCount === $j) {
                            $queryString .= " ) ";
                        }
                        $j++;
                    }
                }
            }
        } else {
            $query->where("o.company_code", $userData['company_code']);
            $query->where("o.branch_code", $userData['branch_code']);
            if ($userData['department_code'] != "") {
                $query->where("d.department_code",$userData['department_code']);
            }
        }
        if($queryString != ""){
            $query->where($queryString);
        }
        $query->where($whr);
        $query->group_by("o.id");
        $query->order_by("o.id", 'DESC');
        return $query;
    }

    public function updateOrderReference(int $orderId, string $referenceId, string $referenceValue): void
    {
        $sql = "SELECT id FROM tb_order_references WHERE order_id = ? AND reference_id  = ? AND ref_value = ? AND status = 1";
        $checkWithReferenceValue = $this->db->query($sql, [$orderId, $referenceId, $referenceValue]);
        if ($checkWithReferenceValue->num_rows() == 1) {
            return;
        }
        $sql = "SELECT id FROM tb_order_references WHERE order_id = ? AND reference_id  = ?  AND status = 1";
        $checkWithoutReferenceValue = $this->db->query($sql, [$orderId, $referenceId]);
        if ($checkWithoutReferenceValue->num_rows() == 1) {
            $this->db->where(['id' => $checkWithoutReferenceValue->row()->id])->update('tb_order_references', ['ref_value' => $referenceValue]);
        } elseif ($checkWithoutReferenceValue->num_rows() == 0) {
            $referenceData = ['order_id' => $orderId, 'reference_id' => $referenceId, 'ref_value' => $referenceValue, 'createdon' => date('Y-m-d H:i:s')];
            $this->db->insert('tb_order_references', $referenceData);
        }
    }

    public function getXborderNotificationData($orderIdsList): array
    {
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $this->db->select(
            "o.order_id, convertToClientTZ(o.pickup_datetime, '" . $currentTimeZone . "') as pickup_date_time, convertToClientTZ(o.delivery_datetime, '" . $currentTimeZone . "') as delivery_date_time,o.pickup_company as pickup, o.createdon,
                           o.shipmentid as shipmentid, o.delivery_company as delivery,
                           r.ref_value as delivery_note, sum(c.quantity) as quantity,c.weight,c.volume"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_references r", "o.id=r.order_id", "LEFT");
        $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $this->db->where_in("o.id", $orderIdsList);
        $this->db->where("r.reference_id", 'DQ');
        $this->db->group_by("o.id");
        $result = $this->db->get();
        return $result->num_rows() > 0 ? $result->result_array() : [];
    }

    public function getOrderIdsByReferenceValues(array $referenceValues): array
    {
        $sql = "SELECT
                  o.order_id
                FROM
                  tb_order_references r,
                  tb_orders o
                WHERE
                  r.order_id = o.id
                  AND r.reference_id IN ?
                  AND r.ref_value IN ?
                  AND r.status = 1
                  AND o.status != 0
                ";
        if (empty($referenceValues)) {
            return [];
        }
        $getResult = $this->db->query($sql, [['DQ', 'XSR', 'AWB', 'MAWB', 'TKN', 'INV'], $referenceValues]);
        if ($getResult->num_rows() > 0) {
            $data = array_column( $getResult->result_array(), "order_id" );
        }
        return $data ?? [];
    }
    
    public function getOrderIdsByRefVal(array $referenceValues): array
    {
        $sql = "SELECT
                  o.order_id
                FROM
                  tb_order_references r,
                  tb_orders o
                WHERE
                  r.order_id = o.id
                  AND r.ref_value IN ?
                  AND r.status = 1
                  AND o.status != 0
                ";
        if (empty($referenceValues)) {
            return [];
        }
        $getResult = $this->db->query($sql, [['DQ', 'XSR', 'AWB', 'MAWB', 'TKN', 'INV'], $referenceValues]);
        if ($getResult->num_rows() > 0) {
            $data = array_column( $getResult->result_array(), "order_id" );
        }
        return $data ?? [];
    }
    
    public function checkMYKNCustomer(int $order_id): int
    {
        $myknCustomer = $this->db->query("SELECT tpr.`reference_type`,tpr.`name`,tpr.`value` FROM tb_orders o LEFT OUTER JOIN tb_customers tc ON tc.id=o.customer_id LEFT OUTER JOIN tbl_party_master tpm ON tc.code=tpm.code AND o.company_code=tpm.company_code LEFT OUTER JOIN `tb_party_reference` tpr ON tpm.id=tpr.partner_id WHERE o.id=? AND tpr.`status`=1 AND tpr.name='MYKN' AND UPPER(value) in ('Y','YES')", [$order_id]);
        return $myknCustomer->num_rows() ?? 0;
    }
    
    public function getOrderDetails(string $id): ?object
    {
        $query = $this->db->query(
            "SELECT * FROM tb_orders WHERE (order_id = ? or external_order_id = ?) and status=1", [$id, $id]
        );
        return $query->row() ?: null;
    }
    
    
    private const OVERLAND_MUMBAI_USER_ID = 3;
    

    public function getOrders(array $registerNumbers): array
    {
        //log_message("error","registerNumbers:".json_encode($registerNumbers));
        $wheelseyeCountriesSQL = $this->db->select('condition')->where(['title' => 'WHEELS_EYE_COUNTRIES'])->get('access_conditions')->row();
        //log_message("error","Qry1:".$this->db->last_query());
        if (empty($wheelseyeCountriesSQL)) {
            return [];
        }
        $wheelseyeCountries = explode(',', $wheelseyeCountriesSQL->condition);
        $SQL = 'SELECT o.trip_id, o.shift_id, t.vehicle_id, t.driver_id, v.register_number
        FROM  tb_orders o
        INNER JOIN tb_trips t ON (t.id = o.trip_id)
        INNER JOIN tb_shft_veh v ON (o.shift_id = v.shft_id)
        INNER JOIN tb_trucks_data trucks ON (trucks.id = v.vehicle_id AND trucks.gpsstatus = ? AND trucks.track_vendor_id > ?)
        INNER JOIN tb_tracking_vendors tvendors ON (tvendors.id = trucks.track_vendor_id AND tvendors.vendor_name = ?)
        WHERE o.company_code IN ?
          AND v.register_number IN ?
          
          AND o.status > 0
          AND o.trip_sts = 0
          AND o.trip_id > 0
        ORDER BY o.id DESC';
        $result = $this->db->query($SQL, [1, 0, 'WHEELSEYE', $wheelseyeCountries, $registerNumbers]);
        //log_message("error","Qry:".$this->db->last_query());
        /*$SQL = 'SELECT o.trip_id, o.shift_id, t.vehicle_id, t.driver_id, v.register_number
        FROM  tb_orders o
        INNER JOIN tb_trips t ON (t.id = o.trip_id)
        INNER JOIN tb_shft_veh v ON (o.shift_id = v.shft_id)
        INNER JOIN tb_trucks_data trucks ON (trucks.id = v.vehicle_id AND trucks.gpsstatus = ? AND trucks.track_vendor_id > ?)
        INNER JOIN tb_tracking_vendors tvendors ON (tvendors.id = trucks.track_vendor_id AND tvendors.vendor_name = ?)
        WHERE o.company_code IN ?
          AND v.register_number IN ?
          AND o.user_id = ?
          AND o.status > 0
          AND o.trip_sts = 0
          AND o.trip_id > 0
        ORDER BY o.id DESC';
        $result = $this->db->query($SQL, [1, 0, 'WHEELSEYE', $wheelseyeCountries, $registerNumbers, self::OVERLAND_MUMBAI_USER_ID]);
        log_message("error","Qry:".$this->db->last_query());*/
        return $result ? $result->result_array() : [];
    }

    public function getStatusResult(int $shipmentId, int $tripID): array
    {
        $SQL = "SELECT SUM(CASE WHEN (stop_type='P' AND status_id = 2) THEN 1 ELSE 0 END) AS gatein,
            SUM(CASE WHEN (stop_type='D' AND status_id = 3) THEN 1 ELSE 0 END) AS gateout
            FROM `tb_stop_status`
            WHERE shipment_id = ?
              AND trip_id = ?
              AND status > 0";
        $result = $this->db->query($SQL, [$shipmentId, $tripID]);
        return $result ? $result->row_array() : [];
    }
}
