<?php

class OrderCo2Model extends CI_Model
{
    public function getClosedShipmentOrders(): array
    {
        $toDate = date('Y-m-d');
        $fromDate = date('Y-m-d', strtotime('-6 months'));
        $whereCondition = "(DATE(o.createdon) BETWEEN '".$fromDate."'  AND '" . $toDate . "') AND o.trip_sts=1 AND tsm.`name` IN ('Full Truck Load','FTL','LTL','LTL Less Than Truck Load','FTL Full Truck Load','Less Than Truck Load','Less Than Truck Load','LTL-EXPRESS','GENERAL SERVICE','EXPRESS SERVICE')";
        $this->db->select(
            'o.id,o.order_id,o.user_id,o.customer_id,o.company_code, o.branch_code,tod.department_code,tsm.`name` AS servicename ,ts.`vehicle_type`, o.`weight`,o.`gross_weight_uom`,o.`plat`,o.`plng`,o.`dlat`,o.`dlng`,o.`pickup_custid`,o.`drop_custid`, o.`transport_mode`,tt.`trucktype`,`fuel_consumption`,tt.`fuel_consumption_cap`,tt.`fuel_consumption_netcap`,tt.`distance_deviation_factor`,tt.`co2_ttw`,tt.`co2_wtw`,tt.`co2e_ttw`,tt.`co2e_wtw`,tt.`temp_regime_type`,tt.`temp_regime_value`,o.createdon'
        );
        $this->db->from('tb_orders o');
        $this->db->join('tb_order_details tod', 'o.id=tod.`order_row_id`');
        $this->db->join('tb_shifts ts', 'o.shift_id=ts.id');
        $this->db->join('`tb_trucktypes` tt', 'ts.vehicle_type=tt.`trucktype`');
        $this->db->join('`tb_service_master` tsm', 'tsm.id=tod.`service`');
        $this->db->where($whereCondition);
        $this->db->group_by("o.id");
        $ordersList = $this->db->get();
        log_message("error","Inn:".$this->db->last_query());
        return $ordersList->num_rows() > 0 ? $ordersList->result_array() : [];
    }

}
