<?php

namespace App\Models\OrderList\Search;

/**
 * Interface SearchInterface
 * @package App\Models\OrderList\Search
 */
interface SearchInterface
{
    const STATUSES = [
        'SALOG PENDING',
        'SALOG ACTIVE',
        'SALOG CLOSED',
        'SALOG TO BE BILLED'
    ];

    const REVENUE_TYPE_ROLE = 0;
    const REVENUE_TYPE_COST = 1;

    const INVOICE_ACTIONS = [
        self::REVENUE_TYPE_ROLE => 'Billed',
        self::REVENUE_TYPE_COST => 'Invoiced'
    ];

    const INVOICE_STATUSES = [
        'To be billed',
        'Ready To Invoice',
        self::INVOICE_ACTIONS
    ];

    const ORDER_TABLE_ALIAS = 'o';
    const ORDER_DETAILS_TABLE_ALIAS = 'd';
}