<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;
/**
 * Through-table linking `tb_orders` to `tb_cargo_details` on columns `order_id`
 * and `cargo_id`.
 */
class Order_cargo_details extends Table
{
    const TABLE = "tb_order_cargodetails";

    const BUYER_PART_COL = "buyer_part";
    const CARGO_CONTENT_COL = "cargo_content";
    const CARGO_ID_COL = "cargo_id";
    const CREATEDON_COL = "createdon";
    const HANDLING_UNIT_COL = "handling_unit";
    const HEIGHT_COL = "height";
    const ID_COL = "id";
    const LABEL_NUMBER_COL = "label_number";
    const LDM_COL = "ldm";
    const LENGTH_COL = "length";
    const LINEBP_NUM1_COL = "linebp_num1";
    const LINECONTAINER_NO_COL = "linecontainer_no";
    const LOAD_PLAN_CONNOTE_COL = "load_plan_connote";
    const MARKS_NUMBERS_COL = "marks_numbers";
    const ORDER_ID_COL = "order_id";
    const PALLET_CLOSE_COL = "pallet_close";
    const PALLET_NAME_COL = "pallet_name";
    const QR_CODE_COL = "qr_code";
    const QUANTITY_COL = "quantity";
    const QUANTITY_TYPE_COL = "quantity_type";
    const REFERENCE_ORDER_NUM_COL = "reference_order_num";
    const SCANNED_QUANTITY_COL = "scanned_quantity";
    const SECOND_VOLUME_COL = "second_volume";
    const SECOND_WEIGHT_COL = "second_weight";
    const STATUS_COL = "status";
    const STOP_DETAIL_ID_COL = "stop_detail_id";
    const UPDATEDON_COL = "updatedon";
    const VOLUMETRIC_WEIGHT_COL = "volumetric_weight";
    const VOLUME_COL = "volume";
    const VOLWEIGHT_UOM_COL = "volweight_uom";
    const WEIGHT_COL = "weight";
    const WIDTH_COL = "width";

    public $buyer_part; // varchar(30)	NULL=YES
    public $cargo_content; // varchar(100)	NULL=YES
    public $cargo_id; // int(11)	NULL=YES
    public $createdon; // timestamp	YES
    public $handling_unit; // varchar(60)	NULL=NO
    public $height; // decimal(10,2)	NULL=YES
    public $id; // int(30)	NULL=NO
    public $label_number; // text	YES
    public $ldm; // decimal(10,3)	NULL=YES
    public $length; // decimal(10,2)	NULL=YES
    public $linebp_num1; // varchar(50)	NULL=YES
    public $linecontainer_no; // varchar(50)	NULL=YES
    public $load_plan_connote; // varchar(30)	NULL=YES
    public $marks_numbers; // varchar(50)	NULL=YES
    public $order_id; // int(11)	NULL=NO
    public $pallet_close; // tinyint(1)	NULL=YES
    public $pallet_name; // varchar(80)	NULL=YES
    public $qr_code; // varchar(66)	NULL=YES
    public $quantity; // decimal(10,2)	NULL=YES
    public $quantity_type; // varchar(100)	NULL=YES
    public $reference_order_num; //	varchar(50)	NULL=YES
    public $scanned_quantity; // decimal(10,2)	NULL=YES
    public $second_volume; // decimal(10,3)	NULL=YES
    public $second_weight; // decimal(10,3)	NULL=YES
    public $status; // tinyint(1)	NULL=YES
    public $stop_detail_id; // int(11)	NULL=YES
    public $updatedon; // timestamp	NULL=YES
    public $volume; // decimal(10,3)	NULL=YES
    public $volumetric_weight; // decimal(12,3)	NULL=YES
    public $volweight_uom; // varchar(20)	NULL=YES
    public $weight; // decimal(12,3)	NULL=YES
    public $width; // decimal(10,2)	NULL=YES


    /**
     * @param $orderId
     * @return void
     */
    public function delete_related($orderId) : void
    {
        $rows = $this->find([
            self::ORDER_ID_COL => $orderId
        ]);
        $cargoIds = array_column($rows, 'cargo_id');

        $this->delete([
            self::ORDER_ID_COL => $orderId
        ], false);

        if (!empty($cargoIds)) {
            $CI = &get_instance();
            $CI->cargo_details->delete([
                'id' => $cargoIds
            ], false);
        }

    }
}
