<?php
class Orderrevenuesmodel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function checkandorconditionforref($order_id, $whr)
    {
        $chkqry = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE o.order_id ='" . $order_id . "' " . $whr . "");
        return $chkqry->num_rows();
    }

    public function checkbookingidexistsornot($whr)
    {
        $result = array();
        $this->db->select("order_id");
        $this->db->from("tb_orders");
        $this->db->where($whr);
        $this->db->where("status !=", 0);
        $chkqry = $this->db->get();
        if ($chkqry->num_rows() > 0) {
            $result = $chkqry->result_array();
        }
        return $result;
    }

    public function getraterecordcharges($rate_id)
    {
        $result = array();
        $this->db->select("rc.rr_charge_type,rc.rr_tier_id,rc.geo_tier_id,rc.rr_charge_id,rc.charge_basis,rc.min_amount,rc.amount,rr.offering_id");
        $this->db->from("tb_raterecord_charges rc");
        $this->db->join("tb_rate_records rr", "rc.raterecord_id=rr.id", "LEFT");
        $this->db->where("rc.status ", 1);
        $this->db->where("rr.rate_id ", $rate_id);
        $this->db->where("rr.status ", 1);
        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $result = $getresult->result_array();
        }
        return $result;
    }

    public function getallordercargodetails($order_id)
    {
        $result = array();
        $getcargodetails = $this->db->query("SELECT sum(o.weight) as total_weight,sum(o.second_weight) as second_weight,sum(o.volume) as total_volume,sum(o.second_volume) as second_volume,sum(o.quantity) as total_quantity,sum(o.ldm) as total_ldm,c.weight_unit,c.secondweight_uom,o2.goods_value FROM tb_cargo_details c,tb_order_cargodetails o JOIN tb_orders o2 ON o.order_id = o2.id  WHERE o.cargo_id=c.id AND o.order_id ='" . $order_id . "' AND o.status='1'");
        if ($getcargodetails->num_rows() > 0) {
            $result = $getcargodetails->row_array();
        }
        return $result;

    }

    public function getrevenuedetails($rev, $order_id = "", $shift_id = "")
    {
        $result = array();
        if ($shift_id != "") {
            $getrevenuedetails = $this->db->query("SELECT id,type,shift_id,recipient_code,exchange_rate FROM trip_reveneus WHERE id IN (" . implode(',', $rev) . ") AND status !=0");
        } else {
            $getrevenuedetails = $this->db->query("SELECT id,type,order_id,recipient_code,exchange_rate FROM tb_reveneus WHERE id IN (" . implode(',', $rev) . ") AND status !=0");
        }
        if ($getrevenuedetails->num_rows() > 0) {
            $result = $getrevenuedetails->result_array();
        }
        return $result;
    }

    public function gettripreports($select, $whr, $searchids)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from("tb_orders");
        if (!empty($searchids)) {
            $this->db->where_in("order_id", $searchids);
        }
        $this->db->where($whr);
        $getorders = $this->db->get();
        if ($getorders->num_rows() > 0) {
            $result = $getorders->result_array();
        }

        return $result;
    }

    public function getactiveorders($select, $whr, $order_id)
    {
        $this->db->select($select);
        $this->db->from("tb_orders");
        $this->db->like(array('order_id' => $order_id));
        $this->db->where($whr);
        $getorderids = $this->db->get();
        return $getorderids;
    }

    public function checkhandlingunit_fororder($whr)
    {
        $this->db->select("oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name");
        $this->db->from("tb_order_cargodetails oc");
        $this->db->join("tbl_shipunit_types im", "im.id=oc.handling_unit", "LEFT");
        $this->db->where($whr);
        $this->db->where("oc.status='1'");
        $gethandlingunit = $this->db->get();
        return $gethandlingunit;

    }

    public function checkservicemaster_withname($whr, $service_name, $service_id, $service)
    {
        $result = array();
        $whr1 = "name LIKE '%" . $service_name . "%'";
        $whr2 = "(name LIKE '%" . $service_id . "%' OR service_id LIKE '" . $service_id . "') ";
        $whr3 = "(name LIKE '%" . $service . "%' OR service_id LIKE '" . $service . "') ";
        if ($service_id != "" && $service_name != "") {
            $this->db->select("id");
            $this->db->from("tb_service_master");
            $this->db->where($whr);
            $this->db->where($whr1);
            $getservice1 = $this->db->get();
            if ($getservice1->num_rows() > 0) {
                $result = $getservice1->row_array();
            } else {
                $this->db->select("id");
                $this->db->from("tb_service_master");
                $this->db->where($whr);
                $this->db->where($whr2);
                $getservice2 = $this->db->get();
                if ($getservice2->num_rows() > 0) {
                    $result = $getservice2->row_array();
                }
            }
        } else {
            $this->db->select("id");
            $this->db->from("tb_service_master");
            $this->db->where($whr);
            $this->db->where($whr3);
            $getservice3 = $this->db->get();
            if ($getservice3->num_rows() > 0) {
                $result = $getservice3->row_array();
            }
        }
        if(empty($result)){
            $this->db->select("id");
            $this->db->from("tb_service_master");
            $this->db->where($whr1);
            $getservice3 = $this->db->get();
            if ($getservice3->num_rows() > 0) {
                $result = $getservice3->row_array();
            }
        }
        return $result ;
    }

    public function getordersbyref($whr)
    {
        $this->db->select("r.order_id");
        $this->db->from("tb_order_references r");
        $this->db->join("tb_orders o", "r.order_id=o.id", "LEFT");
        $this->db->where($whr);
        $qry = $this->db->get();
        return $qry;
    }

    public function getordersbyOrdertypes($whr)
    {
        $this->db->select("r.order_id");
        $this->db->from("tb_order_details d");
        $this->db->join("tb_orders o", "r.order_row_id=o.id", "LEFT");
        $this->db->where($whr);
        $qry = $this->db->get();
        return $qry;
    }

    public function donwloadCompletedOrderForExcel($whr)
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $company_code = $this->session->userdata("company_code");
        $cid = $this->session->userdata("user_id");
        $usrwhr = " o.user_id ='" . $cid . "' ";
        $permission = checkuserpermissions();
        if (in_array('orders', $permission)) {
            $usrwhr = " o.company_code ='" . $company_code . "' ";
        }
        $this->db->select("o.id,o.order_id,o.pickup_company,o.pickup_country,o.pickup_city,o.pickup_pincode,o.pickup_address1,o.delivery_company,o.delivery_country,o.delivery_city,o.delivery_pincode,o.delivery_address1,convertToClientTZ(o.pickup_datetime,'" . $curtz . "') as pickup_datetime, o.shift_id,convertToClientTZ(o.updatedon,'" . $curtz . "') as order_updateddate, convertToClientTZ(t.etime,'" . $curtz . "') as act_etime,c.phone as custid");
        $this->db->from("tb_orders o");
        $this->db->join("tb_trips t", "t.id=o.trip_id AND t.status='0'", "LEFT");
        $this->db->join("tb_customers c", "c.id=o.customer_id", "LEFT");
        $this->db->where("o.trip_sts='1'");
        $this->db->where($usrwhr);
        if ($whr != "") {
            $this->db->where($whr);
        }
        $this->db->group_by("o.order_id");
        $this->db->order_by("o.trip_id", "DESC");
        $qry = $this->db->get();
        return $qry;
    }
    
    public function getactive_fuelsurcharge($fuel_surcharge_id){
        $whr = $result = array();
        $this->db->select("id");
        $this->db->from("tb_fuel_surcharge");
        $this->db->where_in("id",$fuel_surcharge_id);
        $this->db->where("status",'1');
        $qry = $this->db->get();
        if($qry->num_rows() > 0){
            foreach ($qry->result() as $res){
                $result[] = $res->id;
            }
        }
        return $result;
    }
    
    public function getemptytariffrecords_forfaf($whr){
        $result = array();
        if($whr != ""){
            $this->db->select("id,faf_id,faf_name");
            $this->db->from("tb_fuel_surcharge");
            $this->db->where($whr);
            $qry = $this->db->get();
            if($qry->num_rows() > 0){
                $result = $qry->result_array();
            }
            return $result;
        }
    }
 
    public function getfafdetailsbydate($fuel_surcharge_id,$date){
        $whr = $result = array();
        $whr["DATE_FORMAT(from_date,'%Y-%m-%d') <="] = $date;
        $whr["DATE_FORMAT(to_date,'%Y-%m-%d') >="] = $date;
        $this->db->select("amount,currency,percentage");
        $this->db->from("tb_fuel_surcharge_sheet");
        $this->db->where_in("fuel_surcharge_id",$fuel_surcharge_id);
        $this->db->where($whr);
        $this->db->where("Status",'1');
        $qry = $this->db->get();
        if($qry->num_rows() > 0){
            $result = $qry->result_array();
        }
        return $result;
    }
    
    public function checkothercurrencyexistsornot($info){
        $exchange_rate = 1;
        if(!empty($info)){
            $rev_id = isset($info['rev_id']) ? $info['rev_id'] : "0";
            $company_code  = $info['company_code'];
            $user_currency = $info['user_currency'];
            if($rev_id >0){
                $this->db->select("id,exchange_rate,foreign_currency");
                $this->db->from("tb_reveneus");
                $this->db->where("id",$rev_id);
                $this->db->where('status','1');
                $qry = $this->db->get();
                if($qry->num_rows() > 0){
                    $exchange_rate    = $qry->row()->exchange_rate;
                    $foreign_currency = $qry->row()->foreign_currency;
                    if($foreign_currency == ""){
                        $exchange_rate =1;
                    }else{
                        if($exchange_rate == ""){
                            $exchange_rate = 0;
                        }
                    }
                }
            }
        }
        return $exchange_rate;
    }
   
    public function getexchangerateamount_fororder($info){
        $exchange_rate_amount = 0;
        if(!empty($info)){
            if($info['exchange_rate_id'] != "" && $info['exchange_rate_id'] != "0"){
                $getexchange_rate = $this->db->query("SELECT exchange_rate FROM tb_rate_exchange_sheet WHERE rate_exchange_id ='".$info['exchange_rate_id']."' AND exchange_from LIKE '".$info['from_currency']."' AND   exchange_to LIKE '".$info['to_currency']."' AND effective_date <= '".$info['order_createddate']."' AND expiry_date >= '".$info['order_createddate']."' AND status ='1' ");
                if($getexchange_rate->num_rows() > 0){
                    $exchange_rate_amount  =  $getexchange_rate->row()->exchange_rate;
                }
            }else{
                if($info['order_id'] >0){
                    if($info['customer_id'] >0){
                        $getexchange_rate = $this->db->query("SELECT s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.customer_id ='".$info['customer_id']."' AND r.status ='1' AND r.company_code LIKE '".$info['company_code']."' AND r.branch_code LIKE '".$info['branch_code']."' AND r.id= s.rate_exchange_id AND s.exchange_from LIKE '".$info['from_currency']."' AND s.exchange_to LIKE '".$info['to_currency']."' AND s.effective_date <= '".$info['order_createddate']."' AND s.expiry_date >= '".$info['order_createddate']."' AND s.status ='1' ORDER BY r.id DESC ");
                        if($getexchange_rate->num_rows() >0){
                            $exchange_rate_amount  =  $getexchange_rate->row()->exchange_rate;
                        }else{
                            $getexchange_rate1 = $this->db->query("SELECT s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.customer_id ='0' AND r.status ='1' AND r.company_code LIKE '".$info['company_code']."' AND r.branch_code LIKE '".$info['branch_code']."' AND r.id= s.rate_exchange_id AND s.exchange_from LIKE '".$info['from_currency']."' AND s.exchange_to LIKE '".$info['to_currency']."' AND s.effective_date <= '".$info['order_createddate']."' AND s.expiry_date >= '".$info['order_createddate']."' AND s.status ='1' ORDER BY r.id DESC ");
                            if($getexchange_rate1->num_rows() > 0){
                                $exchange_rate_amount  =  $getexchange_rate1->row()->exchange_rate;
                            }else{
                                $getexchange_rate2 = $this->db->query("SELECT s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.company_code LIKE '".$info['company_code']."' AND r.branch_code LIKE '".$info['branch_code']."' AND r.id=s.rate_exchange_id AND s.exchange_from LIKE '".$info['from_currency']."' AND s.exchange_to LIKE '".$info['to_currency']."' AND s.effective_date <= '".$info['order_createddate']."' AND s.expiry_date >= '".$info['order_createddate']."'  AND s.status ='1' ORDER BY r.id DESC ");
                                if($getexchange_rate2->num_rows() > 0){
                                    $exchange_rate_amount  =  $getexchange_rate2->row()->exchange_rate;
                                }
                            }
                        }
                    }
                }
            }
            if($exchange_rate_amount == 0){
                if($info['order_id'] >0){
                    $getexchange_rate_final = $this->db->query("SELECT s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.company_code LIKE '".$info['company_code']."' AND r.branch_code LIKE '".$info['branch_code']."' AND r.id=s.rate_exchange_id AND s.exchange_from LIKE '".$info['from_currency']."' AND s.exchange_to LIKE '".$info['to_currency']."' AND s.effective_date <= '".$info['order_createddate']."' AND s.expiry_date >= '".$info['order_createddate']."' AND s.status ='1' ORDER BY r.id DESC ");
                    if($getexchange_rate_final->num_rows() > 0){
                        $exchange_rate_amount  =  $getexchange_rate_final->row()->exchange_rate;
                    }
                }else{
                    $getexchange_rate_final = $this->db->query("SELECT s.exchange_rate FROM tb_rate_exchange_sheet s,tb_rate_exchange r WHERE r.company_code LIKE '".$info['company_code']."' AND r.branch_code LIKE '".$info['branch_code']."' AND r.id=s.rate_exchange_id AND s.exchange_from LIKE '".$info['from_currency']."' AND s.exchange_to LIKE '".$info['to_currency']."' AND s.status ='1' ORDER BY r.id DESC ");
                    if($getexchange_rate_final->num_rows() > 0){
                        $exchange_rate_amount  =  $getexchange_rate_final->row()->exchange_rate;
                    }
                }
            }
        }

        return $exchange_rate_amount;
    }

    public function checkCustomerInProfileList(array $data): int
    {
        $query = $this->db->query("SELECT id FROM tb_customer_profile_list WHERE cp_id = ? AND profile_id = ? AND status = ?", [$data['profileId'], $data['customerId'], 1]);
        return $query->num_rows();
    }
    
    public function getVendorProfileDetailsFromCID(array $cids, int $userId): array
    {
        $query = $this->db->query("SELECT v.id,v.vend_profile_id,l.profile_id FROM tb_vendor_profile v, tb_vendor_profile_list l WHERE v.id=l.vp_id and v.user_id =? and l.profile_id IN ? AND v.status =? and l.status =? ", [$userId, $cids, 1, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsForRates(int $orderId): array
    {
        $query = $this->db->query("SELECT o.id,o.product,o.transport_mode,d.order_type,d.service FROM tb_orders o LEFT JOIN tb_order_details d ON o.id=d.order_row_id WHERE o.id = ? AND d.status = ?", [$orderId, 1]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }
}

?>
