<?php

defined('BASEPATH') or exit('No direct script access allowed');

class OtmBookingModel extends CI_Model
{

	private $ci;
	public function __construct()
	{
		parent::__construct();
		$this->ci = &get_instance();
		$this->load->model('common');
	}

	public function getOrganizationInfo(string $domainName): array
	{
		$domainNameWhere =["domain_name" => $domainName];
		$orgDetails= $this->ci->common->gettblrowdata($domainNameWhere, "organization_name,business_entity_value,customer_name", "tb_organization_cross_references", 0, 0);
		return $orgDetails;
	}
	
	public function getOtmPartyType(string $organizationId,string $businessEntityValue,string $source,string $partyType): string
	{
	    $domainNameWhere =["org_name" => $organizationId, "business_entity_value" => $businessEntityValue,"source" => $source,"party_type" => $partyType];
		$destinationPartyType= $this->ci->common->gettblrowdata($domainNameWhere, "destination", "tb_party_type_xref", 0, 0);
		log_message("error","Innn:".$this->ci->db->last_query());
		return  $destinationPartyType['destination'] ?? "";
	}

	public function getCustomerInfo(string $organizationId,string $businessEntityValue,string $customerCode): array
	{
		$domainNameWhere = ["tpc.company_code" => $organizationId, "tpc.branch_code" => $businessEntityValue, "tpc.code"=>$customerCode, "tp.name" => "Customer"];
		$select = 'tpc.*';
		/*$customerDetails = $this->ci->common->getjointblrowdata("tb_party_contacts tpc", "tb_party tp", "tpc.party_id=tp.id", "tb_users tu", "tp.user_id=tu.id", "tb_organization_cross_references tocr", "tu.user_id=tocr.customer_name", $domainNameWhere, $select);*/
	    $customerDetails = $this->ci->common->getjointbldata("tbl_party_master tpc", "tbl_party_types tp", "tpc.party_type_id=tp.id", $domainNameWhere, $select, 1, 0);
	   
		return $customerDetails;
	}
	
	public function getOrderType(string $organizationId,string $businessEntityValue): string
	{
		$domainNameWhere =["organization_name" => $organizationId, "business_entity_value" => $businessEntityValue];
		$destinationOrderType= $this->ci->common->gettblrowdata($domainNameWhere, "destination_order_type", "tb_order_type_xref", 0, 0);
		return $destinationOrderType['destination_order_type'] ?? "";
	}
	
	public function getModeOfTransport(string $organizationId,string $businessEntityValue): string
	{
		$domainNameWhere =["organization_name" => $organizationId, "business_entity_value" => $businessEntityValue];
		$destinationModeOfTransport= $this->ci->common->gettblrowdata($domainNameWhere, "destination_mode_of_transport", "tb_mode_of_transport_xref", 0, 0);
		return $destinationModeOfTransport['destination_mode_of_transport'] ?? "";
	}
	
	public function getPartyType(string $organizationId,string $businessEntityValue): string
	{
	    $domainNameWhere =["organization_name" => $organizationId, "business_entity_value" => $businessEntityValue];
		$destinationPartyType= $this->ci->common->gettblrowdata($domainNameWhere, "destination_party_type", "tb_party_type_xref_old", 0, 0);
		//log_message("error","Innn:".$this->ci->db->last_query());
		return  $destinationPartyType['destination_party_type'];
	}
	
	public function getLogicalReceiver(string $organizationId,string $businessEntityValue): string
	{
		$domainNameWhere =["company_code" => $organizationId, "branch_code" => $businessEntityValue];
		$logicalSender= $this->ci->common->gettblrowdata($domainNameWhere, "logical_sender", "tb_branch_master", 0, 0);
		return $logicalSender['logical_sender'];
	}
	
	public function getDomain(string $orderId): array
	{
		$domainNameWhere = ["tor.reference_id" => "DOMAIN", "tod.id" => $orderId];
		$select = 'tod.external_order_id, tod.created_source, tor.ref_value';
	    $domainDetails = $this->ci->common->getjointbldata("tb_orders tod", "tb_order_references tor", "tod.id=tor.order_id", $domainNameWhere, $select, 1, 0);
	  
		return $domainDetails;
	}
	
	public function getOtmStatusCode(string $statusCode): string
	{
		$domainNameWhere =["svk_status" => $statusCode];
		$otmStatus= $this->ci->common->gettblrowdata($domainNameWhere, "otm_status", "tb_edi_status", 0, 0);
		return $otmStatus['otm_status'];
	}
	
	public function getOtmPartyInfo(
        string $organizationId,
        string $businessEntityValue,
        string $customerCode,
        string $partyType
    ): array
    {
        $partyTypeUpper = strtoupper($partyType);
    
        $domainNameWhere = [
            "tpc.company_code" => $organizationId,
            "tpc.branch_code"  => $businessEntityValue,
            "tpc.code"         => $customerCode,
            "upper(tp.name)"   => $partyTypeUpper // ensures case-insensitive match
        ];
    
        $select = 'tpc.*';
    
        $customerDetails = $this->ci->common->getjointbldata(
            "tbl_party_master tpc",
            "tbl_party_types tp",
            "tpc.party_type_id = tp.id",
            $domainNameWhere,
            $select,
            1,
            0
        );
        
        return $customerDetails;
    }
    
    
    public function getOtmCarrierPartyInfo(
        string $organizationId,
        string $businessEntityValue,
        string $customerCode,
        string $partyType
    ): array
    {
        $partyTypeUpper = strtoupper($partyType);
    
        $domainNameWhere = [
            "tpc.code"         => $customerCode,
            "upper(tp.name)"   => $partyTypeUpper // ensures case-insensitive match
        ];
    
        $select = 'tpc.*';
    
        $customerDetails = $this->ci->common->getjointbldata(
            "tbl_party_master tpc",
            "tbl_party_types tp",
            "tpc.party_type_id = tp.id",
            $domainNameWhere,
            $select,
            1,
            0
        );
        
        return $customerDetails;
    }
}

