<?php

defined('BASEPATH') or exit('No direct script access allowed');

class OtmTripModel extends CI_Model
{

	private $ci;

	public function __construct()
	{
		parent::__construct();
		$this->ci = &get_instance();
		$this->load->model('common');
	}

	public function getOrganizationInfo(string $domainName): array
	{
		$domainNameWhere = ["domain_name" => $domainName];
		$orgDetails = $this->ci->common->gettblrowdata($domainNameWhere, "organization_name,business_entity_value,customer_name", "tb_organization_cross_references", 0, 0);
		return $orgDetails;
	}

	/*public function getCustomerInfo(string $domainName)
	{
		$domainNameWhere = ["domain_name" => $domainName];
		$select = 'tp.customer_code, tpa.*';
		$customerDetails = $this->ci->common->getjointblrowdata("tb_party_address tpa", "tb_party tp", "tpa.party_id=tp.id", "tb_users tu", "tp.user_id=tu.id", "tb_organization_cross_references tocr", "tu.user_id=tocr.customer_name", $domainNameWhere, $select);
		return $customerDetails;
	}*/
	public function getCustomerInfo(string $domainName)
	{
		$domainNameWhere = ["domain_name" => $domainName];
		$select = 'tp.customer_code, tpc.*';
		$customerDetails = $this->ci->common->getjointblrowdata("tb_party_contacts tpc", "tb_party tp", "tpc.party_id=tp.id", "tb_users tu", "tp.user_id=tu.id", "tb_organization_cross_references tocr", "tu.user_id=tocr.customer_name", $domainNameWhere, $select);
		return $customerDetails;
	}
}
