<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Otmshipmentmodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    public function checkCrossReferences(string $referenceCode, string $organizationId, string $businessEntityValue): string
    {
        $referenceNameWhere = ["from_ref_code" => $referenceCode, "organization_id" => $organizationId, "entity_value_id" => $businessEntityValue];
        $reference = $this->db->select("to_ref_code")->get_where("tb_references_xref", $referenceNameWhere);
        return $reference->num_rows() > 0 ? $reference->row()->to_ref_code : "";
    }

    public function checkCrossRemarks(string $remarkCode, int $organizationId, int $businessEntityValue): string
    {
        $remarkNameWhere = ["from_remark_type" => $remarkCode, "organization_id" => $organizationId, "entity_value_id" => $businessEntityValue];
        $remark = $this->db->select("to_remark_type")->get_where("tb_remarks_xref", $remarkNameWhere);
        return $remark->num_rows() > 0 ? $remark->row()->to_remark_type : "";
    }

    // public function checkPartyRole(string $partyRole, string $organizationId, string $businessEntityValue): string
    // {
    //     $partyWhere = ["source_party" => $partyRole, "organization_id" => $organizationId, "entity_value_id" => $businessEntityValue];
    //     $party = $this->db->select("destination_party")->get_where("tb_party_role_xref", $partyWhere);
    //     return $party->num_rows() > 0 ? $party->row()->destination_party : "";
    // }
        public function checkPartyRole(string $partyRole, string $organizationId, string $businessEntityValue): string
    {
        log_message('error', "checkPartyRole called | PartyRole: {$partyRole}");

        if (!empty($partyRole)) {
            return $partyRole; 
        }

        log_message('error', "PartyRole EMPTY for OrgID: {$organizationId}, Entity: {$businessEntityValue}");
        return "";
    }

    public function checkPackageType(string $packageType, string $organizationId, string $businessEntityValue): string
    {
        $packageWhere = ["from_package_type" => $packageType, "organization_name" => $organizationId, "business_entity_value" => $businessEntityValue];
        $package = $this->db->select("to_package_type")->get_where("tb_package_types_xref", $packageWhere);
        return $package->num_rows() > 0 ? $package->row()->to_package_type : "";
    }

    public function checkUOM(string $uomType, string $organizationId, string $businessEntityValue): string
    {
        $uomWhere = ["from_uom_type" => $uomType, "organization_name" => $organizationId, "business_entity_value" => $businessEntityValue];
        $uomName = $this->db->select("to_uom_type")->get_where("tb_uom_xref", $uomWhere);
        return $uomName->num_rows() > 0 ? $uomName->row()->to_uom_type : "";
    }
    

    public function getUOMId(string $uomName): string
    {
        $uomId = $this->db->select("id")->get_where("tb_uom_master", ["uom_name" => $uomName]);
        return $uomId->num_rows() > 0 ? $uomId->row()->id : "";
    }

    public function getPartyTypeId(string $partyName): string
    {
        $partyTypeId = $this->db->select("id")->get_where("tb_party_types", ["party_type" => $partyName]);
        return $partyTypeId->num_rows() > 0 ? $partyTypeId->row()->id : "";
    }

    public function getPackageId(string $packageName): string
    {
        $packageId = $this->db->select("id")->get_where("tb_package_types", ["package_type_name" => $packageName]);
        return $packageId->num_rows() > 0 ? $packageId->row()->id : "";
    }

    public function getReferenceId(string $referenceName): string
    {
        $referenceId = $this->db->select("reference_type_id")->get_where("tb_reference_type_master", ["reference_type" => $referenceName]);
        return $referenceId->num_rows() > 0 ? $referenceId->row()->reference_type_id : "";
    }

    public function getRemarkId(string $remarkName): string
    {
        $remarkId = $this->db->select("id")->get_where("tb_remark_type_master", ["remark_type" => $remarkName]);
        return $remarkId->num_rows() > 0 ? $remarkId->row()->id : "";
    }

    public function checkOrderTypeCrossRef(string $orderType): string
    {
        $destinationOrderType = $this->db->select("destination_order_type")->get_where("tb_order_type_xref", ["source_order_type" => $orderType]);
        return $destinationOrderType->num_rows() > 0 ? $destinationOrderType->row()->destination_order_type : "";
    }

    public function checkModeOfTransportCrossRef(string $modeOfTransport): string
    {
        $destinationModeOfTransport = $this->db->select("destination_mode_of_transport")->get_where("tb_mode_of_transport_xref", ["source_mode_of_transport" => $modeOfTransport]);
        return $destinationModeOfTransport->num_rows() > 0 ? $destinationModeOfTransport->row()->destination_mode_of_transport : "";
    }

    public function insertTripReferences(int $tripId, array $orderRef, int $organizationId,
        int $businessEntityValue): void {
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'tripid' => $tripId,
            'reference_id' => $orderRef['RefType']['Code'],
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            //'ref_value' => $orderRef['RefType']['Value'],
        ];
        $chkref = $this->db->select("id")->get_where("tb_trip_references", $chkdt);
        $srefqry = [
            'tripid' => $tripId,
            'reference_id' => $orderRef['RefType']['Code'],
            'ref_value' => $orderRef['RefType']['Value'],
            'organization_id' => $organizationId,
            'entity_value_id' => $businessEntityValue,
            'status' => 1,
            'createdon' => $curdt,
            'modifiedon' => $curdt,
        ];
        if ($chkref->num_rows() === 0) {
            $this->common->insertTableData('tb_trip_references', $srefqry);
        } else {
            $this->db->where(["tripid" => $tripId, "reference_id" => $orderRef['RefType']['Code']])->update("tb_trip_references", $srefqry);
        }
    }

    public function insertTripRemarks(int $tripId, array $orderRem, int $organizationId,
        int $businessEntityValue): void {
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'trip_id' => $tripId,
            'remark_qual_gid' => $orderRem['RemarkType']['Code'],
            'organization_id' => $organizationId,
            'business_entity_id' => $businessEntityValue,
            //'ref_value' => $orderRef['RefType']['Value'],
        ];
        $chkref = $this->db->select("id")->get_where("tb_trip_remarks", $chkdt);
        $srefqry = [
            'trip_id' => $tripId,
            'remark_qual_gid' => $orderRem['RemarkType']['Code'],
            'remark_text' => $orderRem['RemarkType']['Value'],
            'organization_id' => $organizationId,
            'business_entity_id' => $businessEntityValue,
            'status' => 1,
            'createdon' => $curdt,
            'modifiedon' => $curdt,
        ];
        if ($chkref->num_rows() === 0) {
            $this->common->insertTableData('tb_trip_remarks', $srefqry);
        } else {
            $this->db->where(["trip_id" => $tripId, "remark_qual_gid" => $orderRem['RemarkType']['Code']])->update("tb_trip_remarks", $srefqry);
        }
    }
}
