<?php

class PodUpload extends CI_Model {

    public function getPodUploadsWithDetailsByOrderId (string $order_id): array
    {
        $results = [];

        $query = $this->db->query(
            "SELECT
                pu.id,
                pu.latitude, pu.longitude, pu.stop_id, pu.stop_type,
                pu.createdby, pu.createdon, pu.imgpath, pu.hash,pu.receiver_name,
                dt.type_name,
                e.address, e.pickup, e.drop, e.order_id
            FROM tb_pod_uploads pu
                LEFT JOIN tb_document_types dt ON dt.id=pu.doc_type
                LEFT JOIN tb_employee e ON e.id = pu.stop_detail_id
            WHERE pu.order_id = ? AND pu.status=1
            ORDER BY pu.createdon",
            [$order_id]
        );
        foreach ($query->result() as $row) {
            $results [] = $row;
        }

        return $results;
    }
}
