<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Quickbook_model extends CI_model{

    private const VOLUME_TYPES = ['ACTUAL VOLUME', 'VOLUME'];
    private const WEIGHT_TYPES = ['ACTUAL WEIGHT', 'WEIGHT'];

    // the below method will return transport modes
    public function getTransportModes(){
        $data=[];
        $this->db->select("tm.code,tm.name");
        $this->db->from("tb_transportmode tm");
        $condition="('LTL','FTL','SEA-FCL')";
        $this->db->where("tm.code in  $condition");
        $this->db->group_by("tm.code");

        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            $data = $getresult->result_array();
        }
        return $data;
    }

    // the below method will return value added services
    public function getVAS(){
        $vas_data=[];
        $this->db->select("vs.vas_id,vs.vas_name,vs.id");
        $this->db->from("tb_vas_master vs");
        $condition="('TLG')";
        $this->db->where("vs.vas_id in  $condition");

        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            foreach ( $getresult->result() as $res ) {
                $vas_data[] = [ 'vas_row_id' => $res->id, 'vas_id' => $res->vas_id . "-" . $res->vas_name ];
            }
        }
        return $vas_data;
    }

    // below method will fetch the items master for cargo related data
    public function getItemsMaster()
    {
        $whereCondition = $this->getPackagesWhereCondtion();
        $qry = $this->db->query(
            "SELECT id,item_name,length,length_unit,width,width_unit,height,
                                height_unit,weight,weight_unit,volume,volume_unit
                                FROM tb_items WHERE status='1' $whereCondition   ORDER BY createdon DESC"
        );
        if ( $qry->num_rows() > 0 ) {
            foreach ( $qry->result() as $res ) {
                $items[] = array(
                    'id'            => $res->id,
                    'item_name'     => $res->item_name,
                    'length'        => $res->length,
                    'length_uom'    => $res->length_unit,
                    'width'         => $res->width,
                    'width_uom'     => $res->width_unit,
                    'height'        => $res->height,
                    'height_uom'    => $res->height_unit,
                    'weight'        => $res->weight,
                    'weight_uom'    => $res->weight_unit,
                    'volume'        => $res->volume,
                    'volume_uom'    => $res->volume_unit
                );
            }
        }
        return $items;
    }

    public function getPackagesWhereCondtion()
    {
        $companyCode = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata("branch_code");
        if ($this->session->userdata("cust_id") == "" && $companyCode == 'NZPG') {
            if (checkAccessConditions('NZPG_PACK_1', $branch_code)) {
                $itemId = "'BD','BG','BI','BL','BX','CA','CE','CN','DM','HP','PT','20GP','20HC','20OT','40GP','40HC','40OT'";
                return "AND (quickbook_status ='1' AND item_id in ( $itemId))";
            }
            if ($branch_code == 'NZPGALT') {
                $itemId = "'BD','BG','BI','BL','BX','CA','CY','CE','DM','CHEPB','CHEPR','CHEPT','DUNN','HIRED','PALLD','PALLO','MXCON','PLCON','LOS'";
                return "AND (quickbook_status ='1' AND item_id NOT IN ( $itemId))";
            }
            if ($branch_code == 'ALTOWLG') {
                $itemId = "'BD', 'BG', 'BI', 'BX', 'CA', 'CE', 'CY', 'DM', 'CHEPB', 'CHEPR', 'CHEPT', 'DUNN', 'HIRED', 'PALLD', 'PALLO', 'MXCON', 'PLCON', 'LOS'";
                return "AND (quickbook_status ='1' AND item_id NOT IN ( $itemId))";
            }
            if (checkAccessConditions('NZPG_PACK_2', $branch_code)) {
                $itemId = "'PT','WP','PP'";
                return "AND (quickbook_status ='1' AND item_id in ( $itemId))";
            }
        } else {
            $customerid = $this->session->userdata("cust_id");
            $getCustomerCode = $this->db->select("phone")->get_where("tb_customers", ['id' => $customerid, 'status' => '1']);
            if ($getCustomerCode->num_rows() > 0) {
                $customer_code = $getCustomerCode->row()->phone;
            }

            if ($companyCode == 'NZPG' && checkAccessConditions('NZPGALT_Customer_1', $customer_code)) {
                $itemId = "'BD','BG','BI','BL','BX','CA','CE','CN','DM','HP','PT','20GP','20HC','20OT','40GP','40HC','40OT'";
                return "AND (quickbook_status ='1' AND item_id in ( $itemId))";
            }
            if ($companyCode == 'NZPG' && checkAccessConditions('NZPGALT_Customer_2', $customer_code)) {
                $itemId = "'PT','WP','PP'";
                return "AND (quickbook_status ='1' AND item_id in ( $itemId))";
            }
            if ($companyCode == 'NZPG' && $customer_code == 'ALTOWLG') {
                $itemId = "'BD', 'BG', 'BI', 'BX', 'CA', 'CE', 'CY', 'DM', 'CHEPB', 'CHEPR', 'CHEPT', 'DUNN', 'HIRED', 'PALLD', 'PALLO', 'MXCON', 'PLCON', 'LOS'";
                return "AND (quickbook_status ='1' AND item_id NOT IN ( $itemId))";
            }

        }
        $itemId = "'BD','BG','BI','BL','BX','CA','CE','CN','CY','DM','HP','PT','CHEPB','CHEPR','CHEPT','DUNN','HIRED','PALLD','PALLO','MXCON','PLCON','LOS','20GP','20HC','20OT','40GP','40HC','40OT'";
        return "AND  (quickbook_status ='0' OR item_id in ( $itemId))";
    }

    public function getReferenceData(): array {
      $bindParams = [];
      $sql = "SELECT `name`, `description` FROM `tb_reference_master` WHERE `status` = ? ";
      $bindParams[] = 1;
      if ($this->session->userdata('company_code') !== NULL && $this->session->userdata('company_code') === 'NZPG') {
        $getResult = $this->db->query("SELECT `condition` FROM `access_conditions` WHERE `title` = ? ",['RELATED_TO_NZPG_REFERENCES']);
        $referenceList = $getResult->num_rows() > 0 ? explode(',', $getResult->row()->condition) : [];
        if ($referenceList) {
          $sql .= " AND `name` IN ? ";
          $bindParams[] = $referenceList;
        }
      }
      $sql .= " GROUP BY `name` ORDER BY `name`";
      $getResults = $this->db->query($sql,$bindParams);
      return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getServicesData(){
        $service_data=[];
        $this->db->select("sm.id,sm.name,sm.service_id,sm.transport_mode");
        $this->db->from("tb_service_master sm");
        $condition="('3','5','16')";
        $this->db->where("sm.id in  $condition");

        $getresult = $this->db->get();
        if ($getresult->num_rows() > 0) {
            foreach ( $getresult->result() as $res ) {
                $service_data[] = [ 'id' => $res->id, 'name' => $res->service_id . " - " . $res->name,'transport_mode'=>$res->transport_mode ];
            }
        }
        return $service_data;

    }

    public function getCharges($cargoWeight, $cargoVolume, $cargoQuantity, $offeringType, $tariffType, $geoPairs, $geoTierPairs, $ratePreferencesData = [])
    {
        $currentDate = date('Y-m-d');
        $geoCondition = $geoPairs['geoCondition'];
        $lanesCondition = $geoPairs['lanesCondition'];
        $geoPairsGsheet = str_replace(['DUMMY_FROM', 'DUMMY_TO'], ['gsheet.geo_from', 'gsheet.geo_to'], $geoCondition);
        $geoPairsLaneMaster = str_replace(['DUMMY_FROM', 'DUMMY_TO'], ['lm.source', 'lm.destination'], $lanesCondition);
        $cargoWeight = $this->db->escape($cargoWeight);
        $cargoVolume = $this->db->escape($cargoVolume);
        $cargoQuantity = $this->db->escape($cargoQuantity);
        $offeringType = $this->db->escape($offeringType);
        $tariffType = $this->db->escape($tariffType);
        $branch_code = $this->db->escape($this->session->userdata("branch_code"));
        $recordsToGet = $ratePreferencesData['recordsToGet'] ?? [];
        $recordsNotToGet = $ratePreferencesData['recordsNotToGet'] ?? [];
        $recordIdsCondition = empty($recordsToGet) ? "" : " AND rr.id IN (" . implode(',', $recordsToGet) . ") ";
        $recordIdsCondition .= empty($recordsNotToGet) ? "" : " AND rr.id NOT IN (" . implode(',', $recordsNotToGet) . ") ";
        $query = 'SELECT source,destination,rate_id,vendor_profile,vendor_profile_id, vehicle_profile_id, vehicle_profile,transit_time, min_price, Sum(price) AS price,
       SUM(total_services_price) AS total_services_price, SUM(total_price) as total_price, currency, uom_conversion_id,rr_charge_type,geotier_id from
       (SELECT source, destination, rate_id, vendor_profile, vendor_profile_id, vehicle_profile_id, vehicle_profile,
        transit_time,  min_price,  SUM(price) as price, total_services_price, fuel_surcharge_id, amount, percentage,
        CASE
                        WHEN rr_charge_id = 39 THEN
                            CASE
                              WHEN COALESCE(CONVERT(amount, DECIMAL(10, 2)), 0) <> 0 THEN ROUND(SUM(price)+amount, 2)
                              WHEN COALESCE(CONVERT(amount, DECIMAL(10, 2)), 0) = 0 AND COALESCE(CONVERT(percentage, DECIMAL(10, 2)), 0) <> 0 THEN
                                ROUND(SUM(total_price) + SUM(total_price) * percentage / 100, 2)
                              WHEN amount IS NULL AND percentage IS NULL THEN
                                ROUND(SUM(total_price), 0)
                            END
                        ELSE ROUND(SUM(total_price), 0)
        END AS total_price,
            uom_conversion_id,rr_charge_type,geotier_id, currency
        FROM ( SELECT  DISTINCT rr_charge_id,table1.source,table1.destination,table1.rate_id,vendor_profile, table1.vendor_profile_id,
            vehicle_profile_id, vehicle_profile, transit_time, min_price, Price, total_services_price, table2.fuel_surcharge_id,
            table2.amount, table2.percentage, total_price, uom_conversion_id,rr_charge_type,geotier_id,
            table1.currency FROM (SELECT source,destination,rate_id,rr_charge_type,rr_charge_id, fuel_surcharge_id,vendor_profile,
            vehicle_profile,vendor_profile_id,vehicle_profile_id,transit_time, min_price, SUM(Price) AS Price,
            SUM(total_services_price) AS total_services_price, SUM(total_price) AS total_price,currency,uom_conversion_id, geotier_id
                  FROM
                     (
                       SELECT source, destination, rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id,
                          vendor_profile, vehicle_profile, vendor_profile_id, vehicle_profile_id, transit_time, min_price, Price,
                          SUM(IFNULL(Serviceprice, 0)) AS `total_services_price`,
                          Price + SUM(IFNULL(Serviceprice, 0)) AS `total_price`, currency, uom_conversion_id, geotier_id
                     FROM
                        (
                           SELECT lm.id, source, destination, rr.rate_id,  rc.rr_charge_type, rc.rr_charge_id, rc.fuel_surcharge_id,
                           rc.rr_tier_id, rc.geo_tier_id, vp.name AS vendor_profile, vp.id AS vendor_profile_id,
                           vehp.id AS vehicle_profile_id, ros.rateoffering_id, vehp.name AS vehicle_profile,
                           ROUND(rs_lane_days + rs_lane_hours / 24 + rs_lane_mins / 1440) AS transit_time,
                              (
                  CASE WHEN rr_charge_type = "Fixed" and uom_conversion_id <> 0  THEN
                      rc.min_amount
                    WHEN rr_charge_type = "Geo Tier" and uom_conversion_id <> 0  and 0  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), 0  )
                                          AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), 0  )  THEN
                                          geotier.cost
                END
                ) as min_price,
                              (
                                 CASE
                                    WHEN rr_charge_type = "Fixed" THEN
                                          CASE
                                             WHEN uom_conversion_id <> 0 THEN
                                                rc.amount
                                             WHEN rc.charge_basis = "KG" OR rc.charge_basis = "PER KG" THEN
                                                CASE
                                                         WHEN ' . $cargoWeight . ' * rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE ' . $cargoWeight . ' * rc.amount
                                                END
                                             WHEN rc.charge_basis = "CBM" OR rc.charge_basis = "PER CBM" THEN
                                                CASE
                                                         WHEN ' . $cargoVolume . ' * rc.amount < rc.min_amount THEN  rc.min_amount
                                                         ELSE ' . $cargoVolume . ' * rc.amount
                                                END
                                             WHEN rc.charge_basis = "PER PIECE" THEN
                                                CASE
                                                         WHEN ' . $cargoQuantity . ' * rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE ' . $cargoQuantity . ' * rc.amount
                                                END
                                            WHEN rc.charge_basis = "PER TRIP"  OR rc.charge_basis = "TRIP" THEN
                                                CASE
                                                         WHEN  rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE  rc.amount
                                                END
                                          END
                                    WHEN rr_charge_type = "Tier" THEN
                                          CASE
                                             WHEN tier.billing_uom = "WEIGHT"  OR tier.billing_uom = "ACTUAL WEIGHT" THEN
                                                   CASE
                                                      WHEN ' . $cargoWeight . ' BETWEEN COALESCE( CONVERT(tier.uom1_min, DECIMAL(10, 2)), ' . $cargoWeight . ' )
                                                         AND COALESCE( CONVERT(tier.uom1_max, DECIMAL(10, 2)), ' . $cargoWeight . ' )
                                                         AND ' . $cargoVolume . ' BETWEEN COALESCE( CONVERT(tier.uom2_min, DECIMAL(10, 2)), ' . $cargoVolume . ')
                                                         AND COALESCE( CONVERT(tier.uom2_max, DECIMAL(10, 2)), ' . $cargoVolume . ' ) THEN ' . $cargoWeight . ' * tier.cost
                                                   END
                                             WHEN  tier.billing_uom = "VOLUME" OR tier.billing_uom = "ACTUAL VOLUME" THEN
                                                   CASE
                                                      WHEN ' . $cargoWeight . ' BETWEEN COALESCE( CONVERT(tier.uom1_min, DECIMAL(10, 2)), ' . $cargoWeight . ' )
                                                         AND COALESCE( CONVERT(tier.uom1_max, DECIMAL(10, 2)), ' . $cargoWeight . ' )
                                                         AND ' . $cargoVolume . ' BETWEEN COALESCE( CONVERT(tier.uom2_min, DECIMAL(10, 2)), 1 )
                                                         AND COALESCE( CONVERT(tier.uom2_max, DECIMAL(10, 2)), ' . $cargoVolume . ' ) THEN ' . $cargoVolume . ' * tier.cost
                                                   END
                                          END
                                    WHEN  rr_charge_type = "Geo Tier"  THEN
                                          CASE
                                             WHEN geotier.unit_measure1 = "KG" OR geotier.unit_measure1 = "PER KG" THEN
                                                    CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN  ' . $cargoWeight . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoWeight . ' )
                                    AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoWeight . ' ) THEN
                                    geotier.cost
                                    END
                            ELSE
                                                      CASE
                                                       WHEN  ' . $cargoWeight . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoWeight . ' )
                                                         AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoWeight . ' ) THEN
                                                         CASE
                                                           WHEN  ' . $cargoWeight . ' * geotier.cost < geotiermaxvalue.uom1_minimum  THEN geotiermaxvalue.uom1_minimum
                                                           ELSE ' . $cargoWeight . ' * geotier.cost
                                                         END
                                                      END
                                                  END

                                             WHEN geotier.unit_measure1 = "CBM" OR geotier.unit_measure1 = "PER CBM" THEN
             CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN ' . $cargoVolume . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoVolume . '  )
                                          AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoVolume . '  )  THEN
                                          geotier.cost
                                 END
                            ELSE
                                                   CASE
                                                      WHEN ' . $cargoVolume . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoVolume . '  )
                                                            AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoVolume . '  )  THEN
                                                         CASE
                                                            WHEN ' . $cargoVolume . ' * geotier.cost < geotiermaxvalue.uom1_minimum THEN  geotiermaxvalue.uom1_minimum
                                                              ELSE ' . $cargoVolume . '  * geotier.cost
                                                         END
                                                   END
            END
                                             WHEN geotier.unit_measure1 = "PIECE COUNT" THEN
            CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN ' . $cargoQuantity . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoQuantity . '  )
                                          AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoQuantity . '  )  THEN
                                          geotier.cost
                                 END
                            ELSE
                                                   CASE
                                                      WHEN ' . $cargoQuantity . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $cargoQuantity . '  )
                                                            AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $cargoQuantity . '  )  THEN
                                                         CASE
                                                            WHEN ' . $cargoQuantity . ' * geotier.cost < geotiermaxvalue.uom1_minimum THEN  geotiermaxvalue.uom1_minimum
                                                              ELSE ' . $cargoQuantity . '  * geotier.cost
                                                         END
                                                   END
            END
                                          END
                                 END
                              ) AS price,

                                 CASE WHEN ros.min_amount > ros.amount THEN ros.min_amount ELSE ros.amount
                                 END
                                    AS Serviceprice,
                                 CASE
                                   WHEN rr_charge_type = "Fixed" THEN rc.currency
                                   WHEN  rr_charge_type = "Tier" THEN  tier.currency
                                   WHEN  rr_charge_type = "Geo Tier" THEN  geotier.currency
                                END
                                AS currency, uom_conversion_id,geotier.id as geotier_id
                                 FROM
                                 tb_lanes_master lm
                                 INNER JOIN  tb_rateservice_lanes rsl  ON lm.id = rsl.lane_id
                                 INNER JOIN  tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id and ro.branch_code = '. $branch_code .'
                                 LEFT JOIN  tb_rateoffering_services ros ON ro.id = ros.rateoffering_id
                                 INNER JOIN  tb_rate_records rr ON rr.offering_id = ro.id '.$recordIdsCondition.'
                                 INNER JOIN tb_raterecord_charges rc  ON rc.raterecord_id = rr.id
                                 LEFT JOIN tb_raterecord_services rrs  ON rrs.raterecord_id = rr.id
                                 LEFT JOIN
                                    (
                                       SELECT tm.id, tm.billing_uom, tsheet.uom1_min, uom1_max, uom2_min, uom2_max,
                                       cost, tsheet.status, tm.currency, tm.company_code  FROM tb_tier_master tm
                                       INNER JOIN  tb_tier_rate_sheet tsheet  ON tm.id = tsheet.tier_master_id
                                       WHERE tsheet.status = 1 AND tm.status = 1 ORDER BY  tsheet.updatedon DESC
                                    ) tier ON tier.id = rc.rr_tier_id  OR rc.rr_charge_type = "Fixed"
                                 LEFT JOIN
                                    (
                                       SELECT  gt.id, gt.flat, unit_measure1, uom1_min, uom1_max, uom1_minimum, cost,
                                       gt.currency, gt.company_code  FROM tb_geo_tier gt
                                       INNER JOIN tb_geo_tier_sheet gsheet ON gt.id = gsheet.geo_tier_id
                                       WHERE  gsheet.status = 1 AND gt.status = 1
                                       AND
                                        CASE
                                        WHEN gt.geo_hierarchy ="PROVINCE" THEN '.$geoTierPairs["PROVINCE"].'
                                        WHEN gt.geo_hierarchy ="POSTAL CODE" THEN '.$geoTierPairs["POSTAL CODE"].'
                                        WHEN gt.geo_hierarchy ="CITY" THEN '.$geoTierPairs["CITY"].'
                                        WHEN gt.geo_hierarchy ="COUNTRY" THEN '.$geoTierPairs["COUNTRY"].' ELSE
                                       ( '.$geoPairsGsheet.' ) END ORDER BY gsheet.updatedon DESC
                                    ) geotier  ON geotier.id = rc.geo_tier_id OR rc.rr_charge_type = "Fixed"
                                 LEFT JOIN
                                    (
                                       SELECT  gt.id, cost AS uom1_minimum
                                       FROM tb_geo_tier gt
                                       INNER JOIN tb_geo_tier_sheet gsheet ON gt.id = gsheet.geo_tier_id
                                       WHERE gsheet.status = 1 AND gt.status = 1 AND
                                        CASE
                                        WHEN gt.geo_hierarchy ="PROVINCE" THEN '.$geoTierPairs["PROVINCE"].'
                                        WHEN gt.geo_hierarchy ="POSTAL CODE" THEN '.$geoTierPairs["POSTAL CODE"].'
                                        WHEN gt.geo_hierarchy ="CITY" THEN '.$geoTierPairs["CITY"].'
                                        WHEN gt.geo_hierarchy ="COUNTRY" THEN '.$geoTierPairs["COUNTRY"].' ELSE
                                       ( '.$geoPairsGsheet.' ) END AND uom1_minimum <> "0"
                                       GROUP BY gt.id ORDER BY gsheet.updatedon DESC
                                    ) geotiermaxvalue  ON geotier.id = geotiermaxvalue.id OR rc.rr_charge_type = "Fixed"
                                 LEFT JOIN tb_vendor_profile vp ON ro.vendor_profile_id = vp.id
                                 LEFT JOIN tb_vehicle_profile vehp ON ro.veh_profile_id = vehp.id
                                 WHERE
                                    ( '.$geoPairsLaneMaster.' ) AND ro.tarrif_type = ' . $tariffType . '
                                       AND ( ' . $tariffType . '  = "" OR ro.offering_type = ' . $offeringType . ' ) AND rc.status=1 AND rr.status=1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1 AND vp.status = 1

                        ) AS RATES
                        WHERE rr_charge_id<>38
                        GROUP BY source, destination, rate_id, rr_charge_type, rr_charge_id,fuel_surcharge_id,
                        vendor_profile, vendor_profile_id, vehicle_profile_id, vehicle_profile, transit_time, Price, currency ) t1
                        GROUP BY source, destination, rate_id, rr_charge_type, rr_charge_id,fuel_surcharge_id,
                        vendor_profile, vendor_profile_id, vehicle_profile_id, vehicle_profile, transit_time, currency) AS table1
                        LEFT JOIN (
                           SELECT rate_id, fscharges.id AS fuel_surcharge_id,fscharges.amount,fscharges.percentage FROM
                              (SELECT rate_id,rr_charge_type,rr_charge_id,fuel_surcharge_id FROM
                                 (SELECT  rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id FROM
                                    (
                                       SELECT lm.id, source, destination, rr.rate_id, rc.rr_charge_type, rc.rr_charge_id,
                                       rc.fuel_surcharge_id, rc.rr_tier_id, rc.geo_tier_id,vp.name AS vendor_profile,
                                       vp.id AS vendor_profile_id, vehp.id AS vehicle_profile_id,ros.rateoffering_id,
                                       vehp.name AS vehicle_profile
                                       FROM tb_lanes_master lm
                                       INNER JOIN tb_rateservice_lanes rsl ON lm.id = rsl.lane_id
                                       INNER JOIN tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id
                                       LEFT JOIN  tb_rateoffering_services ros ON ro.id = ros.rateoffering_id
                                       INNER JOIN tb_rate_records rr ON rr.offering_id = ro.id
                                       INNER JOIN tb_raterecord_charges rc ON rc.raterecord_id = rr.id
                                       LEFT JOIN tb_raterecord_services rrs ON rrs.raterecord_id = rr.id
                                       LEFT JOIN tb_vendor_profile vp ON ro.vendor_profile_id = vp.id
                                       LEFT JOIN tb_vehicle_profile vehp ON ro.veh_profile_id = vehp.id
                                       WHERE ( '.$geoPairsLaneMaster.' ) AND ro.tarrif_type = ' . $tariffType . '
                                       AND ( "FTL" = "" OR ro.offering_type = ' . $offeringType . ' )
                                       AND rc.status=1 AND rr.status=1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1 AND vp.status = 1) AS RATES

                                 ) t1  WHERE rr_charge_id=38
                                 GROUP BY rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id
                              ) tblfrt
                              INNER JOIN (
                                 SELECT f.id,fs.amount,fs.percentage FROM tb_fuel_surcharge f
                                 INNER JOIN tb_fuel_surcharge_sheet fs ON f.id = fs.fuel_surcharge_id
                                 WHERE fs.Status=1 and f.status=1 and from_date <= "' . $currentDate . '" and to_date >= "' . $currentDate . '"
                              ) AS fscharges ON fscharges.id=tblfrt.fuel_surcharge_id
                     ) AS table2
                     ON table1.rate_id = table2.rate_id ) AS finalResult
                     WHERE total_price IS NOT NULL
                     GROUP  BY
                     rate_id,rr_charge_id
                     ORDER BY total_price desc )tab1 group BY source,
               destination,
               rate_id,
               vendor_profile,
               vendor_profile_id,
                     vehicle_profile_id,
                     vehicle_profile,
                     transit_time';

        $chargesObject = $this->db->query($query);
        return [$chargesObject, $query];
    }

    public function getConversionFactorRate($cargoWeight, $cargoVolume, $cargoQuantity, $uom_conversion_id, $price, $min_price, $chargeType, $geotier_id, $geoTierPairs, $rateId)
    {
        $query = $this->db->select("uom_type1, uom_type2, uom_type3, uom_type4, uom1, uom2, uom3, uom4,
            uom1_conversion, uom2_conversion, uom3_conversion, uom4_conversion, base_uom"
        )->where("id", $uom_conversion_id)->get("tb_knuom_conversion");
        if ($query->num_rows() > 0) {
            $data = $query->row_array();
            $conversionFactorWeight = $this->getConversionFactorWeight($data) ?? 0;
            $conversionFactorVolume = $this->getConversionFactorVolume($data) ?? 0;
            $weight = $cargoWeight * $conversionFactorWeight;
            $volume = $cargoVolume * $conversionFactorVolume;
            $data['unitToBeConsidered'] = max($weight, $volume);
            $data['conversionBaseUom'] = $data['base_uom'];
            $data['cargoWeight'] = $cargoWeight;
            $data['cargoVolume'] = $cargoVolume;
            $data['cargoQuantity'] = $cargoQuantity;
            $data['rateId'] = $rateId;
            $data['GEOPROVINCE'] = $geoTierPairs['PROVINCE'];
            $data['GEOPOSTAL CODE'] = $geoTierPairs['POSTAL CODE'];
            $data['GEOCITY'] = $geoTierPairs['CITY'];
            $data['GEOCOUNTRY'] = $geoTierPairs['COUNTRY'];
            $getFinalPrice = $this->getRatePriceByConversionFactor($data);
        }
        return $getFinalPrice['total_price'] ?? $price;
    }

    private function getRatePriceByConversionFactor(array $data): array
    {
        $currentDate = date('Y-m-d');
        $sql = 'SELECT source,destination,rate_id,transit_time, min_price, Sum(price) AS price,
       SUM(total_services_price) AS total_services_price, SUM(total_price) as total_price, currency, uom_conversion_id,rr_charge_type,geotier_id from
       (SELECT source, destination, rate_id,
        transit_time,  min_price,  SUM(price) as price, total_services_price, fuel_surcharge_id, amount, percentage,
        CASE
                        WHEN rr_charge_id = 39 THEN
                            CASE
                              WHEN COALESCE(CONVERT(amount, DECIMAL(10, 2)), 0) <> 0 THEN ROUND(SUM(price)+amount, 2)
                              WHEN COALESCE(CONVERT(amount, DECIMAL(10, 2)), 0) = 0 AND COALESCE(CONVERT(percentage, DECIMAL(10, 2)), 0) <> 0 THEN
                                ROUND(SUM(total_price) + SUM(total_price) * percentage / 100, 2)
                              WHEN amount IS NULL AND percentage IS NULL THEN
                                ROUND(SUM(total_price), 0)
                            END
                        ELSE ROUND(SUM(total_price), 0)
        END AS total_price,
            uom_conversion_id,rr_charge_type,geotier_id, currency
        FROM ( SELECT  DISTINCT rr_charge_id,table1.source,table1.destination,table1.rate_id,
             transit_time, min_price, Price, total_services_price, table2.fuel_surcharge_id,
            table2.amount, table2.percentage, total_price, uom_conversion_id,rr_charge_type,geotier_id,
            table1.currency FROM (SELECT source,destination,rate_id,rr_charge_type,rr_charge_id, fuel_surcharge_id,
            transit_time, min_price, SUM(Price) AS Price,
            SUM(total_services_price) AS total_services_price, SUM(total_price) AS total_price,currency,uom_conversion_id, geotier_id
                  FROM
                     (
                       SELECT source, destination, rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id,
                          transit_time, min_price, Price,
                          SUM(IFNULL(Serviceprice, 0)) AS `total_services_price`,
                          Price + SUM(IFNULL(Serviceprice, 0)) AS `total_price`, currency, uom_conversion_id, geotier_id
                     FROM
                        (
                           SELECT lm.id, source, destination, rr.rate_id,  rc.rr_charge_type, rc.rr_charge_id, rc.fuel_surcharge_id,
                           rc.rr_tier_id, rc.geo_tier_id, ros.rateoffering_id,
                           ROUND(rs_lane_days + rs_lane_hours / 24 + rs_lane_mins / 1440) AS transit_time,
                              (
                  CASE WHEN rr_charge_type = "Fixed" and uom_conversion_id <> 0  THEN
                      rc.min_amount
                END
                ) as min_price,
                              (
                                 CASE
                                    WHEN rr_charge_type = "Fixed" THEN
                                          CASE
                                WHEN rc.charge_basis = "' . $data['conversionBaseUom'] . '" OR rc.charge_basis = "PER ' . $data['conversionBaseUom'] . '" THEN
                                       CASE
                                                WHEN ' . $data['unitToBeConsidered'] . ' * rc.amount < rc.min_amount THEN rc.min_amount
                                                ELSE ' . $data['unitToBeConsidered'] . ' * rc.amount
                                       END
                                             WHEN rc.charge_basis = "KG" OR rc.charge_basis = "PER KG" THEN
                                                CASE
                                                         WHEN ' . $data['cargoWeight'] . ' * rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE ' . $data['cargoWeight'] . ' * rc.amount
                                                END
                                             WHEN rc.charge_basis = "CBM" OR rc.charge_basis = "PER CBM" THEN
                                                CASE
                                                         WHEN ' . $data['cargoVolume'] . ' * rc.amount < rc.min_amount THEN  rc.min_amount
                                                         ELSE ' . $data['cargoVolume'] . ' * rc.amount
                                                END
                                             WHEN rc.charge_basis = "PER PIECE" THEN
                                                CASE
                                                         WHEN ' . $data['cargoQuantity'] . ' * rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE ' . $data['cargoQuantity'] . ' * rc.amount
                                                END
                                            WHEN rc.charge_basis = "PER TRIP"  OR rc.charge_basis = "TRIP" THEN
                                                CASE
                                                         WHEN  rc.amount < rc.min_amount THEN rc.min_amount
                                                         ELSE  rc.amount
                                                END
                                          END
                                    WHEN rr_charge_type = "Tier" THEN
                                          CASE
                                             WHEN tier.billing_uom = "WEIGHT"  OR tier.billing_uom = "ACTUAL WEIGHT" THEN
                                                   CASE
                                                      WHEN ' . $data['cargoWeight'] . ' BETWEEN COALESCE( CONVERT(tier.uom1_min, DECIMAL(10, 2)), ' . $data['cargoWeight'] . ' )
                                                         AND COALESCE( CONVERT(tier.uom1_max, DECIMAL(10, 2)), ' . $data['cargoWeight'] . ' )
                                                         AND ' . $data['cargoVolume'] . ' BETWEEN COALESCE( CONVERT(tier.uom2_min, DECIMAL(10, 2)), ' . $data['cargoVolume'] . ')
                                                         AND COALESCE( CONVERT(tier.uom2_max, DECIMAL(10, 2)), ' . $data['cargoVolume'] . ' ) THEN ' . $data['cargoVolume'] . ' * tier.cost
                                                   END
                                             WHEN  tier.billing_uom = "VOLUME" OR tier.billing_uom = "ACTUAL VOLUME" THEN
                                                   CASE
                                                      WHEN ' . $data['cargoWeight'] . ' BETWEEN COALESCE( CONVERT(tier.uom1_min, DECIMAL(10, 2)), ' . $data['cargoWeight'] . ' )
                                                         AND COALESCE( CONVERT(tier.uom1_max, DECIMAL(10, 2)), ' . $data['cargoWeight'] . ' )
                                                         AND ' . $data['cargoVolume'] . ' BETWEEN COALESCE( CONVERT(tier.uom2_min, DECIMAL(10, 2)), 1 )
                                                         AND COALESCE( CONVERT(tier.uom2_max, DECIMAL(10, 2)), ' . $data['cargoVolume'] . ' ) THEN ' . $data['cargoVolume'] . ' * tier.cost
                                                   END
                                          END
                                    WHEN  rr_charge_type = "Geo Tier"  THEN
                                    CASE
                                             WHEN geotier.unit_measure1 = "' . $data['conversionBaseUom'] . '" OR geotier.unit_measure1 = "PER ' . $data['conversionBaseUom'] . '" THEN
                                                    CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN  ' . $data['unitToBeConsidered'] . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['unitToBeConsidered'] . ' )
                                    AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['unitToBeConsidered'] . ' ) THEN
                                    geotier.cost
                                    END
                            ELSE
                                                      CASE
                                                       WHEN  ' . $data['unitToBeConsidered'] . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['unitToBeConsidered'] . ' )
                                                         AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['unitToBeConsidered'] . ' ) THEN
                                                         CASE
                                                           WHEN  ' . $data['unitToBeConsidered'] . ' * geotier.cost < geotiermaxvalue.uom1_minimum  THEN geotiermaxvalue.uom1_minimum
                                                           ELSE ' . $data['unitToBeConsidered'] . ' * geotier.cost
                                                         END
                                                      END
                                                  END
                                             WHEN geotier.unit_measure1 = "KG" OR geotier.unit_measure1 = "PER KG" THEN
                                                    CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN  ' . $data['cargoWeight'] . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoWeight'] . ' )
                                    AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoWeight'] . ' ) THEN
                                    geotier.cost
                                    END
                            ELSE
                                                      CASE
                                                       WHEN  ' . $data['cargoWeight'] . ' BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoWeight'] . ' )
                                                         AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoWeight'] . ' ) THEN
                                                         CASE
                                                           WHEN  ' . $data['cargoWeight'] . ' * geotier.cost < geotiermaxvalue.uom1_minimum  THEN geotiermaxvalue.uom1_minimum
                                                           ELSE ' . $data['cargoWeight'] . ' * geotier.cost
                                                         END
                                                      END
                                                  END

                                             WHEN geotier.unit_measure1 = "CBM" OR geotier.unit_measure1 = "PER CBM" THEN
             CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN ' . $data['cargoVolume'] . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoVolume'] . '  )
                                          AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoVolume'] . '  )  THEN
                                          geotier.cost
                                 END
                            ELSE
                                                   CASE
                                                      WHEN ' . $data['cargoVolume'] . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoVolume'] . '  )
                                                            AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoVolume'] . '  )  THEN
                                                         CASE
                                                            WHEN ' . $data['cargoVolume'] . ' * geotier.cost < geotiermaxvalue.uom1_minimum THEN  geotiermaxvalue.uom1_minimum
                                                              ELSE ' . $data['cargoVolume'] . '  * geotier.cost
                                                         END
                                                   END
            END
                                             WHEN geotier.unit_measure1 = "PIECE COUNT" THEN
            CASE
                            WHEN geotier.flat=1 THEN
                                    CASE
                                    WHEN ' . $data['cargoQuantity'] . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoQuantity'] . '  )
                                          AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoQuantity'] . '  )  THEN
                                          geotier.cost
                                 END
                            ELSE
                                                   CASE
                                                      WHEN ' . $data['cargoQuantity'] . '  BETWEEN COALESCE( CONVERT( geotier.uom1_min, DECIMAL(10, 2) ), ' . $data['cargoQuantity'] . '  )
                                                            AND COALESCE( CONVERT( geotier.uom1_max, DECIMAL(10, 2) ), ' . $data['cargoQuantity'] . '  )  THEN
                                                         CASE
                                                            WHEN ' . $data['cargoQuantity'] . ' * geotier.cost < geotiermaxvalue.uom1_minimum THEN  geotiermaxvalue.uom1_minimum
                                                              ELSE ' . $data['cargoQuantity'] . '  * geotier.cost
                                                         END
                                                   END
            END
                                          END
                                 END
                              ) AS price,

                                 CASE WHEN ros.min_amount > ros.amount THEN ros.min_amount ELSE ros.amount
                                 END
                                    AS Serviceprice,
                                 CASE
                                   WHEN rr_charge_type = "Fixed" THEN rc.currency
                                   WHEN  rr_charge_type = "Tier" THEN  tier.currency
                                   WHEN  rr_charge_type = "Geo Tier" THEN  geotier.currency
                                END
                                AS currency, uom_conversion_id,geotier.id as geotier_id
                                 FROM
                                 tb_lanes_master lm
                                 INNER JOIN  tb_rateservice_lanes rsl  ON lm.id = rsl.lane_id
                                 INNER JOIN  tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id
                                 LEFT JOIN  tb_rateoffering_services ros ON ro.id = ros.rateoffering_id
                                 INNER JOIN  tb_rate_records rr ON rr.offering_id = ro.id  AND rr.rate_id ="' . $data['rateId'] . '"
                                 INNER JOIN tb_raterecord_charges rc  ON rc.raterecord_id = rr.id
                                 LEFT JOIN tb_raterecord_services rrs  ON rrs.raterecord_id = rr.id
                                 LEFT JOIN
                                    (
                                       SELECT tm.id, tm.billing_uom, tsheet.uom1_min, uom1_max, uom2_min, uom2_max,
                                       cost, tsheet.status, tm.currency, tm.company_code  FROM tb_tier_master tm
                                       INNER JOIN  tb_tier_rate_sheet tsheet  ON tm.id = tsheet.tier_master_id
                                       WHERE tsheet.status = 1 AND tm.status = 1 ORDER BY  tsheet.updatedon DESC
                                    ) tier ON tier.id = rc.rr_tier_id  OR rc.rr_charge_type = "Fixed"
                                 LEFT JOIN
                                    (
                                       SELECT  gt.id, gt.flat, unit_measure1, uom1_min, uom1_max, uom1_minimum, cost,
                                       gt.currency, gt.company_code  FROM tb_geo_tier gt
                                       INNER JOIN tb_geo_tier_sheet gsheet ON gt.id = gsheet.geo_tier_id
                                       WHERE  gsheet.status = 1 AND gt.status = 1
                                       AND
                                        CASE
                                        WHEN gt.geo_hierarchy ="PROVINCE" THEN ' . $data["GEOPROVINCE"] . '
                                        WHEN gt.geo_hierarchy ="POSTAL CODE" THEN ' . $data["GEOPOSTAL CODE"] . '
                                        WHEN gt.geo_hierarchy ="CITY" THEN ' . $data["GEOCITY"] . '
                                        WHEN gt.geo_hierarchy ="COUNTRY" THEN ' . $data["GEOCOUNTRY"] . '
                                         END ORDER BY gsheet.updatedon DESC
                                    ) geotier  ON geotier.id = rc.geo_tier_id OR rc.rr_charge_type = "Fixed"
                                 LEFT JOIN
                                    (
                                       SELECT  gt.id, cost AS uom1_minimum
                                       FROM tb_geo_tier gt
                                       INNER JOIN tb_geo_tier_sheet gsheet ON gt.id = gsheet.geo_tier_id
                                       WHERE gsheet.status = 1 AND gt.status = 1 AND
                                        CASE
                                        WHEN gt.geo_hierarchy ="PROVINCE" THEN ' . $data["GEOPROVINCE"] . '
                                        WHEN gt.geo_hierarchy ="POSTAL CODE" THEN ' . $data["GEOPOSTAL CODE"] . '
                                        WHEN gt.geo_hierarchy ="CITY" THEN ' . $data["GEOCITY"] . '
                                        WHEN gt.geo_hierarchy ="COUNTRY" THEN ' . $data["GEOCOUNTRY"] . '
                                         END AND uom1_minimum <> "0"
                                       GROUP BY gt.id ORDER BY gsheet.updatedon DESC
                                    ) geotiermaxvalue  ON geotier.id = geotiermaxvalue.id OR rc.rr_charge_type = "Fixed"
                                 WHERE
                                    rr.rate_id ="' . $data['rateId'] . '" AND rc.status=1 AND rr.status=1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1

                        ) AS RATES
                        WHERE rr_charge_id<>38
                        GROUP BY source, destination, rate_id, rr_charge_type, rr_charge_id,fuel_surcharge_id,
                        transit_time, Price, currency ) t1
                        GROUP BY source, destination, rate_id, rr_charge_type, rr_charge_id,fuel_surcharge_id,
                        transit_time, currency) AS table1
                        LEFT JOIN (
                           SELECT rate_id, fscharges.id AS fuel_surcharge_id,fscharges.amount,fscharges.percentage FROM
                              (SELECT rate_id,rr_charge_type,rr_charge_id,fuel_surcharge_id FROM
                                 (SELECT  rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id FROM
                                    (
                                       SELECT lm.id, source, destination, rr.rate_id, rc.rr_charge_type, rc.rr_charge_id,
                                       rc.fuel_surcharge_id, rc.rr_tier_id, rc.geo_tier_id,ros.rateoffering_id
                                       FROM tb_lanes_master lm
                                       INNER JOIN tb_rateservice_lanes rsl ON lm.id = rsl.lane_id
                                       INNER JOIN tb_rate_offerings ro ON rsl.rate_id = ro.rate_service_id
                                       LEFT JOIN  tb_rateoffering_services ros ON ro.id = ros.rateoffering_id
                                       INNER JOIN tb_rate_records rr ON rr.offering_id = ro.id
                                       INNER JOIN tb_raterecord_charges rc ON rc.raterecord_id = rr.id
                                       LEFT JOIN tb_raterecord_services rrs ON rrs.raterecord_id = rr.id
                                       WHERE  rr.rate_id ="' . $data['rateId'] . '"
                                       AND  rc.status=1 AND rr.status=1 AND rsl.status = 1 AND lm.status = 1 AND ro.status = 1) AS RATES

                                 ) t1  WHERE rr_charge_id=38
                                 GROUP BY rate_id, rr_charge_type, rr_charge_id, fuel_surcharge_id
                              ) tblfrt
                              INNER JOIN (
                                 SELECT f.id,fs.amount,fs.percentage FROM tb_fuel_surcharge f
                                 INNER JOIN tb_fuel_surcharge_sheet fs ON f.id = fs.fuel_surcharge_id
                                 WHERE fs.Status=1 and f.status=1 and from_date <= "' . $currentDate . '" and to_date >= "' . $currentDate . '"
                              ) AS fscharges ON fscharges.id=tblfrt.fuel_surcharge_id
                     ) AS table2
                     ON table1.rate_id = table2.rate_id ) AS finalResult
                     WHERE total_price IS NOT NULL
                     GROUP  BY
                     rate_id,rr_charge_id
                     ORDER BY total_price desc )tab1 group BY source,
               destination,
               rate_id,
               transit_time';
        $query = $this->db->query($sql);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getConversionFactorWeight(array $data): string
    {
        if (in_array($data['uom_type1'], self::WEIGHT_TYPES, true)) {
            $data['conversion_factor_weight'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], self::WEIGHT_TYPES, true)) {
            $data['conversion_factor_weight'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], self::WEIGHT_TYPES, true)) {
            $data['conversion_factor_weight'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], self::WEIGHT_TYPES, true)) {
            $data['conversion_factor_weight'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_weight'] ?? 0;
    }

    public function getConversionFactorVolume(array $data): string
    {
        if (in_array($data['uom_type1'], self::VOLUME_TYPES, true)) {
            $data['conversion_factor_volume'] = $data['uom1_conversion'];
        } elseif (in_array($data['uom_type2'], self::VOLUME_TYPES, true)) {
            $data['conversion_factor_volume'] = $data['uom2_conversion'];
        } elseif (in_array($data['uom_type3'], self::VOLUME_TYPES, true)) {
            $data['conversion_factor_volume'] = $data['uom3_conversion'];
        } elseif (in_array($data['uom_type4'], self::VOLUME_TYPES, true)) {
            $data['conversion_factor_volume'] = $data['uom4_conversion'];
        }
        return $data['conversion_factor_volume'] ?? 0;
    }


    public function getOrderTypes(){
        $orderTypes = [];
        $custId = $this->session->userdata('cust_id');
        $companyCode = $this->session->userdata('company_code');
        if ($custId != ''){
            $getOrderTypes = $this->db->select('id,type_name')->group_by('type_name')->get_where('tb_order_types', array('customer_id' => $custId));
            if ($getOrderTypes->num_rows() > 0) {
                foreach ($getOrderTypes->result() as $res) {
                    $orderTypes[] = ['type_id' => $res->id, 'type_name' => $res->type_name];
                }
            }
        }
        if(empty($orderTypes)){
            $getOrderTypes = $this->db->select('id,type_name')
                ->group_by('type_name')
                ->get_where('tb_order_types',array('company_code'=>$companyCode,'status'=>1));
            if($getOrderTypes->num_rows() >0){
                foreach($getOrderTypes->result() as $res){
                    $orderTypes[] = ['type_id'=>$res->id,'type_name'=>$res->type_name];
                }
            }
        }
        return $orderTypes;
    }

    public function getCostCenter(){
        $costCenters = [];
        $custId = $this->session->userdata('cust_id');
        $companyCode = $this->session->userdata('company_code');
        if ($custId != ''){
            $getCostCenters = $this->db->select('id,type_name,department_code')
                ->group_by('type_name')
                ->get_where('tb_cost_center', ['customer_id' => $custId]);
            if ($getCostCenters->num_rows() > 0) {
                foreach ($getCostCenters->result() as $res) {
                    $costCenters[] = ['type_id' => $res->id, 'type_name' => $res->type_name,'department_code'=>$res->department_code];
                }
            }
        }
        if(empty($costCenters)){
            $getCostCenters = $this->db->select('id,type_name,department_code')
                ->group_by('type_name')
                ->get_where('tb_cost_center',['company_code'=>$companyCode,'status'=>1]);
            if($getCostCenters->num_rows() >0){
                foreach($getCostCenters->result() as $res){
                    $costCenters[] = ['type_id'=>$res->id,'type_name'=>$res->type_name,'department_code'=>$res->department_code];
                }
            }
        }
        return $costCenters;
    }

    public function getVendorIdFromRateEngline($refId){
        $vendorId = '';
        if($refId!=''){
            $this->db->select('v.id');
            $this->db->from( 'tb_vendors v' );
            $this->db->join( 'tb_vendor_profile_list vpl', 'vpl.profile_id = v.code', 'inner' );
            $this->db->where( 'vpl.vp_id', $refId );
            $this->db->where("vpl.status ='1'");
            $getresult = $this->db->get();
            if ($getresult->num_rows() > 0) {
                $data = $getresult->result_array();
                if(!empty($data) && isset($data[0])){
                    if(isset($data[0]['id']) && $data[0]['id']!=''){
                        $vendorId = $data[0]['id'];
                    }
                }
            }
        }
        return $vendorId;

    }

    public function getVehicleIdFromRateEngline($refId){
        $vehicleId = '';
        if($refId!=''){
            $this->db->select('tt.id');
            $this->db->from( 'tb_trucktypes tt' );
            $this->db->join( 'tb_vehicle_profile_list vpl', 'vpl.profile_id=tt.id', 'inner' );
            $this->db->where( 'vpl.veh_p_id', $refId );
            $getresult = $this->db->get();
            if ($getresult->num_rows() > 0) {
                $data = $getresult->result_array();
                if(!empty($data) && isset($data[0])){
                    if(isset($data[0]['id']) && $data[0]['id']!=''){
                        $vehicleId = $data[0]['id'];
                    }
                }
            }
        }
        return $vehicleId;
    }

    public function getRatePreferencesInQuickBook(array $info): array
    {
        $checkAddressReference = $this->db->query(
            "SELECT ref_value FROM orders_filelineidentifier WHERE source_city = ? AND source_suburb = ? AND source_country = ? AND destination_city = ? AND destination_suburb = ? AND destination_country = ? AND company_code = ? AND branch_code = ? AND status = ?",
            [$info['sourceCity'], $info['sourceProvince'], $info['sourceCountry'], $info['destinationCity'], $info['destinationProvince'], $info['destinationCountry'], $info['companyCode'], $info['branchCode'], '1']
        );
        $fileLineReference = $checkAddressReference->num_rows() > 0 ? $checkAddressReference->row()->ref_value : "";
        $getPreferences = $this->getRatePreferencesData($info);
        if (empty($getPreferences)) {
            return ['recordsToGet' => [], 'recordsNotToGet' => []];
        }
        foreach ($getPreferences as $eachLine) {
            $preferences[] = $eachLine['id'];
            $preferencesWithRate[$eachLine['id']] = $eachLine['rate_record_id'];
        }
        $getFileLineID = $this->db->query("SELECT id FROM tb_reference_master where name = ? ", ['FI']);
        $fileLineId = $getFileLineID->num_rows() > 0 ? $getFileLineID->row()->id : 0;
        $checkReference = $this->db->query("SELECT rate_prefer_id,ref_value FROM tb_rateprefer_ref_types WHERE rate_prefer_id IN ? AND ref_id = ? AND status = ? GROUP BY rate_prefer_id", [$preferences, $fileLineId, 1]);
        $references = $checkReference->num_rows() > 0 ? $checkReference->result_array() : [];
        if (empty($references)) {
            return ['recordsToGet' => $preferencesWithRate ?? [], 'recordsNotToGet' => []];
        }
        $lineReferenceIds = $noLineReferenceIds = [];
        foreach ($references as $eachLine) {
            if (($eachLine['ref_value'] == $fileLineReference) && ($fileLineReference != "")) {
                $lineReferenceIds[] = $eachLine['rate_prefer_id'];
            } else {
                $noLineReferenceIds[] = $eachLine['rate_prefer_id'];
            }
        }
        if (empty($noLineReferenceIds)) {
            foreach ($preferences as $eachLine) {
                if (!in_array($eachLine, $lineReferenceIds)) {
                    $lineReferenceIds[] = $eachLine;
                }
            }
        }
        if (!empty($noLineReferenceIds)) {
            foreach ($preferences as $eachLine) {
                if (!in_array($eachLine, $noLineReferenceIds) && !in_array($eachLine, $lineReferenceIds)) {
                    $lineReferenceIds[] = $eachLine;
                }
            }
        }
        foreach ($lineReferenceIds as $eachLine) {
            $rateRecordId = $preferencesWithRate[$eachLine] ?? 0;
            if ($rateRecordId > 0) {
                $recordsToGet[] = $rateRecordId;
            }
        }
        foreach ($noLineReferenceIds as $eachLine) {
            $rateRecordId = $preferencesWithRate[$eachLine] ?? 0;
            if ($rateRecordId > 0) {
                $recordsNotToGet[] = $rateRecordId;
            }
        }
        return ['recordsToGet' => $recordsToGet ?? [], 'recordsNotToGet' => $recordsNotToGet ?? []];
    }

    private function getRatePreferencesData(array $info): array
    {
        $whereCondition = " rp.vend_profile_id > 0 AND rp.tariff_type = '1' AND rp.company_code ='" . $info['companyCode'] . "' AND rp.branch_code ='" . $info['branchCode'] . "' AND rp.status='1' AND (rps.country LIKE '" . $info['sourceCountry'] . "' OR rps.state LIKE '" . $info['sourceProvince'] . "' OR rps.city LIKE '" . $info['sourceCity'] . "' OR rps.pincode LIKE '" . $info['sourcePin'] . "') AND rps.status ='1' AND (rds.country LIKE '" . $info['destinationCountry'] . "' OR rds.state LIKE '" . $info['destinationProvince'] . "' OR rds.city LIKE '" . $info['destinationCity'] . "' OR rds.pincode LIKE '" . $info['destinationPin'] . "' ) AND rds.status ='1'";
        $this->db->select('rp.id,rp.rate_record_id');
        $this->db->from("tb_rate_preferences rp");
        $this->db->join("tb_rateprefer_source rps", "rps.rate_prefer_id=rp.id", "LEFT");
        $this->db->join("tb_rateprefer_destination rds", "rds.rate_prefer_id=rp.id", "LEFT");
        $this->db->group_by("rp.id");
        $this->db->where($whereCondition);
        $preferenceQuery = $this->db->get();
        return $preferenceQuery->num_rows() > 0 ? $preferenceQuery->result_array() : [];
    }
}
