<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Quickratesmodel extends CI_Model
{
    public function getChargeCodes()
    {
        $this->db->select('id, charge_code, name');
        $this->db->from('tb_charge_codes');
        $this->db->where('status', '1');
        $this->db->order_by('charge_code', 'ASC');
        $chargeCodes = $this->db->get();
        return $chargeCodes->num_rows() > 0 ? $chargeCodes->result_array() : [];
    }

    function getChargeIds($chargeIds)
    {
        $this->db->select('*');
        $this->db->from('tb_raterecord_charges');
        $this->db->where('status', '1');
        $this->db->where_in('id', $chargeIds);
        $this->db->group_by('id');
        $this->db->order_by('id', 'DESC');
        $chargeIds = $this->db->get();
        return $chargeIds->num_rows() > 0 ? $chargeIds->result_array() : [];
    }



    public function getGeneratingIds($select, $table)
    {
        $result = [];
        $this->db->select($select);
        $this->db->from($table);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $res = $this->db->get();
        $result = $res->row();
        return $result;
    }

}


