<?php
class Rateofferingmodel extends CI_Model {

   function getrateofferings($where){
        $result = array();
        $this->db->select('ro.*,rs.service_id rateservice,lm.lane_id laneid,tm.name as offering_type')->from('tb_rate_offerings ro');
        $this->db->join('tb_rate_services rs','rs.id = ro.rate_service_id','LEFT');
        $this->db->join('tb_transportmode tm','tm.code=ro.offering_type','LEFT');
        $this->db->join('tb_lanes_master lm','lm.id = ro.lane_id','LEFT');
        $this->db->where($where);
        $this->db->group_by('ro.id');
        $this->db->order_by('ro.id','DESC');
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }
    function getrateofr($id){
        $result = array();
        $this->db->select('ro.*,ro.id rofrid,crp.cargo_profile_id cargopfid,rc.*,rs.service_id rateservice,lm.lane_id laneid,vp.vend_profile_id vendpfid,cp.cust_profile_id custpfid,vhp.veh_profile_id vehpfid,uc.conversion_id')->from('tb_rate_offerings ro');
        $this->db->join('tb_rate_services rs','rs.id = ro.rate_service_id','LEFT');
        $this->db->join('tb_rateoffering_constraints rc','rc.rateoffering_id = ro.id','LEFT');
        $this->db->join('tb_lanes_master lm','lm.id = ro.lane_id','LEFT');
        $this->db->join('tb_vendor_profile vp','vp.id = ro.vendor_profile_id','LEFT');
        $this->db->join('tb_customer_profile cp','cp.id = ro.cust_profile_id','LEFT');
        $this->db->join('tb_vehicle_profile vhp','vhp.id = ro.veh_profile_id','LEFT');
        $this->db->join('tb_cargo_profile crp','crp.id = rc.cargo_profile_id','LEFT');
        $this->db->join('tb_knuom_conversion uc','uc.id = ro.uom_conversion_id','LEFT');
        $this->db->where('ro.id',$id);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->row_array();
        }
        return $result;
    }

    function getchargeidlist($where){
        $result = array();
        $this->db->select('id,charge_code,name')->from('tb_charge_codes');
        $this->db->where($where);
        $this->db->order_by('charge_code','ASC');
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }
    function getlanesbyratesrv($service_id){
        $result = array();
        $this->db->select('lm.id,lm.lane_id')->from('tb_rateservice_lanes rsl');
        $this->db->join('tb_lanes_master lm','rsl.lane_id = lm.id','LEFT');
        $this->db->join('tb_rate_services rs','rs.id = rsl.rate_id','LEFT');
        $this->db->where('rsl.rate_id',$service_id);
        $this->db->where('rsl.status',1);
        $this->db->group_by('rsl.lane_id');
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function remarktypes($wherein){
        $result = array();
        $this->db->select('id,name,description')->from('tbl_remark_types');
        $this->db->where_in('id',$wherein);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function remarktypesbyid($rofrid){
        $result = array();
        $this->db->select('rr.*,rt.name,rt.description')->from('tb_rateoffering_remarks rr');
        $this->db->join('tbl_remark_types rt','rt.id = remark_type','LEFT');
        $this->db->where('rr.rateoffering_id',$rofrid);
        $this->db->where('rr.status',1);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function documentlist($wherein){
        $result = array();
        $this->db->select('rd.*,dt.type_name as document_name,dt.document_id documentid')->from('tb_rateoffering_docs rd');
        $this->db->join('tb_document_types dt','dt.id = rd.document_id','LEFT');
        $this->db->where_in('rd.id',$wherein);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function documentlistbyid($rofrid){
        $result = array();
        $this->db->select('rd.*,dt.type_name as document_name,dt.document_id documentid')->from('tb_rateoffering_docs rd');
        $this->db->join('tb_document_types dt','dt.id = rd.document_id','LEFT');
        $this->db->where('rd.rateoffering_id',$rofrid);
        $this->db->where('rd.status',1);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function vaslist($wherein){
        $result = array();
        $this->db->select('rs.*,vas.vas_id vasid,vas.vas_name,cc.charge_code')->from('tb_rateoffering_services rs');
        $this->db->join('tb_vas_master vas','vas.id = rs.ro_vas_id','LEFT');
        $this->db->join('tb_charge_codes cc','cc.id = rs.ro_charge_id','LEFT');
        $this->db->where_in('rs.id',$wherein);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function vaslistbyid($rofrid){
        $result = array();
        $this->db->select('rs.*,vas.vas_id vasid,vas.vas_name,cc.charge_code')->from('tb_rateoffering_services rs');
        $this->db->join('tb_vas_master vas','vas.id = rs.ro_vas_id','LEFT');
        $this->db->join('tb_charge_codes cc','cc.id = rs.ro_charge_id','LEFT');
        $this->db->where('rs.rateoffering_id',$rofrid);
        $this->db->where('rs.status',1);
        $query = $this->db->get();
        if($query->num_rows() >0){
            $result = $query->result_array();
        }
        return $result;
    }

    function updaterofrmodule($tbl,$data,$wherein){
        $this->db->where_in('id',$wherein);
        $this->db->update($tbl,$data);
        return true;
    }

    public function getVehicleProfilesListById(int $profileRowId): array
    {
        $query = $this->db->query("SELECT t.trucktype,t.description,t.iconimg FROM tb_trucktypes t INNER JOIN tb_vehicle_profile_list l on l.profile_id=t.id WHERE l.veh_p_id = ? AND l.status =? AND t.status = ?", [$profileRowId, 1, 'Active']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getVendorProfilesListById(int $profileRowId): array
    {
        $query = $this->db->query("SELECT v.name,v.mobile,v.location,v.pincode,v.country,v.code,v.company_code,v.branch_code FROM tb_vendors v INNER JOIN tb_vendor_profile_list l on l.party_id=v.id WHERE l.vp_id = ? AND l.status =? AND v.status = ?", [$profileRowId, 1, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
    public function getCustomerProfilesListById(int $profileRowId): array
    {
        $query = $this->db->query("SELECT c.name,c.phone,c.location,c.pincode,c.code,c.country,c.company_code,c.branch_code FROM tb_customers c INNER JOIN tb_customer_profile_list l on l.party_id=c.id WHERE l.cp_id = ? AND l.status =? AND c.status = ?", [$profileRowId, 1, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

}
