<?php

/**
 * Class Rateprefermodel
 *
 * @property CI_DB_mysqli_driver $db
 */
class Rateprefermodel extends CI_Model {

    function ratepreferlist(array $where, array $tableWhere = [], string $fromDate = null, string $toDate = null): array
    {
        $this->db->select(
            'rp.*,rs.service_id,rs.service_name,rf.offering_id,rf.offering_name,rr.rate_id,rr.record_name,cp.cust_profile_id custpfid,vp.vend_profile_id vendpfid'
        );
        $this->db->from("tb_rate_preferences rp");
        $this->db->join('tb_rate_services rs', 'rs.id=rp.rate_service_id', 'LEFT');
        $this->db->join('tb_rate_offerings rf', 'rf.id=rp.rate_offering_id', 'LEFT');
        $this->db->join('tb_rate_records rr', 'rr.id=rp.rate_record_id', 'LEFT');
        $this->db->join('tb_customer_profile cp', 'cp.id=rp.cust_profile_id', 'LEFT');
        $this->db->join('tb_vendor_profile vp', 'vp.id=rp.vend_profile_id', 'LEFT');
        if (!empty($tableWhere['ref_type']) || !empty($tableWhere['ref_value'])) {
            $findSet = '';
            if (!empty($tableWhere['ref_type'])) {
                $findSet .= 'AND find_in_set(' . $tableWhere['ref_type'] . ',rt.ref_id)';
            }
            if (!empty($tableWhere['ref_value'])) {
                $findSet .= 'AND find_in_set("' . $tableWhere['ref_value'] . '",rt.ref_value)';
            }
            $this->db->join('tb_rateprefer_ref_types rt', 'rt.rate_prefer_id=rp.id ' . $findSet, 'INNER');
        }
        if (!empty($tableWhere['order_type'])) {
            $this->db->join(
                'tb_rateprefer_ordertypes ot',
                'ot.rate_prefer_id=rp.id AND find_in_set(' . $tableWhere['order_type'] . ',ot.order_type_id)',
                'INNER'
            );
        }
        if (!empty($tableWhere['service'])) {
            $this->db->join(
                'tb_rateprefer_service rps',
                'rps.rate_prefer_id=rp.id AND find_in_set(' . $tableWhere['service'] . ',rps.service_id)',
                'INNER'
            );
        }
        if (!empty($tableWhere['product'])) {
            $this->db->join(
                'tb_rateprefer_product rpp',
                'rpp.rate_prefer_id=rp.id AND find_in_set(' . $tableWhere['product'] . ',rpp.product_id)',
                'INNER'
            );
        }
        $this->db->where($where);
        if ($fromDate && $toDate) {
            $this->db->where("rp.createdon BETWEEN '" . $fromDate . "' AND '" . $toDate . "'", null, false);
        }
        $this->db->group_by('rp.id');
        $this->db->order_by('rp.id', 'DESC');
        $query = $this->db->get();
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    function ratepreference($id){
        $this->db->select('rp.*,cp.cust_profile_id custpfid,vp.vend_profile_id vendpfid')->from('tb_rate_preferences rp');
        $this->db->join('tb_customer_profile cp','cp.id=rp.cust_profile_id','LEFT');
        $this->db->join('tb_vendor_profile vp','vp.id=rp.vend_profile_id','LEFT');
        $this->db->where('rp.id',$id);
        $query = $this->db->get();
        return $query->row_array();
    }

    function sourcelist($wherein){
        $this->db->select('src.*,m.code as partyid')->from('tb_rateprefer_source src');
        $this->db->join('tbl_party_master m','m.id = src.party_id','LEFT');
        $this->db->where_in('src.id',$wherein);
        $this->db->order_by('src.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function sourcelistbyid($id){
        $this->db->select('src.*,m.code as partyid')->from('tb_rateprefer_source src');
        $this->db->join('tbl_party_master m','m.id = src.party_id','LEFT');
        $this->db->where('src.rate_prefer_id',$id);
        $this->db->order_by('src.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function destlist($wherein){
        $this->db->select('dt.*,m.code as partyid')->from('tb_rateprefer_destination dt');
        $this->db->join('tbl_party_master m','m.id = dt.party_id','LEFT');
        $this->db->where_in('dt.id',$wherein);
        $this->db->order_by('dt.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function destlistbyid($id){
        $this->db->select('dt.*,m.code as partyid')->from('tb_rateprefer_destination dt');
        $this->db->join('tbl_party_master m','m.id = dt.party_id','LEFT');
        $this->db->where('dt.rate_prefer_id',$id);
        $this->db->order_by('dt.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function reftypelist($wherein){
        $this->db->select('rt.*,m.name as reftypeid,m.description as refname')->from('tb_rateprefer_ref_types rt');
        $this->db->join('tb_reference_master m','m.id = rt.ref_id','LEFT');
        $this->db->where_in('rt.id',$wherein);
        $this->db->order_by('rt.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function reftypelistbyid($id){
        $this->db->select('rt.*,m.name as reftypeid,m.description as refname')->from('tb_rateprefer_ref_types rt');
        $this->db->join('tb_reference_master m','m.id = rt.ref_id','LEFT');
        $this->db->where('rt.rate_prefer_id',$id);
        $this->db->order_by('rt.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function ordtypelist($wherein){
        $this->db->select('ot.*,o.type_name')->from('tb_rateprefer_ordertypes ot');
        $this->db->join('tb_order_types o','o.id = ot.order_type_id','LEFT');
        $this->db->where_in('ot.id',$wherein);
        $this->db->order_by('ot.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function ordtypelistbyid($id){
        $this->db->select('ot.*,o.type_name')->from('tb_rateprefer_ordertypes ot');
        $this->db->join('tb_order_types o','o.id = ot.order_type_id','LEFT');
        $this->db->where('ot.rate_prefer_id',$id);
        $this->db->order_by('ot.rate_prefer_id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function servicelist($wherein){
        $this->db->select('s.*,sm.service_id as serviceid,sm.name')->from('tb_rateprefer_service s');
        $this->db->join('tb_service_master sm','sm.id = s.service_id','LEFT');
        $this->db->where_in('s.id',$wherein);
        $this->db->order_by('s.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function servicelistbyid($id){
        $this->db->select('s.*,sm.service_id as serviceid,sm.name')->from('tb_rateprefer_service s');
        $this->db->join('tb_service_master sm','sm.id = s.service_id','LEFT');
        $this->db->where('s.rate_prefer_id',$id);
        $this->db->order_by('s.id','DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    function productlist($wherein){
        $this->db->select('p.*,pm.name')->from('tb_rateprefer_product p');
        $this->db->join('tb_products_master pm','pm.id = p.product_id','LEFT');
        $this->db->where_in('p.id',$wherein);
        $query = $this->db->get();
        return $query->result_array();
    }

    function productlistbyid($id){
        $this->db->select('p.*,pm.name')->from('tb_rateprefer_product p');
        $this->db->join('tb_products_master pm','pm.id = p.product_id','LEFT');
        $this->db->where_in('p.rate_prefer_id',$id);
        $query = $this->db->get();
        return $query->result_array();
    }

    /*
	 *  Get RatePrefence Details with id from tb_rate_preferences
	 *  @param: int (id from tb_rate_preferences table)
	 *  @return : array  (query result)
	 */
    function getRatePrefenceDetails(int $id){
        $this->db->select('rp.*,cp.cust_profile_id custpfid,vp.vend_profile_id vendpfid,rs.service_id,rs.service_name,ro.offering_id,ro.offering_name,rr.rate_id,rr.record_name')->from('tb_rate_preferences rp');
        $this->db->join('tb_customer_profile cp','cp.id=rp.cust_profile_id','LEFT');
        $this->db->join('tb_vendor_profile vp','vp.id=rp.vend_profile_id','LEFT');
        $this->db->join('tb_rate_services rs','rs.id=rp.rate_service_id','LEFT');
        $this->db->join('tb_rate_offerings ro','ro.id=rp.rate_offering_id','LEFT');
        $this->db->join('tb_rate_records rr','rr.id=rp.rate_record_id','LEFT');
        $this->db->where('rp.id',$id);
        $query = $this->db->get();
		return $query->num_rows() > 0 ? $query->row_array() : [];
    }

}

