<?php
class Reason_code_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get reason_code by id
     */
    function get_reason_code($id)
    {
        return $this->db->get_where('tb_reason_codes',array('id'=>$id))->row_array();
    }
    
    /*
     * Get all reason_codes count
     */
    function get_all_reason_codes_count()
    {
        $this->db->from('tb_reason_codes');
        $this->db->where("status","1");
        return $this->db->count_all_results();
    }
        
    /*
     * Get all reason_codes
     */
    function get_all_reason_codes($params = array())
    {
        $this->db->where("status","1");
        $this->db->order_by('id', 'desc');
        if(isset($params) && !empty($params))
        {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('tb_reason_codes')->result_array();
    }
        
    /*
     * function to add new reason_code
     */
    function add_reason_code($params)
    {
        $this->db->insert('tb_reason_codes',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update reason_code
     */
    function update_reason_code($id,$params)
    {
        $this->db->where('id',$id);
        return $this->db->update('tb_reason_codes',$params);
    }
    
    /*
     * function to delete reason_code
     */
    function delete_reason_code($id)
    {
        return $this->db->where(array('id'=>$id))->update('tb_reason_codes',array("status"=>"0"));
    }
}
