<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class Routingauto extends CI_Model
{

	function gettblrowdata($where,$select,$table,$limit,$start)
	{
		$result = array();
		$this->db->select($select);
		$this->db->from($table);
		$this->db->where($where);
		$this->db->limit(1);
		$res = $this->db->get();
		if($res->num_rows() > 0){
			$result = $res->row_array();
		}
		return $result;
	}
	function updatedata($table,$id,$data)
    {
        $this->db->where('id',$id);
        return $this->db->update($table,$data);
    }

    function getroutedata($uid,$whr)
    {
        $this->db->select("ra.id, ra.route_id,ra.cust_id,ra.trans_type,ra.trigger_at,ra.triggered_type,ra.order_type,ra.product,ra.mot,ra.service,ra.inco_terms,ra.cust_code,ra.carrier_id,ra.vehicle_type,ra.vehicle_id,ra.driver_id,ra.template_id,ra.min_weight,ra.max_weight, ra.min_volume,ra.max_volume, ra.min_weight_uom, ra.max_weight_uom, ra.min_volume_uom, ra.max_volume_uom, c.name as cust_name");
        $this->db->from("tb_routing_auto ra");
	    $this->db->join('tb_customers c', 'ra.cust_id = c.id');
        $this->db->like($whr);
        $this->db->where("ra.user_id",$uid);
        $this->db->where("ra.status", 1);
        $this->db->order_by("ra.id", "DESC");
        return $this->db->get();
    }

	function getalldata($uid){
        /*new filds addd in DB fetching here*/
        $this->db->select("ra.id, ra.route_id,ra.cust_id,ra.trans_type,ra.trigger_at,ra.triggered_type,ra.order_type,ra.product,ra.mot,ra.service,ra.inco_terms,ra.cust_code,ra.carrier_id,ra.vehicle_type,ra.vehicle_id,ra.driver_id,ra.template_id,ra.min_weight,ra.max_weight, ra.min_volume,ra.max_volume, ra.min_weight_uom, ra.max_weight_uom, ra.min_volume_uom, ra.max_volume_uom, c.name as cust_name");
    $this->db->from("tb_routing_auto ra");
    $this->db->join('tb_customers c', 'ra.cust_id = c.id');
    $this->db->where("ra.user_id",$uid);
    $this->db->where("ra.status", 1);
    $this->db->order_by("ra.id", "DESC");
    return $this->db->get();
}
	function getshipments($shipment_id){
		$result=$this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '".$shipment_id."'");
		return $result;
	}
	public function getpreviousrecord($order_id,$country_code){
		$result='';
		$getpreviousrecord= $this->db->query("SELECT order_id FROM tb_orders WHERE id <'".$order_id."' AND order_id LIKE '%".$country_code."%' ORDER BY id DESC LIMIT 1");
		if($getpreviousrecord->num_rows() >0){
			$result=$getpreviousrecord->row()->order_id;
		}
        return $result;

	}

    /**
     *  This method is used to show party types by company code for both xborder and normal
     *  @param  string $companyCode, string $where, string $code string $type
     * 	return :array (query result)
     */
    public function getAllPartyTypeDetailsForRouting(string $companyCode, string $where, string $code, string $type): array
    {
        $dbXborderCountries = $response = [];
        $xborderCode = "";
        if (checkAccessConditions('RELATED_2_CROSSBORDER', $companyCode)) {
            $this->db->select("xborder_code");
            $this->db->from("tb_xborder_country");
            $this->db->where("company_code", $companyCode);
            $getxborder_cntry = $this->db->get();
            if ($getxborder_cntry->num_rows() > 0) {
                $xborderCode = $getxborder_cntry->row()->xborder_code;
            }
            if (strlen($xborderCode) > 0) {
                $dbXborderCountries = explode(",", $xborderCode);
            }
        }
        $dbXborderCountries[] = $companyCode;
        if ($type == "ALL-CUSTOMER") {
            $type = "CUSTOMER";
        }
        if ($type == "CUSTOMER") {
            $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code");
            $this->db->from("tb_customers");
            $this->db->where($where);
            $this->db->where_in("company_code", $dbXborderCountries);
            $finalQuery = $this->db->get();
            $response = $finalQuery->num_rows() > 0 ? $finalQuery->row_array() : [];
        } else {
            if ($code != "") {
                $sql = "SELECT m.id,
                    m.name,
                    m.email,
                    m.street,
                    m.location_id as city,
                    m.state,
                    m.mobile,
                    m.address,
                    m.country,
                    m.pincode,
                    m.country,
                    m.code,
                    m.company_code,
                    m.branch_code,
                    m.fax,
                    t.id as partytype_id,
                    t.name as role
                FROM tbl_party_master m
                LEFT JOIN tbl_party_types t ON t.id=m.party_type_id
                WHERE m.code LIKE ?
                AND m.company_code IN ?
                AND m.status = ? GROUP BY m.id";
                $finalQuery = $this->db->query($sql, [$code, $dbXborderCountries,1]);
                $response = $finalQuery->num_rows() > 0 ? $finalQuery->result_array() : [];
            } else {
                $response = $this->getAllPartyTypeDetailsByTypeName($type, $dbXborderCountries);
            }
        }
        return $response ?? [];
    }

    private function getAllPartyTypeDetailsByTypeName(string $type, array $dbXborderCountries): array
    {
        $partyTypeIds = $masterIds = $result = [];
        if ($type == "Shipper") {
            $partyTypes = ["Shipper", "Pickup"];
        } elseif ($type == "Consignee") {
            $partyTypes = ["Consignee", "Delivery"];
        } else {
            $partyTypes[] = $type;
        }
        $getDataByPartyTypeId = $this->db->query(
            "SELECT
       m.id,m.name,m.email,m.mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.address,m.country,m.state,m.street,m.pincode,m.party_types,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m LEFT JOIN tbl_party_types t ON t.id=m.party_type_id WHERE t.name IN ? AND m.code Is NOT NULL AND m.code != ? AND m.code != ? AND m.company_code IN ? AND m.status =?",
            [$partyTypes, 0, '', $dbXborderCountries, 1]
        );
        $masterResultData = $getDataByPartyTypeId->num_rows() > 0 ? $getDataByPartyTypeId->result_array() : [];
        foreach ($masterResultData as $eachLine) {
            $masterIds[] = $eachLine['id'];
            $result[] = [
                'id' => $eachLine['id'],
                'name' => $eachLine['name'],
                'email' => $eachLine['email'],
                'street' => $eachLine['street'],
                'city' => $eachLine['city'],
                'state' => $eachLine['state'],
                'mobile' => $eachLine['mobile'],
                'address' => $eachLine['address'],
                'country' => $eachLine['country'],
                'pincode' => $eachLine['pincode'],
                'code' => $eachLine['code'],
                'company_code' => $eachLine['company_code'],
                'branch_code' => $eachLine['branch_code'],
                'fax' => $eachLine['fax'],
                'partytype_id' => $eachLine['partytype_id'],
                'role' => $eachLine['role']
            ];
        }
        if (empty($masterIds)) {
            return $result;
        }
        $getPartyIds = $this->db->query("SELECT id from tbl_party_types WHERE name IN ? AND company_code IN ? AND status = ? ", [$partyTypes, $dbXborderCountries, 1]);
        $partyTypeResultIds = $getPartyIds->num_rows() > 0 ? $getPartyIds->result_array() : [];
        foreach ($partyTypeResultIds as $eachLine) {
            $partyTypeIds[] = $eachLine['id'];
        }
        if (empty($partyTypeIds)) {
            return $result;
        }
        $getAdditionalData = $this->db->query("SELECT m.id,m.name,m.email,m.mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.address,m.country,m.state,m.street,m.pincode,m.party_types,m.fax FROM tbl_party_master m WHERE m.id NOT IN ? AND m.code Is NOT NULL AND m.code != ? AND m.code != ? AND m.company_code IN ? AND m.status =?", [$masterIds, 0, '', $dbXborderCountries, 1]);
        $getAdditionalResultData = $getAdditionalData->num_rows() > 0 ? $getAdditionalData->result_array() : [];
        foreach ($getAdditionalResultData as $eachLine) {
            $partyTypes = $eachLine['party_types'];
            if ($partyTypes != "" && $partyTypes != '0') {
                $partyTypesArray = explode(',', $partyTypes);
                if (end($partyTypesArray) == "") {
                    array_pop($partyTypesArray);
                }
                if (is_array($partyTypesArray)) {
                    foreach ($partyTypesArray as $eachId) {
                        if (in_array($eachId, $partyTypeIds, true) && !in_array($eachLine['id'], $masterIds, true)) {
                            $masterIds[] = $eachLine['id'];
                            $result[] = [
                                'id' => $eachLine['id'],
                                'name' => $eachLine['name'],
                                'email' => $eachLine['email'],
                                'street' => $eachLine['street'],
                                'city' => $eachLine['city'],
                                'state' => $eachLine['state'],
                                'mobile' => $eachLine['mobile'],
                                'address' => $eachLine['address'],
                                'country' => $eachLine['country'],
                                'pincode' => $eachLine['pincode'],
                                'code' => $eachLine['code'],
                                'company_code' => $eachLine['company_code'],
                                'branch_code' => $eachLine['branch_code'],
                                'fax' => $eachLine['fax'],
                                'partytype_id' => $eachId,
                                'role' => $type
                            ];
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function getNotifyIdOfParty(string $companyCode, int $userId): ?int
    {
        $this->db->select('id');
        $this->db->from('tbl_party_types');
        $this->db->where(
            [
                'name' => 'NOTIFY_PARTY',
                'company_code' => $companyCode,
                'user_id' => $userId,
                'status' => 1,
            ]
        );
        $result = $this->db->get()->row();
        if (is_object($result)) {
            return (int)$result->id ?? null;
        }
        return null;
    }

    function getNotifyList(array $data): array
    {
        if (!isset($data) || !$data['action']) {
            return [];
        }

        if ($data['action'] == "byCode") {
            $result = $this->db->query(
                "SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,m.country,m.pincode,m.country,m.code,m.company_code,m.branch_code,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t
         WHERE  m.code IS NOT NULL AND m.company_code IS NOT NULL  AND m.branch_code IS NOT NULL AND m.party_type_id=t.id AND m.code LIKE ? GROUP BY m.id ORDER BY m.id DESC
", [$data['code']]
            );
        } else {
            $result = $this->db->query(
                "SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,m.country,m.pincode,m.country,m.code,m.company_code,m.branch_code,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t
         WHERE FIND_IN_SET(?,m.party_types) AND m.company_code = ? AND m.company_code IS NOT NULL  AND m.party_type_id=t.id AND m.branch_code IS NOT NULL AND m.branch_code IS NOT NULL GROUP BY m.id ORDER BY m.id DESC
", [$data['notifyId'], $data['companyCode']]
            );
        }

        return  $result->result();
    }

}
