<?php


class Scheduledjobdetailedlog extends CI_Model
{
    private const TABLE_NAME = 'scheduled_job_detailed_log';
    private const REQUIRED_KEYS = ['scheduled_job_history_id', 'entity_name'];

    /**
     * @param int $id
     * @return object
     */
    public function find(int $id): object
    {
        $queryBuilder = $this->db->select('*')->from(self::TABLE_NAME)->where('id', $id);
        return $queryBuilder->get()->result()[0];
    }

    /**
     * @param array $data
     * @return object|null
     */
    public function insert(array $data): ?object
    {
        if (!$this->isInputValid($data)) {
            return null;
        }

        $this->db->insert(self::TABLE_NAME, $data);
        return $this->find($this->db->insert_id());
    }

    /**
     * @param array $data
     * @return bool
     */
    private function isInputValid(array $data): bool
    {
        return !array_diff_key(array_flip(self::REQUIRED_KEYS), $data);
    }

    /**
     * @param string $highestId
     * @return bool
     * @throws Exception
     */
    public function massdelete(string $highestId): bool
    {
        if (!$this->db->where('scheduled_job_history_id <=', $highestId)->delete(self::TABLE_NAME)) {
            throw new \Exception("ERROR: Scheduledjobdetailedlog::massdelete | massdelete of scheduled job log lines went wrong");
        }
        return true;
    }
}
