<?php
class Servicesmodel extends CI_Model
{
    public function getServices($company_code=null,$branch_code=null,$from_date=null,$to_date=null)
    {
        $query = 'SELECT id,service_id,name,company_code,branch_code,createdon from tb_service_master WHERE status = 1';
        if($company_code){
            $query .= " AND company_code = '".$company_code."'";
        }
        if($branch_code){
            $query .= " AND branch_code = '".$branch_code."'";
        }
        if($from_date && $to_date){
            $query .= " AND createdon BETWEEN '".$from_date."' AND '".$to_date."'";
        }
        $res = $this->db->query($query);
        return $res->result_array();
    }

    function getServicesdata($search,$where,$from_date=null,$to_date=null){
        $this->db->select('*');
        $this->db->from('tb_service_master');
        $this->db->where($where);
        if($from_date && $to_date){
            $this->db->where("createdon BETWEEN '".$from_date."' AND '".$to_date."'");
        }
        if($search){
           $this->db->like('service_id',$search);
           $this->db->or_like('name',$search);
        }
        $this->db->order_by('id','DESC');
        $res = $this->db->get();
        $result = $res->result_array();
        return $result;
    }

    public function getcustomerwiseServices($search,$where,$from_date = null,$to_date = null): array
    {
        $this->db->select('tsm.id,tsm.company_code,tsm.branch_code,tsm.user_id,tsm.service_id,tsm.name,tsm.status,tsm.createdon,tc.id as cid,tc.name as customername');
        $this->db->from('tb_service_master as tsm');
        $this->db->join('customer_servicedata as cs', 'cs.servicerow_id = tsm.id', 'left');
        $this->db->join('tb_customers as tc', 'tc.id = cs.customer_id', 'left');
        $this->db->where($where);
        if ($from_date && $to_date) {
            $this->db->where("tsm.createdon BETWEEN '" . $from_date . "' AND '" . $to_date . "'");
        }
        if ($search) {
            $this->db->like('tsm.service_id', $search);
            $this->db->or_like('tsm.name', $search);
        }
        $this->db->order_by('tsm.id', 'DESC');
        $res = $this->db->get();
        $result = $res->result_array();
        return $result ?? [];
    }

    public function getCustomerdata(int $id, string $cid = ''): array
    {
        if (!empty($cid)) {
            $where['customer_id'] = $cid;
            $where['servicerow_id'] = $id;
            $this->db->select('tc.id as cid,tc.name as customername');
            $this->db->from('customer_servicedata as cs');
            $this->db->join('tb_customers as tc', 'tc.id = cs.customer_id');
            $this->db->where($where);
            $res = $this->db->get();
            $result = $res->result_array();
            return $result ?? [];
        } else {
            return [];
        }
    }

    public function getCustomerList(array $where): array
    {
        if (!empty($where)) {
            $c_list = $this->db->select("id,name,code")->order_by("name", "asc")->get_where("tb_customers", $where);
            if ($c_list->num_rows() > 0) {
                $data = $c_list->result();
            }
            return $data ?? [];
        } else {
            return [];
        }
    }
}
