<?php

defined('BASEPATH') or exit('No direct script access allowed');
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Shifts_model extends CI_Model {

    /**
     * Class Constructor
     */
    public function __construct() {
        parent::__construct();
    }

    public function getShifts($userId, $where = NULL) {
        try {
            $this->db->select('*');
            $this->db->from('tb_shifts');
            $this->db->where('status', 1);
            $this->db->where('user_id', $userId);

            // Applying Filters
            if (!empty($where)) {
                if (!empty($where['shipmentid'])) {
                    $this->db->where('shipmentid', $where['shipmentid']);
                }
                if (!empty($where['carrier_type'])) {
                    $this->db->where('carrier_type', $where['carrier_type']);
                }
                if (!empty($where['startdate'])) {
                    $this->db->where('DATE(startdate)', date('Y-m-d', strtotime($where['startdate'])));
                }
                if (!empty($where['todate'])) {
                    $this->db->where('DATE(enddate)', date('Y-m-d', strtotime($where['todate'])));
                }
            }
            $this->db->order_by('id', 'DESC');
            $query = $this->db->get();

            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getShiftById($shiftId, $userId) {
        try {
            $query = $this->db->query("SELECT * FROM `tb_shifts` WHERE `user_id` = '" . $userId . "' AND status='1' AND id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getShiftVehicles($shiftId, $userId) {
        try {
            $query = $this->db->query("SELECT * FROM `tb_shft_veh` WHERE `user_id` = '" . $userId . "' AND status='1' AND shft_id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches Shift details by Shift Id
     * @param $shiftId Integer
     * @param $userId Integer
     * @return array
     */
    public function getShiftDetailsById($shiftId, $userId) {
        try {
            $query = $this->db->query("SELECT s.*,sv.* FROM `tb_shifts` s JOIN tb_shft_veh sv ON s.id = sv.shft_id WHERE s.`user_id` = '" . $userId . "' AND s.status='1' AND s.id=" . $shiftId);
            return $query->row_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all vendors
     * @param $userId Integer
     * @return array
     */
    public function getVendors($userId) {
        try {
            $query = $this->db->query("SELECT * FROM `tb_vendors` WHERE `user_id` = '" . $userId . "' AND status='1'");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all vehicles from master table
     * @param $userId Integer
     * @return array
     */
    public function getVehicleTypes($userId) {
        try {
            $query = $this->db->query("SELECT * FROM `tb_trucktypes` WHERE `user_id` = '" . $userId . "' AND status='Active'");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all trucks from master table
     * @param $userId Integer
     * @return array
     */
    public function getTrucksData($userId) {
        try {
            $query = $this->db->query("SELECT * FROM `tb_trucks_data` WHERE `user_id` = '" . $userId . "' AND status='Active' ORDER BY truck_type");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all drivers per shift
     * @param $userId Integer
     * @param $vehicleId Integer
     * @return array
     */
    public function getShiftAssignedDrivers($userId, $vehicleId) {
        try {
            $driverIds = array();
            $query = $this->db->query("SELECT DISTINCT(driver_id) FROM tbl_assigned_drivers WHERE vehicle_id = " . $vehicleId . " AND status='1' AND user_id = '" . $userId . "'");
            $results = $query->result_array();
            foreach ($results as $result) {
                $driverIds[] = $result['driver_id'];
            }

            return $driverIds;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all truck drivers
     * @param $userId Integer
     * @return array
     */
    public function getTruckDrivers($userId) {
        try {
            $query = $this->db->query("SELECT td.name,td.id FROM tb_truck_drivers td JOIN tb_vehicles_drivers vd ON vd.driver_id = td.id WHERE td.user_id = '" . $userId . "' AND td.status = 'Active' GROUP BY td.id");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method fetches all department codes
     * @return array
     */
    public function getDepartments() {
        try {
            $query = $this->db->query("SELECT * FROM tb_department_master WHERE status='1' ORDER BY department_code");
            return $query->result_array();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method lists orders per shift
     * @param int $shiftId
     * @return array
     */
    public function getShiftOrders($shiftId) {
        try {
            $order = [];
            $query = $this->db->query("SELECT * FROM tb_orders WHERE shift_id = " . $shiftId);
            $orderdata = $query->result_array();

            foreach ($orderdata as $res) {
                $order_row_ids[] = $res['id'];
                $delivery_note = "";
                $shipmentid = $res['shipment_id'];
                $shift_id = $res['shift_id'];
                $trip_sts = $res['trip_sts'];
                $trip_id = $res['trip_id'];
                $order_status = 'PENDING';
                if ($trip_id != 0 && $trip_sts == 0) {
                    $order_status = 'ACTIVE';
                }
                if ($trip_id != 0 && $trip_sts == 1) {
                    $order_status = 'CLOSED';
                }

                $getdnote = $this->db->select("ref_value")->get_where("tb_order_references", array('order_id' => $res['id'], 'reference_id' => 'DQ'));
                if ($getdnote->num_rows() > 0) {
                    $delivery_note = $getdnote->row()->ref_value;
                }
                $order[] = array('order_row_id' => $res['id'], 'order_id' => $res['order_id'], 'delivery_note' => $delivery_note, 'pickup' => $res['pickup_company'], 'delivery' => $res['delivery_company'], 'order_status' => $order_status, 'transport_mode' => $res['transport_mode'], 'createdon' => $res['createdon'], 'total_packages' => $res['quantity'], 'weight' => $res['weight'], 'volume' => $res['volume']);
            }
            return $order;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method updates shift
     */
    public function updateShift($shiftId, $update) {
        try {
            $this->db->where('id', $shiftId);
            $this->db->update('tb_shifts', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     * This method updates shift vehicle
     */
    public function updateShiftVeh($shiftId, $update) {
        try {
            $this->db->where('shft_id', $shiftId);
            $this->db->update('tb_shft_veh', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updatedata($table, $id, $data) {
        $this->db->where('id', $id);
        return $this->db->update($table, $data);
    }

    public function addOrder($orderIds, $shiftId) {
        try {
            // Loop over Orders
            foreach ($orderIds as $orderId) {
                $details = $this->getOrderDetailsById($orderId);
                $this->updateShiftId($orderId, $shiftId);
                $this->insertShipOrderStops($details, $shiftId);
            }
            return TRUE;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateShiftId($orderId, $shiftId) {
        try {
            $update['shift_id'] = $shiftId;
            $update['user_id'] = $this->session->userdata('user_id');
            $this->db->where('id', $orderId);
            return $this->db->update('tb_orders', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     *
     * @param type $orderId
     * @return type
     */
    public function getOrderDetailsById($orderId) {
        try {
            $result = array();

            $this->db->select('*');
            $this->db->from('tb_orders');
            $this->db->where('id', $orderId);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    /**
     *
     * @param type $details
     * @param type $shiftId
     * @return integer
     */
    public function insertShipOrderStops($details, $shiftId) {
        try {
            // Stop ID
            $result = $this->getStopId($details, 'P');
            if (count($result)) {
                $details['stop_id'] = $result['id'];
                $this->updateShipOrderStop($details['stop_id'], $shiftId);
            } else {
                $details['stop_id'] = $this->insertShipOrderPickupStop($details, $shiftId);
            }

            // Drop ID
            $result = $this->getStopId($details, 'D');
            if (count($result)) {
                $details['drop_id'] = $result['id'];
                $this->updateShipOrderStop($details['drop_id'], $shiftId);
            } else {
                $details['drop_id'] = $this->insertShipOrderDropStop($details, $shiftId);
            }

            // Check Employee Record
            $result = $this->checkEmployeeId($details['stop_id'], $details['drop_id']);
            if (count($result)) {
                $employee['employee_id'] = $result['id'];
                $this->updateEmployee($employee['employee_id'], $shiftId, $details['order_id']);
            } else {
                $this->insertEmployee($details, $shiftId);
            }
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateShipOrderStop($id, $shiftId) {
        try {
            $update['shipment_id'] = $shiftId;
            $update['status'] = 1;
            $update['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where('id', $id);
            return $this->db->update('tb_shiporder_stops', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateEmployee($id, $shiftId, $order_id) {
        try {
            $update['shift_id'] = $shiftId;
            $update['order_id'] = $order_id;
            $update['status'] = 1;
            $update['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $id);
            return $this->db->update('tb_employee', $update);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function checkEmployeeId($stop_id, $drop_id) {
        try {
            $result = array();

            $this->db->select('id');
            $this->db->from('tb_employee');
            $this->db->where('stop_id', $stop_id);
            $this->db->where('drop_stopid', $drop_id);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getEmployeeDetails($order_id) {
        try {
            $result = array();

            $this->db->select('*');
            $this->db->from('tb_employee');
            $this->db->where('order_id', $order_id);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function updateOrder($orderId, $shiftId) {
        try {
            // Get Order Details
            $order = $this->getOrderDetailsById($orderId);

            // Get Employee Details
            $employee = $this->getEmployeeDetails($order['order_id']);

            // Update Employee
            $eupdate['status'] = 0;
            $eupdate['shift_id'] = 0;
            $eupdate['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $employee['id']);
            $this->db->update('tb_employee', $eupdate);

            // Update Ship Order Stops
            $supdate['status'] = 0;
            $supdate['shipment_id'] = 0;
            $supdate['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where_in('id', array($employee['stop_id'], $employee['drop_stopid']));
            $this->db->update('tb_shiporder_stops', $supdate);

            // Update Order
            $oupdate['shift_id'] = 0;
            $oupdate['trip_id'] = 0;
            $oupdate['updatedon'] = date('Y-m-d H:i:s');
            $this->db->where('id', $orderId);
            return $this->db->update('tb_orders', $oupdate);
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function getStopId($details, $stoptype) {
        try {
            $result = array();

            $this->db->select('id');
            $this->db->from('tb_shiporder_stops');
            $this->db->where('stoptype', $stoptype);
            $this->db->where('plat', $details['plat']);
            $this->db->where('plng', $details['plng']);

            $query = $this->db->get();

            if ($query->num_rows()) {
                $result = $query->row_array();
            }

            return $result;
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertShipOrderPickupStop($details, $shiftId) {
        try {
            $insert['plat'] = $details['plat'];
            $insert['plng'] = $details['plng'];
            $insert['address'] = $details['pickup_address1'] . ', ' . $details['pickup_company'] . ', ' . $details['pickup_country'] . ', ' . $details['pickup_pincode'];
            $insert['stoptype'] = 'P';
            $insert['stopstatus'] = 0;
            $insert['shipment_id'] = $shiftId;
            $insert['ordernumber'] = 1;
            $insert['startdate'] = $details['pickup_datetime'];
            $insert['enddate'] = $details['pickup_endtime'];
            $insert['weight'] = $details['weight'];
            $insert['volume'] = $details['volume'];
            $insert['shipmentstopid'] = 0;
            $insert['ship_units'] = $details['quantity'];
            $insert['txncode'] = 'NP';
            $insert['status'] = 1;
            $insert['created_on'] = date('Y-m-d H:i:s');
            $insert['updated_on'] = date('Y-m-d H:i:s');

            $this->db->insert('tb_shiporder_stops', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertShipOrderDropStop($details, $shiftId) {
        try {
            $insert['stopname'] = $details['delivery_city'];
            $insert['plat'] = $details['plat'];
            $insert['plng'] = $details['plng'];
            $insert['stopcity'] = $details['delivery_city'];
            $insert['address'] = $details['delivery_address1'] . ', ' . $details['delivery_company'] . ', ' . $details['delivery_country'] . ', ' . $details['delivery_pincode'];
            $insert['stoptype'] = 'D';
            $insert['stopstatus'] = 0;
            $insert['shipment_id'] = $shiftId;
            $insert['ordernumber'] = 2;
            $insert['startdate'] = $details['delivery_datetime'];
            $insert['enddate'] = $details['drop_endtime'];
            $insert['weight'] = $details['weight'];
            $insert['volume'] = $details['volume'];
            $insert['shipmentstopid'] = 0;
            $insert['ship_units'] = $details['quantity'];
            $insert['txncode'] = 'NP';
            $insert['status'] = 1;
            $insert['created_on'] = date('Y-m-d H:i:s');
            $insert['updated_on'] = date('Y-m-d H:i:s');

            $this->db->insert('tb_shiporder_stops', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

    public function insertEmployee($details, $shiftId) {
        try {
            $insert['pickup'] = getLocationName($details['plat'], $details['plng']);
            $insert['plat'] = $details['plat'];
            $insert['plat'] = $details['plng'];
            $insert['drop'] = getLocationName($details['dlat'], $details['dlng']);
            $insert['dlat'] = $details['dlat'];
            $insert['dlng'] = $details['dlng'];
            $insert['pickup_city'] = $details['pickup_city'];
            $insert['drop_city'] = $details['delivery_city'];
            $insert['pickup_datetime'] = $details['pickup_datetime'];
            $insert['drop_datetime'] = $details['delivery_datetime'];
            $insert['address'] = $details['pickup_address1'] . ', ' . $details['pickup_company'] . ', ' . $details['pickup_country'] . ', ' . $details['pickup_pincode'];
            $insert['user_id'] = $this->session->userdata('user_id');
            $insert['status'] = 1;
            $insert['createdon'] = date('Y-m-d H:i:s');
            $insert['updatedon'] = date('Y-m-d H:i:s');
            $insert['material_id'] = 0;
            $insert['capacity'] = $details['quantity'];
            $insert['shipment_weight'] = $details['weight'];
            $insert['shipment_volume'] = $details['volume'];
            $insert['ship_type'] = 'P';
            $insert['customer_id'] = $details['customer_id'];
            $insert['vendor_id'] = $details['vendor_id'];
            $insert['shipment_id'] = 0;
            $insert['startdate'] = $details['pickup_datetime'];
            $insert['enddate'] = $details['delivery_datetime'];
            $insert['shift_id'] = $shiftId;
            $insert['stop_order'] = 1;
            $insert['drop_order'] = 0;
            $insert['basic_stop'] = 0;
            $insert['stop_id'] = $details['stop_id'];
            $insert['drop_stopid'] = $details['drop_id'];
            $insert['order_id'] = $details['order_id'];

            $this->db->insert('tb_employee', $insert);
            return $this->db->insert_id();
        } catch (\Exception $e) {
            log_message('error', $e->getMessage());
        }
    }

	/**
     * This method fetches Shift Order Documents
     * @param int $userId
     * @param int $shiftId
     * @return array
     */
    public function getShiftOrderDocs($userId, $shiftId) {
        try {
            $result = array();
            $orderIds = $this->getShiftOrders($userId, $shiftId);
			$curtz = $this->session->userdata("usr_tzone")['timezone'];

            $query = $this->db->query("SELECT p.shipment_id, p.stop_id, p.latitude, p.longitude, d.type_name, p.imgpath, p.pdfpath,
						td.name, s.stopname, convertToClientTZ(ts.createdon,'" . $curtz . "') as p.createdon
                        FROM tb_pod_uploads p
                        JOIN tb_document_types d ON d.id = p.doc_type
                        JOIN tb_truck_drivers td ON p.createdby = td.id
                        JOIN tb_shiporder_stops s ON s.id = p.stop_id
                        WHERE p.user_id = " . $userId . "
                        AND p.shipment_id = " . $shiftId . "
                        AND p.order_id IN (" . implode(',', $orderIds) . ")");
            return $query->result_array();
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * This method fetches Shift Orders
     * @param int $userId
     * @param int $shiftId
     * @return array
     */
    public function getOrdersByShiftId($userId, $shiftId) {
        try {
            $result = array();

            $this->db->select('id');
            $this->db->from('tb_orders');
            $this->db->where('user_id', $userId);
            $this->db->where('shift_id', $shiftId);
            $query = $this->db->get();


            if ($query->num_rows()) {
                foreach ($query->result_array() as $value) {
                    $result[] = $value['id'];
                }
            }


            return $result;
        } catch (Exception $ex) {
            echo $ex->getMessage();
        }
    }

}
