<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;

/**
 * Table that has the stops for an order on a shipment (shift).
 */
class Ship_order_stops extends Table
{
    const TABLE = "tb_shiporder_stops";

    const ID_COL = "id";
    const STOPNAME_COL = "stopname";
    const PLAT_COL = "plat";
    const PLNG_COL = "plng";
    const STOPCITY_COL = "stopcity";
    const ADDRESS_COL = "address";
    const STOPTYPE_COL = "stoptype";
    const STOPSTATUS_COL = "stopstatus";
    const SHIPMENT_ID_COL = "shipment_id";
    const ORDERNUMBER_COL = "ordernumber";
    const ORDER_ID_COL = "order_id";
    const STARTDATE_COL = "startdate";
    const ENDDATE_COL = "enddate";
    const WEIGHT_COL = "weight";
    const VOLUME_COL = "volume";
    const SHIPMENTSTOPID_COL = "shipmentstopid";
    const SERVICEPROVIDER_COL = "serviceprovider";
    const SHIP_UNITS_COL = "ship_units";
    const TXNCODE_COL = "txncode";
    const STATUS_COL = "status";
    const CREATEDON_COL = "created_on";
    const UPDATEDON_COL = "updated_on";
    const STOP_PARTY_ID_COL = "stop_party_id";

    private $id;
    private $stopname;
    private $plat;
    private $plng;
    private $stopcity;
    private $address;
    private $stoptype;
    private $stopstatus;
    private $shipment_id;
    private $ordernumber;
    private $order_id;
    private $startdate;
    private $enddate;
    private $weight;
    private $volume;
    private $shipmentstopid;
    private $serviceprovider;
    private $ship_units;
    private $txncode;
    private $status;
    private $created_on;
    private $updated_on;
    private $stop_party_id;

    public function getEndtimeUpdates(array $shiftsData): array
    {
        $shiftIds = array_unique(array_column($shiftsData, 'id'));

        if (empty($shiftIds)) {
            return [];
        }

        $query = $this->db->query(
            "SELECT shipment_id, max(enddate) as enddate
                FROM tb_shiporder_stops
                WHERE
                    shipment_id IN ? AND stoptype=? AND status =?
                GROUP BY shipment_id
                ORDER BY id DESC",
            [$shiftIds, 'D', 1]
        );
        if (!$query) {
            return [];
        }

        $result = [];
        foreach ($query->result() as $row) {
            $result [$row->shipment_id] = $row->enddate ?: date("Y-m-d H:i:s");
        }
        return $result;
    }

    public function getOrderIdsByMultipleStopDropStops(array $stopIds): array
    {
        if (empty($stopIds)) {
            return [];
        }

        // gather info about stops and drop_stops with their status
        $query = $this->db->query(
            "SELECT
                    e.order_id, e.stop_id, e.drop_stopid, e.status
                    FROM tb_employee e
                    WHERE stop_id IN ? OR drop_stopid IN ?",
            [$stopIds, $stopIds]
        );
        if (!$query) {
            return [];
        }

        $cache = [];
        $orderIds = [];
        foreach ($query->result() as $row) {
            // only e.status = 1 can be used
            if (1 !== (int) $row->status) {
                continue;
            }
            $orderIds [$row->order_id] = $row->order_id;
            // cache results
            $cache[$row->stop_id] = $row->order_id;
            $cache[$row->drop_stopid] = $row->order_id;
        }

        // check how about orders to those stops and drop stops
        $query = $this->db->query("SELECT order_id, status
            FROM tb_orders
            WHERE order_id IN ?",
            [ array_values($orderIds)]);
        if (!$query) {
            return [];
        }

        $activeOrders = [];
        foreach ($query->result() as $row) {
            // only order status 1 and 2 can be used
            if (in_array((int) $row->status, [1,2])) {
                $activeOrders [] = $row->order_id;
            }
        }

        // loop cache table to remove stops and drop stops of not activeOrders
        foreach ($cache as $stopId => $orderId) {
            if (!(in_array($orderId, $activeOrders, true))) {
                unset($cache[$stopId]);
            }
        }

        return $cache;
    }
}
