<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ShipmentPlanningModel extends CI_model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Datatables_model');
    }

    public function getShipments(string $customerId, string $vendorId, string $shipmentId, string $uid, string $companyCode, array $permissions, string $curtz): array
    {
        $where['conditions'] = ['s.status = 1'];
        /*$where['conditions'] = ['s.status = 1', 't.status IS NULL'];*/
        /*$where['conditions'] = ['s.status = 1', 'o.order_id IS not NULL'];*/
        $where['params'] = [];

        if (in_array("trips", $permissions)){
            $where['conditions'][] = 's.company_code = ?';
            $where['params'][] = $companyCode;

            if(strlen($customerId) > 0){
                $where['conditions'][] = 'c.id = ?';
                $where['params'][] = $customerId;
            } elseif (strlen($vendorId) > 0) {
                $where['conditions'][] = 'c.vendor_id = ?';
                $where['params'][] = $vendorId;
            } elseif (strlen($shipmentId) > 0) {
                $where['conditions'][] = 's.shipmentid = ?';
                $where['params'][] = $shipmentId;
            }
        } elseif (strlen($customerId) > 0) {
            array_push($where['conditions'], 's.user_id = ?', 'c.id = ?');
            $where['params'] = [$uid, $customerId];

        } elseif (strlen($vendorId) > 0) {
            array_push($where['conditions'], 's.user_id = ?', 's.vendor_id = ?');
            $where['params'] = [$uid, $vendorId];

        } elseif (strlen($shipmentId) > 0) {
            array_push($where['conditions'], 's.user_id = ?', 's.shipmentid = ?');
            $where['params'] = [$uid, $shipmentId];
        } else {
            array_push($where['conditions'], 'v.status = 1', 's.user_id = ?');
            $where['params'] = [$uid];
        }

        $query = 'SELECT s.id, s.splace, s.slat, s.slng, s.eplace, s.elat, s.elng,
                convertToClientTZ(s.startdate,\''.$curtz.'\') as startdate,
                convertToClientTZ(s.enddate,\''.$curtz.'\') as enddate,
                s.shipmentid, s.transport_mode, s.txnid, s.weight, s.volume, s.units,
                s.domainname, s.vehicle_type, s.vendor_id, c.name, v.register_number, v.vehicle_id, td.name as drivername
            FROM tb_shifts s
            LEFT JOIN tb_customers c ON s.customer_id = c.id
            LEFT JOIN tb_shft_veh v ON s.id=v.shft_id AND v.status = 1
            LEFT JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id AND a.status = 1
            LEFT JOIN tb_truck_drivers td ON a.driver_id= td.id
            LEFT JOIN tb_trips t ON s.id = t.shift_id
            
            WHERE ' . implode(' AND ', $where['conditions']) . ' GROUP BY s.shipmentid
        ORDER BY s.startdate DESC
        LIMIT 100';
        
        //, o.order_id LEFT JOIN tb_orders o ON s.shipmentid = o.shipmentid

        $result = $this->db->query($query, $where['params']);
        //log_message("error","query:".$this->db->last_query());

        return $result ? $result->result_array() : [];
    }
}
