<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ShipmentVisibilityModel extends CI_model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Datatables_model');
        $this->load->model('trips_model');
    }

    public function getNormalTripsFroVisibility(array $post, array $stopDetailUserIds, string $userWhere, string $tableName, string $indexColumn, string $groupBy, string $excludeCountQuery): array
    {
        $companyCode = $this->session->userdata('company_code');
        $userType = $this->session->userdata("business_type");
        $shiftIds = $countTableCondition = $finalShiftIds = $joinsArray = $recordsData = $orderShiftIds = $legIds = [];
        $searchWhere = "";
        $search = trim($post['table_search'] ?? '');
        if ($search !== "") {
            if (!empty($stopDetailUserIds)) {
                $stodetails = $this->db->query(
                    "SELECT shift_id
                    FROM tb_employee
                    WHERE (order_id LIKE ? OR assoc_id LIKE ?)
                      AND status = ?
                      AND user_id IN ?
                    LIMIT 10"
                    ,
                    ['%' . $search . '%', '%' . $search . '%', '1', $stopDetailUserIds]
                );
                if ($stodetails->num_rows() > 0) {
                    foreach ($stodetails->result() as $res) {
                        $shiftIds[] = $res->shift_id;
                    }
                }
                $stodetailsref = $this->db->query(
                    "SELECT o.shift_id
                    FROM tb_orders o
                        LEFT JOIN tb_order_references r ON o.id=r.order_id
                    WHERE r.ref_value LIKE ?
                      AND o.shift_id != ?
                      AND o.user_id IN ?
                      AND o.status > ?
                      AND r.status = ?"
                    ,
                    [$search, '0', $stopDetailUserIds, '0', '1']
                );
                if ($stodetailsref->num_rows() > 0) {
                    foreach ($stodetailsref->result() as $res1) {
                        $shiftIds[] = $orderShiftIds[] = $res1->shift_id;
                    }
                }
            } else {
                $stopDetals = $this->db->query("SELECT s.shift_id
                    FROM tb_employee s
                    WHERE ( s.order_id LIKE ? OR s.assoc_id LIKE ? )
                      AND ".$userWhere."
                      AND s.status = ?
                      LIMIT 10",
                ['%' . $search . '%', '%' . $search . '%', '1']);
                foreach ($stopDetals->result_array() as $eachRow) {
                    $shiftIds[] = $legIds[] = $eachRow['shift_id'];
                }
                $getShiftIdsByReference = $this->db->query("SELECT DISTINCT(s.shift_id) as shift_id
                   FROM `tb_orders` `s`
                   LEFT JOIN `tb_order_references` `or` ON s.id = or.order_id  AND or.status=1
                   WHERE ( s.shipmentid LIKE ? OR s.order_id LIKE ? OR or.ref_value LIKE ? )
                     AND " . $userWhere . "
                     AND s.status != ?
                     LIMIT 10",
                    ['%' . $search . '%', '%' . $search . '%', '%' . $search . '%', '0']);
                foreach ($getShiftIdsByReference->result_array() as $eachRow) {
                    $shiftIds[] = $eachRow['shift_id'];
                }
            }
            if (!empty($shiftIds)) {
                $countTableCondition[] = " ( s.id IN (" . implode(
                        ",",
                        $shiftIds
                    ) . ") OR s.shipmentid LIKE '%" . $search . "%'
                    OR v.name LIKE '%" . $search . "%'
                    OR sv.register_number LIKE '%" . $search . "%')";
            } else {
                $countTableCondition[] = " (s.shipmentid LIKE '%" . $search . "%'
                OR v.name LIKE '%" . $search . "%'
                OR sv.register_number LIKE '%" . $search . "%' ) ";
            }
        }
        $selectColumns = ['s.id'];
        $countTableCondition[] = $userWhere;
        $countTableCondition[] = " s.status=1";

        $joinsArray[] = [
            'table_name' => 'tb_shft_veh as sv',
            'condition' => "sv.shft_id=s.id AND sv.status=1",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_vendors as v',
            'condition' => "v.id = s.vendor_id",
            'join_type' => 'left'
        ];
        $joinsArray[] = [
            'table_name' => 'tb_orders as o',
            'condition' => "o.shift_id=s.id AND o.status>0",
            'join_type' => 'inner'
        ];

        $getRecordListing = $this->Datatables_model->datatablesQuery(
            $selectColumns,
            [],
            $tableName,
            $joinsArray,
            implode(' AND ', $countTableCondition),
            $indexColumn,
            'TRUE',
            $groupBy,
            $excludeCountQuery,
            'POST'
        );
        if (!empty($getRecordListing)) {
            $recordsData = $getRecordListing['data'] ?? [];
        }
        if($search !== ""){
            $searchWhere = " AND shipmentid LIKE '%" . $search . "%' ";
            if(!empty($legIds)){
                $searchWhere .= " AND id IN (".implode(",",$legIds).") ";
            }
            if(!empty($orderShiftIds)){
                $searchWhere .= " AND shift_leg_id IN (".implode(",",$orderShiftIds).") ";
            }
        }
        if ($userType == "Carrier") {
            $vendorId = $this->session->userdata('id');
            $carrierCode = $this->session->userdata('carrier_code');
            $userWhereCondition = " vendor_id = " . $vendorId;
            if (checkAccessConditions('RELATED_2_SG_MY', $companyCode)) {
                $carrierIds = getCarrierids($carrierCode);
                if (!empty($carrierIds)) {
                    $carrierIdValues = implode("','", $carrierIds);
                    $userWhereCondition = " vendor_id IN ('" . $carrierIdValues . "')";
                }
            }
            $userWhereCondition .= $searchWhere;
            $finalShiftIds = $this->trips_model->getAllVendorBasedCrossBorderShiftIds($userWhereCondition);
        } else {
            $finalShiftIds = $this->trips_model->getAllAdminBasedCrossBorderShiftIds($companyCode, $searchWhere);
        }
        foreach ($recordsData as $res) {
            $finalShiftIds[] = $res['id'];
        }
        return array_unique($finalShiftIds);
    }

    public function getFinalTripsList(array $finalShiftIds, int $start, int $length, string $tableName, string $indexColumn, string $groupBy, string $excludeCountQuery): array
    {
        $shiftsData = $joinsArrayMainQuery = $mainQueryCondition = [];
        if (!empty($finalShiftIds)) {
            $_POST['start'] = $start;
            $_POST['length'] = $length;
            $mainQueryCondition[] = " s.id IN (" . implode(',', $finalShiftIds) . ") ";
            $mainQueryCondition[] = " s.status=1";
            $mainTableWhere = implode(' AND ', $mainQueryCondition);
            if ($mainTableWhere != '') {
                $mainTableWhere = " and $mainTableWhere ";
            }
            $mainWhereCondition = $indexColumn . "!='' " . $mainTableWhere;
            $mainSelectColumns = ['s.id,s.txnid,s.splace,s.eplace,s.startdate,s.enddate, s.shipmentid,s.vendor_id,v.name as carrier_name,v.broker as carrier_broker,sv.register_number,c.name as customer_name,td.name as driver_name,sv.vehicle_id'];
            $joinsArrayMainQuery[] = [
                'table_name' => 'tb_shft_veh as sv',
                'condition' => "sv.shft_id=s.id AND sv.status=1",
                'join_type' => 'left'
            ];
            $joinsArrayMainQuery[] = [
                'table_name' => 'tb_vendors as v',
                'condition' => "v.id = sv.carrier_id",
                'join_type' => 'left'
            ];
            $joinsArrayMainQuery[] = [
                'table_name' => 'tb_customers as c',
                'condition' => "c.id = s.customer_id",
                'join_type' => 'left'
            ];
            $joinsArrayMainQuery[] = [
                'table_name' => 'tbl_assigned_drivers as ad',
                'condition' => "ad.vehicle_id=sv.vehicle_id AND ad.status=1",
                'join_type' => 'left'
            ];
            $joinsArrayMainQuery[] = [
                'table_name' => 'tb_truck_drivers as td',
                'condition' => "td.id = ad.driver_id",
                'join_type' => 'left'
            ];
            $getFinalRecordListing = $this->Datatables_model->datatablesQuery(
                $mainSelectColumns,
                [],
                $tableName,
                $joinsArrayMainQuery,
                $mainWhereCondition,
                $indexColumn,
                'TRUE',
                $groupBy,
                $excludeCountQuery,
                'POST'
            );
            $shiftsData = $getFinalRecordListing['data'] ?? [];
        }
        return $shiftsData;
    }

    function getBookingIdsAndEmployeeData(array $stopIds): array
    {
        if (empty($stopIds)) {
            return [];
        }
        $query = $this->db->query(
            "SELECT
            e.order_id,
            e.ship_type,
            e.shift_id,
            stop_id,
            drop_stopid
            FROM tb_employee e
            LEFT JOIN tb_orders o ON o.order_id = e.order_id
            WHERE
            (
              stop_id IN ?
              OR drop_stopid IN ?
            )
            AND e.status = ?
            AND o.status IN ?
            ",
            [$stopIds, $stopIds, 1, [1, 2]]
        );
        if ($query->num_rows() > 0) {
            $results = $query->result_array();
            foreach ($results as $row) {
                $stopId = $row['stop_id'];
                $dropStopId = $row['drop_stopid'];
                $orderId = $row['order_id'];
                $shipType = $row['ship_type'];
                $shiftId = $row['shift_id'];

                $bookingIds[$stopId][] = $orderId;
                $bookingIds[$dropStopId][] = $orderId;
                if ($shipType == "P") {
                    $employeeData[$shipType][$shiftId][$stopId][] = 1;
                }
                if ($shipType == "D") {
                    $employeeData[$shipType][$shiftId][$dropStopId][] = 1;
                }
            }
        }
        return ['bookingIds' => $bookingIds ?? [], 'isEmployeeDataAvailable' => $employeeData ?? []];
    }
}
