<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Smsmodel extends CI_Model {
 
    var $table = 'tbl_sms_logs';
    var $column_order = array(null, 'module','sent_to','message','trip_id','emp_id','sent_on'); //set column field database for datatable orderable
    var $column_search = array('module','sent_to','message','trip_id','emp_id','sent_on'); //set column field database for datatable searchable 
    var $order = array('id' => 'desc'); // default order 
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
    private function _get_datatables_query()
    {
         
        $this->db->from($this->table);
        $this->db->where("user_id",$this->session->userdata("user_id"));
 
        $i = 0;
        $s=isset($_POST['search']['value'])?$_POST['search']['value']:"";
        foreach ($this->column_search as $item) // loop column 
        {
            if($s!="") // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        $this->db->where("user_id",$this->session->userdata("user_id"));
        $l=isset($_POST['length'])?$_POST['length']:"-1";
        $s=isset($_POST['start'])?$_POST['start']:"0";
        if($l != -1){
            $this->db->limit($l, $s);
        }

        $query = $this->db->get();
        return $query->result();
    }
    function get_alldatatables()
    {
        $this->_get_datatables_query();
        $this->db->where("user_id",$this->session->userdata("user_id"));
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered()
    {
        $this->_get_datatables_query();
        $this->db->where("user_id",$this->session->userdata("user_id"));
        $query = $this->db->get();

        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->from($this->table);
        $this->db->where("user_id",$this->session->userdata("user_id"));
        return $this->db->count_all_results();
    }
 
}