<?php

class Smtcorder extends CI_Model {

	function __construct() {
		parent::__construct();
	}


	public function getIdByOrderId( $ids ) {
		if ( $ids != '' ) {
			$dat = $this->db->query( "SELECT group_concat(o.id) as order_numbers FROM tb_orders o WHERE order_id in ($ids)" );
			if ( $dat->num_rows() > 0 ) {
				$result = $dat->result_array();

				return $result[0]['order_numbers'];
			}
		}
	}

	public function getsalogtobebilled($countryuids,$userid,$subcusts,$custid){
        $order_ids = array();
        $company_code = $this->session->userdata('company_code');
        $permission = checkuserpermissions();
        $whr = " AND o.user_id ='".$userid."' ";
        if (in_array('orders', $permission)) {
           $whr = " AND o.company_code LIKE '".$company_code."' ";
        } else {
            if ($userid != '0') {
                if (! empty($countryuids)) {
                    $whr = " AND o.user_id IN ('".implode('', $countryuids)."') ";
                } else {
                    $whr = " AND o.user_id ='".$userid."' ";
                }
            }
        }
        if (! empty($subcusts)) {
            $whr = " AND o.customer_id IN ('".implode('', $subcusts)."') ";
        } else {
            if ($custid != "") {
                $whr = " AND o.customer_id ='".$custid."' ";
            }
        }
        $qry = $this->db->query("SELECT o.order_id FROM tb_reveneus r,tb_orders o WHERE o.status !='0' ".$whr." AND o.created_source ='5' AND o.id=r.order_id AND r.recipient_role LIKE 'Internal BU' AND r.status ='1' AND r.invoice_status < '3' ");
        if($qry->num_rows()>0){
            foreach ($qry->result() as $res) {
                $order_ids[] = $res->order_id;
            }
        }
        return $order_ids;

    }

	public function getorderdata( $userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts ) {
		$orderIds = $orderNumbers = $salogcondition = '';
		$noordercondition = 0;

		$result = array();
        $selectColumns = "o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.drop_endtime,o.pickup_company as pickup,
		o.delivery_company as delivery,o.transport_mode,o.company_code,o.branch_code,o.customer_name as external_customer,
		o.status,o.order_status,o.trip_sts,o.trip_id,o.shipmentid as shipmentid,
		o.createdon,o.updatedon,o.created_source,o.shift_id,
		d.order_status as order_detail_status,c.name as customer_name,cc.type_name";

		$this->db->select($selectColumns);
		$this->db->from( "tb_orders o" );
		$this->db->join( "tb_order_details d", "o.id=d.order_row_id", "LEFT" );
        $this->db->join("tb_customers c", "c.id = o.customer_id", 'LEFT');
        $this->db->join("tb_cost_center cc", "cc.id = d.cost_center_id", 'LEFT');

		$company_code = $this->session->userdata('company_code');
		$this->db->where( "o.status !=", 0 );
		if ( ! empty( $searchids ) ) {
			$this->db->where_in( "o.order_id", $searchids );
		}
		$permission = checkuserpermissions();
        if (in_array('orders', $permission)) {

            $this->db->where("o.company_code", $company_code);
        } else {
            if ($userid != '0') {
                if (! empty($countryuids)) {
                    $this->db->where_in("o.user_id", $countryuids);
                } else {
                    $this->db->where("o.user_id", $userid);
                }
            }
        }

		if ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING') {
			$wherepen = "(o.shift_id=0 AND o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
			$this->db->where($wherepen);
            $this->db->where("o.status !=", 3);
		}

		if($searchsts == 'SALOG PENDING' || $searchsts == 'SALOG ACTIVE' || $searchsts == 'SALOG CLOSED' || $searchsts == 'SALOG TO BE BILLED' || $searchsts == 'SALOG CANCELLED'){
            $this->db->where('o.created_source','5');
        }

		if ( $searchsts == 'ACTIVE' || $searchsts == 'SALOG ACTIVE') {
			$this->db->where( "o.trip_id !=", 0 );
			$whereact="((o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
			$this->db->where($whereact);
			$this->db->where( "o.trip_sts", 0 );
            $this->db->where("o.status !=", 3);
		}
		if ( $searchsts == 'CLOSED' || $searchsts == 'SALOG CLOSED') {
			$this->db->where( "o.trip_sts", 1 );
            $this->db->where("o.status !=", 3);
		}

		if($searchsts == 'SALOG TO BE BILLED'){
            $salogorders = $this->getsalogtobebilled($countryuids,$userid,$subcusts,$custid);
            if(!empty($salogorders)){
                $this->db->where_in('o.order_id',$salogorders);
            }else{
                $noordercondition = 1;
            }
            $this->db->where("o.status !=", 3);
        }
        if ($searchsts == 'SALOG CANCELLED' || $searchsts == 'CANCELLED') {
            $this->db->where("o.status", 3);
        }
        if($noordercondition == '1'){
            $this->db->where('o.id',0);
        }

        if (isset ($whr["o.customer_id"])) {
			$custid = $whr["o.customer_id"];
		}

		if ( ! empty( $subcusts ) ) {
			$this->db->where_in( "o.customer_id", $subcusts );
		} elseif (!empty($custid)) {
			if (is_array($custid)) {
				$this->db->where_in( "o.customer_id", $custid );
			} else {
				$this->db->where( 'o.customer_id', $custid );
			}

			unset($whr["o.customer_id"]);
		}

		$this->db->where( $whr );
		$this->db->group_by( "o.id" );
		$this->db->order_by( "o.createdon", 'DESC' );
		$getorder = $this->db->get();
		//echo $this->db->last_query();exit;
		if ( $getorder->num_rows() > 0 ) {
			$result = $getorder->result_array();
		}
		$formattedData=array();
		$tripCountData=array();
		if(!empty($result) && sizeof($result)>0){
			$reqData=array('id','order_id');
			$this->db->query('SET SESSION  group_concat_max_len=10240');
			$this->load->model('DataArrayFormatter_model');
			$this->load->model('DataQueryFormatter_model');
        	$formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$result);
			$codes="'DQ','XSR','PQ'";
			$formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
			$formattedData=$this->DataQueryFormatter_model->getOrderInvoiceData($formattedData['commaSeparated']['id'],$formattedData);
			$formattedData=$this->DataQueryFormatter_model->getOrderCargoDetailsForOrderListing($formattedData['commaSeparated']['id'],$formattedData);
			$formattedData=$this->DataQueryFormatter_model->getDeliveredStatusForOrder($formattedData['commaSeparated']['id'],$formattedData);


			if(isset($formattedData['commaSeparated']['order_id'])){
				$tripCountData=$this->DataQueryFormatter_model->getTripCountFromEmployee($formattedData['commaSeparated']['order_id']);
			}
			$formattedData['tripData']=$tripCountData;

		}
		unset($formattedData['commaSeparated']);
		return $formattedData;
	}

	public function getorderids_xborder( $orderids, $searchTerm ) {
		$this->db->select( "order_id" );
		$this->db->from( "tb_orders" );
		$this->db->where( "status !=", 0 );
		if ( ! empty( $orderids ) ) {
			$this->db->where_in( "id", $orderids );
		} else {
			$this->db->where( "id", 0 );
		}
		$this->db->like( "order_id", $searchTerm );
		$this->db->order_by( "createdon", 'DESC' );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getorders_bypartymaster($type, $cid, $userid, $countryuids, $subcusts, $custid)
    {
        $result = array();
        $permission = checkuserpermissions();
        $whr = "AND t.name LIKE '" . $type . "' AND (m.code LIKE '" . $cid . "' OR m.name LIKE '" . $cid . "' )";
        if (in_array('orders', $permission)) {
            $company_code = $this->session->userdata('company_code');
            $whr .= "AND o.company_code LIKE '" . $company_code . "' ";
        } else {
            if ($userid != '0') {
                if (! empty($countryuids)) {
                    $whr .= "AND o.user_id IN (" . implode(',', $countryuids) . ") ";
                } else {
                    $whr .= "AND o.user_id ='" . $userid . "' ";
                }
            } else {
                if (! empty($subcusts)) {
                    $whr .= "AND o.customer_id IN (" . implode(',', $subcusts) . ") ";
                } else {
                    if ($custid != "") {
                        $whr .= "AND o.customer_id = '" . $custid . "' ";
                    }
                }
            }
        }
        $chkqry = $this->db->query("SELECT o.order_id FROM tb_orders o,tbl_party_master m,tbl_party_types t,tb_order_parties p WHERE p.order_id =o.id AND t.id=p.party_type AND m.id=p.party_id AND p.status ='1' AND m.status='1' " . $whr);
        /*
         * $this->db->select("o.order_id");
         * $this->db->from("tb_orders o");
         * $this->db->join("tb_order_parties p","p.order_id=o.id AND p.status ='1'","LEFT");
         * $this->db->join("tbl_party_types t","t.id=p.party_type AND p.status ='1'","LEFT");
         * $this->db->join("tbl_party_master m","m.id=p.party_id AND m.status ='1'","LEFT");
         * $this->db->where("t.name",$type);
         * $this->db->where("m.code",$cid);
         * $permission = checkuserpermissions();
         * if(in_array('orders', $permission)){
         * $company_code = $this->session->userdata('company_code');
         * $this->db->where("o.company_code",$company_code);
         * }else{
         * if ( $userid != '0' ) {
         * if ( ! empty( $countryuids ) ) {
         * $this->db->where_in( "o.user_id", $countryuids );
         * } else {
         * $this->db->where( "o.user_id", $userid );
         * }
         * }
         * }
         * if ( ! empty( $subcusts ) ) {
         * $this->db->where_in( "o.customer_id", $subcusts );
         * } else {
         * if ( $custid != "" ) {
         * $this->db->where( 'o.customer_id', $custid );
         * }
         * }
         * $chkqry = $this->db->get();
         */
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $result[] = $res->order_id;
            }
        }
        return $result;
    }

    public function getxborderorderdata($searchids, $searchsts, $whr)
    {
        $this->db->select(
            "o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,o.createdon,d.delivery_note,d.department_code, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty"
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_order_cargodetails c", "o.id=c.order_id", "LEFT");
        $this->db->where("o.status !=", 0);
        if (!empty($searchids)) {
            $this->db->where_in("o.order_id", $searchids);
        } else {
            $this->db->where_in("o.id", 0);
        }
        if ($searchsts == 'PENDING') {
            $this->db->where("(o.trip_id=0 AND o.shift_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)");
        }
        if ($searchsts == 'ACTIVE') {
            $this->db->where("(((SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))");
            $this->db->where("o.trip_sts", 0);
        }
        if ($searchsts == 'CLOSED') {
            $this->db->where("o.trip_id !=", 0);
            $this->db->where("o.trip_sts", 1);
        }
        $this->db->where($whr);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        $result = $getorder->num_rows() > 0 ? $getorder->result_array() : [];
        if (!empty($result)) {
            $reqData = ['id', 'order_id'];
            $this->db->query('SET SESSION  group_concat_max_len=10240');
            $this->load->model('DataArrayFormatter_model');
            $this->load->model('DataQueryFormatter_model');
            $formattedData = $this->DataArrayFormatter_model->getCommaSeparatedFields($reqData, $result);
            if (isset($formattedData['commaSeparated']['order_id'])) {
                $tripCountData = $this->DataQueryFormatter_model->getTripCountFromEmployee($formattedData['commaSeparated']['order_id']);
            }
        }
        return ['orders' => $result, 'trips' => $tripCountData ?? []];
    }

    public function getcustomercodebyids( $select, $table, $ids ) {
		$result = array();
		$this->db->select( $select );
		$this->db->from( $table );
		$this->db->where_in( 'id', $ids );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->result_array();
		}

		return $result;
	}


	public function getordertoedit( $id ) {
		$this->db->select( "o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.shipment_id,o.delivery_datetime,o.drop_endtime,o.pickup_company as pickup,o.delivery_company as delivery,o.pickup_address1,o.delivery_address1,o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.currency,o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,o.pickup_partyid,o.drop_custid,o.drop_partyid,o.trip_sts,o.shift_id,o.trip_id,o.status,o.order_status,o.createdon,o.updatedon,o.shipmentid,o.consignee_id,o.shipper_id as o_shipper_id,d.order_type,d.shipper_id,d.service,d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code,d.docs_received_datetime,d.docs_sent_datetime,d.consignment_note,d.order_remarks" );
		$this->db->from( "tb_orders o" );
		$this->db->join( "tb_order_details d", "o.id=d.order_row_id", "LEFT" );
		$this->db->where( "o.id", $id );
		$this->db->limit( 1 );
		$chkorder = $this->db->get();

		return $chkorder;
	}

	public function getpickupdetails( $id ) {
		$getpickupdetails = $this->db->query( "SELECT id,name,address,pincode,code,country FROM tb_customers WHERE status='1' AND id='" . $id . "' LIMIT 1" );

		return $getpickupdetails;
	}

	public function getpartydetailsbycid( $id ) {
		$getdetails = $this->db->query( "SELECT id,name,email,street,location_id as city,state,mobile,pincode,country,customeridentifier,fax,partyindetifier FROM tbl_party_master WHERE status='1' AND customeridentifier='" . $id . "' ORDER BY id DESC LIMIT 1" );

		return $getdetails;
	}

    public function getpartydetailsbyid($id)
    {
        $getdetails = $this->db->query("SELECT id,name,code,address,email,street,location_id as city,state,mobile,pincode,country,customeridentifier,fax,partyindetifier FROM tbl_party_master WHERE status='1' AND id='" . $id . "' ORDER BY id DESC LIMIT 1");

		return $getdetails;
	}

	public function getreferencebyorder( $id ) {
		$getreference = $this->db->query( "SELECT o.ref_value,r.id,r.name FROM tb_order_references o,tb_reference_master r WHERE o.order_id='" . $id . "' AND o.reference_id=r.name AND o.status='1' AND r.status='1' ORDER BY o.id DESC" );

		return $getreference->result_array();
	}

	public function getcreditdata( $table, $order_id ) {
		$result = array();
		$this->db->select( "*" );
		$this->db->from( $table );
		$this->db->where( "order_id", $order_id );
		$this->db->where( "status", 1 );
		$result = $this->db->get();

		return $result;
	}

	public function getmasters( $table, $select ) {
		$result = array();
		$this->db->select( $select );
		$this->db->from( $table );
		$this->db->where( "status", 1 );
		$result = $this->db->get();

		return $result;
	}

	public function getchargesforrevenuemodel( $revenue_id ) {
		$getcharges = $this->db->select( "*" )->get_where( "tb_charges", array( 'revenue_id' => $revenue_id, 'status' => 1 ) );
		$this->db->select( "c.*,c1.charge_code as chargecode" );
		$this->db->from( "tb_charges c" );
		$this->db->join( "tb_charge_codes c1", "c.charge_code=c1.id", "LEFT" );
		$this->db->where( "c.revenue_id", $revenue_id );
		$this->db->where( "c.status", 1 );
		$getcharges = $this->db->get();

		return $getcharges;
	}

	public function getchargecodes( $code ) {

		$this->db->select( "id,name" );
		$this->db->from( "tb_charge_codes" );
		$this->db->where( 'status', 1 );
		$this->db->like( 'name', $code );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getorderids( $user_id, $custid, $searchTerm ) {
		$company_code = $this->session->userdata( 'company_code' );
		$this->db->select( "order_id" );
		$this->db->from( "tb_orders" );
		$this->db->where( "status !=", 0 );

		$this->db->like( "order_id", $searchTerm );
		if ( ! empty( $custid ) ) {
			$this->db->where_in( "customer_id", $custid );
		}else{
            $permission = checkuserpermissions();
            if (in_array("orders", $permission)) {
                $company_code = $this->session->userdata('company_code');
                $this->db->where("company_code", $company_code);
            } else {
                $this->db->where("user_id", $user_id);
            }
		}
		$this->db->order_by( "createdon", 'DESC' );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getcountryuserorderids( $user_id, $countryids, $searchTerm ) {
		$company_code = $this->session->userdata( 'company_code' );
		$this->db->select( "order_id" );
		$this->db->from( "tb_orders" );
		$this->db->where( "status !=", 0 );
		$this->db->like( "order_id", $searchTerm );
		if ( ! empty( $countryids ) ) {
			$this->db->where_in( "user_id", $countryids );
		}
		$this->db->order_by( "createdon", 'DESC' );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getcustomerbasedservices( $cust_code, $service_id ) {
		$this->db->select( 'rs.id,rs.service_id,rs.service_name,rs.product' );
		$this->db->from( "tb_rate_services rs" );
		$this->db->join( "tb_rate_offerings ro", "rs.id=ro.rate_service_id", "LEFT" );
		$this->db->join( "tb_customer_profile cp", "cp.id=ro.cust_profile_id", "LEFT" );
		$this->db->join( "tb_customer_profile_list cl", "cp.id=cl.cp_id", "LEFT" );
		$this->db->where( "cl.profile_id", $cust_code );
		$this->db->where( "rs.service_type", $service_id );
		$this->db->where( 'rs.status', 1 );
		$this->db->where( 'cp.status', 1 );
		$this->db->where( 'cl.status', 1 );
		$this->db->where( 'ro.status', 1 );
		$this->db->group_by( 'rs.id' );
		$this->db->order_by( "rs.id", "DESC" );
		$chkqry = $this->db->get();

		return $chkqry;

	}

	public function getlanes_byservice( $source, $service_id ) {
		$whr = "";
		if ( ! empty( $source ) ) {
			$pickup_country   = $source['pickup_country'];
			$delivery_country = $source['delivery_country'];
			$pickup_city      = $source['pickup_city'];
			$delivery_city    = $source['delivery_city'];
			$pickup_zcode     = $source['pickup_zcode'];
			$delivery_zcode   = $source['delivery_zcode'];
			if ( ( $pickup_country != "" && $delivery_country != "" ) || ( $pickup_city != "" && $delivery_city != "" ) || ( $pickup_zcode != "" && $delivery_zcode != "" ) ) {
				$whr = "(";
				$whr .= "(l.source_geo ='2' AND l.source LIKE '" . $pickup_country . "' AND l.destination_geo='2' AND l.destination LIKE '" . $delivery_country . "' )";
				if ( $pickup_city != "" && $delivery_city != "" ) {
					$whr .= " OR (l.source_geo ='5' AND l.source LIKE '" . $pickup_city . "' AND l.destination_geo ='5' AND l.destination LIKE '" . $delivery_city . "' ) ";
				}
				if ( $pickup_zcode != "" && $delivery_zcode != "" ) {
					$whr .= " OR ( l.source_geo='6' AND l.source LIKE  '" . $pickup_zcode . "' AND l.destination_geo ='6' AND l.destination LIKE '" . $delivery_zcode . "' ) ";
				}
				$whr .= ")";
			}
		}
		$this->db->select( "l.id,l.lane_id,l.lane_name" );
		$this->db->from( "tb_lanes_master l" );
		$this->db->join( "tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT" );
		if ( $whr != "" ) {
			$this->db->where( $whr );
		}

		$this->db->where( "rl.rate_id", $service_id );
		$this->db->where( "rl.status", 1 );
		$this->db->where( "l.status", 1 );
		$this->db->group_by( 'l.id' );
		$this->db->order_by( "l.id", "DESC" );
		$chkqry = $this->db->get();


		return $chkqry;

	}

	public function getlanes_byservicerange( $service_id ) {

		$this->db->select( "l.id,l.lane_id,l.lane_name" );
		$this->db->from( "tb_lanes_master l" );
		$this->db->join( "tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT" );
		$this->db->where( "rl.rate_id", $service_id );
		$this->db->where( "l.source_geo", 1 );
		$this->db->where( "l.destination_geo", 1 );
		$this->db->where( "rl.status", 1 );
		$this->db->where( "l.status", 1 );
		$this->db->group_by( 'l.id' );
		$this->db->order_by( "l.id", "DESC" );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getifrangeexits( $service_id ) {

		$this->db->select( "l.id,l.lane_id,l.lane_name" );
		$this->db->from( "tb_lanes_master l" );
		$this->db->join( "tb_rateservice_lanes rl", "l.id=rl.lane_id", "LEFT" );
		$this->db->where( "rl.rate_id", $service_id );
		$this->db->where( "l.source_geo", 1 );
		$this->db->where( "l.destination_geo", 1 );
		$this->db->group_by( 'l.id' );
		$this->db->order_by( "l.id", "DESC" );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getVendorbasedservices( $vendor_code, $service_id ) {
		$this->db->select( 'rs.id,rs.service_id,rs.service_name' );
		$this->db->from( "tb_rate_services rs" );
		$this->db->join( "tb_rate_offerings ro", "rs.id=ro.rate_service_id", "LEFT" );
		$this->db->join( "tb_vendor_profile vp", "vp.id=ro.vendor_profile_id", "LEFT" );
		$this->db->join( "tb_vendor_profile_list vpl", "vp.id=vpl.vp_id", "LEFT" );
		$this->db->where( "vpl.profile_id", $vendor_code );
		$this->db->where( "rs.service_type", $service_id );
		$this->db->where( 'rs.status', 1 );
		$this->db->where( 'vp.status', 1 );
		$this->db->where( 'vpl.status', 1 );
		$this->db->where( 'ro.status', 1 );
		$this->db->group_by( 'rs.id' );
		$this->db->order_by( "rs.id", "DESC" );
		$chkqry = $this->db->get();

		return $chkqry;

	}

	/* Get customer profile by using customer code */
	public function getcustomerprofileforpreference( $cust_code, $user_id ) {
		$this->db->select( 'cp.id' );
		$this->db->from( "tb_customer_profile cp" );
		$this->db->join( "tb_customer_profile_list cpl", "cpl.cp_id=cp.id", "LEFT" );
		$this->db->where( "cpl.profile_id", $cust_code );
		$this->db->where( "cp.user_id", $user_id );
		$this->db->where( "cp.status", 1 );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getvendorprofileforpreference( $code, $user_id ) {
		$this->db->select( 'vp.id' );
		$this->db->from( "tb_vendor_profile vp" );
		$this->db->join( "tb_vendor_profile_list vpl", "vpl.vp_id=vp.id", "LEFT" );
		$this->db->where( "vpl.profile_id", $code );
		$this->db->where( "vp.user_id", $user_id );
		$this->db->where( "vp.status", 1 );
		$chkqry = $this->db->get();

		return $chkqry;
	}

	public function getvendorpreferencebyorderdetails( $vend_profile_id, $user_id, $pickup, $delivery ) {
		$whr    = "";
		$result = array();
		if ( $vend_profile_id != "" && $vend_profile_id != '0' ) {
			if ( ! empty( $pickup ) && ! empty( $delivery ) ) {
				$whr = " (rps.country LIKE '" . $pickup['country'] . "' OR rps.state LIKE '" . $pickup['state'] . "' OR rps.city LIKE '" . $pickup['city'] . "' OR rps.pincode LIKE '" . $pickup['pincode'] . "') AND rps.user_id='" . $user_id . "' AND rps.status='1' AND (rds.country LIKE '" . $delivery['country'] . "' OR rds.state LIKE '" . $delivery['state'] . "' OR rds.city LIKE '" . $delivery['city'] . "' OR rds.pincode LIKE '" . $delivery['pincode'] . "' ) AND rds.user_id ='" . $user_id . "' AND rds.status='1' AND rp.status='1'";
			}
			if ( $whr != "" ) {
				$this->db->select( 'rp.id,rp.rate_service_id,rp.rate_offering_id,rp.rate_record_id,rp.auto_bill' );
				$this->db->from( "tb_rate_preferences rp" );
				$this->db->join( "tb_rateprefer_source rps", "rps.rate_prefer_id=rp.id", "LEFT" );
				$this->db->join( "tb_rateprefer_destination rds", "rds.rate_prefer_id=rp.id", "LEFT" );
				$this->db->where( "rp.vend_profile_id", $vend_profile_id );
				$this->db->where( "rp.tariff_type", '1' );
				$this->db->group_by( "rp.id" );
				$this->db->where( $whr );
				$chkqry = $this->db->get();
				if ( $chkqry->num_rows() > 0 ) {
					$result = $chkqry->result_array();
				}

				return $result;
			}
		}
	}

	/* Get rate Preference list by order details */
	public function getpreferencebyorderdetails( $cust_profile_id, $user_id, $arr ) {
		$result = array();
		$whr    = "";
		if ( $cust_profile_id != "" && $cust_profile_id != '0' ) {
			if ( ! empty( $arr ) ) {
				$whr = " (rps.country LIKE '" . $arr['pickup'] . "' OR rps.state LIKE '" . $arr['pickup_state'] . "' OR rps.city LIKE '" . $arr['pickup_city'] . "' OR rps.pincode LIKE '" . $arr['pickup_pincode'] . "') AND rps.user_id='" . $user_id . "' AND rps.status='1' AND (rds.country LIKE '" . $arr['drop'] . "' OR rds.state LIKE '" . $arr['drop_state'] . "' OR rds.city LIKE '" . $arr['drop_city'] . "' OR rds.pincode LIKE '" . $arr['drop_pincode'] . "' ) AND rds.user_id ='" . $user_id . "' AND rds.status='1' AND rp.status='1'";
			}
			if ( $whr != "" ) {
				$this->db->select( 'rp.id,rp.rate_service_id,rp.rate_offering_id,rp.rate_record_id,rp.auto_bill' );
				$this->db->from( "tb_rate_preferences rp" );
				$this->db->join( "tb_rateprefer_source rps", "rps.rate_prefer_id=rp.id", "LEFT" );
				$this->db->join( "tb_rateprefer_destination rds", "rds.rate_prefer_id=rp.id", "LEFT" );
				$this->db->where( "rp.cust_profile_id", $cust_profile_id );
				$this->db->where( "rp.tariff_type", '0' );
				$this->db->where( "rp.user_id", $user_id );
				$this->db->where( "rp.status", 1 );
				$this->db->group_by( "rp.id" );
				$chkqry = $this->db->get();
				if ( $chkqry->num_rows() > 0 ) {
					$result = $chkqry->result_array();
				}

				return $result;
			}
		}
	}

	public function getvatdetails( $data ) {
		/* get vat Details With customer/vendor */
		$result = array();
		$this->db->select( "v.name,v.cat_id,v.cat_val,lv.charge_id,lv.vat,c.charge_code,l.source_geo,l.source_country,l.destination_geo,l.destination_country" );
		$this->db->from( "tbl_vat_master v" );
		$this->db->join( 'tbl_lanes l', 'l.vatid = v.id', 'left' );
		$this->db->join( 'tbl_lane_vat lv', 'lv.lane_id = l.id', 'left' );
		$this->db->join( 'tb_charge_codes c', 'c.id = lv.charge_id', 'left' );
		if ( $data['type'] == 0 ) {
			$this->db->join( 'tbl_party_master p', 'p.customeridentifier = v.customeridentifier', 'left' );
		} else {
			$this->db->join( 'tbl_party_master p', 'p.customeridentifier = v.vendoridentifier', 'left' );
		}
		$this->db->where( "p.code", $data['custcode'] );
		$this->db->where( "c.id", $data['chargecodeid'] );
		$this->db->where( "v.company_code", $data['company_code'] );
		$this->db->where( "v.status", 1 );
		$this->db->where( "l.status", 1 );
		$this->db->where( "lv.status", 1 );
		$this->db->where( "p.user_id", $data['user_id'] );
		$this->db->where( "p.status", 1 );
		$getvatdetails = $this->db->get();
		if ( $getvatdetails->num_rows() > 0 ) {
			$result = $getvatdetails->result_array();
		}

		return $result;
	}

	public function getvatgeneric( $data ) {
		/* get vat Details Without customer/vendor(Generic) */
		$result = array();
		$this->db->select( "v.name,v.cat_id,v.cat_val,lv.charge_id,lv.vat,c.charge_code,l.source_geo,l.source_country,l.destination_geo,l.destination_country" );
		$this->db->from( "tbl_vat_master v" );
		$this->db->join( 'tbl_lanes l', 'l.vatid = v.id', 'left' );
		$this->db->join( 'tbl_lane_vat lv', 'lv.lane_id = l.id', 'left' );
		$this->db->join( 'tb_charge_codes c', 'c.id = lv.charge_id', 'left' );
		$this->db->where( "c.id", $data['chargecodeid'] );
		$this->db->where( "v.company_code", $data['company_code'] );
		$this->db->where( "v.status", 1 );
		$this->db->where( "l.status", 1 );
		$this->db->where( "lv.status", 1 );
		$getvatdetails = $this->db->get();
		if ( $getvatdetails->num_rows() > 0 ) {
			$result = $getvatdetails->result_array();
		}

		return $result;
	}

	public function getserviceid_bylanes( $source ) {
		$whr          = "";
		$company_code = $this->session->userdata( 'company_code' );
		if ( ! empty( $source ) ) {
			$pickup_country   = $source['pickup_country'];
			$delivery_country = $source['delivery_country'];
			$pickup_city      = $source['pickup_city'];
			$delivery_city    = $source['delivery_city'];
			$pickup_zcode     = $source['pickup_zcode'];
			$delivery_zcode   = $source['delivery_zcode'];
			$user_id          = $source['user_id'];
			if ( ( $pickup_country != "" && $delivery_country != "" ) || ( $pickup_city != "" && $delivery_city != "" ) || ( $pickup_zcode != "" && $delivery_zcode != "" ) ) {
				$whr = "(";
				$whr .= "(l.source_geo ='2' AND l.source LIKE '" . $pickup_country . "' AND l.destination_geo='2' AND l.destination LIKE '" . $delivery_country . "' )";
				if ( $pickup_city != "" && $delivery_city != "" ) {
					$whr .= " OR (l.source_geo ='5' AND l.source LIKE '" . $pickup_city . "' AND l.destination_geo ='5' AND l.destination LIKE '" . $delivery_city . "' ) ";
				}
				if ( $pickup_zcode != "" && $delivery_zcode != "" ) {
					$whr .= " OR ( l.source_geo='6' AND l.source LIKE  '" . $pickup_zcode . "' AND l.destination_geo ='6' AND l.destination LIKE '" . $delivery_zcode . "' ) ";
				}
				$whr .= ")";
			}
		}
		$this->db->select( "rl.rate_id" );
		$this->db->from( "tb_rateservice_lanes rl" );
		$this->db->join( "tb_lanes_master l", "l.id=rl.lane_id", "LEFT" );
		if ( $whr != "" ) {
			$this->db->where( $whr );
		}
		if ( $company_code != "RUKN" ) {
			$this->db->where( "rl.user_id", $user_id );
		}
		$this->db->where( "rl.status", 1 );
		if ( $company_code == "RUKN" ) {
			$this->db->where( "l.company_code", $company_code );
		} else {
			$this->db->where( "l.user_id", $user_id );
		}
		$this->db->where( "l.status", 1 );
		$this->db->group_by( 'rl.rate_id' );
		$this->db->order_by( "l.id", "DESC" );
		$chkqry = $this->db->get();

		/*log_message("error","191 ".$this->db->last_query());*/

		return $chkqry;

	}

	/* Australia ASN order data  */
	public function getauasnorderdata( $whr ) {
		$result = array();
		$this->db->select( "id,order_id, pickup_company as Shipper Name, delivery_company as Consignee Name, pickup_country as Shipper Country, delivery_country as Consignee Country, pickup_city as Shipper City, delivery_city as Consignee City, pickup_pincode as  Shipper Zipcode, delivery_pincode as  Consignee Zipcode, pickup_address1 as Shipper Address, delivery_address1 as  Consignee Address , pickup_address2 as Shipper State, delivery_address2 as Consignee State" );
		$this->db->from( "tb_orders" );
		$this->db->where( $whr );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->row_array();
		}

		return $result;
	}

	/* Australia ASN order cargo  data  */
	public function getasncargodetails( $whr ) {
		$result = array();
		$this->db->select( "length,width,height,weight,volume,quantity" );
		$this->db->from( "tb_order_cargodetails" );
		$this->db->where( $whr );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->result_array();
		}

		return $result;
	}

	/* get reference numbers */
	public function getrefnums() {
		$result = array();
		$this->db->select( 'name' );
		$this->db->distinct( 'name' );
		$this->db->from( 'tb_reference_master' );
		$this->db->where( 'status', 1 );
		$this->db->order_by( 'name', 'ASC' );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->result_array();
		}

		return $result;
	}

	/* get reference numbers */
	public function getrefvals( $whr, $where, $userid = NULL, $countryuids = NULL ) {
		$result = array();
		$this->db->select( 'o.order_id' );
		$this->db->from( 'tb_order_references r' );
		$this->db->join( "tb_orders o", "o.id=r.order_id", "LEFT" );
		if($user_id != ""){
			$permission = checkuserpermissions();
	        if (in_array("orders", $permission)) {
	            $company_code = $this->session->userdata('company_code');
	            $this->db->where("company_code", $company_code);
	        } else {
	            $this->db->where("user_id", $user_id);
	        }
		}
		$this->db->where( $whr );
		$this->db->like( $where );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->result_array();
		}

		return $result;
	}

	public function getorderbookingids( $whr, $where ) {
		$result = array();
		$this->db->select( 'o.order_id' );
		$this->db->from( 'tb_order_references r' );
		$this->db->join( "tb_orders o", "o.id=r.order_id", "LEFT" );
		$this->db->where( $whr );
		$this->db->like( $where );
		$res = $this->db->get();
		if ( $res->num_rows() > 0 ) {
			$result = $res->result_array();
		}

		return $result;
	}

	public function getorderdatamini( $userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts ) {
		$result = array();

		$this->db->select( "o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.transport_mode,o.vendor_id,o.customer_id,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid,r.reference_id,r.ref_value,o.createdon,o.parent_id,d.delivery_note,d.department_code, d.num_of_pallets" );
		$this->db->join( "tb_order_details d", "o.id=d.order_row_id", "LEFT" );
		$this->db->join( "tb_order_references r", "o.id=r.order_id", "LEFT" );
		$this->db->where( "o.status !=", 0 );
		if ( ! empty( $searchids ) ) {
			$this->db->where_in( "o.order_id", $searchids );
		}
		if ( $userid != '0' ) {
			if ( ! empty( $countryuids ) ) {
				$this->db->where_in( "o.user_id", $countryuids );
			} else {
				$this->db->where( "o.user_id", $userid );
			}
		}
		if ( $searchsts == 'PENDING' ) {
			$this->db->where( "o.trip_id", 0 );
		}
		if ( $searchsts == 'ACTIVE' ) {
			$this->db->where( "o.trip_id !=", 0 );
			$this->db->where( "o.trip_sts", 0 );
		}
		if ( $searchsts == 'CLOSED' ) {
			$this->db->where( "o.trip_id !=", 0 );
			$this->db->where( "o.trip_sts", 1 );
		}
		if ( ! empty( $subcusts ) ) {
			$this->db->where_in( "o.customer_id", $subcusts );
		} else {
			if ( $custid != "" ) {
				$this->db->where( 'o.customer_id', $custid );
			}
		}
		if ( isset( $whr['like_c'] ) ) {
			$like_c = $whr['like_c'];
			unset( $whr['like_c'] );
			$this->db->where( $like_c );
		}

		if ( isset( $whr['DOC_DESC'] ) ) {
			$DOC_DESC = $whr['DOC_DESC'];
			unset( $whr['DOC_DESC'] );
			$this->db->where( $DOC_DESC, NULL, FALSE );
		}
		if ( isset( $whr['customer_id_c'] ) ) {
			$customer_id_c = $whr['customer_id_c'];
			unset( $whr['customer_id_c'] );
			$this->db->where( $customer_id_c );
		}

		$this->db->where( $whr );
		$this->db->group_by( "o.id" );
		$this->db->order_by( "o.createdon", 'DESC' );
		$getorder = $this->db->get( 'tb_orders o' );
		if ( $getorder->num_rows() > 0 ) {
			$result = $getorder->result_array();
		}

//    echo $this->db->last_query();exit;
		return $result;
	}
	public function getOrderdetailsByOrderId($ids,$where_field)
    {
        $result = array();
        $this->db->select("order_id,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,customer_id,c.name,c.code,c.street,c.location,c.pincode,c.country");
        $this->db->from('tb_orders o');
        $this->db->join('tb_customers c', 'c.id = o.customer_id', 'left');
        if(isset($where_field) && $where_field=='id'){
            $this->db->where('o.id',$ids);
        }else{
            $this->db->where_in('o.order_id',$ids);
        }
        $dat = $this->db->get();
        if ($dat->num_rows() > 0) {
            if(isset($where_field) && $where_field=='id'){
                $result = $dat->row_array();
            }else{
                $result = $dat->result_array();
            }
        }
        return $result;
    }
	public function getcustomername($order_id)
    {
        $result = '';
        $this->db->select('c.name');
        $this->db->from('tb_orders o');
        $this->db->join("tb_customers c", "c.id=o.customer_id", "LEFT");
        $this->db->where('o.id',$order_id);

        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $res = $res->row_array();
			if(isset($res['name']) && !empty($res['name'])){
				$result=$res['name'];
			}
        }
        return $result;
    }

	 public function getorderdataNew($userid, $searchids, $searchsts, $custid, $countryuids, $whr, $subcusts) {
        $orderIds = $orderNumbers = $salogcondition = '';
        $noordercondition = 0;
        if (!empty($searchids) && sizeof($searchids) > 0) {
            $orderIds = implode(',', $searchids);
            $orderNumbers = $this->getIdByOrderId($orderIds);
        }


        $ordeIdCondition = '';
        if ($orderNumbers != '') {
            $ordeIdCondition = " and order_id in ($orderNumbers) ";
        }
        $result = array();

        /* NEW TRIPS MODULE CODE */
         $this->db->select( "tu.name as username,COUNT(tbe.trip_id) AS tripno,v.name as vendor_name,d.order_status as order_detail_status,o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.drop_endtime,o.pickup_company as pickup,o.delivery_company as delivery,o.delivery_city,o.transport_mode,o.vendor_id,o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,o.shipmentid as shipmentid,o.createdon,o.created_source,o.parent_id,d.delivery_note,d.department_code,`cx`.weight_unit,`cx`.secondweight_uom,`cx`.secondvolume_uom, Sum(Case When c.status = '1' Then c.second_weight Else 0 End) as second_weight, Sum(Case When c.status = '1' Then c.second_volume Else 0 End) as second_volume, Sum(Case When c.status = '1' Then c.weight Else 0 End) as totwg,SUM(Case When c.status = '1' Then c.volume Else 0 End) as totvol,SUM(Case When c.status = '1' Then c.quantity Else 0 End) as totqty,SUM(Case When c.status = '1' Then c.scanned_quantity Else 0 End) as tot_scanned_qty,d.num_of_pallets,s.createdon as delivered_time,cust.name as customer_name" );
		/* NEW TRIPS MODULE CODE */
		$this->db->from( "tb_orders o" );
		$this->db->join( "tb_order_details d", "o.id=d.order_row_id", "LEFT" );
		$this->db->join( "tb_users tu", "tu.id=o.user_id", "LEFT" );
		$this->db->join( "tb_order_cargodetails c", "o.id=c.order_id", "LEFT" );
		$this->db->join( "tb_cargo_details cx", "c.cargo_id=cx.id", "LEFT" );
        $this->db->join("tb_customers cust", "cust.id=o.customer_id", "LEFT");
		$this->db->join( "tb_employee tbe", "o.order_id=tbe.order_id", "LEFT" );
		$this->db->join( "tb_stop_status s", "o.id=s.order_id AND s.status_code='3000' AND s.status ='1'", "LEFT" );
		$this->db->join( "tb_vendors v", "v.id=o.vendor_id", "LEFT" );


        if ($searchsts == 'SCANNED') {
            $this->db->join("tb_order_status os", "o.id=os.order_id AND os.status_code ='2491'", "INNER");
        }
        if ($searchsts == 'MANIFESTED') {
            $this->db->join("tb_order_status os", "o.id=os.order_id AND os.status_code ='2492'", "INNER");
        }
        $company_code = $this->session->userdata('company_code');
        $this->db->where("o.status !=", 0);
        if (!empty($searchids)) {
            $this->db->where_in("o.order_id", $searchids);
        }
        $permission = checkuserpermissions();
        if (in_array('orders', $permission)) {

            $this->db->where("o.company_code", $company_code);
        } else {
            if ($userid != '0') {
                if (!empty($countryuids)) {
                    $this->db->where_in("o.user_id", $countryuids);
                } else {
                    $this->db->where("o.user_id", $userid);
                }
            }
        }
        if (isset($company_code) && $company_code == 'AUKN' && ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING')) {

            $au_where = "(o.id NOT IN (select order_id from tb_order_status where  order_id=o.id and status_code ='2491'))";
            $this->db->where($au_where);
            /* NEW TRIPS MODULE CODE */
            $wherepen = "(o.trip_id=0 AND o.shift_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
              $this->db->where($wherepen);
            /* NEW TRIPS MODULE CODE */
            //$this->db->where("o.trip_id", 0);
        } else {
            if ($searchsts == 'PENDING' || $searchsts == 'SALOG PENDING') {
                /* NEW TRIPS MODULE CODE */
                 $wherepen = "(o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0)";
                  $this->db->where($wherepen);
                /* NEW TRIPS MODULE CODE */
                //$this->db->where("o.trip_id", 0);
            }
        }

        if ($searchsts == 'SALOG PENDING' || $searchsts == 'SALOG ACTIVE' || $searchsts == 'SALOG CLOSED' || $searchsts == 'SALOG TO BE BILLED') {
            $this->db->where('o.created_source', '5');
        }


        if ($searchsts == 'ACTIVE' || $searchsts == 'SALOG ACTIVE') {
            //$this->db->where("o.trip_id !=", 0);
            /* NEW TRIPS MODULE CODE */
             $whereact="((o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
              $this->db->where($whereact);
            /* NEW TRIPS MODULE CODE */
            $this->db->where("o.trip_sts", 0);
        }
        if ($searchsts == 'CLOSED' || $searchsts == 'SALOG CLOSED') {
            /* NEW TRIPS MODULE CODE */
            /* 	$whereact="((o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0) OR (o.trip_id!=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)=0))";
              $this->db->where($whereact); */
            /* NEW TRIPS MODULE CODE */
            $this->db->where("o.trip_sts", 1);
        }

        if ($searchsts == 'SALOG TO BE BILLED') {
            $salogorders = $this->getsalogtobebilled($countryuids, $userid, $subcusts, $custid);
            if (!empty($salogorders)) {
                $this->db->where_in('o.order_id', $salogorders);
            } else {
                $noordercondition = 1;
            }
        }
        if ($noordercondition == '1') {
            $this->db->where('o.id', 0);
        }

        if ($searchsts == 'SCANNED') {
            $this->db->where("o.trip_id", 0);
            $this->db->where("o.shift_id", 0);
        }
        if ($searchsts == 'MANIFESTED') {
            $this->db->where("o.trip_id", 0);
            $this->db->where("o.shift_id !=", 0);
        }

        if (!empty($subcusts)) {
            $this->db->where_in("o.customer_id", $subcusts);
        } else {
            if ($custid != "") {
                $this->db->where('o.customer_id', $custid);
            }
        }
        $this->db->where($whr);
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon", 'DESC');
        $getorder = $this->db->get();
        if ($getorder->num_rows() > 0) {
            $result = $getorder->result_array();
        }

        return $result;
    }

	/* get reference value Nvs Query */

    public function getReferenceQuery($orderNumbers) {
        $result = [];
        if ($orderNumbers != '') {
            $implode = implode(',',$orderNumbers);
            $ordeIdCondition = "and order_id in ($implode)";
            $sql = "select order_id,GROUP_CONCAT(reference_value SEPARATOR '?????') as reference_value from (
            SELECT order_id,concat(reference_id,' ===== ',ref_value) as reference_value
                FROM tb_order_references ar where
                reference_id IN ('DQ','CTR','MN','LPC','XSR','POS') AND status=1
                $ordeIdCondition
                group by order_id,reference_id
                ) as a
                group by order_id";
            $query = $this->db->query($sql);
            $result = $query->result_array();
        }
        return $result;
    }

    /* get  reference value Nvs Data */

    public function getReferenceData($orderNumbers) {
        $queryDt = $this->getReferenceQuery($orderNumbers);
        $result = [];
        if (!empty($queryDt)) {
            foreach ($queryDt as $val) {
                $result[$val['order_id']] = $val['reference_value'];
            }
        }
        return $result;
    }

    /* get Invoice value Nvs Query */

    public function getInvoiceQuery($orderNumbers) {
        $result = [];
        if ($orderNumbers != '') {
             $implode = implode(',',$orderNumbers);
            $ordeIdCondition = " and order_id in ($implode) ";
            $sql = "select order_id,GROUP_CONCAT(invoice_details order by id desc SEPARATOR '+++++') as invoice_details from
        ( select id, order_id, concat(invoice_details,';',recipient_name,';',amount) as invoice_details
            from ( select id, order_id,concat( type,';',invoice_status) as invoice_details,recipient_name,amount
                from ( SELECT id, order_id, concat ('type','=====',type) as type , concat ('invoice_status','=====',invoice_status) as invoice_status,concat('recipient_name','=====',recipient_name) as recipient_name, concat('amount', '=====', currency,' ',amount) as amount
                    from `tb_reveneus` WHERE  `status` = 1
                    $ordeIdCondition
                    )as invoice_inner1
                ) as invoice_inner2
            ) as invoice_inner3
            group by order_id";
            $query = $this->db->query($sql);
            $result = $query->result_array();
        }
        return $result;
    }

    /* get  Invoice value Nvs Data */

    public function getInvoiceData($orderNumbers) {
        $queryDt = $this->getInvoiceQuery($orderNumbers);
        $result = [];
        if (!empty($queryDt)) {
          foreach ($queryDt as $val) {
          $result[$val['order_id']] = $val['invoice_details'];
            }
        }
        return $result;
    }

	/**
     * This method fetches the data from the tb_reveneus values
     * @param int where conditon elements.
     * @return array
     */
	public function getinternalinvoice($order_id){
		$this->db->select( 'id' );
		$this->db->from( 'tb_reveneus' );
		$this->db->where("type",'0');
		$this->db->where("order_id", $order_id);
		$this->db->where("status", "1");
		$this->db->where("recipient_role", 'Internal BU');
		$res = $this->db->get();
		$result=$res->num_rows();
		return $result;
	}
	
	public function getsmtcorderlistcolumns($user_id,$childid){
		$result = array();
        $this->db->select("osc.id,osc.s_no,osc.ord_id,osc.created_date, osc.delivery_note, osc.salog_ref, osc.pickup, osc.delivery, osc.trip_no, osc.other_status,osc.Stoppage,osc.pickup_date, osc.estimated_delivery_date, osc.delivery_date, osc.mode_of_transport, osc.total_packages,osc.order_jfr, osc.billing_status, osc.actual_weight, osc.weight, osc.actual_volume, osc.volume,osc.company_code, osc.branch_code, osc.from_source, osc.status, osc.customer_name, osc.vendor_name, osc.container_no, osc.pos_ref, osc.loadplanconnote, osc.deliverycity, osc.booking_creat_by, osc.manifest_no, osc.scanned_quantity, osc.no_of_pallets, osc.pod, osc.department,osc.booking_updated_date,osc.vehicle_type,osc.vehicle_number,osc.pq_ref,osc.external_customer");
        $this->db->from("tb_orderlist_spec_cols osc");
        $this->db->join("tb_users u", "osc.user_id = u.id", "LEFT");
        $where = "osc.user_id = $user_id and osc.childid = $childid and osc.is_active = 1 ";
        $this->db->where($where);
        $res = $this->db->get();
        if($res->num_rows() > 0){
			$result = $res->row_array();
		}
		return $result;
	}
	
	public function getallcurrencies(){
		$result = array();
		$this->db->select("currency");
		$this->db->from("tbl_country_master");
		$this->db->where("status","1");
		$this->db->group_by("currency");
		$this->db->order_by("currency","ASC");
		$qry = $this->db->get();
		if($qry->num_rows() > 0){
			foreach($qry->result() as $res){
				$result[] =  $res->currency;
			}
		}
		return $result;
	}

    public function getStopStatusForOrder(array $info): array
    {
        $intransitAllowedSecurelinkCountries = ['CNKN', 'TWKN', 'SGKN', 'MYKN', 'THKN', 'VNKN', 'IDKN', 'IDNKN', 'PHKN', 'HKKN'];
        $groupByCondition = " ";
        if (!in_array($info['orderCompanyCode'], $intransitAllowedSecurelinkCountries)) {
            $groupByCondition = " GROUP BY ts.status_code ";
        }
        $result = [];
        $checkBookedBySupplier = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,convertToClientTZ(ts.createdon,?) as createdon,ts.reason,sm.status_name,ts.comment from tb_stop_status ts,tb_status_master sm WHERE sm.id=ts.status_id AND ts.order_id =? AND ts.status =? AND ts.status_id = ? ORDER BY ts.id DESC LIMIT 1", [$info['timeZone'], $info['orderId'], 1,'9']);
        if($checkBookedBySupplier && $checkBookedBySupplier->num_rows() >0){
            $result[] = ['id'=>$checkBookedBySupplier->row()->id,'latitude'=>$checkBookedBySupplier->row()->latitude,'longitude'=>$checkBookedBySupplier->row()->longitude,'loc_name'=>$checkBookedBySupplier->row()->loc_name,'stop_id'=>$checkBookedBySupplier->row()->stop_id,'stop_type'=>$checkBookedBySupplier->row()->stop_type,'status_code'=>$checkBookedBySupplier->row()->status_code,'createdon'=>$checkBookedBySupplier->row()->createdon,'reason'=>$checkBookedBySupplier->row()->reason,'status_name'=>$checkBookedBySupplier->row()->status_name,'comment'=>$checkBookedBySupplier->row()->comment];

        }
        //$getStopStatus : " . $groupByCondition . "
        $getStopStatus = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,convertToClientTZ(ts.createdon,?) as createdon,ts.reason,sm.status_name,ts.comment from tb_stop_status ts,tb_status_master sm WHERE sm.id=ts.status_id AND ts.order_id =? AND ts.status =? AND ts.status_id != ? ORDER BY ts.id DESC", [$info['timeZone'], $info['orderId'], 1,'9']);
        if($getStopStatus && $getStopStatus->num_rows() >0){
            foreach ($getStopStatus->result_array() as $eachLine) {
                $result[] = ['id'=>$eachLine['id'],'latitude'=>$eachLine['latitude'],'longitude'=>$eachLine['longitude'],'loc_name'=>$eachLine['loc_name'],'stop_id'=>$eachLine['stop_id'],'stop_type'=>$eachLine['stop_type'],'status_code'=>$eachLine['status_code'],'createdon'=>$eachLine['createdon'],'reason'=>$eachLine['reason'],'status_name'=>$eachLine['status_name'],'comment'=>$eachLine['comment']];
            }
        }
        return  $result;
    }
	

}

?>
