<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Standarddocumentmodel extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    public function getOrderReference(int $orderId): string
    {
        $getDqValue = $this->db->select("ref_value")->get_where("tb_order_references", ["order_id" => $orderId, "reference_id" => "DQ"], 1, 0);
        return $getDqValue->num_rows() > 0 ? $getDqValue->row()->ref_value : "";
    }

    public function getOrderLegs(array $data): string
    {
        $legids = "";
        $i = 1;
        $getLegsinfo = $this->common->gettbldata(['id' => $data['orderinfo']['shipment_id']], "shift_leg_id", "tb_shifts", 0, 0);
        if (!empty($getLegsinfo)) {
            foreach ($getLegsinfo as $leg) {
                $legShiftIdRes = $this->db->select("shipmentid")->get_where("tb_shifts", ["id" => $leg['shift_leg_id']], 1, 0);
                if ($legShiftIdRes->num_rows() > 0) {
                    $legshipmentid = $legShiftIdRes->row()->shipmentid;
                    $legids .= "<LegID" . $i . ">" . $legshipmentid . "</LegID" . $i . ">";
                }
            }
        }
        return $legids;
    }
}
