<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Standardstatusmodel extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    public function getLatitudeLongitude(int $lgusrid): array
    {
        $latitudeLongitudes = $this->db->select("latitude,longitude")->get_where("tb_site_settings", ["user_id" => $lgusrid], 1, 0);
        return $latitudeLongitudes->num_rows() > 0 ? $latitudeLongitudes->result() : [];
    }

    public function getshipmentDrivername(int $shiftId): string
    {
        if ($shiftId == 0) {
            return "";
        }
        $this->db->select('ttd.name');
        $this->db->from('tb_shft_veh veh');
        $this->db->join('tb_trips tt', 'veh.vehicle_id=tt.vehicle_id AND veh.shft_id = tt.shift_id');
        $this->db->join('tb_truck_drivers ttd', 'tt.driver_id=ttd.id');
        $this->db->where(['veh.shft_id' => $shiftId, 'veh.status' => 1, 'tt.status' => 1, 'ttd.status' => 1]);
        $orderReference = $this->db->get();
        if (isset($orderReference) && $orderReference->num_rows() > 0) {
            foreach ($orderReference->result_array() as $ores) {
                $driverName = $ores['name'];
            }
        }
        return $driverName ?? "";
    }

    public function getTripInformation(string $bookingId): array
    {
        $this->db->select('o.id AS orderid,o.shift_id,o.trip_id,tsv.carrier_id,tt.`vehicle_id`,tt.`driver_id`,o.company_code,o.branch_code,o.user_id,o.created_source,,o.plat, o.plng');
        $this->db->from('tb_orders o');
        $this->db->join('tb_shft_veh tsv', 'tsv.shft_id=o.shift_id');
        $this->db->join('tb_trips tt', 'o.shift_id= tt.shift_id');
        $this->db->where(['o.order_id' => $bookingId]);
        $tripInformation = $this->db->get();
        return $tripInformation->num_rows() > 0 ? $tripInformation->row_array() : [];
    }

    public function checkTripVehicle(array $vehicleDetails, string $company_code, string $branch_code, int $user_id, int $carrier_id): int
    {
        $vehicleTypeCode = (empty($vehicleDetails['VehicleTypeCode'])) ? "" : $vehicleDetails['VehicleTypeCode'];
        $vehicleModelCode = (empty($vehicleDetails['VehicleModelCode'])) ? "" : $vehicleDetails['VehicleModelCode'];
        $registrationNumber = (empty($vehicleDetails['RegistrationNumber'])) ? "" : $vehicleDetails['RegistrationNumber'];
        if ($registrationNumber == "") {
            return 0;
        }
        $vehicleTypeData = ["trucktype" => $vehicleTypeCode, "company_code" => $company_code, "branch_code" => $branch_code, "user_id" => $user_id, "status" => 1];
        $checkVehicleType = $this->db->select("id")->get_where("tb_trucktypes", $vehicleTypeData, 1, 0);
        if ($checkVehicleType->num_rows() > 0) {
            $vehicleTypeID = $checkVehicleType->row()->id;
        } else {
            $vehicleTypeData["description"] = $vehicleTypeCode;
            $vehicleTypeID = $this->common->insertTableData('tb_trucktypes', $vehicleTypeData);
        }

        $vehicleData = ["register_number" => $registrationNumber, "vendor_id" => $carrier_id, "user_id" => $user_id, "status" => 1];
        $checkVehicle = $this->db->select("id")->get_where("tb_trucks_data", $vehicleData, 1, 0);
        $vehicleData['truck_brand'] = $vehicleModelCode;
        if ($checkVehicle->num_rows() > 0) {
            $vehicleID = $checkVehicle->row()->id;
            $this->db->where(["id" => $vehicleID])->update("tb_trucks_data", $vehicleData);
        } else {
            $vehicleID = $this->common->insertTableData('tb_trucks_data', $vehicleData);
        }

        return $vehicleID ?? 0;
    }

    public function checkTripVehicleDriver(array $driverDetails, int $user_id, int $carrier_id): int
    {
        $driverName = (empty($driverDetails['DriverName'])) ? "" : $driverDetails['DriverName'];
        if ($driverName == "") {
            return 0;
        }
        $driverLicence = (empty($driverDetails['DriverLicence'])) ? "" : $driverDetails['DriverLicence'];
        $driverNationalIdentificationNumber = (empty($driverDetails['DriverNationalIdentificationNumber'])) ? "" : $driverDetails['DriverNationalIdentificationNumber'];
        $driverContactNo = (empty($driverDetails['ContactNo'])) ? "" : $driverDetails['ContactNo'];
        $userCompanyDetails = $this->common->gettblrowdata(['id' => $user_id], "`company_code`,`branch_code`", "tb_users", 0, 0);
        $driverdata = [
            "name" => $driverName,
            "vendor_id" => $carrier_id,
            "company_code" => $userCompanyDetails['company_code'] ?? "",
            "branch_code" => $userCompanyDetails['branch_code'] ?? "",
            "user_id" => $user_id,
            "status" => 1
        ];
        $checkVehicleDriver = $this->db->select("id")->get_where("tb_truck_drivers", $driverdata, 1, 0);
        $driverdata['driver_national_identification_number'] = $driverNationalIdentificationNumber;
        $driverdata['contact_num'] = $driverContactNo;
        $driverdata['driving_licence_num'] = $driverLicence;
        if ($checkVehicleDriver->num_rows() > 0) {
            $driverID = $checkVehicleDriver->row()->id;
            $this->db->where(["id" => $driverID])->update("tb_truck_drivers", $driverdata);
        } else {
            $driverdata['password'] = password_hash($driverContactNo,PASSWORD_DEFAULT);
            $driverID = $this->common->insertTableData('tb_truck_drivers', $driverdata);
        }
        return $driverID ?? 0;
    }

    public function getOrderLastinsertedStatus(int $shift_id, int $orderid): int
    {
        $orderlastStatus = $this->db->query("SELECT id FROM tb_stop_status WHERE order_id= ? AND shipment_id= ? AND `status`=1 ", [$orderid, $shift_id]);
        if ($orderlastStatus->num_rows() > 0) {
            $lastStatusid = $orderlastStatus->row()->id;
        }
        return $lastStatusid ?? 0;
    }

    public function insertOrdeeRemarks(string $remarkCode, string $remarkDescription, array $tripInformation): void
    {
        $checkRemarkCode = $this->db->select("id")->get_where("tbl_remark_types", ["name" => $remarkCode, "status" => 1], 1, 0);
        if ($checkRemarkCode->num_rows() > 0) {
            $remarkCodeID = $checkRemarkCode->row()->id;
        } else {
            $remarksCodeData = ["name" => $remarkCode, "description" => $remarkDescription, "status" => 1];
            $remarkCodeID = $this->common->insertTableData('tbl_remark_types', $remarksCodeData);
        }
        $remarksData = ["order_id" => $tripInformation['orderid'], "remark_id" => $remarkCodeID, "description" => $remarkDescription, "status" => 1];
        $checkRemarks = $this->db->select("id")->get_where("tb_order_remarks", $remarksData, 1, 0);
        if ($checkRemarks->num_rows() > 0) {
            $remarkID = $checkRemarks->row()->id;
            $this->db->where(["id" => $remarkID])->update("tb_order_remarks", $remarksData);
        } else {
            $remarkCodeID = $this->common->insertTableData('tb_order_remarks', $remarksData);
        }
    }

    public function getStatusCodeId(string $statusCode, string $statusName): int
    {
        $currentDate = date('Y-m-d H:i:s');
        $getStatusCode = $this->db->query("SELECT id FROM tb_status_master WHERE status_code =?", [$statusCode]);
        if ($getStatusCode->num_rows() == 0) {
            $statusCodeData = ['status_name' => $statusName, 'description' => $statusName, 'status_type' => 'yes', 'status_code' => $statusCode, 'status' => 1, 'createdon' => $currentDate, 'updatedon' => $currentDate];
            $this->db->insert("tb_status_master", $statusCodeData);
            $statusId = $this->db->insert_id();
        } else {
            $statusId = $getStatusCode->row()->id;
        }
        return $statusId ?? 0;
    }

    public function getOrderInformation(string $party, string $event): array
    {
        if ($party == "Customer") {
            $this->db->select('o.id as orderid,o.order_id as bookingid,`tc`.`id` AS `customer_id`, tc.name as customer_name,`tpm`.`category_type`, `tpe`.`edi_url`, `tta`.`name` AS `ediname`, `tet`.`NAME` AS `ediservice`, `tpe`.`user_name`, `tpe`.`password`');
            $this->db->from('`tb_customers` `tc`');
            $this->db->join('`tb_orders` `o`', 'o.customer_id =tc.id ');
        } else {
            $this->db->select('o.id as orderid,o.order_id as bookingid,`tc`.`id` AS `customer_id`, tc.name as customer_name,`tpm`.`category_type`, `tpe`.`edi_url`, `tta`.`name` AS `ediname`, `tet`.`NAME` AS `ediservice`, `tpe`.`user_name`, `tpe`.`password`');
            $this->db->from('`tb_vendors` `tc`');
            $this->db->join('`tb_orders` `o`', 'o.vendor_id =tc.id ');
        }
        $this->db->join('`tbl_party_master` `tpm`', '`tc`.`code`=`tpm`.`code` AND `tpm`.`status`=1');
        if ($event == "Status") {
            $this->db->join('`tb_party_reference` `tpr`', '`tpm`.`id`=`tpr`.`partner_id` AND `tpr`.`status`=1 AND `tpr`.`name`="STATUS_OUTBOUND" AND tpr.`value`="Y"');
            $this->db->join('`tbl_partner_ediapi` `tpe`', '`tpm`.`id`=`tpe`.`partner_id` AND `tpe`.`status`=1 AND `tpe`.`edi_url`!=""');
            $this->db->join('`tbl_edi_types` `tet`', '`tpe`.`type`=`tet`.`id` AND `tet`.`status`=1');
            $this->db->join('`tbl_txn_actions` `tta`', 'tpe.`transaction_action`=tta.id AND `tta`.`status`=1 AND tta.name = "Order-Status"');
        } else {
            $this->db->join('`tb_party_reference` `tpr`', '`tpm`.`id`=`tpr`.`partner_id` AND `tpr`.`status`=1 AND `tpr`.`name`="DOCUMENT_OUTBOUND" AND tpr.`value`="Y"');
            $this->db->join('`tbl_partner_ediapi` `tpe`', '`tpm`.`id`=`tpe`.`partner_id` AND `tpe`.`status`=1 AND `tpe`.`edi_url`!=""');
            $this->db->join('`tbl_edi_types` `tet`', '`tpe`.`type`=`tet`.`id` AND `tet`.`status`=1');
            $this->db->join('`tbl_txn_actions` `tta`', 'tpe.`transaction_action`=tta.id AND `tta`.`status`=1 AND tta.name = "Order-Documents"');
        }
        $this->db->where(['o.company_code' => "CNKN"]);
        $orderReference = $this->db->get();
        return $orderReference->num_rows() > 0 ? $orderReference->result_array() : [];
    }

    public function getOrderDocuments(array $orderIds, string $partyType): array
    {
        $where = ($partyType == "Customer") ? "AND tpu.`customer_pod_trigger`=0" : "AND tpu.`carrier_pod_trigger`=0";
        $orderDocuments = $this->db->query("SELECT o.id AS orderid,o.user_id, o.order_id,o.company_code,o.branch_code,tpu.id as podrowid,tdt.`document_id`,tdt.`type_name`,tpu.`imgpath`,tpu.`createdon` FROM tb_orders o LEFT JOIN `tb_pod_uploads` tpu ON tpu.order_id=o.id AND tpu.`imgpath`!='' AND tpu.status=1  LEFT JOIN `tb_document_types` tdt ON tdt.id=tpu.`doc_type` WHERE o.id IN ? $where ", [$orderIds]);
        return $orderDocuments->num_rows() > 0 ? $orderDocuments->result_array() : [];
    }

    public function getUserTimeZone(int $user_id): string
    {
        $checkUser = $this->db->query("SELECT country_code FROM tb_users WHERE id=? AND status='Active' LIMIT 1", [$user_id]);
        if ($checkUser->num_rows() > 0) {
            $country_code = $checkUser->row()->country_code;
            $getqry = $this->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE (country_code=? OR country_name=?) AND status=1 LIMIT 1", [$country_code, $country_code]);
            if ($getqry && $getqry->num_rows() > 0) {
                $timeZone = $getqry->row()->cntry_timezone;
            } else {
                throw new RuntimeException("login user's timezone is undefined.");
            }
        }
        return $timeZone;
    }

    public function getInternalCustomersOrderStatusList(array $orderIds, string $partyType): array
    {
        $statusOrderInfo = $statusOrders = [];
        $statusOrderList = $this->getorderStatuses($orderIds, $partyType);
        foreach ($statusOrderList as $orderstatus) {
            $statusOrderInfo[$orderstatus['id']]['status'][] = $orderstatus;
            $statusOrders[] = $orderstatus['id'];
        }

        $statusOrders = array_unique($statusOrders);
        if (!empty($statusOrders)) {
            $getTripinfo = $this->getOrderTripDetails($statusOrders);
            foreach ($getTripinfo as $trips) {
                $statusOrderInfo[$trips['id']]["trip_info"] = $trips;
            }
            $getOrderRemarks = $this->getOrderRemarks($statusOrders);
            foreach ($getOrderRemarks as $remarks) {
                $statusOrderInfo[$remarks['order_id']]["remarks"][] = $remarks;
            }
        }
        return $statusOrderInfo ?? [];
    }

    private function getorderStatuses(array $orderIds, string $partyType): array
    {
        $stopstatuswhere = ($partyType == "Customer") ? "AND tss.`customer_status_trigger`=0" : "AND tss.`carrier_status_trigger`=0";
        $orderstatuswhere = ($partyType == "Customer") ? "AND tos.`customer_status_trigger`=0" : "AND tos.`carrier_status_trigger`=0";

        $orderStatusListResult = $this->db->query("SELECT o.id,tss.id as statusrowid, o.order_id,o.user_id, o.company_code,o.branch_code,tss.status_code,tsm.`status_name`,tss.`stop_type`,tss.`latitude`,tss.`longitude`, tss.`loc_name`,tss.`next_stop_eta`,tss.`next_stop_duration`,tss.`createdon`,tss.reason AS statusdate FROM tb_orders o LEFT JOIN tb_stop_status tss ON tss.`shipment_id`=o.shift_id LEFT JOIN `tb_status_master` tsm ON tss.`status_code`=tsm.status_code AND tss.status_id=tsm.id WHERE o.id IN ? $stopstatuswhere ", [$orderIds]);
        if ($orderStatusListResult->num_rows() > 0) {
            foreach ($orderStatusListResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }
        $orderStatusResult = $this->db->query("SELECT o.id, tos.id as statusrowid, o.order_id,o.company_code,o.branch_code,tos.status_code,tsm.`status_name`,tos.`latitude`,tos.`longitude`,tos.`createdon` AS statusdate FROM tb_orders o LEFT JOIN `tb_order_status` tos ON tos.order_id= o.id LEFT JOIN `tb_status_master` tsm ON tos.`status_code`=tsm.status_code  WHERE o.id IN ? $orderstatuswhere ", [$orderIds]);
        if ($orderStatusResult->num_rows() > 0) {
            foreach ($orderStatusResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }

        return $orderStatusList ?? [];
    }

    private function getOrderTripDetails(array $statusOrders): array
    {
        $orderTripDetailsResult = $this->db->query(
            "SELECT o.id, o.order_id, o.company_code,o.branch_code, ttd.`truck_number`, ttd.`register_number`,ttt.`trucktype`,ttd.`truck_brand`,ttda.`name` AS drivername,ttda.`contact_num` AS drivernumber,ttda.`driver_national_identification_number`,ttda.driving_licence_num  FROM tb_orders o LEFT JOIN tb_shft_veh  tsv ON tsv.shft_id=o.shift_id AND tsv.status=1 LEFT JOIN tb_trips tt ON tt.shift_id = o.shift_id AND tt.status=1 LEFT JOIN `tb_trucks_data` ttd ON ttd.id=tsv.vehicle_id AND ttd.status=1 LEFT JOIN `tb_truck_drivers` ttda ON ttda.id = tt.driver_id AND ttda.status=1 LEFT JOIN  `tb_trucktypes` ttt ON ttt.id=ttd.`truck_type` AND ttt.status=1 WHERE o.id IN ?",
            [$statusOrders]
        );
        return $orderTripDetailsResult->num_rows() > 0 ? $orderTripDetailsResult->result_array() : [];
    }

    private function getOrderRemarks(array $statusOrders): array
    {
        $orderOrderRemarks = $this->db->query(
            "SELECT tor.`order_id`,trt.`name`,tor.`description` FROM `tb_order_remarks` tor LEFT JOIN `tbl_remark_types` trt ON trt.id=tor.`remark_id` WHERE tor.`order_id` IN ?",
            [$statusOrders]
        );
        return $orderOrderRemarks->num_rows() > 0 ? $orderOrderRemarks->result_array() : [];
    }

    public function getExternalCustomersOrderStatusList(array $orderIds, array $externalStatusCode, string $partyType): array
    {
        $statusOrderInfo = $statusOrders = [];
        $statusOrderList = $this->getExternalOrderStatuses($orderIds, $externalStatusCode, $partyType);
        foreach ($statusOrderList as $orderstatus) {
            $statusOrderInfo[$orderstatus['id']]["status"][] = $orderstatus;
            $statusOrders[] = $orderstatus['id'];
        }

        $statusOrders = array_unique($statusOrders);
        if (!empty($statusOrders)) {
            $getTripinfo = $this->getOrderTripDetails($statusOrders);
            foreach ($getTripinfo as $trips) {
                $statusOrderInfo[$trips['id']]["trip_info"] = $trips;
            }

            $getOrderRemarks = $this->getOrderRemarks($statusOrders);
            foreach ($getOrderRemarks as $remarks) {
                $statusOrderInfo[$remarks['order_id']]["remarks"][] = $remarks;
            }
        }
        return $statusOrderInfo ?? [];
    }

    private function getExternalOrderStatuses(array $orderIds, array $externalStatusCode, string $partyType): array
    {
        $stopstatuswhere = ($partyType == "Customer") ? "AND tss.`customer_status_trigger`=0" : "AND tss.`carrier_status_trigger`=0";
        $orderstatuswhere = ($partyType == "Customer") ? "AND tos.`customer_status_trigger`=0" : "AND tos.`carrier_status_trigger`=0";

        $orderStatusListResult = $this->db->query(
            "SELECT o.id,tss.id as statusrowid, o.order_id,o.user_id, o.company_code,o.branch_code,tss.status_code,tsm.`status_name`,tss.`stop_type`,tss.`latitude`,tss.`longitude`, tss.`loc_name`,tss.`next_stop_eta`,tss.`next_stop_duration`,tss.`createdon`,tss.reason AS statusdate FROM tb_orders o LEFT JOIN tb_stop_status tss ON tss.`shipment_id`=o.shift_id LEFT JOIN `tb_status_master` tsm ON tss.`status_code`=tsm.status_code AND tss.status_id=tsm.id  WHERE o.id IN ?  AND tss.`status_code` IN ? $stopstatuswhere",
            [$orderIds, $externalStatusCode]
        );
        if ($orderStatusListResult->num_rows() > 0) {
            foreach ($orderStatusListResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }
        $orderStatusResult = $this->db->query("SELECT o.id, tos.id as statusrowid, o.order_id, o.company_code,o.branch_code,tos.status_code,tsm.`status_name`,tos.`latitude`,tos.`longitude`,tos.`createdon` AS statusdate FROM tb_orders o LEFT JOIN `tb_order_status` tos ON tos.order_id= o.id LEFT JOIN `tb_status_master` tsm ON tos.`status_code`=tsm.status_code  WHERE o.id IN ? AND tos.status_code IN ? $orderstatuswhere", [$orderIds, $externalStatusCode]);
        if ($orderStatusResult->num_rows() > 0) {
            foreach ($orderStatusResult->result_array() as $orders) {
                $orderStatusList[] = $orders;
            }
        }

        return $orderStatusList ?? [];
    }

    public function getExternalStatusCode(string $partyType): array
    {
        $statusWhere = ($partyType == "Customer") ? "customer_view = 1 AND status = 1" : " carrier_view = 1 AND status = 1";
        $getStatusCodes = $this->db->query("SELECT `status_code` FROM `tb_status_master` WHERE $statusWhere");
        if ($getStatusCodes->num_rows() > 0) {
            foreach ($getStatusCodes->result_array() as $statuscodes) {
                $statusCodesList[] = $statuscodes['status_code'];
            }
        }
        return $statusCodesList ?? [];
    }

    public function getOrderCarrierInformation(int $order_id): array
    {
        $this->db->select('o.id as orderid,o.order_id as bookingid,`tc`.`id` AS `customer_id`, tc.name as customer_name,`tpm`.`category_type`, `tpe`.`edi_url`, `tta`.`name` AS `ediname`, `tet`.`NAME` AS `ediservice`, `tpe`.`user_name`, `tpe`.`password`,tpe.authentication');
        $this->db->from('`tb_vendors` `tc`');
        $this->db->join('`tb_orders` `o`', 'o.vendor_id =tc.id ');
        $this->db->join('`tbl_party_master` `tpm`', '`tc`.`code`=`tpm`.`code` AND `tpm`.`status`=1');
        $this->db->join('`tb_party_reference` `tpr`', '`tpm`.`id`=`tpr`.`partner_id` AND `tpr`.`status`=1 AND `tpr`.`name`="DOCUMENT_OUTBOUND" AND tpr.`value`="Y"');
        $this->db->join('`tbl_partner_ediapi` `tpe`', '`tpm`.`id`=`tpe`.`partner_id` AND `tpe`.`status`=1 AND `tpe`.`edi_url`!=""');
        $this->db->join('`tbl_edi_types` `tet`', '`tpe`.`type`=`tet`.`id` AND `tet`.`status`=1');
        $this->db->join('`tbl_txn_actions` `tta`', 'tpe.`transaction_action`=tta.id AND `tta`.`status`=1 AND tta.name = "Order-Documents"');
        $this->db->where(['o.id' => $order_id, 'o.company_code' => "CNKN"]);
        $orderReference = $this->db->get();
        return $orderReference->num_rows() > 0 ? $orderReference->result_array() : [];
    }
    public function getCustomerIdAndCode(string $bookingId): array
    {
        $query = $this->db->query("SELECT c.id,c.name,c.code,c.email_id FROM tb_customers c,tb_orders o WHERE o.customer_id = c.id AND o.order_id = ?", [$bookingId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getCarrierOrderList()
    {
        $carrierOrderList = $this->db->query(
            "SELECT order_id FROM tb_pod_uploads WHERE order_id IN (SELECT id FROM tb_orders WHERE vendor_id IN (SELECT tv.id FROM tb_vendors tv LEFT JOIN tbl_party_master tpm ON tv.code=tpm.code LEFT JOIN tb_party_reference  tbp ON  tbp.`partner_id`=tpm.id AND tbp.name='DOCUMENT_OUTBOUND' AND tbp.status=1 LEFT JOIN tbl_partner_ediapi tpe ON  tpe.`partner_id`=tpm.id AND tpe.status=1 LEFT  JOIN `tbl_edi_types` tet ON tpe.type=tet.id LEFT JOIN `tbl_txn_actions` tta ON tpe.`transaction_action`=tta.id WHERE tta.name='Order-Documents' AND tbp.name='DOCUMENT_OUTBOUND' AND tbp.value='Y') AND company_code='CNKN' AND trip_id!=0 AND trip_sts!=1 ) AND `carrier_pod_trigger`=0 GROUP BY order_id"
        );
        return $carrierOrderList->num_rows() > 0 ? $carrierOrderList->result_array() : [];
    }

    public function getCarrierShipmentList()
    {
        $getCarrierList = $this->db->query("SELECT `condition` FROM access_conditions WHERE title = ? ", ['CHECK_CHINA_CARRIER_FOR_TRIPOUTBOUND_CALL_API']);
        if ($getCarrierList->num_rows() == 0) {
            return [];
        }
        $carrierlist = explode(",",$getCarrierList->row()->condition);
        $tripOutboundshipments= $this->db->query(
            "SELECT o.shift_id FROM tb_orders o LEFT JOIN tb_trips tt ON o.trip_id=tt.id WHERE o.trip_id!=0 AND o.trip_sts!=1 AND tt.`is_carrier_edi_sent`=0 AND o.status NOT IN ? AND o.vendor_id IN ? ORDER BY o.shift_id DESC",[[0,3],$carrierlist]
        );
        //log_message("error","Carrier Query".$this->db->last_query());
        return $tripOutboundshipments->num_rows() > 0 ? $tripOutboundshipments->result_array() : [];
    }


}
