<?php
class Status_code_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*
     * Get status_code by id
     */
    function get_status_code($id)
    {
        return $this->db->get_where('tb_status_codes',array('id'=>$id))->row_array();
    }
    
    /*
     * Get all status_codes count
     */
    function get_all_status_codes_count()
    {
        $this->db->from('tb_status_codes');
        $this->db->where("status","1");
        return $this->db->count_all_results();
    }
        
    /*
     * Get all status_codes
     */
    function get_all_status_codes($params = array())
    {
        $this->db->where("status","1");
        $this->db->order_by('id', 'desc');
        if(isset($params) && !empty($params))
        {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('tb_status_codes')->result_array();
    }
        
    /*
     * function to add new status_code
     */
    function add_status_code($params)
    {
        $this->db->insert('tb_status_codes',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update status_code
     */
    function update_status_code($id,$params)
    {
        $this->db->where('id',$id);
        return $this->db->update('tb_status_codes',$params);
    }
    
    /*
     * function to delete status_code
     */
    function delete_status_code($id)
    {
        return $this->db->where(array('id'=>$id))->update('tb_status_codes',array("status"=>"0"));
    }
}
