<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;

class Status_master_model extends Table
{
    const TABLE = "tb_status_master";

    const ID_COL = "id";
    const STATUS_NAME_COL = "status_name";
    const DESCRIPTION_COL = "description";
    const STATUS_TYPE_COL = "status_type";
    const STATUS_CODE_COL = "status_code";
    const CUSTOMER_ID_COL = "customer_id";
    const COMPANY_CODE_COL = "company_code";
    const BRANCH_CODE_COL = "branch_code";
    const STATUS_COL = "status";
    const CREATEDON_COL = "createdon";
    const UPDATEDON_COL = "updatedon";

    function getsearchdata($whr, $sera)
    {
        if ($sera == 0) {
            $this->db->where("status", 1);
        } else {}
        $this->db->like($whr);
        $this->db->from('tb_status_master');
        $truck = $this->db->get();
        $result = $truck->result_array();
        return $result;
    }

    function selectlist($select, $table, $whr)
    {
        $getcustcode = array();
        $this->db->select($select);
        $this->db->group_by('name');
        $this->db->where($whr);
        $this->db->from($table);
        $res = $this->db->get();
        $getcustcode = $res->result_array();
        return $getcustcode;
    }

    function statuslist($whr, $where)
    {
        $status_list = array();
        $this->db->select("m.id,m.name,sm.*");
        $this->db->from("tb_status_master sm");
        $this->db->like($whr);
        $this->db->where($where);
        $this->db->join("tb_customers m ", "sm.customer_id=m.id", "LEFT");
        $this->db->order_by("sm.id", "DESC");
        $res = $this->db->get();
        $status_list = $res->result_array();
        return $status_list;
    }

    function statusview($where)
    {
        $status_list = array();
        $this->db->select("m.id,m.name,sm.*");
        $this->db->from("tb_status_master sm");
        $this->db->where($where);
        $this->db->join("tb_customers m ", "sm.customer_id=m.id", "LEFT");
        $res = $this->db->get();
        $status_list = $res->row_array();
        return $status_list;
    }
    
    

    /**
     * Given a status code, and optionally a company and branch code,
     * return the model id that *most closely* matches.
     *
     * A status code match is a requirement, but company and branch codes work differently.
     * If branch and company are provided, we will return a match where
     *
     *      status_code = status_code
     *      company_code = company_code
     *      branch_code = branch_code
     *
     * if such a row exists. If it doesn't exist, we will instead attempt
     * to search for a row where
     *
     *      status_code = status_code
     *      company_code = null
     *      branch_code = null
     *
     * and return that row instead.
     *
     * If branch and company codes are not provided, we will only attempt to check
     * for a row matching the second condition.
     *
     * If no row is found, we return null.
     *
     * @param string $status_code
     * @param string $company_code
     * @param string $branch_code
     * @return string
     */
    function get_model_id_from_kn_status_code($status_code, $company_code = null, $branch_code = null)
    {
        if($branch_code && $company_code)
        {
            $result_array = $this->statuslist(
                array('sm.status_code' => $status_code),
                array('sm.company_code' => $company_code, 'sm.branch_code' => $branch_code)
            );

            if(count($result_array) > 0)
            {
                return $result_array[0]['id'];
            }
        }

        $result_array = $this->statuslist(
            array('sm.status_code' => $status_code),
            array('sm.company_code' => NULL, 'sm.branch_code' => NULL)
        );

        if(count($result_array) > 0)
        {
            return $result_array[0]['id'];
        }

        return NULL;
    }

    /**
     * Given a status name, and optionally a company and branch code,
     * return the model id that *most closely* matches.
     *
     * A status name match is a requirement, but company and branch codes work differently.
     * If branch and company are provided, we will return a match where
     *
     *      status_name = status_name
     *      company_code = company_code
     *      branch_code = branch_code
     *
     * if such a row exists. If it doesn't exist, we will instead attempt
     * to search for a row where
     *
     *      status_name = status_name
     *      company_code = null
     *      branch_code = null
     *
     * and return that row instead.
     *
     * If branch and company codes are not provided, we will only attempt to check
     * for a row matching the second condition.
     *
     * If no row is found, we return null.
     *
     * @param string $status_name
     * @param string $company_code
     * @param string $branch_code
     * @return string
     */
    function get_model_id_from_status_name($status_name, $company_code = null, $branch_code = null)
    {
        if($branch_code && $company_code)
        {
            $result_array = $this->statuslist(
                array('sm.status_name' => $status_name),
                array('sm.company_code' => $company_code, 'sm.branch_code' => $branch_code)
            );

            if(count($result_array) > 0)
            {
                return $result_array[0]['id'];
            }
        }

        $result_array = $this->statuslist(
            array('sm.status_name' => $status_name),
            array('sm.company_code' => NULL, 'sm.branch_code' => NULL)
        );

        if(count($result_array) > 0)
        {
            return $result_array[0]['id'];
        }

        return NULL;
    }

    /**
     * Given a primary key (ID), return a named
     * attribute from the specific row.
     *
     * @param int $id
     * @param string $attribute
     * @return string
     */
    function get_attribute($id, $attribute)
    {
        $this->db->select($attribute);
        $this->db->from('tb_status_master');
        $this->db->where(array('id' => $id));
        $res = $this->db->get();
        $status_list = $res->result_array();
        return $status_list[0][$attribute];
    }
}
