<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;

/**
 * Model for table tb_employee, better known as "Stop Details". This table was
 * originally used for employee data but was commandeered for verbose stop data
 * as a through-table (unsure why). This is a through-table to connect orders to
 * legs and the stops that the order has on that leg (there will alwasy be 2 on
 * each leg, pickup and drop).
 */
class Stop_detail extends Table {
    const TABLE = "tb_employee";

    const ID_COL = "id";
    const ASSOC_ID_COL = "assoc_id";
    const PICKUP_COL = "pickup";
    const PLAT_COL = "plat";
    const PLNG_COL = "plng";
    const DROP_COL = "drop";
    const DLAT_COL = "dlat";
    const DLNG_COL = "dlng";
    const PICKUP_CITY_COL = "pickup_city";
    const DROP_CITY_COL = "drop_city";
    const PICKUP_DATETIME_COL = "pickup_datetime";
    const DROP_DATETIME_COL = "drop_datetime";
    const NAME_COL = "name";
    const PHONE_COL = "phone";
    const ADDRESS_COL = "address";
    const IMG_COL = "img";
    const EMAILID_COL = "emailid";
    const USER_ID_COL = "user_id";
    const PASSWORD_COL = "password";
    const ALTR_NUM_COL = "altr_num";
    const STATUS_COL = "status";
    const GCM_ID_COL = "gcm_id";
    const CREATEDON_COL = "createdon";
    const UPDATEDON_COL = "updatedon";
    const MATERIAL_ID_COL = "material_id";
    const CAPACITY_COL = "capacity";
    const INFORMATION_COL = "information";
    const SHIPMENT_WEIGHT_COL = "shipment_weight";
    const SHIPMENT_VOLUME_COL = "shipment_volume";
    const SHIP_TYPE_COL = "ship_type";
    const CUSTOMER_ID_COL = "customer_id";
    const VENDOR_ID_COL = "vendor_id";
    const SHIPMENT_ID_COL = "shipment_id"; // FK to tb_shifts
    const STARTDATE_COL = "startdate";
    const ENDDATE_COL = "enddate";
    const SHIFT_ID_COL = "shift_id"; // FK to tb_shifts
    const STOP_ORDER_COL = "stop_order";
    const DROP_ORDER_COL = "drop_order";
    const BASIC_STOP_COL = "basic_stop";
    const STOP_ID_COL = "stop_id"; // FK to tb_shiporder_stops where stop type is pickup
    const DROP_STOPID_COL = "drop_stopid"; // FK to tb_shiporder_stops where stop type is drop
    const ORDER_ID_COL = "order_id"; // FK to tb_orders on the orderid column (NOT to id)
    const PKGITEMID_COL = "pkgitemid";
    const NO_OF_PKGS_COL = "no_of_pkgs";
    const DOMAINNAME_COL = "domainname";
    const ACCEPTED_COL = "accepted";
    const VEHICLE_TYPE_COL = "vehicle_type";
    const VEHICLE_ID_COL ="vehicle_id";
    const DRIVER_ID_COL = "driver_id";
    const TRIP_ID_COL = "trip_id"; // FK to tb_shifts

    /**
     * Get data for a WHERE clause
     *
     * @param array $where
     * @param int $limit
     * @param boolean $active_only
     * @return CI_DB_result
     */
    public function get_where(array $where, int $limit = NULL, bool $active_only = TRUE)
    {
        if( $active_only ) { $where[self::STATUS_COL] = 1; }
        return $this->db->get_where(self::TABLE, $where, $limit);
    }

    /**
     * SELECT data from the table given WHERE clause.
     *
     * @param array $select
     * @param array $where
     * @param boolean $active_only
     * @return CI_DB_result
     */
    public function select(array $select, array $where, bool $active_only = TRUE)
    {
        if( $active_only ) { $where[self::STATUS_COL] = 1; }
        $this->db->select($select);
        $this->db->from(self::TABLE);
        $this->db->where($where);
        return $this->db->get();
    }

    /**
     * Get the ID of the employee row related
     * to the specific pickup and drop shiporder_stop rows.
     *
     * @param integer $pickup_id
     * @param integer $drop_id
     * @return integer
     */
    public function get_id_for_stops(int $pickup_id,
                                     int $drop_id)
    {
        $where = array(
            'stop_id' => $pickup_id,
            'drop_stopid' => $drop_id,
        );

        $this->db->select('id');
        $this->db->from(self::TABLE);
        $this->db->where($where);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();

        if( !$query->num_rows() )
            throw new Exception('employee not found for stops ' . $pickup_id . ' and ' . $drop_id);

        return $query->result()[0]->id;
    }

    /**
     * Get the ID of all the rows that show the stops for an order on a shift.
     *
     * @param integer $order_id
     * @param integer $shift_id
     * @param boolean $active_only
     * @return array array of arrays. empty if no matching stops.
     */
    public function get_stop_ids_for_order_on_shift(string $order_id,
                                                    int $shift_id,
                                                    bool $active_only = TRUE)
    {
        $where = array(
            self::ORDER_ID_COL => $order_id,
            self::SHIFT_ID_COL => $shift_id,
        );

        $results = $this->find(
            $where,
            array(
                self::ID_COL,
                self::STOP_ID_COL,
                self::DROP_STOPID_COL
            ),
            [],
            $active_only
        );

        $ret_val = array(NULL, NULL);
        if( !count($results) )
            return $ret_val;

        foreach($results as $emp)
        {
            $ret_val[0] = $emp->{self::STOP_ID_COL};
            $ret_val[1] = $emp->{self::DROP_STOPID_COL};

            if($ret_val[0] && $ret_val[1])
            {
                break;
            }
        }
        return $ret_val;
    }
}
