<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\Table;

class Stop_status extends Table {
    const TABLE = "tb_stop_status";

    const ID_COL = "id";
    const ORDER_ID_COL = "order_id";
    const SHIPMENT_ID_COL = "shipment_id";
    const STOP_ID_COL = "stop_id";
    const STOP_DETAIL_ID_COL = "stop_detail_id";
    const STOP_TYPE_COL = "stop_type";
    const TRIP_ID_COL = "trip_id";
    const STATUS_ID_COL = "status_id";
    const LATITUDE_COL = "latitude";
    const LONGITUDE_COL = "longitude";
    const LOC_NAME_COL = "loc_name";
    const STATUS_CODE_COL = "status_code";
    const STATUS_STAGE_COL = "status_stage";
    const STATUS_COL = "status";
    const REASON_COL = "reason";
    const VEHICLE_ID_COL = "vehicle_id";
    const DRIVER_ID_COL = "driver_id";
    const SENTKNLOGIN_COL = "sentknlogin";
    const CREATEDON_COL = "createdon";
    const UPDATEDON_COL = "updatedon";

    public function fetchStopStatusesByOrderId(int $orderId):array {
        $results = [];
        $query = $this->db->query(
            "SELECT *
                FROM tb_stop_status
                WHERE order_id = ?
                ORDER BY id DESC",
            [$orderId]
        );
        foreach ($query->result() as $row) {
            $results [] = $row;
        }

        return $results;
    }

    public function filterResults(array $input, int $status, array $allowedStatusCodes = []): array {
        $results = [];

        foreach ($input as $row) {
            if (((int) ($row->status ?? $row['status'])) !== $status) {
                continue;
            }
            if (!in_array(($row->status_code ?? $row['status_code']), $allowedStatusCodes, true)) {
                continue;
            }
            $results [] = $row;
        }

        return $results;
    }
}
