<?php
class Tatkpimodel extends CI_Model
{
    public function getReports(string $where,array $bindParams,int $limit,int $offset): array
    {
        $businessType = $this->session->userdata("business_type");
        if ($businessType == "Carrier") {
            $carrierId = $this->session->userdata("id");
            $where .= " and tr.vendor_id = ? ";
            $bindParams[] = $carrierId;
        } elseif ($businessType == "Customer") {
            $customerId = $this->session->userdata("cust_id");
            $where .= " and s.customer_id = ? ";
            $bindParams[] = $customerId;
        } else {
            $userId = (int) $this->session->userdata('user_id');
            if ($userId > 0) {
                $where .= " and o.user_id = ? ";
                $bindParams[] = $userId;
            }
        }        
        $timeZone = $this->session->userdata("usr_tzone")['timezone'];
        if ($businessType == "Customer") {
            $query = "SELECT 
                        trip.shift_id,
                        t.register_number,
                        o.id,
                        o.order_id,
                        o.pickup_datetime, 
                        o.delivery_datetime, 
                        o.pickup_endtime, 
                        o.drop_endtime,
                        o.createdon,
                        IFNULL(t.truck_capacity,0) AS tcapacity,
                        o.trip_id,
                        o.shipmentid,
                        convertToClientTZ(tr.start_time,?) AS start_time,
                        convertToClientTZ(tr.end_time,?) AS end_time,
                        us.name,
                        us.contact_num,
                        (
                            SELECT
                                ish.etime 
                            FROM
                                tb_trips it,
                                tb_shifts ish 
                            WHERE it.id=tr.trip_id and ish.id=it.shift_id
                        ) AS dvrlate 
                        FROM
                        tb_orders o
                        LEFT JOIN tb_trips trip ON (trip.id = o.trip_id)
                        LEFT JOIN tb_trip_summary tr ON (trip.id = tr.trip_id)
                        LEFT JOIN tb_truck_drivers us ON (us.id = trip.driver_id)
                        LEFT JOIN tb_trucks_data t ON (trip.vehicle_id=t.id)
                        LEFT JOIN tb_shifts s ON (s.id=trip.shift_id)
                        {$where}
                        ORDER BY 
                        o.createdon DESC";
        } else {
            $query = "SELECT 
                          trip.shift_id,
                          t.register_number,
                          o.id,
                          o.order_id,
                          o.pickup_datetime, 
                          o.delivery_datetime, 
                          o.pickup_endtime, 
                          o.drop_endtime,
                          o.createdon,
                          IFNULL(t.truck_capacity, 0) AS tcapacity, 
                          o.trip_id,
                          o.shipmentid,
                          convertToClientTZ(
                            tr.start_time, ?
                          ) AS start_time, 
                          convertToClientTZ(tr.end_time, ?) AS end_time, 
                          us.name, 
                          us.contact_num, 
                          (
                            SELECT 
                              ish.etime 
                            FROM 
                              tb_trips it, 
                              tb_shifts ish 
                            WHERE 
                              it.id = tr.trip_id 
                              and ish.id = it.shift_id
                          ) AS dvrlate 
                        FROM 
                        tb_orders o
                        LEFT JOIN tb_trips trip ON (trip.id = o.trip_id)
                        LEFT JOIN tb_trip_summary tr ON (trip.id = tr.trip_id)
                        LEFT JOIN tb_truck_drivers us ON (us.id = trip.driver_id)
                        LEFT JOIN tb_trucks_data t ON (trip.vehicle_id=t.id)
                        LEFT JOIN tb_shifts s ON (s.id=trip.shift_id)
                        {$where}
                        ORDER BY 
                        o.createdon DESC";
        }
        if ($limit > 0) {
            $query .= " LIMIT ".$offset.", ".$limit;
        }
        $getResults = $this->db->query($query, $bindParams);
        return ($getResults->num_rows() > 0) ? $getResults->result_array() : [];
    }

    public function getTripStopDateTimeInfo(int $orderId, int $tripId, string $timeZone): array
    {
        $actualPickup = $actualDelivery ="";
        $sql = "SELECT convertToClientTZ(`createdon`,?) as `createdon` FROM `tb_stop_status` WHERE status = ? AND order_id = ? AND trip_id = ? AND status_code = ?";
        $actualPickupQry = $this->db->query($sql,[$timeZone, 1, $orderId, $tripId,'0500']);
        if ($actualPickupQry->num_rows() > 0)
        {
            $actualPickup = $actualPickupQry->row()->createdon;
        }
        $actualDeliveryQry = $this->db->query($sql,[$timeZone, 1, $orderId, $tripId,'2300']);
        if ($actualDeliveryQry->num_rows() > 0)
        {
            $actualDelivery = $actualDeliveryQry->row()->createdon;
        }
        return ['pickup'=>$actualPickup ,'delivery'=>$actualDelivery];
    }

    public function getCountryUserTripIds($user_id, $countryids, $searchTerm): array
    {
        $companyCode = $this->session->userdata('company_code');
        $where = " WHERE status != ? AND trip_id LIKE ?";
        $bindParam = [0, sprintf('%s%%', $searchTerm)];
        if (!empty($countryids))
        {
            $where .= " AND user_id IN ?";
            $bindParam[] = $countryids;
        }
        $getResults = $this->db->query("SELECT trip_id FROM tb_orders {$where} ORDER BY createdon DESC", $bindParam);
        return $getResults->num_rows() ? $getResults->result_array() : [];
    }

    public function getTripIds(int $user_id, array $custid, string $searchTerm): array
    {
        $companyCode = $this->session->userdata('company_code');
        $where = " WHERE status != ? AND shipmentid IS NOT NULL AND shipmentid LIKE ?";
        $bindParam = [0, sprintf('%s%%', $searchTerm)];
        if (!empty($custid)) {
            $where .= " AND customer_id IN ?";
            $bindParam[] = $custid;
        } else {
            $permission = checkuserpermissions();
            if (in_array("orders", $permission))
            {
                $companyCode = $this->session->userdata('company_code');
                $where .= " AND company_code = ?";
                $bindParam[] = $companyCode;
            }
            else
            {
                $where .= " AND user_id = ?";
                $bindParam[] = $user_id;
            }
        }
        $getResults = $this->db->query("SELECT shipmentid FROM tb_orders {$where} ORDER BY createdon DESC", $bindParam);
        return $getResults->num_rows() ? $getResults->result_array() : [];
    }
}