<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class TrackingService_model extends CI_model
{

    public function __construct()
    {
        parent::__construct();
    }

    // the below method will give the order details.
    public function getOrderDetails($searchString)
    {
        $data = array();
        if ($searchString != '') {
            /*$this->db->select("d.order_status as order_detail_status,o.id,o.order_id,o.pickup_datetime,o.delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,
                o.company_code,o.branch_code,o.shipment_id,o.status,o.order_status,o.trip_sts,o.shift_id,o.trip_id,
                o.shipmentid,o.createdon,o.weight as totwg,o.volume as totvol,o.quantity as totqty,
                ot.type_name as order_type_name");*/
            $this->db->select(
                "o.id,o.order_id,o.shift_id,o.user_id,o.pickup_pincode,o.delivery_pincode,
                o.pickup_address1,o.pickup_address2,o.delivery_address1,o.delivery_address2,o.pickup_city,
                o.pickup_country,o.delivery_city,o.delivery_country,o.pickup_datetime,o.delivery_datetime,
                o.plat,o.plng,o.dlat,o.dlng,o.createdon,o.company_code,o.trip_sts,u.country_code,
                ot.type_name as order_type_name,o.branch_code,o.company_code,o.created_source,o.quantity,o.weight,o.volume"
            );
            $this->db->from("tb_orders o");
            $this->db->join("tb_users u", "o.user_id=u.id", "inner join");
            $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
            $this->db->join(
                "tb_order_types ot",
                "ot.id=d.order_type and  ot.company_code=o.company_code and  ot.status=1",
                "LEFT"
            );
            $this->db->where("o.status !=", 0);
            $this->db->where("o.order_id", $searchString);

            $getorder = $this->db->get();
            if ($getorder->num_rows() > 0) {
                $data = $getorder->result_array();
            }
        }
        return $data;
    }

    // the below method will give the order details.
    /*public function getOrderInfoDetails($searchString)
    {
        $data = array();
        if ($searchString != '') {
            $this->db->select(
                "id,order_id,shift_id,user_id,pickup_pincode,delivery_pincode,
                pickup_address1,pickup_address2,delivery_address1,delivery_address2,pickup_city,
                pickup_country,delivery_city,delivery_country,pickup_datetime,delivery_datetime,
                plat,plng,dlat,dlng,createdon,company_code,trip_sts,branch_code,company_code,created_source,quantity,weight,volume,product,vendor_id"
            );
            $this->db->from("tb_orders");
            $this->db->where("status !=", 0);
            $this->db->where("order_id", $searchString);
            $this->db->limit(1);
            $getorder = $this->db->get();
            if ($getorder->num_rows() > 0) {
                $data = $getorder->row_array();
            }
        }
        return $data;
    }*/
    
    public function getOrderInfoDetails($searchString): array
    {
        $data = array();
        if ($searchString != '') {
            $shift_query = $this->db->select('shift_id')
                ->from('tb_orders')
                ->where('order_id', $searchString)  // confirm field name
                ->get();

            $shift_id = $shift_query ? $shift_query->row_array() : [];
            $shift_id = $shift_id['shift_id'] ?? null;
            $shift_arr = [];
            //log_message('error', 'shift_id' . json_encode($shift_id));
            if (!empty($shift_id) and $shift_id != "0") {
                $query = $this->db->select('ts.id')
                    ->from('tb_shifts ts')
                    ->join('tb_orders o', 'o.shift_id = ts.shift_leg_id')
                    ->where('o.order_id', $searchString)
                    ->get()
                    ->result_array();

                $shift_arr = array_column($query, 'id');
            }

            $legCoords = [];
            if (count($shift_arr) > 0) {
                //log_message('error', 'ids_shifts:' . print_r($shift_arr, true));
                $legCoords = $this->getCoordsByShiftd($shift_arr);
            }
            $this->db->select(
                "id,order_id,shift_id,user_id,pickup_pincode,delivery_pincode,
                pickup_address1,pickup_address2,delivery_address1,delivery_address2,pickup_city,
                pickup_country,delivery_city,delivery_country,pickup_datetime,delivery_datetime,
                plat,plng,dlat,dlng,createdon,company_code,trip_sts,branch_code,company_code,created_source,quantity,weight,volume,product,vendor_id,transport_mode as tmode,shift_id"
            );
            $this->db->from("tb_orders");
            $this->db->where("status !=", 0);
            $this->db->where("order_id", $searchString);
            $this->db->limit(1);
            $getorder = $this->db->get();
            if ($getorder->result_array() > 0) {
                $data = $getorder->row_array();
            }
        }
        $data['legs'] = $legCoords;
        //log_message('error', 'map_data:' . print_r($data, true));
        return $data;
    }

    public function getCoordsByShiftd($shift_ids): array
    {
        $query = $this->db->select('splace,eplace,transport_mode,slat,slng,elat,elng')
            ->from('tb_shifts')
            ->where_in('id', $shift_ids)
            ->get();

        $latLngArr = $query->result_array();
        return $latLngArr;
    }

    /*the below method will fetch the users timezone based on the user id country code*/
    public function getUserTimezone($userid)
    {
        $curtz = 'Asia/Singapore';
        if ($userid != '') {
            $sql = "SELECT country_code FROM tb_users WHERE id=$userid LIMIT 1";
            $getdata = $this->db->query($sql);
            if ($getdata->num_rows() > 0) {
                $countryCode = $getdata->row()->country_code;
                $cntryqry = "SELECT cntry_timezone FROM tbl_country_master WHERE country_code='$countryCode' AND cntry_timezone !='' AND status=1 LIMIT 1";
                $getcntrydata = $this->db->query($cntryqry);
                if ($getcntrydata->num_rows() > 0) {
                    $curtz = $getcntrydata->row()->cntry_timezone;
                }
            }
        }
        return $curtz;
    }

    // the below method will return invoice numbers associated with the order number
    public function getInvoiceNumbers($orderId)
    {
        $invoice_number = '';
        if ($orderId != '') {
            $this->db->select("group_concat(distinct(invoice_number)) as invoice_number");
            $this->db->from("tb_reveneus r");
            $this->db->where("order_id", $orderId);
            $getdata = $this->db->get();
            if ($getdata->num_rows() > 0) {
                $data = $getdata->result_array();
                if (isset($data) && !empty($data) && sizeof($data) > 0) {
                    $invoice_number = $data[0]['invoice_number'];
                }
            }
        }
        return $invoice_number;
    }

    // the below method will retrn the vehicle details
    public function getVehicleDetails($shiftId)
    {
        $sql = "select ttt.trucktype,ttd.latitude,ttd.longitude,ttd.truck_number from tb_trips ttr
        left join tb_trucks_data ttd on ttd.id=ttr.vehicle_id
        left join tb_trucktypes ttt on ttt.id=ttd.truck_type
        where ttr.shift_id='$shiftId' group by shift_id";
        $dat = $this->db->query($sql);
        if ($dat->num_rows() > 0) {
            $result = $dat->result_array();
            return $result[0];
        }
    }

    // the below method will return various order status of a shipment based on order id
    public function getOrderStatusDetails($orderId, $statusCodes = '')
    {
        $result = [];
        $sql = " SELECT distinct sm.id, sm.status_icon, sm.status_name,tps.status_code,tps.createdon,tps.stop_type,tps.latitude,tps.longitude,tps.loc_name
        FROM tb_stop_status tps
        inner join tb_status_master sm on sm.id=tps.status_id
        where tps.status=1 and order_id = '$orderId' and tps.status_code!='' order by tps.id asc ";
        $dat = $this->db->query($sql);
        if ($dat->num_rows() > 0) {
            $result = $dat->result_array();
        }
        return $result;
    }

    // the below method will return various order status of a shipment based on order id for uniqlo
    public function getOrderStatusDetailsNew($orderId, $ordtype)
    {
        $result = array();
        if ($ordtype == '15') {
            $sql = "SELECT scan_datetime,CASE
                WHEN scan_type='UD' AND scan_val IN ('Manifested', 'Not Picked','Pending','Assigned','Out-For-Pickup','Pickup-Failed') THEN 'Pickup Pending'
                WHEN scan_type='UD' AND scan_val IN ('In Transit', 'At-Hub','Moving-To-Hub','Picked','Assigned-At-Hub') THEN 'In Transit'
                WHEN scan_type='UD' AND scan_val IN ('Dispatched','Attempted','In-Progress','Assigned-to-Out-for-delivery') THEN 'Out for delivery'
                WHEN scan_type='RT' AND scan_val IN ('Dispatched','Moving-to-Origin') THEN 'Out for Return'
                WHEN scan_type='RT' AND scan_val IN ('In Transit', 'Pending','Returned-to-Origin','Returned-to-Origin-Failed','At-Hub-RTO') THEN 'Return In Transit'
                WHEN scan_type='DL' AND scan_val IN ('Delivered','Complete') THEN 'Delivered'
                WHEN scan_type='DL' AND scan_val IN ('RTO','Returned') THEN 'RTO Delivered'
                WHEN scan_type='LT' AND scan_val='LOST' THEN 'Lost'
                END AS scan_value,
                GROUP_CONCAT(DISTINCT scan_status_time,'###',scan_location,'###',scan_instruction SEPARATOR '---') as status_info
                FROM `tb_uniqlo_order_scans`
                WHERE `order_id` = " . $orderId . " GROUP BY scan_value ORDER BY scan_status_time ASC";
        } else {
            $sql = "SELECT scan_datetime,CASE
                WHEN ((scan_type='PP' AND scan_val IN ('Open', 'Dispatched')) OR (scan_type IN ('PP','PU') AND scan_val='Scheduled')) THEN 'Pickup Pending'
                WHEN scan_type='PU' AND scan_val IN ('In Transit') THEN 'In Transit'
                WHEN scan_type='PU' AND scan_val IN ('Pending') THEN 'Pending'
                WHEN scan_type='PU' AND scan_val='Dispatched' THEN 'Out for delivery'
                WHEN scan_type IN('DL','DTO') AND scan_val in('DTO', 'Delivered') THEN 'Delivered'
                WHEN scan_type='PP' AND scan_val='Canceled' THEN 'Cancelled'
                WHEN scan_type='CN' AND scan_val='Canceled' THEN 'Pickup Cancelled'
                WHEN scan_type='CN' AND scan_val='Closed' THEN 'Closed'
                WHEN scan_type='LT' AND scan_val='LOST' THEN 'Lost'
                END AS scan_value,
                GROUP_CONCAT(DISTINCT scan_status_time,'###',scan_location,'###',scan_instruction SEPARATOR '---') as status_info
                FROM `tb_uniqlo_order_scans`
                WHERE `order_id` = " . $orderId . " GROUP BY scan_value ORDER BY scan_status_time ASC";
        }
        $dat = $this->db->query($sql);
        if ($dat->num_rows() > 0) {
            $result = $dat->result_array();
        }
        return $result;
    }

    /*get the various order status of a shipment based on ecom carrier order id for uniqlo*/
    public function getEcomOrderStatusDetailsNew($orderId, $ordtype, $rtoType=null)
    {
        $result = array();
        if ($ordtype == '15') {
            $sql = $this->getSalesOrderEcomStatusQuery( $orderId, $rtoType );
        } else {
            $sql = $this->getReturnOrderEcomStatusQuery( $orderId );
        }
        $dat = $this->db->query($sql);
        if ($dat->num_rows() > 0) {
            $result = $dat->result_array();
        }
        return $result;
    }

    private function getSalesOrderEcomStatusQuery($orderId, $rtoType)
    {
        $rtoDeliveredStatusCode = $outForReturnStatusCode = $returnInTransitStatusCode = [];
        $pendingStatusCode = [
            '100',
            '207',
            '210',
            '212',
            '213',
            '214',
            '215',
            '216',
            '217',
            '218',
            '219',
            '220',
            '221',
            '222',
            '223',
            '224',
            '225',
            '226',
            '227',
            '228',
            '228',
            '229',
            '231',
            '232',
            '234',
            '236',
            '331',
            '1224',
            '1225',
            '12241',
            '12242',
            '12243',
            '12244',
            '12245',
            '12246',
            '12247',
            '20701',
            '21004',
            '21501',
            '21502',
            '21503',
            '21701',
            '22101',
            '22102',
            '22103',
            '22104',
            '22105',
            '22106',
            '22107',
            '22301',
            '22303',
            '22701',
            '22702',
            '22703',
            '22801',
            '22901',
            '22902',
            '22903',
            '23101',
            '23102',
            '23103',
            '23201',
            '23202',
            '23401',
            '23402',
            '24203',
            '30001',
            '30101',
            '30204',
            '32101',
            '32102',
            '32103',
            '34601',
            '005'
        ];
        $pickupPendingStatusCode = ['310', '001', '1220', '1230'];
        $inTransitStatusCode = ['216', '229', '302', '302', '303', '317', '0011', '002'];
        $outForDeliveryStatusCode = ['006'];
        $deliveredStatusCode = ['239', '999', '20002', '20003'];
        $lostStatusCode = ['333', '888', '33301', '33302', '33303', '33304', '33305', '33306', '33307'];
        $cancelStatusCode = ['21002', '1330'];

        $orderBy = "scan_status_time ASC";

        if ($rtoType != "") {
            $lostStatusCode = ['333', '888'];
            $rtoDeliveredStatusCode = ['999'];
            $outForReturnStatusCode = ['006'];
            $returnInTransitStatusCode = ['216', '777', '22903', '32101', '32102', '32103', '32104', '002', '005'];

            $orderBy = "FIELD(scan_value,'Pickup Pending','In Transit','Out for Delivery','Return In Transit','Delivered','Lost'),scan_status_time ASC";
        }

        $allStatusCode = array_unique(
            array_merge(
                $pendingStatusCode,
                $pickupPendingStatusCode,
                $inTransitStatusCode,
                $outForDeliveryStatusCode,
                $deliveredStatusCode,
                $lostStatusCode,
                $cancelStatusCode,
                $rtoDeliveredStatusCode,
                $outForReturnStatusCode,
                $returnInTransitStatusCode
            )
        );

        return "SELECT scan_datetime,CASE
                WHEN scan_status_code IN ('" . implode("','", $pendingStatusCode) . "') THEN 'Pending'
                WHEN scan_status_code IN ('" . implode("','", $pickupPendingStatusCode) . "') THEN 'Pickup Pending'
                WHEN scan_status_code IN ('" . implode("','", $inTransitStatusCode) . "') THEN 'In Transit'
                WHEN scan_status_code IN ('" . implode("','", $outForDeliveryStatusCode) . "') THEN 'Out for Delivery'
                WHEN scan_status_code IN ('" . implode("','", $deliveredStatusCode) . "') THEN 'Delivered'
                WHEN scan_status_code IN ('" . implode("','", $outForReturnStatusCode) . "') THEN 'Out for Return'
                WHEN scan_status_code IN ('" . implode("','", $returnInTransitStatusCode) . "') THEN 'Return In Transit'
                WHEN scan_status_code IN ('" . implode("','", $rtoDeliveredStatusCode) . "') THEN 'RTO Delivered'
                WHEN scan_status_code IN ('" . implode("','", $lostStatusCode) . "') THEN 'Lost'
                WHEN scan_status_code IN ('" . implode("','", $cancelStatusCode) . "') THEN 'Canceled'
                END AS scan_value, GROUP_CONCAT(scan_status_time,'###',IFNULL(scan_location,''),'###',scan_instruction,'###',scan_status_code,'###',scan_val SEPARATOR '---') as status_info FROM `tb_uniqlo_order_scans` WHERE `order_id` = " . $orderId . " AND scan_val != '' AND scan_status_code in('" . implode(
                "','",
                $allStatusCode
            ) . "') GROUP BY scan_value ORDER BY $orderBy";
    }

    private function getReturnOrderEcomStatusQuery($orderId)
    {
        $pickupPendingStatusCode = [
            '412',
            '417',
            '418',
            '419',
            '401',
            '402',
            '403',
            '405',
            '406',
            '407',
            '408',
            '409',
            '410',
            '411',
            '413',
            '414',
            '415',
            '421',
            '422',
            '423',
            '424',
            '425',
            '426'
        ];
        $pickupCancelledStatusCode = ['420'];
        $inTransitStatusCode = [
            '416',
            '221',
            '450',
            '22101',
            '22102',
            '22103',
            '22104',
            '22105',
            '22106',
            '22107',
            '22903'
        ];
        $canceledStatusCode = ['404', '427', '430'];

        $allStatusCode = array_unique(
            array_merge(
                $pickupPendingStatusCode,
                $pickupCancelledStatusCode,
                $inTransitStatusCode,
                $canceledStatusCode
            )
        );

        return "SELECT scan_datetime,CASE
                WHEN scan_status_code IN ('" . implode("','", $pickupPendingStatusCode) . "') THEN 'Pickup Pending'
                WHEN scan_status_code IN ('" . implode("','", $pickupCancelledStatusCode) . "') THEN 'Pickup Cancelled'
                WHEN scan_status_code IN ('" . implode("','", $inTransitStatusCode) . "') THEN 'In Transit'
                WHEN scan_status_code IN ('" . implode("','", $canceledStatusCode) . "') THEN 'Canceled'
                END AS scan_value, GROUP_CONCAT(scan_status_time,'###',IFNULL(scan_location,''),'###',scan_instruction,'-',scan_val SEPARATOR '---') as status_info FROM `tb_uniqlo_order_scans` WHERE `order_id` = " . $orderId . " AND scan_status_code in('" . implode(
                "','",
                $allStatusCode
            ) . "') GROUP BY scan_value ORDER BY scan_status_time ASC";
    }

    // the below method will return the driver acceptance and delivered status based on shift id
    public function getDriverAcceptanceAndDeliveredStatus($shiftId)
    {
        $result = [];
        $sql = " select distinct sm.status_name,tps.status_code,tps.createdon,tps.stop_type,tps.loc_name,tps.latitude,tps.longitude
        from  `tb_stop_status` tps
        inner join tb_status_master sm on sm.id=tps.status_id
        where  tps.shipment_id in ($shiftId) AND  tps.shipment_id !=0 
        
        order by tps.id ASC ";
        $dat = $this->db->query($sql);
        //log_message('error',"Qry:".$this->db->last_query());
        if ($dat->num_rows() > 0) {
            $result = $dat->result_array();
        }
        return $result;
    }
    
   // AND tps.status_code in ('3000','0212','0100', 'SV0100', 'SV0120', 'SV0130','SV0131','SV0140','SV0210','SV0220','SV0230','SV0310','SV0410','SV0510')

    // the below method will return the package related information such as weight, volume, quantity etc
    public function getWeightAndVolumeCount($orderId)
    {
        $result = array();
        if ($orderId != '') {
            $sql = "SELECT sum(c.weight) as weight,sum(c.second_weight) as second_weight,sum(c.volumetric_weight) as volumetric_weight,sum(c.quantity) as quantity,sum(c.volume) as volume,cd.weight_unit,cd.volume_unit,cd.cargo_type
            FROM tb_order_cargodetails c
            inner join tb_cargo_details cd on c.cargo_id=cd.id
            where c.status=1 and c.order_id>0  and c.order_id ='$orderId' group by c.order_id";
            //echo $sql;exit;
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                $result = $result[0];
            }
        }
        return $result;
    }

    /*the below method will return the order info based on the order ref value*/
    public function getOrderInfoFromReference($trackingNum)
    {
        $result = array();
        $sql = "select order_id,reference_id from tb_order_references where ref_value='" . $trackingNum . "' AND status=1 LIMIT 1";
        $res = $this->db->query($sql);
        if ($res->num_rows() > 0) {
            $resArray = $res->row_array();
            $refOrderId = $resArray['order_id'];
            if ($refOrderId != '') {
                $sql = "select id,order_id,shift_id,user_id,pickup_pincode,delivery_pincode,
                pickup_address1,pickup_address2,delivery_address1,delivery_address2,pickup_city,
                pickup_country,delivery_city,delivery_country,pickup_datetime,delivery_datetime,
                plat,plng,dlat,dlng,createdon,company_code,trip_sts,branch_code,company_code,created_source,quantity,weight,volume,product,vendor_id from tb_orders where id='$refOrderId' AND status!=0 LIMIT 1";
                $getOrdId = $this->db->query($sql);
                if ($getOrdId->num_rows() > 0) {
                    $result = $getOrdId->row_array();
                }
            }
        }
        return $result;
    }

    /*the below method will get order type name*/
    public function getOrderTypeByID($id)
    {
        $ordertypename = 'Normal';
        $orddetail = $this->db->query(
            "SELECT o.id,t.type_name FROM tb_order_details o,tb_order_types t WHERE o.order_type=t.id AND o.order_row_id='" . $id . "' LIMIT 1"
        );
        if ($orddetail->num_rows() > 0) {
            $ordertypename = $orddetail->row()->type_name;
        }
        return $ordertypename;
    }

    /* the below code is used to get reference value from order if */
    public function getOrderReferenceByID($oid){

        $this->db->select('ref_value');
        $this->db->from("tb_order_references");
        $this->db->where("reference_id", "DQ");
        $this->db->where("order_id", $oid);
        $getReferences = $this->db->get();
        $refValues = '';
        if ($getReferences->num_rows() > 0) {
            $data = $getReferences->row_array();
            foreach ($data as $value){
                $refValues .= $value.",";
            }
        }
        return $refValues;
    }

    public function getPromisedDeliveryDate(int $orderId): string {
        $getResult = $this->db->query("SELECT promise_deliver_date FROM tb_order_details WHERE order_row_id = ? AND promise_deliver_date IS NOT NULL", [$orderId]);
        return $getResult->num_rows() > 0 ? (string) $getResult->row()->promise_deliver_date : "";
    }
}
?>
