<?php

namespace App\Models\Traits;

/**
 * Cache Trait for Models
 * There is no need to trigger get_instance of CI
 * as Trait will be used in models only
 *
 * CacheKey is build to ensure the same conditions for diffrent
 * table will not overwrite redis cache.
 */
trait CacheTrait
{
    /**
     * @param array $conditions
     * @return string
     */
    private function _getCacheKey(array $conditions): string
    {
        return static::TABLE . ':' . hash('sha256', implode('_', $conditions));
    }

    /**
     * @param array $conditions
     */
    private function _getCache(array $conditions)
    {
        $this->load->driver('cache', ['adapter' => 'redis', 'backup' => 'file']);
        if ($cachedResults = $this->cache->get($this->_getCacheKey($conditions))) {
            return $cachedResults;
        }
        return null;
    }

    /**
     * @param array $conditions
     * @param $row
     */
    private function _setCache(array $conditions, $res, $ttl = 60)
    {
        $this->load->driver('cache', ['adapter' => 'redis', 'backup' => 'file']);
        $this->cache->save($this->_getCacheKey($conditions), $res, $ttl);
    }
}
