<?php

class Transitstatusreportmodel extends CI_Model
{
    private const  DEPARTURE_STATUS_CODE = '0191';
    private const  DELIVERY_STATUS_CODE = ['2300', '0503', '0504', '0505'];
    private const  INTRASIT_STATUS_CODE = '1550';
    private const  ADMIN_DRIVER_STATUS_CODE = ['0501', '0502','0500'];
    private const  GATEOUT_STATUS_CODE = '3000';
    private const  TRIP_ACCEPTED_STATUS_CODE = '0212';

    public function getReports($post, $limit, $offset)
    {
        $custid = "";
        $country_userids = [];
        $userTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $companyCode = $this->session->userdata('company_code');
        $userid = $this->session->userdata("user_id");
        $subcusts = $this->session->userdata('sub_cust');
        if (!empty($this->session->userdata("country_user_ids")) && ($this->session->userdata("country_user_ids") != null) && (count($this->session->userdata("country_user_ids")) > 0)) {
            $country_userids = $this->session->userdata("country_user_ids");
        }
        $business_type = $this->session->userdata('business_type');
        if (!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        $subQuery1 = "
            (SELECT ref_value
            FROM tb_order_references
            WHERE reference_id IN ('DQ','CTR','MN','LPC','XSR','POS','ORD','PO','AWB') AND status=1 AND order_id = o.id
            GROUP BY order_id
        ) as reference_value";

        $this->db->select(
            "
            tu.name as username,
            v.name as vendor_name,cu.name as customer_name,
            o.id,o.order_id,o.pickup_datetime,o.pickup_endtime,o.plat,o.plng,o.dlat,o.dlng,o.shipment_id,o.delivery_datetime,o.drop_endtime,
            o.pickup_company as pickup,o.delivery_company as delivery,o.pickup_address1,o.delivery_address1,
            o.pickup_address2,o.delivery_address2,o.pickup_city,o.delivery_city,o.pickup_country,o.delivery_country,
            o.pickup_pincode,o.delivery_pincode,o.company_code,o.branch_code,o.product,o.goods_value,o.currency,
            o.transport_mode,o.vehicle_type,o.quantity,o.customer_id,o.vendor_id,o.pickup_custid,o.pickup_partyid,
            o.drop_custid,o.drop_partyid,o.trip_sts,o.shift_id,o.trip_id,o.status,o.order_status,convertToClientTZ(o.createdon,'" . $userTimeZone . "') as createdon,
            o.updatedon,o.shipmentid,o.consignee_id,o.shipper_id as o_shipper_id,o.created_source,d.order_type,d.shipper_id,d.service,
            d.delivery_term,d.incoterm,d.delivery_note,d.purchase_order,d.notify_party,d.lane_reference,d.distance,
            d.customs_required,d.high_cargo_value,d.valorance_insurance,d.temperature_control,d.department_code,
            d.docs_received_datetime,d.docs_sent_datetime,d.consignment_note,d.order_remarks,d.cost_center_id,
            o.external_order_id,
            convertToClientTZ(tbo.createdon,'" . $userTimeZone . "') as podUploadDate,
            " . $subQuery1
        );
        $this->db->from("tb_orders o");
        $this->db->join("tb_users tu", "tu.id=o.user_id", "LEFT");
        $this->db->join("tb_order_details d", "o.id=d.order_row_id", "LEFT");
        $this->db->join("tb_vendors v", "v.id=o.vendor_id", "LEFT");
        $this->db->join("tb_customers cu", "cu.id = o.customer_id", 'left');
        $this->db->join("tb_pod_uploads tbo", "tbo.order_id = o.id", 'left');
        $this->db->group_by("o.id");
        $this->db->order_by("o.id", 'desc');

        $this->db->where("o.company_code", $companyCode);

        if ($business_type == "Customer") {
            $userid = 0;
            if (!empty($custid)) {
                if ($this->session->userdata('sub_cust') !== false) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = [$custid];
                    }
                } else {
                    $subcusts = [$custid];
                }
            }
            if (!empty($subcusts)) {
                $subcusts = implode(',', $subcusts);
                $this->db->where_in("o.customer_id", $subcusts);
            } else {
                if ($custid != "") {
                    $this->db->where("o.customer_id", $custid);
                }
            }
        } elseif ($business_type == "Carrier") {
            $vendorId = $this->session->userdata("id");
            $this->db->where("o.vendor_id", $vendorId);
        } else {
            if ($userid != '0') {
                if (!empty($country_userids)) {
                    $this->db->where_in("o.user_id", $country_userids);
                } else {
                    $this->db->where("o.user_id", $userid);
                }
            }
        }

        $fromDate = $post['fromdate_search'] ?? '';
        $toDate = $post['todate_search'] ?? '';
        if (!empty($fromDate) && !empty($toDate)) {
            $this->db->where('date(o.createdon) >=', $fromDate);
            $this->db->where('date(o.createdon) <=', $toDate);
        } elseif (!empty($fromDate)) {
            $this->db->where('date(o.createdon) =', $fromDate);
        } elseif (!empty($toDate)) {
            $this->db->where('date(o.createdon) =', $toDate);
        }

        if (isset($post['carrier_search']) && trim($post['carrier_search']) != "") {
            $this->db->where('o.vendor_id', $post['carrier_search']);
        }

        if (isset($post['customer_search']) && trim($post['customer_search']) != "") {
            $this->db->where('o.customer_id', $post['customer_search']);
        }
        if (isset($post['hidden_cid']) && trim($post['hidden_cid']) != "") {
            $this->db->where('o.customer_id', $post['hidden_cid']);
        }

        if ($limit > 0) {
            $this->db->limit($limit, $offset);
        }

        $orderQuery = $this->db->get();
        $orders = [];
        if ($orderQuery->num_rows() > 0) {
            foreach ($orderQuery->result_array() as $orderRow) {
                $id=$orderRow['id'];
                $orders[$id]['id'] = $id ?? '';
                $orders[$id]['shift_id'] = $orderRow['shift_id'] ?? '';
                $orders[$id]['order_id'] = $orderRow['order_id'] ?? '';
                $orders[$id]['delivery_note'] = $orderRow['reference_value'] ?? '';
                $orders[$id]['customer_name'] = $orderRow['customer_name'] ?? '';
                $orders[$id]['vendor_name'] = $orderRow['vendor_name'] ?? '';
                $orders[$id]['order_id'] = $orderRow['order_id'] ?? '';

                $orders[$id]['source']['name'] = $orderRow['pickup'] ?? '';
                $orders[$id]['source']['street'] = $orderRow['pickup_address1'] ?? '';
                $orders[$id]['source']['state'] = $orderRow['pickup_address2'] ?? '';
                $orders[$id]['source']['city'] = $orderRow['pickup_city'] ?? '';
                $orders[$id]['source']['country'] = $orderRow['pickup_country'] ?? '';
                $orders[$id]['source']['pincode'] = $orderRow['pickup_pincode'] ?? '';

                $orders[$id]['destination']['name'] = $orderRow['delivery'] ?? '';
                $orders[$id]['destination']['street'] = $orderRow['delivery_address1'] ?? '';
                $orders[$id]['destination']['state'] = $orderRow['delivery_address2'] ?? '';
                $orders[$id]['destination']['city'] = $orderRow['delivery_city'] ?? '';
                $orders[$id]['destination']['country'] = $orderRow['delivery_country'] ?? '';
                $orders[$id]['destination']['pincode'] = $orderRow['delivery_pincode'] ?? '';
                $orders[$id]['destination']['drop_custid'] = $orderRow['drop_custid'] ?? '';


                $orders[$id]['bookingCreateDate'] = $orderRow['createdon'] ?? '';

                $pickupDateTime = getdatetimebytimezone($userTimeZone, $orderRow['pickup_datetime'], DFLT_TZ);
                $orders[$id]['estimated_pickup_date'] = $pickupDateTime['datetime'] ?? '';

                $deliveryDateTime = getdatetimebytimezone($userTimeZone, $orderRow['delivery_datetime'], DFLT_TZ);
                $orders[$id]['estimate_delivery_date'] = $deliveryDateTime['datetime'] ?? '';

                $orders[$id]['ePODUploadDate'] = $orderRow['podUploadDate'] ?? '';

                $this->db->select('convertToClientTZ(createdon,"' . $userTimeZone . '") as  createdon');
                $this->db->from("tb_stop_status");
                $this->db->where("status_code", self::TRIP_ACCEPTED_STATUS_CODE);
                $this->db->where("shipment_id", $orderRow['shift_id']);
                $tripAcceptedQuery = $this->db->get();
                if ($tripAcceptedQuery->num_rows() > 0) {
                    foreach ($tripAcceptedQuery->result_array() as $tripAcceptedRow) {
                        $orders[$id]['tirpCreateDate'] = $tripAcceptedRow['createdon'] ?? '';
                    }
                }


                $this->db->select('id, order_id, shipment_id, stop_id, stop_detail_id, stop_type, trip_id, status_id, latitude, longitude, loc_name, status_code, status_stage, status, reason, vehicle_id, driver_id, sentknlogin, convertToClientTZ(createdon,"' . $userTimeZone . '") as  createdon, updatedon');
                $this->db->from("tb_stop_status");
                $this->db->where("order_id", $id);
                $this->db->where("shipment_id", $orderRow['shift_id']);
                $this->db->order_by("id", 'ASC');
                $stopStatusQuery = $this->db->get();

                $i = 1;
                if ($stopStatusQuery->num_rows() > 0) {
                    foreach ($stopStatusQuery->result_array() as $stopStatusRow) {
                        if($stopStatusRow['status_code'] == self::INTRASIT_STATUS_CODE) {
                            $orders[$id]['LastInTransitDate'] = $stopStatusRow['createdon'] ?? '';
                            $orders[$id]['LastInTransitLocation'] = (isset($stopStatusRow['latitude'], $stopStatusRow['longitude'])) ? $stopStatusRow['latitude'] . '@' . $stopStatusRow['longitude'] : '';
                        }
                        if(in_array($stopStatusRow['status_code'],self::ADMIN_DRIVER_STATUS_CODE)) {
                            $orders[$id]['actuallyPickupDate'] = $stopStatusRow['createdon'] ?? '';
                        }
                        if(in_array($stopStatusRow['status_code'],self::DELIVERY_STATUS_CODE)) {
                            $orders[$id]['actualDeliveryDate'] = $stopStatusRow['createdon'] ?? '';
                        }
                        if (!empty($stopStatusRow['status_code']) && ($stopStatusRow['status_code'] == self::DEPARTURE_STATUS_CODE)) {
                            $orders[$id]['actuallyDepartureDate'] = $stopStatusRow['createdon'] ?? '';
                        }elseif (!empty($stopStatusRow['status_code']) && ($stopStatusRow['status_code'] == self::INTRASIT_STATUS_CODE)) {
                            $orders[$id]['Intrasit_date_' . $i] = $stopStatusRow['createdon'] ?? '';
                            $orders[$id]['Intrasit_location_' . $i] = (isset($stopStatusRow['latitude'], $stopStatusRow['longitude'])) ? $stopStatusRow['latitude'] . '@' . $stopStatusRow['longitude'] : '';
                            $i++;
                        }
                    }
                }
            }
        }

        return $orders;
    }
}
