<?php
defined('BASEPATH') or exit('No direct script access allowed');
use App\Models\Table;
/**
 * Table `tb_trips` has information linking the shift to the carrier that is
 * handling the cargo. Though the names are confusing, do not confuse this with
 * the `Trips_model` -- that is for the `tb_shifts` table. The `tb_trips` table
 * has a 1:1 relationship with the `tb_shifts` table through the column
 * `shift_id`.
 */
class Trips_carrier_details extends Table
{
    const TABLE = "tb_trips";

    /**
     * Use these constants for building arrays that will be passed to the DB.
     */
    const ACT_EPLACE_COL = "act_eplace";
    const ACT_SPLACE_COL = "act_splace";
    const CREATED_ON_COL = "created_on";
    const DLAT_COL = "dlat";
    const DLNG_COL = "dlng";
    const DRIVER_ID_COL = "driver_id";
    const END_IMEI_COL = "end_imei";
    const END_READING_COL = "end_reading";
    const EPLACE_COL = "eplace";
    const ETIME_COL = "etime";
    const ID_COL = "id";
    const PAIR_MEAN_STATUS_COL = "pair_mean_status";
    const PLAT_COL = "plat";
    const PLNG_COL = "plng";
    const SHIFT_ID_COL = "shift_id";
    const SPLACE_COL = "splace";
    const START_IMEI_COL = "start_imei";
    const START_READING_COL = "start_reading";
    const STATUS_COL = "status";
    const STIME_COL = "stime";
    const TRANSIT_STATUS_COL = "transit_status";
    const TRIP_TYPE_COL = "trip_type";
    const UPDATED_ON_COL = "updated_on";
    const VEHICLE_ID_COL = "vehicle_id";

    /**
     * These variables may be used for populating the model and passing $this to
     * codeigniter database function calls as per the Models documentation.
     *
     * @see https://codeigniter.com/userguide3/general/models.html#what-is-a-model
     */
    public $act_eplace; // varchar(255)	NULL=YES
    public $act_splace; // varchar(255)	NULL=YES
    public $created_on; // timestamp	NO
    public $dlat; // varchar(50)	NULL=YES
    public $dlng; // varchar(50)	NULL=YES
    public $driver_id; // int(11)	NULL=YES
    public $end_imei; // varchar(50)	NULL=YES
    public $end_reading; // varchar(10)	NULL=NO
    public $eplace; // varchar(120)	NULL=YES
    public $etime; // timestamp	NULL=YES
    public $id; // int(11)	NULL=NO
    public $pair_mean_status; // enum('1','0')	NULL=YES
    public $plat; // varchar(50)	NULL=YES
    public $plng; // varchar(50)	NULL=YES
    public $shift_id; // int(11)	NULL=YES
    public $splace; // varchar(120)	NULL=YES
    public $start_imei; // varchar(50)	NULL=YES
    public $start_reading; // varchar(10)	NULL=NO
    public $status; // tinyint(1)	NULL=NO
    public $stime; // timestamp	YES
    public $transit_status; // tinyint(1)	NULL=YES
    public $trip_type; // tinyint(1)	NULL=YES
    public $updated_on; // timestamp	NULL=NULL=YES
    public $vehicle_id; // int(11)	NULL=YES

    /**
     * Given the shift id cross reference, get the row's id.
     *
     * @param string $shift_id
     * @return int
     */
    public function get_id_from_shift_id(string $shift_id)
    {
        $where = array(self::SHIFT_ID_COL => $shift_id);
        $this->db->select(self::ID_COL);
        $this->db->from(self::TABLE);
        $this->db->where($where);
        $this->db->order_by(self::ID_COL, 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();

        if( !$query->num_rows() )
            throw new Exception('trip not found for shift_id ' . $shift_id);

        return $query->result()[0]->{self::ID_COL};
    }
}
