<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Triptemplatemodel extends CI_Model
{
    public function getRouteTemplatesDataByWhereCondition(string $where, int $checkLimit): array
    {
        $limitQuery = "";
        if ($checkLimit > 0) {
            $limitQuery = " LIMIT 1";
        }
        $query = $this->db->query("SELECT id,template_id,template_name,description,product,service,customer_id,order_type,carrier_type,shipment_type,min_distance,mindistance_units,max_distance,maxdistance_units,min_weight,minweight_units,max_weight,maxweight_units,min_volume,minvolume_units,max_volume,maxvolume_units,active,user_id,company_code,branch_code FROM route_templates WHERE " . $where . " ORDER BY id DESC " . $limitQuery);
        if ($checkLimit > 0) {
            return $query->num_rows() > 0 ? $query->row_array() : [];
        } else {
            return $query->num_rows() > 0 ? $query->result_array() : [];
        }
    }

    public function getRouteTemplateLegsByWhereCondition(int $templateRowId): array
    {
        $query = $this->db->query("SELECT id,leg_id,origin_id,origin_location,destination_id,destination_location,carrier_id,transport_mode,vehicle_type,vehicle_id,driver_id FROM routetemplate_legs WHERE routetemplate_id = ? AND status =? ORDER BY id ASC", [$templateRowId, 1]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomerRowByWhereCondition(int $rowId, array $data): array
    {
        if (empty($data)) {
            $query = $this->db->query("SELECT id,code FROM tb_customers WHERE id = ? AND status =? LIMIT 1", [$rowId, '1']);
            return $query->num_rows() > 0 ? $query->row_array() : [];
        }
        $query = $this->db->query("SELECT id,code FROM tb_customers WHERE code = ? AND company_code IN ? AND  status =? LIMIT 1", [$data['code'], $data['companyCode'], '1']);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getServiceDataByIds(array $serviceIds): array
    {
        $query = $this->db->query("SELECT id,service_id,name FROM tb_service_master WHERE id IN ?", [$serviceIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomersById(array $customerIds): array
    {
        $query = $this->db->query("SELECT id,code FROM tb_customers WHERE id IN ?", [$customerIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCarriersById(array $carrierIds): array
    {
        $query = $this->db->query("SELECT id,name FROM tb_vendors WHERE id IN ?", [$carrierIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getDriversById(array $driverIds): array
    {
        $query = $this->db->query("SELECT id,name FROM tb_truck_drivers WHERE id IN ?", [$driverIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getVehiclesById(array $vehicleIds): array
    {
        $query = $this->db->query("SELECT id,register_number FROM tb_trucks_data WHERE id IN ?", [$vehicleIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getVehicleTypesById(array $vehicleTypeIds): array
    {
        $query = $this->db->query("SELECT id,trucktype FROM tb_trucktypes WHERE id IN ?", [$vehicleTypeIds]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderTypesById(array $orderTypes): array
    {
        $query = $this->db->query("SELECT id,type_name FROM tb_order_types WHERE id IN ?", [$orderTypes]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCarrierMasterData(array $companyCodes): array
    {
        $query = $this->db->query("SELECT id,name FROM tb_vendors WHERE company_code IN ? ANd status =? ", [$companyCodes, '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getCustomersByWhereCondition(array $companyCodes): array
    {
        $query = $this->db->query("SELECT id,name,location,code,country,state,street,email_id,company_code,branch_code FROM tb_customers WHERE company_code IN ? AND status =? ", [$companyCodes, '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getxorderCountries(string $companyCode): array
    {
        $query = $this->db->query("SELECT xborder_code FROM tb_xborder_country WHERE company_code = ? LIMIT 1", [$companyCode]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function updateRouteTemplateTableData(array $setArray, int $rowId): bool
    {
        $this->db->where('id', $rowId);
        $updated = $this->db->update('route_templates', $setArray);
        return true;
    }

    public function updateRouteTemplateLegsTableData(array $setArray, array $rowIds): bool
    {
        $this->db->where_in('id', $rowIds);
        $updated = $this->db->update('routetemplate_legs', $setArray);
        return true;
    }

    public function insertRouteTemplateTableData(array $insertData): int
    {
        $query = $this->db->insert("route_templates", $insertData);
        $insertedId = $this->db->insert_id();
        return $insertedId;
    }

    public function insertRouteTemplateLegsTableData(array $insertData): int
    {
        $query = $this->db->insert("routetemplate_legs", $insertData);
        $insertedId = $this->db->insert_id();
        return $insertedId;
    }

    public function getLastTemplateId(): array
    {
        $query = $this->db->query("SELECT template_id FROM route_templates ORDER BY id DESC LIMIT 1");
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getTripTemplatesByUser(string $companyCode): array
    {
        $query = $this->db->query("SELECT id,template_id,template_name FROM route_templates WHERE company_code = ? AND active = ? AND status =? ORDER by id DESC", [$companyCode, '1', '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }
    public function getRouteTemplateById(int $templateId): array
    {
        $query = $this->db->query("SELECT id,template_id,customer_id,carrier_type,shipment_type FROM route_templates WHERE id = ?", [$templateId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function getPartyMasterCodeById(array $rowId): array
    {
        $query = $this->db->query("SELECT id,code,location_id,country,state,street,pincode,latitude,longitude FROM tbl_party_master WHERE id  IN ?", [$rowId]);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function insertShiftData(array $insertData): int
    {
        $query = $this->db->insert("tb_shifts", $insertData);
        $insertedId = $this->db->insert_id();
        return $insertedId;
    }

    public function checkLegsStop(array $data): array
    {
        $query = $this->db->query("SELECT id FROM tb_shiporder_stops WHERE shipment_id = ? AND stopcity = ? AND stoptype = ? AND status = ? LIMIT 1", [$data['shipmentId'], $data['stopCity'], $data['stopType'],'1']);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function insertShipOrderStops(array $data): int
    {
        $query = $this->db->insert("tb_shiporder_stops", $data);
        $insertId = $this->db->insert_id();
        return $insertId;
    }

    public function updateShipOrderStopsdata(array $setArray, int $rowId): bool
    {
        $this->db->where('id', $rowId);
        $updated = $this->db->update("tb_shiporder_stops", $setArray);
        return true;
    }

    public function checkShiftVehicleData(int $shiftId): array
    {
        $query = $this->db->query("SELECT id FROM tb_shft_veh WHERE shft_id = ? AND status = ?", [$shiftId, '1']);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function insertShiftVehTableData(array $data): int
    {
        $query = $this->db->insert("tb_shft_veh", $data);
        $insertId = $this->db->insert_id();
        return $insertId;
    }

    public function updateShiftVehicletbledata(array $setArray, int $rowId): bool
    {
        $this->db->where('id', $rowId);
        $updated = $this->db->update("tb_shft_veh", $setArray);
        return true;
    }

    public function checkShiftDrivers(int $shiftId, int $ShiftLegId): array
    {
        $query = $this->db->query("SELECT tsd_id FROM tb_shift_drivers WHERE shift_id = ? AND main_shift_id = ?", [$shiftId, $ShiftLegId]);
        return $query->num_rows() > 0 ? $query->row_array() : [];
    }

    public function insertShiftDriversData(array $data): void
    {
        $this->db->insert("tb_shift_drivers", $data);
    }

    public function updateShiftDriversdata(array $setArray, int $rowId): void
    {
        $this->db->where('id', $rowId);
        $this->db->update("tb_shift_drivers", $setArray);
    }

    public function updateVehicleDriversData(array $data): void
    {
        $checkDrivers = $this->db->query("SELECT driver_id FROM tb_vehicles_drivers WHERE vehicle_id = ? AND status = ?", [$data['vehicleId'], '1']);
        if ($checkDrivers->num_rows() > 0) {
            $checkAssignedDrivers = $this->db->query("SELECT id FROM tbl_assigned_drivers WHERE vehicle_id = ? AND driver_id = ? AND user_id = ? AND status = ?", [$data['vehicleId'], $data['driverId'], $data['userId'], '1']);
            if ($checkAssignedDrivers->num_rows() > 0) {
                $assignedDriverId = $checkAssignedDrivers->row()->id;
                $this->db->update("tbl_assigned_drivers", ["vehicle_id" => $data['vehicleId'], "user_id" => $data['userId'], "driver_id" => $data['driverId'], "from_time" => $data['date'], "to_time" => $data['date'], 'created_on' => $data['date'], 'updated_on' => $data['date']], ["id" => $assignedDriverId]);
            } else {
                $this->db->insert("tbl_assigned_drivers", ["vehicle_id" => $data['vehicleId'], "user_id" => $data['userId'], "driver_id" => $data['driverId'], "from_time" => $data['date'], "to_time" => $data['date'], "status" => '1', 'created_on' => $data['date'], 'updated_on' => $data['date']]);
            }
        }
    }

    public function updateShiftTabledata(array $setArray, int $rowId)
    {
        $this->db->where('id', $rowId);
        $this->db->update("tb_shifts", $setArray);
    }

    public function updateOrdersTabledata(array $setArray, int $rowId, array $updateIds = [])
    {
        if ($rowId > 0) {
            $this->db->where('id', $rowId);
        } else {
            $this->db->where_in('id', $updateIds);
        }
        $this->db->update("tb_orders", $setArray);
    }

    public function getTripDetailsByIds(array $ids): array
    {
        $getLegIds = $this->db->query("SELECT id,shift_leg_id FROM tb_shifts WHERE shift_leg_id IN ? AND status = ?", [$ids, 1]);
        $legIdsResult = $getLegIds->num_rows() > 0 ? $getLegIds->result_array() : [];
        foreach ($legIdsResult as $eachLeg) {
            $ids[] = $legIds[$eachLeg['shift_leg_id']][] = $eachLeg['id'];
        }
        $finalQuery = $this->db->query("SELECT id,splace,slat,slng,eplace,elat,elng,scity,dcity,startdate,enddate,shipmentid,vendor_id,vehicle_type,company_code,branch_code FROM tb_shifts WHERE id IN ? AND status = ?", [$ids, 1]);
        $finalResult = $finalQuery->num_rows() > 0 ? $finalQuery->result_array() : [];
        foreach ($finalResult as $eachRow) {
            $response[$eachRow['id']] = [
                'id' => $eachRow['id'],
                'splace' => $eachRow['splace'],
                'slat' => $eachRow['slat'],
                'slng' => $eachRow['slng'],
                'eplace' => $eachRow['eplace'],
                'elat' => $eachRow['elat'],
                'elng' => $eachRow['elng'],
                'scity' => $eachRow['scity'],
                'dcity' => $eachRow['dcity'],
                'shipmentid' => $eachRow['shipmentid'],
                'vendor_id' => $eachRow['vendor_id'],
                'vehicle_type' => $eachRow['vehicle_type'],
                'company_code' => $eachRow['company_code'],
                'startdate' => $eachRow['startdate'],
                'enddate' => $eachRow['enddate'],
                'branch_code' => $eachRow['branch_code']
            ];
        }
        return ['legsIds' => $legIds ?? [], 'shiftData' => $response ?? []];
    }

    public function addCrossBorderReference(array $insertArray, array $checkArray): void
    {
        $query = $this->db->query("SELECT id FROM tb_order_references WHERE order_id= ? AND reference_id = ? AND ref_value = ? AND status = ?", [$checkArray['order_id'], $checkArray['reference_id'], $checkArray['ref_value'], '1']);
        if ($query->num_rows() === 0) {
            $this->db->insert("tb_order_references", $insertArray);
        }
    }

    public function checkStopsByShiftId(int $shiftId): array
    {
        $query = $this->db->query("SELECT id,plat,plng,address,stoptype FROM tb_shiporder_stops WHERE shipment_id = ? AND status = ? ", [$shiftId, '1']);
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderDetailsByIds(array $ids): array
    {
        $query = $this->db->query("SELECT id,order_id,quantity,weight,volume,customer_id FROM tb_orders WHERE id IN ? ", [$ids]);
        $result = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($result as $eachLine) {
            $orders[$eachLine['id']] = ['id' => $eachLine['id'], 'bookingId' => $eachLine['order_id'], 'customerId' => $eachLine['customer_id'], 'quantity' => $eachLine['quantity'], 'weight' => $eachLine['weight'], 'volume' => $eachLine['volume']];
        }
        return $orders ?? [];
    }

    public function checkEmployeeWithTripsTable(array $insertArray, array $checkArray, array $orderData): void
    {
        $checkQuery = $this->db->query("SELECT id FROM tb_employee WHERE shift_id = ? AND order_id = ? AND status = ?", [$checkArray['shiftId'], $checkArray['bookingId'], '1']);
        if ($checkQuery->num_rows() === 0) {
            $this->db->insert("tb_employee", $insertArray);
        }
        $pickupStopId = $insertArray['stop_id'];
        $dropStopId = $insertArray['drop_stopid'];
        $this->db->query("UPDATE tb_shiporder_stops SET weight = ?,volume = ?,ship_units=? WHERE id IN ? ", [$orderData['weight'], $orderData['volume'], $orderData['quantity'], [$pickupStopId, $dropStopId]]);
        $this->db->query("UPDATE tb_shifts SET weight = ?,volume = ?,units=?,customer_id=? WHERE id = ? ", [$orderData['weight'], $orderData['volume'], $orderData['quantity'], $orderData['customerId'], $checkArray['shiftId']]);
        $this->db->insert("tb_stop_status", ["shipment_id" => $checkArray['shiftId'], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "0100", "order_id" => $orderData['id'], "reason" => "Coming from E-Booking", "createdon" => $insertArray['createdon']]);
    }

    public function getMasterDataForTripTemplateByCode(array $data): array
    {
        $partyType = $data['partyType'];
        $partyIds = [];
        if ($partyType == 'origin') {
            $partyType = ['Shipper', 'Yard', 'Border', 'xDock', 'In Transit', 'Port'];
        } else {
            $partyType = ['Consignee', 'Yard', 'Border', 'xDock', 'In Transit', 'Port'];
        }
        $getPartyTypeIds = $this->db->query("SELECT id,name FROM tbl_party_types WHERE name IN ? AND company_code IN ?", [$partyType, $data['companyCode']]);
        $typesData = $getPartyTypeIds->num_rows() > 0 ? $getPartyTypeIds->result_array() : [];
        if (empty($typesData)) {
            return [];
        }
        foreach ($typesData as $eachType) {
            $partyIds[] = $eachType['id'];
            $partyTypeData[$eachType['id']] = $eachType['name'];
        }
        if (empty($partyIds)) {
            return [];
        }
        $partyIds = array_unique($partyIds);
        $query = $this->db->query(
            "SELECT id,party_type_id,name,email,code,company_code,branch_code,location_id,country,state,street,party_types FROM tbl_party_master WHERE  (code LIKE ? OR name LIKE ? OR email LIKE ? OR location_id LIKE ? OR state LIKE ? OR country LIKE ? ) AND status = ? AND company_code IN ? ORDER BY id DESC",
            ["%" . $data['code'] . "%", "%" . $data['code'] . "%", "%" . $data['code'] . "%", "%" . $data['code'] . "%", "%" . $data['code'] . "%", "%" . $data['code'] . "%", '1', $data['companyCode']]
        );
        $queryResponse = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResponse as $eachLine) {
            $checkStatus = $partyTypeId =  0;
            if (in_array($eachLine['party_type_id'], $partyIds)) {
                $checkStatus = 1;
                $partyTypeId = $eachLine['party_type_id'];
            }
            if ($checkStatus === 0) {
                $partyTypesString = $eachLine['party_types'];
                if ($partyTypesString != "") {
                    $partyTypes = explode(',', $partyTypesString);
                    if (end($partyTypes) == "") {
                        array_pop($partyTypes);
                    }
                    foreach ($partyTypes as $eachType) {
                        if (in_array($eachType, $partyIds)) {
                            $checkStatus = 1;
                            $partyTypeId = $eachType;
                        }
                    }
                }
            }
            if ($checkStatus === 0) {
                continue;
            }
            $checkBox = "<input type='radio' name='consigneelist' id='consigneelist_" . $eachLine['id'] . "' class='masterlist' onchange='selectparty(" . $eachLine['id'] . ")' value='" . $eachLine['code'] . "'>";
            $parties[] = [
                'check' => $checkBox,
                'id' => $eachLine['code'],
                'name' => $eachLine['name'],
                'email' => $eachLine['email'],
                'city' => $eachLine['location_id'],
                'country' => $eachLine['country'],
                'state' => $eachLine['state'],
                'street' => $eachLine['street'],
                'company_code' => $eachLine['company_code'],
                'branch_code' => $eachLine['branch_code'],
                'party_name' => $partyTypeData[$partyTypeId] ?? $data['partyType'],
            ];
        }
        return $parties ?? [];
    }

    public function checkEDIBookingStatus(int $order_id): int
    {
        $ediStatus = $this->db->query("SELECT id FROM tb_stop_status WHERE order_id= ? AND status_code= ? UNION ALL SELECT id FROM `tb_order_status` WHERE order_id=?  AND status_code= ?", [$order_id, "0142", $order_id, "0142"]);
        return $ediStatus->num_rows() > 0 ? 1 : 0;
    }

}

?>
