<?php 
class Truckmodel extends CI_Model
{
  public function gettruckreportdata($userid,$custid,$countryuids,$fromdate,$todate,$ordtype,$carrier)
  {
	
    $result = array();
    $fromdate=date('Y-m-d',strtotime($fromdate)); 
        $todate=date('Y-m-d',strtotime($todate));
    $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.company_code,o.branch_code,o.status as tripstatus,o.trip_sts,o.createdon,d.department_code,o.status,o.trip_sts,s.shipid,o.vendor_id");
    $this->db->from("tb_orders o");
    $this->db->join("tb_order_details d","o.id=d.order_row_id","LEFT");
    $this->db->join("tb_shipments s","s.id=o.shipment_id","LEFT");
    /*$this->db->join("tb_employee e","e.order_id=o.order_id","LEFT"); */
    if(count($carrier)>0){
        $this->db->where_in("o.vendor_id",$carrier); 
    }
    if($ordtype=='pending' || $ordtype=='ready'){
    $this->db->where("o.status",1); 
    }else if($ordtype=='active'){
    $this->db->where("o.status",2);
    $this->db->where("o.trip_sts",0);
    }else if($ordtype=='closed'){
    $this->db->where("o.status",2);
    $this->db->where("o.trip_sts",1);
    }else{
    $this->db->where("o.status !=",0); 
    }
    //$this->db->where("o.status !=",0);
    if(!empty($countryuids)){
      $this->db->where_in("o.user_id",$countryuids);
    }else{
      $this->db->where("o.user_id",$userid);
    }
    if($custid != ""){
      $this->db->where('o.customer_id',$custid);
    }
    //$this->db->where('o.createdon >=', $fromdate);
	$this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') >= '".$fromdate."'",NULL,FALSE);
	$this->db->where("DATE_FORMAT(o.createdon,'%Y-%m-%d') <= '".$todate."'",NULL,FALSE);
    //$this->db->where('o.createdon <=', $todate);
    $this->db->group_by("o.id");
    $this->db->order_by("o.createdon",'DESC');
    $getorder = $this->db->get();
    if($getorder->num_rows() >0){
      $result = $getorder->result_array();
    }
	return $result;
  }
    /**
     * This method get truck volumes
     * @return array
     * @last change: Container number search  added for australia
     */
  public function getreporttruckvolume($user_details,$status_search,$whr,$wherein)
  {
    
        $result = array();
        $this->db->select("o.id,o.order_id,o.pickup_company as pickup,o.delivery_company as delivery,o.company_code,o.branch_code,o.status as tripstatus,o.trip_sts,o.createdon,d.department_code,o.status,o.trip_sts,s.shipid,o.vendor_id,o.trip_id,r.ref_value as container_num,d.num_of_pallets");
        $this->db->from("tb_orders o");
        $this->db->join("tb_order_details d","o.id=d.order_row_id","LEFT");
        $this->db->join("tb_shipments s","s.id=o.shipment_id","LEFT");
        $this->db->join("tb_order_references r","o.id=r.order_id AND r.reference_id='CTR'","LEFT");
        
        if(!empty($wherein)) {
          if(!empty($wherein['vendor_id'])) {
            $this->db->where_in('o.vendor_id',$wherein['vendor_id']);
          }
        }
      
        if($status_search=='pending' || $status_search=='ready'){
            $this->db->where("o.status",1); 
        }else if($status_search=='active'){
            $this->db->where("o.status",2);
            $this->db->where("o.trip_sts",0);
        }else if($status_search=='closed'){
            $this->db->where("o.status",2);
            $this->db->where("o.trip_sts",1);
        }else{
            $this->db->where("o.status !=",0); 
        }
        
        if(!empty($user_details['country_userids'])){
          $this->db->where_in("o.user_id",$user_details['country_userids']);
        }elseif ($user_details['company_code'] == "AUKN") {
          $this->db->where("o.company_code",$user_details['company_code']);  
        }else{
          $this->db->where("o.user_id",$user_details['userid']);
        }
        
        if($user_details['custid'] != ""){
          $this->db->where('o.customer_id',$user_details['custid']);
        }

        $this->db->where($whr);       
        $this->db->group_by("o.id");
        $this->db->order_by("o.createdon",'DESC');
        $getorder = $this->db->get();
        if($getorder->num_rows() >0){
          $result = $getorder->result_array();
        }
        // print_r($this->db->last_query());die();
        return $result;
    }
}