<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Uniqlomodel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('log_helper');
    }

    public function getsearchdata($whr, $sera)
    {
        if ($sera == 0) {
            $this->db->where("status", 1);
        }

        $this->db->like($whr);
        $this->db->from('tb_customer_pincodes');
        $truck = $this->db->get();
        $result = $truck->result_array();

        log_error(UNIQLO_LOG_PREFIX . "getsearchdata outbound data: " . json_encode($result));

        return $result;
    }

    public function searchdata($where = [], $whr = [], $limit = 10, $start = 0)
    {
        $this->db->select("tc.*, c.code, v.name as carrier_name");
        $this->db->from("tb_customer_pincodes tc");
        $this->db->join('tb_customers c', 'c.id = tc.customer_id', "LEFT");
        $this->db->join('tb_vendors v', 'tc.carrier_id = v.id', "LEFT");

        // Apply WHERE filters
        if (!empty($where)) {
            $this->db->where($where);
        }

        // Apply LIKE filters properly (not all together)
        if (!empty($whr)) {
            foreach ($whr as $key => $val) {
                if ($key === 'global_search') {
                    // Optional global search (for DataTables search box)
                    $this->db->group_start();
                    $this->db->like('tc.origin_city', $val);
                    $this->db->or_like('tc.destination_city', $val);
                    $this->db->or_like('tc.origin_pin', $val);
                    $this->db->or_like('tc.destination_pin', $val);
                    $this->db->group_end();
                } else {
                    $this->db->where($key, $val);
                }
            }
        }

        // 🔹 Ensure oldest (or first) records appear first
        $this->db->order_by("tc.id", "ASC");

        // 🔹 Apply LIMIT and OFFSET (Pagination)
        $this->db->limit($limit, $start);

        $res = $this->db->get();
        return $res->result_array();
    }
    
    public function countAll($where = [], $whr = [])
    {
        $this->db->from("tb_customer_pincodes tc");
        $this->db->join('tb_customers c', 'c.id = tc.customer_id', "LEFT");
        $this->db->join('tb_vendors v', 'tc.carrier_id = v.id', "LEFT");

        if (!empty($where)) {
            $this->db->where($where);
        }

        if (!empty($whr)) {
            foreach ($whr as $key => $val) {
                if ($key === 'global_search') {
                    $this->db->group_start();
                    $this->db->like('tc.origin_city', $val);
                    $this->db->or_like('tc.destination_city', $val);
                    $this->db->or_like('tc.origin_pin', $val);
                    $this->db->or_like('tc.destination_pin', $val);
                    $this->db->group_end();
                } else {
                    $this->db->where($key, $val);
                }
            }
        }

        return $this->db->count_all_results();
    }

    public function customerpreferencedata($where, $whr)
    {
        $this->db->select(" tc.*,v.name as carrier_name");
        $this->db->from("tb_carrier_prefer_rule tc");
        $this->db->join('tb_vendors v', 'tc.carrier_id=v.id', "LEFT");
        $this->db->where($where);
        $this->db->like($whr);
        $this->db->order_by("tc.id", "DESC");
        $res = $this->db->get();
        $getcustcode = $res->result_array();

        log_error(UNIQLO_LOG_PREFIX . "customerpreferencedata outbound data: " . json_encode($getcustcode));

        return $getcustcode;
    }


    public function delete($id, $table)
    {
        $this->db->where('id', $id);
        $this->db->set('status', 0);
        $result = $this->db->update($table);

        log_error(UNIQLO_LOG_PREFIX . "delete outbound data: " . $result);

        return $result;
    }


    public function selectlist($select, $table, $whr)
    {
        $this->db->select($select);
        $this->db->group_by('name');
        $this->db->where($whr);
        $this->db->from($table);
        $res = $this->db->get();
        $getcustcode = $res->result_array();

        log_error(UNIQLO_LOG_PREFIX . "selectlist outbound data: " . json_encode($getcustcode));

        return $getcustcode;
    }

    public function carrierratios($where, $whr)
    {
        $this->db->select(" tc.*,v.name as carrier_name");
        $this->db->from("tb_allocate_ratio_batch tc");
        $this->db->join('tb_vendors v', 'tc.carrier_id=v.id', "LEFT");
        $this->db->where($where);
        $this->db->like($whr);
        $this->db->order_by("tc.id", "DESC");
        $res = $this->db->get();
        $getcustcode = $res->result_array();

        log_error(UNIQLO_LOG_PREFIX . "carrierratios outbound data: " . json_encode($getcustcode));

        return $getcustcode;
    }


    public function checkdupdata($where, $whr, $table)
    {
        $this->db->select(" tc.*");
        $this->db->from($table . " tc");
        $this->db->where($where);
        $this->db->like($whr);
        $this->db->order_by("tc.id", "DESC");
        $res = $this->db->get();
        $getcustcode = $res->result_array();

        log_error(UNIQLO_LOG_PREFIX . "checkdupdata outbound data: " . json_encode($getcustcode));

        return $getcustcode;
    }

    public function checkratiodata($data)
    {
        $order_type = $data['order_type'];
        $date1 = $data['startdate'];
        $date2 = $data['enddate'];
        $where = '';
        if (isset($data['id']) && $data['id'] != "") {
            $where = " AND id !=" . $data['id'];
        }
        $getdata = $this->db->query(
            "select * from tb_allocate_ratio_batch where order_type=$order_type and startdate = '$date1' and enddate =  '$date2' and status=1 $where "
        )->result_array();

        log_error(UNIQLO_LOG_PREFIX . "checkratiodata outbound data: " . json_encode($getdata));

        return $getdata;
    }

    /* get the order delviered status based on the shipment ids*/
    public function getOrderStatusDelvier($shiftIds)
    {
        $data = [];
        if ($shiftIds != '') {
            $sql = "SELECT shipment_id,stop_type,status_id,status_code,createdon FROM `tb_stop_status` WHERE shipment_id IN ($shiftIds) AND shipment_id !=0 AND (status_id=1 OR status_id=44 OR status_id=46 OR status_id=52) AND stop_type='D' GROUP BY shipment_id ORDER BY id DESC";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['delivered_status_status_name'] = "Delivered";
                        $data[$index]['delivered_status_stop_type'] = $each['stop_type'];
                        $data[$index]['delivered_status_status_id'] = $each['status_id'];
                        $data[$index]['delivered_status_status_code'] = $each['status_code'];
                        $data[$index]['delivered_status_createdon'] = $each['createdon'];
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getOrderStatusDelvier complete");

        return $data;
    }

    /*the below method will convert all the multiple status of a orders in to a single line order for a particular order*/
    public function getOrderStatusGeneric($shiftIds)
    {
        $data = [];
        if ($shiftIds != '') {
            $sql = "SELECT tps.shipment_id,sm.id,sm.status_name,tps.stop_type,tps.status_id,tps.status_code,tps.createdon
            FROM tb_stop_status tps INNER JOIN tb_status_master sm on sm.id=tps.status_id WHERE tps.id IN ( SELECT max(id) as id FROM tb_stop_status where shipment_id IN ($shiftIds) AND shipment_id !=0 GROUP BY shipment_id ORDER BY id DESC )";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['shipment_id'];
                        $data[$index]['shipment_id'] = $each['shipment_id'];
                        $data[$index]['generic_status_status_name'] = $each['status_name'];
                        $data[$index]['generic_status_stop_type'] = $each['stop_type'];
                        $data[$index]['generic_status_status_id'] = $each['status_id'];
                        $data[$index]['generic_status_status_code'] = $each['status_code'];
                        $data[$index]['generic_status_createdon'] = $each['createdon'];
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getOrderStatusGeneric complete");

        return $data;
    }

    /**
     * Get pickup done orders statuses
     *
     * @param string $shiftIds Comma separated shiftIds
     */
    public function getOrderStatusPicked(string $shiftIds): array
    {
        if (trim($shiftIds) === '') {
            return [];
        }
        $shiftIds = explode(',', $shiftIds);
        $data = [];
        $sql = "SELECT shipment_id, sm.id, sm.status_name, tps.stop_type, tps.status_id, tps.status_code, tps.createdon
            FROM `tb_stop_status` tps
            INNER JOIN tb_status_master sm ON sm.id = tps.status_id
            WHERE tps.shipment_id IN (" . implode( ',', $shiftIds ) . ")
                AND tps.shipment_id != 0
                AND tps.status_code IN ('0500','1550')
                AND tps.stop_type='P'
            GROUP BY tps.shipment_id
            ORDER BY tps.id ASC";

        $res = $this->db->query($sql);

        if ($res && $res->num_rows() > 0) {
            $result = $res->result_array();
            foreach ($result as $each) {
                $index = $each['shipment_id'];
                $data[$index]['shipment_id'] = $each['shipment_id'];
                $data[$index]['pickup_status_status_name'] = $each['status_name'];
                $data[$index]['pickup_status_stop_type'] = $each['stop_type'];
                $data[$index]['pickup_status_status_id'] = $each['status_id'];
                $data[$index]['pickup_status_status_code'] = $each['status_code'];
                $data[$index]['pickup_status_createdon'] = $each['createdon'];
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getOrderStatusPicked complete");

        return $data;
    }

    /* get the order track data reverse_ntransit,dispatch_count,invoice_amount,charged_weight from tracking table */
    public function getOrderTrackData($ordIds)
    {
        $data = [];
        if ($ordIds != '') {
            $sql = "SELECT order_id,reverse_ntransit,dispatch_count,invoice_amount,charged_weight FROM tb_uniqlo_order_tracking WHERE id IN ( SELECT max(id) as id FROM tb_uniqlo_order_tracking where order_id IN ($ordIds) GROUP BY order_id ORDER BY id DESC )";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['order_id'];
                        $data[$index]['track_order_id'] = $each['order_id'];
                        $data[$index]['track_reverse_ntransit'] = $each['reverse_ntransit'];
                        $data[$index]['track_dispatch_count'] = $each['dispatch_count'];
                        $data[$index]['track_invoice_amount'] = $each['invoice_amount'];
                        $data[$index]['track_charged_weight'] = $each['charged_weight'];
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getOrderTrackData complete");

        return $data;
    }

    /* get the order scanning data from scan table */
    public function getOrderScanData($orderIds)
    {
        if ($orderIds == '') {
            log_error(UNIQLO_LOG_PREFIX . "getOrderScanData outbound data: null");
            return [];
        }
        $query = "SELECT order_id, scan_type, scan_val, scan_type, scan_status_time, scan_instruction, call_duration, scan_status_code
        FROM tb_uniqlo_order_scans
        WHERE order_id IN ? AND status=1
        ORDER BY scan_status_time ASC";
        $getResult = $this->db->query($query, [explode(',', $orderIds)]);
        if ($getResult->num_rows() > 0) {
            foreach ($getResult->result_array() as $eachRow){
                $data[$eachRow['order_id']][] = $eachRow;
            }
        }
        log_error(UNIQLO_LOG_PREFIX . "getOrderScanData complete");
        return $data ?? [];
    }

    /* get the order push data for estimate delivery date, attempt_count and rtodto_date */
    public function getOrderPushApiData($awbNumbers)
    {
        $data = [];
        if ($awbNumbers != '') {
            $formattedAwbNumbers = '"' . implode('","', explode(',', $awbNumbers)) . '"';
            $res = $this->db->query(
                '
                SELECT
                    status_name,
                    status_datetime,
                    promise_deliver_date,
                    no_of_attempt,awbnum
                FROM tb_uniqlo_push_api_data
                WHERE id IN (
                    SELECT
                        max(id) AS id
                    FROM tb_uniqlo_push_api_data
                    WHERE awbnum IN (' . $formattedAwbNumbers . ')
                    GROUP BY awbnum
                    ORDER BY id DESC
                )
            '
            );
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['awbnum'];
                        $data[$index]['push_status_name'] = $each['status_name'];
                        $data[$index]['push_status_datetime'] = $each['status_datetime'];
                        $data[$index]['push_promise_deliver_date'] = $each['promise_deliver_date'];
                        $data[$index]['push_no_of_attempt'] = $each['no_of_attempt'];
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getOrderPushApiData outbound data: " . json_encode($data));

        return $data;
    }

    /**
     * Get the region and zones from order pickup, delivery pincodes
     *
     * @param string $pincodes Comma separated pickup and delivery pincodes
     * @param string $cities Comma separated pickup and delivery cities
     */
    public function getRegionZonesData(string $pincodes, string $cities): array
    {
        $data = [];
        if ($pincodes != '') {
            $sql = "SELECT id, origin_pin, destination_pin, origin_city, destination_city, carrier_id,
                        carrier_surface_tat, carrier_return_surface_tat,carrier_zone
                    FROM `tb_customer_pincodes`
                    WHERE (
                        origin_pin IN ($pincodes)
                        OR destination_pin IN ($pincodes)
                        OR origin_city IN ($cities)
                        OR destination_city IN ($cities)
                    ) GROUP BY id ORDER BY id DESC";

            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $result = $res->result_array();
                if (isset($result) && sizeof($result) > 0) {
                    foreach ($result as $each) {
                        $index = $each['origin_pin'] . "_" . $each['destination_pin'] . "_" . $each['carrier_id'];
                        $data[$index]['zone_origin_pin'] = $each['origin_pin'];
                        $data[$index]['zone_destination_pin'] = $each['destination_pin'];
                        $data[$index]['zone_origin_city'] = $each['origin_city'];
                        $data[$index]['zone_destination_city'] = $each['destination_city'];
                        $data[$index]['zone_carrier_id'] = $each['carrier_id'];
                        $data[$index]['zone_carrier_so_tat'] = $each['carrier_surface_tat'];
                        $data[$index]['zone_carrier_return_tat'] = $each['carrier_return_surface_tat'];
                        $data[$index]['zone_carrier_zone'] = $each['carrier_zone'];
                    }
                }
            }
        }

        return $data;
    }

    public function getReferencesValueAndOrdersIdByVendorId(string $vendorId, int $weekValue)
    {
        $where = "to.vendor_id = " . $vendorId . " AND to.trip_sts = '0' AND to.status != 0 AND to.shift_id > 0 AND tor.reference_id = 'AWB' AND tor.status = 1";

        if ($weekValue < 6) {
            $where .= $this->getCreatedOnDateRange($weekValue);
        } else {
            // TODO: Sorry for this code below :) We will come up with a webhook solution for this stupid Uniqlo tracking stuff next week :)
            switch ($weekValue) {
                case 6:
                    $where .= " AND date(to.createdon) > " . $this->db->escape(date("Y-m-d", strtotime( "-2 days"))) .
                        " AND date(to.createdon) <= " . $this->db->escape(date("Y-m-d" ));
                    break;
                case 7:
                    $where .= " AND date(to.createdon) > " . $this->db->escape(date("Y-m-d", strtotime( "-4 days"))) .
                        " AND date(to.createdon) <= " . $this->db->escape(date("Y-m-d",strtotime("-2 days" )));
                    break;
                case 8:
                    $where .= " AND date(to.createdon) > " . $this->db->escape(
                            date("Y-m-d", strtotime("-6 days"))
                        ) .
                        " AND date(to.createdon) <= " . $this->db->escape(date("Y-m-d", strtotime("-4 days")));
                    break;
                case 9:
                    $where .= " AND date(to.createdon) > " . $this->db->escape(
                            date("Y-m-d", strtotime("-8 days"))
                        ) .
                        " AND date(to.createdon) <= " . $this->db->escape(date("Y-m-d", strtotime("-6 days")));
                    break;
            }
        }

        return $this->db->select("tor.ref_value AS refValue, to.id AS ordersId, tor.reference_id as refType")
            ->from("tb_order_references tor")
            ->join('tb_orders to', 'tor.order_id = to.id', "INNER")
            ->where($where)
            ->get()
            ->result_array();

    }

    public function getRtoRefIdReferencesValueAndOrdersIdByVendorId(string $vendorId, int $weekValue)
    {
        $where = "to.vendor_id = " . $vendorId . " AND to.trip_sts = '0' AND to.status != 0 AND to.shift_id > 0 AND tor.reference_id = 'REFAWB' AND tor.status = 1";
        $where .= $this->getCreatedOnDateRange($weekValue);

        return $this->db->select("tor.ref_value AS refValue, to.id AS ordersId, tor.reference_id as refType")
            ->from("tb_order_references tor")
            ->join('tb_orders to', 'tor.order_id = to.id', "INNER")
            ->where($where)
            ->get()
            ->result_array();
    }

    /* get the order push data check*/
    public function getPushApiOrdersData()
    {
        $data = [];
            $sql = "
            SELECT upad.createdon , upad.id, upad.awbnum as refValue, upad.queue_triggered, upad.triggered_datetime, orf.order_id as ordersId
            FROM tb_uniqlo_push_api_data as upad
                     INNER JOIN tb_order_references as orf on upad.awbnum = orf.ref_value
            WHERE upad.status = 1
              AND upad.queue_triggered = '0'
              AND orf.status = 1 GROUP BY upad.awbnum
            ORDER BY upad.id DESC LIMIT 0,500
            ";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $data = $res->result_array();
            }
        return $data;
    }

    /* get the old order push data check*/
    public function getPushApiOldOders()
    {
        $currDate = date("Y-m-d H:i:s", strtotime('-4 hours'));
        $data = [];
        $sql = "SELECT upad.id,upad.awbnum as refValue,upad.queue_triggered,upad.triggered_datetime,orf.order_id as orderId,'1' as webHook from tb_uniqlo_push_api_data as upad
                    inner join tb_order_references as orf on upad.awbnum = orf.ref_value
              where upad.status=1 and upad.queue_triggered=1 and upad.triggered_datetime < '" . $currDate . "' and orf.status=1 GROUP BY upad.awbnum ORDER BY upad.id DESC";
        $res = $this->db->query($sql);
        if ($res->num_rows() > 0) {
            $data = $res->result_array();
        }
        return $data;
    }

    /**
     * @param int $weekValue
     * @return string
     */
    private function getCreatedOnDateRange(int $weekValue): string
    {
        if ($weekValue > 0) {
            $weekDays = 7;
            $daysFrom = $weekDays * $weekValue;
            $daysTo = $weekDays * ($weekValue - 1);
            $dateFrom = date("Y-m-d", strtotime("-" . $daysFrom . " days"));
            $dateTo = date("Y-m-d", strtotime("-" . $daysTo . " days"));
            $createdOnFrom = $weekValue < 5 ? " AND date(to.createdon) > '" . $dateFrom . "'" : "";
            $createdOnTo = " AND date(to.createdon) <= '" . $dateTo . "' ";

            log_error(UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob week ' . $weekValue);

            return $createdOnFrom . $createdOnTo;
        }

        return '';
    }

    public function getEdiResponseData(string $orderIds, int $userId): array
    {
        if ($orderIds == "") {
            return [];
        }
        $finalOrderIds = explode(',', $orderIds);
        // $query = $this->db->query("SELECT edi_id,txn_obj_id,edi_response FROM tb_etn_edi_transactions where edi_id IN ? AND edi_type = ? AND bounded_type = ? AND user_id = ? AND txn_obj_id IN ? AND status = ?", [[8,9], '1', '2', $userId, $finalOrderIds, 0]);
        $query = $this->db->query(
            "SELECT e.edi_id,e.txn_obj_id,e.edi_response FROM tb_etn_edi_transactions e
         INNER JOIN tb_orders o ON o.id=e.txn_obj_id
         where e.edi_id IN ? AND e.edi_type = ? AND e.bounded_type = ?
        AND e.user_id = ? AND e.txn_obj_id IN ? AND e.status = ?
        AND o.vendor_id IN ?",
            [[8, 9], '1', '2', $userId, $finalOrderIds, 0, [310, 311]]
        );
        log_error(UNIQLO_LOG_PREFIX . "getEdiResponseData complete");
        return $query->num_rows() > 0 ? $query->result_array() : [];
    }

    public function getOrderCargoWeight(string $orderIds): array
    {
        if ($orderIds == "") {
            return [];
        }
        $finalOrderIds = explode(',', $orderIds);
        $query = $this->db->query("SELECT order_id,sum(weight) as totalWeight FROM tb_order_cargodetails where status= ? and order_id > ?  and order_id in ? group by order_id", [1, 0, $finalOrderIds]);
        $queryResult = $query->num_rows() > 0 ? $query->result_array() : [];
        foreach ($queryResult as $eachLine) {
            $cargoWeight[$eachLine['order_id']] = $eachLine['totalWeight'];
        }
        return $cargoWeight ?? [];
    }

    public function getStatusDatesForPromiseDate(string $shiftIds): array
    {
        if ($shiftIds == "") {
            log_error(UNIQLO_LOG_PREFIX . "getStatusDatesForPromiseDate shiftIds: null");
            return [];
        }
        $finalShiftIds = explode(',', $shiftIds);
        $query = "SELECT shipment_id, stop_type, status_id, status_code, createdon
        FROM tb_stop_status
        WHERE shipment_id IN ? AND shipment_id >0 AND status =1 AND status_code IN ? ORDER BY id DESC";

        $getResult = $this->db->query($query, [$finalShiftIds,['0470','2300','RTO','DTO']]);
        if ($getResult->num_rows() > 0) {
            $data = $getResult->result_array();
        }
        log_error(UNIQLO_LOG_PREFIX . "getStatusDatesForPromiseDate complete");
        return $data ?? [];
    }
}
