<?php  defined('BASEPATH') OR exit('No direct script access allowed');
class Vatmastermodel extends CI_Model
{

 function updatedata($table,$id,$data)
 {
    $this->db->where('id',$id);
    return $this->db->update($table,$data);
}

function getvatdata($uid,$whr){
 $result = array();
 $this->db->select("v.*,cp.name as custname,vp.name as vendorname ");
 $this->db->from("tbl_vat_master v"); 
 $this->db->join('tbl_party_master cp', 'v.customeridentifier = cp.customeridentifier', 'LEFT');
 $this->db->join('tbl_party_master vp', 'v.vendoridentifier = vp.customeridentifier', 'LEFT');
 $this->db->like($whr);
 $this->db->where("v.user_id",$uid);
 $this->db->where("v.status", 1); 
 $this->db->group_by("v.id");
 $this->db->order_by("v.id", "DESC");
 $getvatdata = $this->db->get();
 if($getvatdata->num_rows() >0){
    $result = $getvatdata->result_array();
}
return $result;

}
function getrecentlanes($uid,$company_code){
 $result = array();
 $this->db->select("*");
 $this->db->from("tbl_lanes "); 
 $this->db->where("vatid",0);
 $this->db->where("company_code",$company_code);
 $this->db->where("user_id",$uid);
 $this->db->where("status", 1);
 $this->db->where("DATE(created_on) = DATE(NOW())", NULL, FALSE);
 $this->db->order_by("id", "DESC");
 $recentlanes = $this->db->get();
 if($recentlanes->num_rows() >0){
    $result = $recentlanes->result_array();
}
return $result;

}
function getlanevats($lane_id){
 $result = array();
 $this->db->select("c.charge_code,c.description,v.*");
 $this->db->from("tbl_lane_vat v"); 
 $this->db->join('tb_charge_codes c', 'v.charge_id = c.id', 'LEFT');
 $this->db->where("v.lane_id",$lane_id);
 $this->db->where("v.status", 1);
 $this->db->order_by("v.id", "DESC");
 $getlanevats = $this->db->get();
 if($getlanevats->num_rows() >0){
    $result = $getlanevats->result_array();
}
return $result;

}
function getchargevat($vatid){
 $result = array();
 $this->db->select("c.charge_code,c.description,v.*");
 $this->db->from("tbl_lane_vat v"); 
 $this->db->join('tb_charge_codes c', 'v.charge_id = c.id', 'LEFT');
 $this->db->where("v.id",$vatid);
 $this->db->where("v.status", 1);
 $this->db->limit(1);
 $getlanevat = $this->db->get();
 if($getlanevat->num_rows() >0){
    $result = $getlanevat->row_array();
}
return $result;

}

function getlanes($vatid,$uid,$company_code){
 $result = array();
 $this->db->select("*");
 $this->db->from("tbl_lanes"); 
 $this->db->where("vatid",$vatid);
 $this->db->where("company_code",$company_code);
 $this->db->where("user_id",$uid);
 $this->db->where("status", 1);
 $this->db->order_by("id", "DESC");
 $getlanes = $this->db->get();
 if($getlanes->num_rows() >0){
    $result = $getlanes->result_array();
}
return $result;

}
function getroletypelist($info){
    $result = array();
    $this->db->select("m.id,m.name,m.email,m.customeridentifier,m.company_code,m.branch_code");
    $this->db->from("tbl_party_master m");
    $this->db->join("tbl_party_types p","p.id=m.party_type_id","LEFT");
    $this->db->where("p.name",$info['type']);
    if($info['company_code'] != "RUKN"){
        $this->db->where("m.user_id",$info['user_id']);
        $this->db->where("p.user_id",$info['user_id']);
    }else{
       $this->db->where("m.company_code",$info['company_code']);
       $this->db->where("p.company_code",$info['company_code']);
   }
   $getresult = $this->db->get();
   if($getresult->num_rows() >0){
    $result = $getresult->result_array();
}
return $result;
}


}