<?php
defined('BASEPATH') or exit('No direct script access allowed');
use App\Models\Table;


class Vendors extends Table
{
    const TABLE = "tb_vendors";

    const ADDRESS_COL = "address";
    const AUTO_ACCEPT_COL = "auto_accept";
    const BRANCH_CODE_COL = "branch_code";
    const CARRIER_GRADE_COL = "carrier_grade";
    const CODE_COL = "code";
    const COMPANY_CODE_COL = "company_code";
    const COMPANY_NAME_COL = "company_name";
    const COUNTRY_COL = "country";
    const CREATED_ON_COL = "created_on";
    const CUSTID_COL = "custid";
    const EFFECTIVE_DATE_COL = "effective_date";
    const EMAIL_COL = "email";
    const EXPIRY_DATE_COL = "expiry_date";
    const FCM_TOKEN_COL = "fcm_token";
    const ID_COL = "id";
    const LOCATION_COL = "location";
    const MOBILE_COL = "mobile";
    const NAME_COL = "name";
    const OFFERING_TYPE_COL = "offering_type";
    const ONLINE_COL = "online";
    const PARTYID_COL = "partyid";
    const PASSWORD_COL = "password";
    const PINCODE_COL = "pincode";
    const QUOTE_MODULE_ID_COL = "quote_module_id";
    const SERVICE_ID_COL = "service_id";
    const SERVICE_NAME_COL = "service_name";
    const STATUS_COL = "status";
    const TMS_AUTO_ACCEPT = "tms_auto_accept";
    const UPDATED_ON_COL = "update_on";
    const USER_ID_COL = "user_id";

    public $address;
    public $auto_accept;
    public $branch_code;
    public $carrier_grade;
    public $code;
    public $company_code;
    public $company_name;
    public $country;
    public $created_on;
    public $custid;
    public $effective_date;
    public $email;
    public $expiry_date;
    public $fcm_token;
    public $id;
    public $location;
    public $mobile;
    public $name;
    public $offering_type;
    public $online;
    public $partyid;
    public $password;
    public $pincode;
    public $quote_module_id;
    public $service_id;
    public $service_name;
    public $status;
    public $tms_auto_accept;
    public $update_on;
    public $user_id;

    /**
     * @param int $entityId
     * @return array
     */
    public function getChildren(int $entityId): array
    {
        $this->db->reset_query();
        $children = $this->db->select('id')
            ->where('parent_id', $entityId)
            ->get('tb_vendors')
            ->result_array();

        return array_merge( [ $entityId ], array_column($children, 'id') );
    }

    public function updateDriver(int $vendorId, int $vehicleId) : bool
    {
        $sql = "
                UPDATE tb_truck_drivers ttd
                    LEFT JOIN tb_vehicles_drivers AS tvd ON ttd.id = tvd.driver_id AND tvd.status = 1
                SET ttd.vendor_id = ?
                WHERE ttd.status = 'Active' AND tvd.vehicle_id = ?";

        return $this->db->query($sql, [$vendorId, $vehicleId]);
    }

    public function getVendorNames(array $vendorIds):array
    {
        if (empty($vendorIds)) {
            return [];
        }

        $query = $this->db->query("SELECT id, name, broker
            FROM tb_vendors
         WHERE id IN ?", [ $vendorIds ]);
        if (!$query) {
            return [];
        }

        $result = [];
        foreach($query->result() as $row) {
            $result [$row->id] = ['name' => $row->name, 'broker' => $row->broker];
        }
        return $result;
    }
}
